package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The definition of a Docker image that can be used for a Bitbucket Pipelines step execution context.
 **/
@ApiModel(description = "The definition of a Docker image that can be used for a Bitbucket Pipelines step execution context.")
public class PipelineImage   {
  
  private @Valid String name;
  private @Valid String password;
  private @Valid String email;
  private @Valid String username;

  /**
   * The name of the image. If the image is hosted on DockerHub the short name can be used, otherwise the fully qualified name is required here.
   **/
  public PipelineImage name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of the image. If the image is hosted on DockerHub the short name can be used, otherwise the fully qualified name is required here.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   * The password needed to authenticate with the Docker registry. Only required when using a private Docker image.
   **/
  public PipelineImage password(String password) {
    this.password = password;
    return this;
  }

  
  @ApiModelProperty(value = "The password needed to authenticate with the Docker registry. Only required when using a private Docker image.")
  @JsonProperty("password")
  public String getPassword() {
    return password;
  }
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * The email needed to authenticate with the Docker registry. Only required when using a private Docker image.
   **/
  public PipelineImage email(String email) {
    this.email = email;
    return this;
  }

  
  @ApiModelProperty(value = "The email needed to authenticate with the Docker registry. Only required when using a private Docker image.")
  @JsonProperty("email")
  public String getEmail() {
    return email;
  }
  public void setEmail(String email) {
    this.email = email;
  }

  /**
   * The username needed to authenticate with the Docker registry. Only required when using a private Docker image.
   **/
  public PipelineImage username(String username) {
    this.username = username;
    return this;
  }

  
  @ApiModelProperty(value = "The username needed to authenticate with the Docker registry. Only required when using a private Docker image.")
  @JsonProperty("username")
  public String getUsername() {
    return username;
  }
  public void setUsername(String username) {
    this.username = username;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineImage pipelineImage = (PipelineImage) o;
    return Objects.equals(name, pipelineImage.name) &&
        Objects.equals(password, pipelineImage.password) &&
        Objects.equals(email, pipelineImage.email) &&
        Objects.equals(username, pipelineImage.username);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, password, email, username);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineImage {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

