package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.PipelineSshPublicKey;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineKnownHost extends Object  {
  
  private @Valid PipelineSshPublicKey publicKey = null;
  private @Valid String uuid;
  private @Valid String hostname;

  /**
   **/
  public PipelineKnownHost publicKey(PipelineSshPublicKey publicKey) {
    this.publicKey = publicKey;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("public_key")
  public PipelineSshPublicKey getPublicKey() {
    return publicKey;
  }
  public void setPublicKey(PipelineSshPublicKey publicKey) {
    this.publicKey = publicKey;
  }

  /**
   * The UUID identifying the known host.
   **/
  public PipelineKnownHost uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the known host.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   * The hostname of the known host.
   **/
  public PipelineKnownHost hostname(String hostname) {
    this.hostname = hostname;
    return this;
  }

  
  @ApiModelProperty(value = "The hostname of the known host.")
  @JsonProperty("hostname")
  public String getHostname() {
    return hostname;
  }
  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineKnownHost pipelineKnownHost = (PipelineKnownHost) o;
    return Objects.equals(publicKey, pipelineKnownHost.publicKey) &&
        Objects.equals(uuid, pipelineKnownHost.uuid) &&
        Objects.equals(hostname, pipelineKnownHost.hostname);
  }

  @Override
  public int hashCode() {
    return Objects.hash(publicKey, uuid, hostname);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineKnownHost {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    publicKey: ").append(toIndentedString(publicKey)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

