package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineSshPublicKey extends Object  {
  
  private @Valid String md5Fingerprint;
  private @Valid String sha256Fingerprint;
  private @Valid String key;
  private @Valid String keyType;

  /**
   * The MD5 fingerprint of the public key.
   **/
  public PipelineSshPublicKey md5Fingerprint(String md5Fingerprint) {
    this.md5Fingerprint = md5Fingerprint;
    return this;
  }

  
  @ApiModelProperty(value = "The MD5 fingerprint of the public key.")
  @JsonProperty("md5_fingerprint")
  public String getMd5Fingerprint() {
    return md5Fingerprint;
  }
  public void setMd5Fingerprint(String md5Fingerprint) {
    this.md5Fingerprint = md5Fingerprint;
  }

  /**
   * The SHA-256 fingerprint of the public key.
   **/
  public PipelineSshPublicKey sha256Fingerprint(String sha256Fingerprint) {
    this.sha256Fingerprint = sha256Fingerprint;
    return this;
  }

  
  @ApiModelProperty(value = "The SHA-256 fingerprint of the public key.")
  @JsonProperty("sha256_fingerprint")
  public String getSha256Fingerprint() {
    return sha256Fingerprint;
  }
  public void setSha256Fingerprint(String sha256Fingerprint) {
    this.sha256Fingerprint = sha256Fingerprint;
  }

  /**
   * The base64 encoded public key.
   **/
  public PipelineSshPublicKey key(String key) {
    this.key = key;
    return this;
  }

  
  @ApiModelProperty(value = "The base64 encoded public key.")
  @JsonProperty("key")
  public String getKey() {
    return key;
  }
  public void setKey(String key) {
    this.key = key;
  }

  /**
   * The type of the public key.
   **/
  public PipelineSshPublicKey keyType(String keyType) {
    this.keyType = keyType;
    return this;
  }

  
  @ApiModelProperty(value = "The type of the public key.")
  @JsonProperty("key_type")
  public String getKeyType() {
    return keyType;
  }
  public void setKeyType(String keyType) {
    this.keyType = keyType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineSshPublicKey pipelineSshPublicKey = (PipelineSshPublicKey) o;
    return Objects.equals(md5Fingerprint, pipelineSshPublicKey.md5Fingerprint) &&
        Objects.equals(sha256Fingerprint, pipelineSshPublicKey.sha256Fingerprint) &&
        Objects.equals(key, pipelineSshPublicKey.key) &&
        Objects.equals(keyType, pipelineSshPublicKey.keyType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(md5Fingerprint, sha256Fingerprint, key, keyType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineSshPublicKey {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    md5Fingerprint: ").append(toIndentedString(md5Fingerprint)).append("\n");
    sb.append("    sha256Fingerprint: ").append(toIndentedString(sha256Fingerprint)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    keyType: ").append(toIndentedString(keyType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

