package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.PipelineCommand;
import se.bjurr.bitbucketcloud.gen.model.PipelineImage;
import se.bjurr.bitbucketcloud.gen.model.PipelineStepState;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class PipelineStep extends Object  {
  
  private @Valid Date completedOn;
  private @Valid PipelineImage image = null;
  private @Valid List<PipelineCommand> setupCommands = new ArrayList<PipelineCommand>();
  private @Valid Date startedOn;
  private @Valid PipelineStepState state = null;
  private @Valid List<PipelineCommand> scriptCommands = new ArrayList<PipelineCommand>();
  private @Valid String uuid;

  /**
   * The timestamp when the step execution was completed. This is not set if the step is still in progress.
   **/
  public PipelineStep completedOn(Date completedOn) {
    this.completedOn = completedOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the step execution was completed. This is not set if the step is still in progress.")
  @JsonProperty("completed_on")
  public Date getCompletedOn() {
    return completedOn;
  }
  public void setCompletedOn(Date completedOn) {
    this.completedOn = completedOn;
  }

  /**
   **/
  public PipelineStep image(PipelineImage image) {
    this.image = image;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("image")
  public PipelineImage getImage() {
    return image;
  }
  public void setImage(PipelineImage image) {
    this.image = image;
  }

  /**
   * The list of commands that are executed as part of the setup phase of the build. These commands are executed outside the build container.
   **/
  public PipelineStep setupCommands(List<PipelineCommand> setupCommands) {
    this.setupCommands = setupCommands;
    return this;
  }

  
  @ApiModelProperty(value = "The list of commands that are executed as part of the setup phase of the build. These commands are executed outside the build container.")
  @JsonProperty("setup_commands")
  public List<PipelineCommand> getSetupCommands() {
    return setupCommands;
  }
  public void setSetupCommands(List<PipelineCommand> setupCommands) {
    this.setupCommands = setupCommands;
  }

  /**
   * The timestamp when the step execution was started. This is not set when the step hasn&#39;t executed yet.
   **/
  public PipelineStep startedOn(Date startedOn) {
    this.startedOn = startedOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the step execution was started. This is not set when the step hasn't executed yet.")
  @JsonProperty("started_on")
  public Date getStartedOn() {
    return startedOn;
  }
  public void setStartedOn(Date startedOn) {
    this.startedOn = startedOn;
  }

  /**
   **/
  public PipelineStep state(PipelineStepState state) {
    this.state = state;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("state")
  public PipelineStepState getState() {
    return state;
  }
  public void setState(PipelineStepState state) {
    this.state = state;
  }

  /**
   * The list of build commands. These commands are executed in the build container.
   **/
  public PipelineStep scriptCommands(List<PipelineCommand> scriptCommands) {
    this.scriptCommands = scriptCommands;
    return this;
  }

  
  @ApiModelProperty(value = "The list of build commands. These commands are executed in the build container.")
  @JsonProperty("script_commands")
  public List<PipelineCommand> getScriptCommands() {
    return scriptCommands;
  }
  public void setScriptCommands(List<PipelineCommand> scriptCommands) {
    this.scriptCommands = scriptCommands;
  }

  /**
   * The UUID identifying the step.
   **/
  public PipelineStep uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the step.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PipelineStep pipelineStep = (PipelineStep) o;
    return Objects.equals(completedOn, pipelineStep.completedOn) &&
        Objects.equals(image, pipelineStep.image) &&
        Objects.equals(setupCommands, pipelineStep.setupCommands) &&
        Objects.equals(startedOn, pipelineStep.startedOn) &&
        Objects.equals(state, pipelineStep.state) &&
        Objects.equals(scriptCommands, pipelineStep.scriptCommands) &&
        Objects.equals(uuid, pipelineStep.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(completedOn, image, setupCommands, startedOn, state, scriptCommands, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PipelineStep {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    completedOn: ").append(toIndentedString(completedOn)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    setupCommands: ").append(toIndentedString(setupCommands)).append("\n");
    sb.append("    startedOn: ").append(toIndentedString(startedOn)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    scriptCommands: ").append(toIndentedString(scriptCommands)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

