package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.Participant;
import se.bjurr.bitbucketcloud.gen.model.PullrequestEndpoint;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Pullrequest extends Object  {
  

public enum StateEnum {

    MERGED(String.valueOf("MERGED")), SUPERSEDED(String.valueOf("SUPERSEDED")), OPEN(String.valueOf("OPEN")), DECLINED(String.valueOf("DECLINED"));


    private String value;

    StateEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String v) {
        for (StateEnum b : StateEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid StateEnum state;
  private @Valid List<Participant> participants = new ArrayList<Participant>();
  private @Valid Boolean closeSourceBranch;
  private @Valid Object links = null;
  private @Valid PullrequestEndpoint destination = null;
  private @Valid Date createdOn;
  private @Valid List<Account> reviewers = new ArrayList<Account>();
  private @Valid Date updatedOn;
  private @Valid String reason;
  private @Valid Account author = null;
  private @Valid Integer commentCount;
  private @Valid Integer taskCount;
  private @Valid Account closedBy = null;
  private @Valid Object rendered = null;
  private @Valid Object summary = null;
  private @Valid Integer id;
  private @Valid String title;
  private @Valid Object mergeCommit = null;
  private @Valid PullrequestEndpoint source = null;

  /**
   * The pull request&#39;s current status.
   **/
  public Pullrequest state(StateEnum state) {
    this.state = state;
    return this;
  }

  
  @ApiModelProperty(value = "The pull request's current status.")
  @JsonProperty("state")
  public StateEnum getState() {
    return state;
  }
  public void setState(StateEnum state) {
    this.state = state;
  }

  /**
   *         The list of users that are collaborating on this pull request.         Collaborators are user that:          * are added to the pull request as a reviewer (part of the reviewers           list)         * are not explicit reviewers, but have commented on the pull request         * are not explicit reviewers, but have approved the pull request          Each user is wrapped in an object that indicates the user&#39;s role and         whether they have approved the pull request. For performance reasons,         the API only returns this list when an API requests a pull request by         id.         
   **/
  public Pullrequest participants(List<Participant> participants) {
    this.participants = participants;
    return this;
  }

  
  @ApiModelProperty(value = "        The list of users that are collaborating on this pull request.         Collaborators are user that:          * are added to the pull request as a reviewer (part of the reviewers           list)         * are not explicit reviewers, but have commented on the pull request         * are not explicit reviewers, but have approved the pull request          Each user is wrapped in an object that indicates the user's role and         whether they have approved the pull request. For performance reasons,         the API only returns this list when an API requests a pull request by         id.         ")
  @JsonProperty("participants")
  public List<Participant> getParticipants() {
    return participants;
  }
  public void setParticipants(List<Participant> participants) {
    this.participants = participants;
  }

  /**
   * A boolean flag indicating if merging the pull request closes the source branch.
   **/
  public Pullrequest closeSourceBranch(Boolean closeSourceBranch) {
    this.closeSourceBranch = closeSourceBranch;
    return this;
  }

  
  @ApiModelProperty(value = "A boolean flag indicating if merging the pull request closes the source branch.")
  @JsonProperty("close_source_branch")
  public Boolean getCloseSourceBranch() {
    return closeSourceBranch;
  }
  public void setCloseSourceBranch(Boolean closeSourceBranch) {
    this.closeSourceBranch = closeSourceBranch;
  }

  /**
   **/
  public Pullrequest links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   **/
  public Pullrequest destination(PullrequestEndpoint destination) {
    this.destination = destination;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("destination")
  public PullrequestEndpoint getDestination() {
    return destination;
  }
  public void setDestination(PullrequestEndpoint destination) {
    this.destination = destination;
  }

  /**
   * The ISO8601 timestamp the request was created.
   **/
  public Pullrequest createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "The ISO8601 timestamp the request was created.")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   * The list of users that were added as reviewers on this pull request when it was created. For performance reasons, the API only includes this list on a pull request&#39;s &#x60;self&#x60; URL.
   **/
  public Pullrequest reviewers(List<Account> reviewers) {
    this.reviewers = reviewers;
    return this;
  }

  
  @ApiModelProperty(value = "The list of users that were added as reviewers on this pull request when it was created. For performance reasons, the API only includes this list on a pull request's `self` URL.")
  @JsonProperty("reviewers")
  public List<Account> getReviewers() {
    return reviewers;
  }
  public void setReviewers(List<Account> reviewers) {
    this.reviewers = reviewers;
  }

  /**
   * The ISO8601 timestamp the request was last updated.
   **/
  public Pullrequest updatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
    return this;
  }

  
  @ApiModelProperty(value = "The ISO8601 timestamp the request was last updated.")
  @JsonProperty("updated_on")
  public Date getUpdatedOn() {
    return updatedOn;
  }
  public void setUpdatedOn(Date updatedOn) {
    this.updatedOn = updatedOn;
  }

  /**
   * Explains why a pull request was declined. This field is only applicable to pull requests in rejected state.
   **/
  public Pullrequest reason(String reason) {
    this.reason = reason;
    return this;
  }

  
  @ApiModelProperty(value = "Explains why a pull request was declined. This field is only applicable to pull requests in rejected state.")
  @JsonProperty("reason")
  public String getReason() {
    return reason;
  }
  public void setReason(String reason) {
    this.reason = reason;
  }

  /**
   **/
  public Pullrequest author(Account author) {
    this.author = author;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("author")
  public Account getAuthor() {
    return author;
  }
  public void setAuthor(Account author) {
    this.author = author;
  }

  /**
   * The number of comments for a specific pull request.
   * minimum: 0
   **/
  public Pullrequest commentCount(Integer commentCount) {
    this.commentCount = commentCount;
    return this;
  }

  
  @ApiModelProperty(value = "The number of comments for a specific pull request.")
  @JsonProperty("comment_count")
 @Min(0)  public Integer getCommentCount() {
    return commentCount;
  }
  public void setCommentCount(Integer commentCount) {
    this.commentCount = commentCount;
  }

  /**
   * The number of open tasks for a specific pull request.
   * minimum: 0
   **/
  public Pullrequest taskCount(Integer taskCount) {
    this.taskCount = taskCount;
    return this;
  }

  
  @ApiModelProperty(value = "The number of open tasks for a specific pull request.")
  @JsonProperty("task_count")
 @Min(0)  public Integer getTaskCount() {
    return taskCount;
  }
  public void setTaskCount(Integer taskCount) {
    this.taskCount = taskCount;
  }

  /**
   **/
  public Pullrequest closedBy(Account closedBy) {
    this.closedBy = closedBy;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("closed_by")
  public Account getClosedBy() {
    return closedBy;
  }
  public void setClosedBy(Account closedBy) {
    this.closedBy = closedBy;
  }

  /**
   **/
  public Pullrequest rendered(Object rendered) {
    this.rendered = rendered;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("rendered")
  public Object getRendered() {
    return rendered;
  }
  public void setRendered(Object rendered) {
    this.rendered = rendered;
  }

  /**
   **/
  public Pullrequest summary(Object summary) {
    this.summary = summary;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("summary")
  public Object getSummary() {
    return summary;
  }
  public void setSummary(Object summary) {
    this.summary = summary;
  }

  /**
   * The pull request&#39;s unique ID. Note that pull request IDs are only unique within their associated repository.
   **/
  public Pullrequest id(Integer id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "The pull request's unique ID. Note that pull request IDs are only unique within their associated repository.")
  @JsonProperty("id")
  public Integer getId() {
    return id;
  }
  public void setId(Integer id) {
    this.id = id;
  }

  /**
   * Title of the pull request.
   **/
  public Pullrequest title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "Title of the pull request.")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public Pullrequest mergeCommit(Object mergeCommit) {
    this.mergeCommit = mergeCommit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("merge_commit")
  public Object getMergeCommit() {
    return mergeCommit;
  }
  public void setMergeCommit(Object mergeCommit) {
    this.mergeCommit = mergeCommit;
  }

  /**
   **/
  public Pullrequest source(PullrequestEndpoint source) {
    this.source = source;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("source")
  public PullrequestEndpoint getSource() {
    return source;
  }
  public void setSource(PullrequestEndpoint source) {
    this.source = source;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Pullrequest pullrequest = (Pullrequest) o;
    return Objects.equals(state, pullrequest.state) &&
        Objects.equals(participants, pullrequest.participants) &&
        Objects.equals(closeSourceBranch, pullrequest.closeSourceBranch) &&
        Objects.equals(links, pullrequest.links) &&
        Objects.equals(destination, pullrequest.destination) &&
        Objects.equals(createdOn, pullrequest.createdOn) &&
        Objects.equals(reviewers, pullrequest.reviewers) &&
        Objects.equals(updatedOn, pullrequest.updatedOn) &&
        Objects.equals(reason, pullrequest.reason) &&
        Objects.equals(author, pullrequest.author) &&
        Objects.equals(commentCount, pullrequest.commentCount) &&
        Objects.equals(taskCount, pullrequest.taskCount) &&
        Objects.equals(closedBy, pullrequest.closedBy) &&
        Objects.equals(rendered, pullrequest.rendered) &&
        Objects.equals(summary, pullrequest.summary) &&
        Objects.equals(id, pullrequest.id) &&
        Objects.equals(title, pullrequest.title) &&
        Objects.equals(mergeCommit, pullrequest.mergeCommit) &&
        Objects.equals(source, pullrequest.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(state, participants, closeSourceBranch, links, destination, createdOn, reviewers, updatedOn, reason, author, commentCount, taskCount, closedBy, rendered, summary, id, title, mergeCommit, source);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Pullrequest {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    participants: ").append(toIndentedString(participants)).append("\n");
    sb.append("    closeSourceBranch: ").append(toIndentedString(closeSourceBranch)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    destination: ").append(toIndentedString(destination)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    reviewers: ").append(toIndentedString(reviewers)).append("\n");
    sb.append("    updatedOn: ").append(toIndentedString(updatedOn)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    commentCount: ").append(toIndentedString(commentCount)).append("\n");
    sb.append("    taskCount: ").append(toIndentedString(taskCount)).append("\n");
    sb.append("    closedBy: ").append(toIndentedString(closedBy)).append("\n");
    sb.append("    rendered: ").append(toIndentedString(rendered)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    mergeCommit: ").append(toIndentedString(mergeCommit)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

