package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The metadata that describes a pull request merge.
 **/
@ApiModel(description = "The metadata that describes a pull request merge.")
public class PullrequestMergeParameters   {
  
  private @Valid String message;

public enum MergeStrategyEnum {

    MERGE_COMMIT(String.valueOf("merge_commit")), SQUASH(String.valueOf("squash")), FAST_FORWARD(String.valueOf("fast_forward"));


    private String value;

    MergeStrategyEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static MergeStrategyEnum fromValue(String v) {
        for (MergeStrategyEnum b : MergeStrategyEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid MergeStrategyEnum mergeStrategy = MergeStrategyEnum.MERGE_COMMIT;
  private @Valid String type;
  private @Valid Boolean closeSourceBranch;

  /**
   * The commit message that will be used on the resulting commit.
   **/
  public PullrequestMergeParameters message(String message) {
    this.message = message;
    return this;
  }

  
  @ApiModelProperty(value = "The commit message that will be used on the resulting commit.")
  @JsonProperty("message")
  public String getMessage() {
    return message;
  }
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * The merge strategy that will be used to merge the pull request.
   **/
  public PullrequestMergeParameters mergeStrategy(MergeStrategyEnum mergeStrategy) {
    this.mergeStrategy = mergeStrategy;
    return this;
  }

  
  @ApiModelProperty(value = "The merge strategy that will be used to merge the pull request.")
  @JsonProperty("merge_strategy")
  public MergeStrategyEnum getMergeStrategy() {
    return mergeStrategy;
  }
  public void setMergeStrategy(MergeStrategyEnum mergeStrategy) {
    this.mergeStrategy = mergeStrategy;
  }

  /**
   **/
  public PullrequestMergeParameters type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   * Whether the source branch should be deleted. If this is not provided, we fallback to the value used when the pull request was created, which defaults to False
   **/
  public PullrequestMergeParameters closeSourceBranch(Boolean closeSourceBranch) {
    this.closeSourceBranch = closeSourceBranch;
    return this;
  }

  
  @ApiModelProperty(value = "Whether the source branch should be deleted. If this is not provided, we fallback to the value used when the pull request was created, which defaults to False")
  @JsonProperty("close_source_branch")
  public Boolean getCloseSourceBranch() {
    return closeSourceBranch;
  }
  public void setCloseSourceBranch(Boolean closeSourceBranch) {
    this.closeSourceBranch = closeSourceBranch;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PullrequestMergeParameters pullrequestMergeParameters = (PullrequestMergeParameters) o;
    return Objects.equals(message, pullrequestMergeParameters.message) &&
        Objects.equals(mergeStrategy, pullrequestMergeParameters.mergeStrategy) &&
        Objects.equals(type, pullrequestMergeParameters.type) &&
        Objects.equals(closeSourceBranch, pullrequestMergeParameters.closeSourceBranch);
  }

  @Override
  public int hashCode() {
    return Objects.hash(message, mergeStrategy, type, closeSourceBranch);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PullrequestMergeParameters {\n");
    
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    mergeStrategy: ").append(toIndentedString(mergeStrategy)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    closeSourceBranch: ").append(toIndentedString(closeSourceBranch)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

