package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import se.bjurr.bitbucketcloud.gen.model.RefLinks;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * A ref object, representing a branch or tag in a repository.
 **/
@ApiModel(description = "A ref object, representing a branch or tag in a repository.")
public class Ref   {
  
  private @Valid String name;
  private @Valid Commit target = null;
  private @Valid String type;
  private @Valid RefLinks links = null;

  /**
   * The name of the ref.
   **/
  public Ref name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of the ref.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   **/
  public Ref target(Commit target) {
    this.target = target;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("target")
  public Commit getTarget() {
    return target;
  }
  public void setTarget(Commit target) {
    this.target = target;
  }

  /**
   **/
  public Ref type(String type) {
    this.type = type;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("type")
  @NotNull
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }

  /**
   **/
  public Ref links(RefLinks links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public RefLinks getLinks() {
    return links;
  }
  public void setLinks(RefLinks links) {
    this.links = links;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Ref ref = (Ref) o;
    return Objects.equals(name, ref.name) &&
        Objects.equals(target, ref.target) &&
        Objects.equals(type, ref.type) &&
        Objects.equals(links, ref.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, target, type, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Ref {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

