package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.SearchCodeSearchResult;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class SearchResultPage   {
  
  private @Valid String next;
  private @Valid Integer pagelen;
  private @Valid String previous;
  private @Valid Integer page;
  private @Valid List<SearchCodeSearchResult> values = new ArrayList<SearchCodeSearchResult>();
  private @Valid Long size;
  private @Valid Boolean querySubstituted;

  /**
   **/
  public SearchResultPage next(String next) {
    this.next = next;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("next")
  public String getNext() {
    return next;
  }
  public void setNext(String next) {
    this.next = next;
  }

  /**
   **/
  public SearchResultPage pagelen(Integer pagelen) {
    this.pagelen = pagelen;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("pagelen")
  public Integer getPagelen() {
    return pagelen;
  }
  public void setPagelen(Integer pagelen) {
    this.pagelen = pagelen;
  }

  /**
   **/
  public SearchResultPage previous(String previous) {
    this.previous = previous;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("previous")
  public String getPrevious() {
    return previous;
  }
  public void setPrevious(String previous) {
    this.previous = previous;
  }

  /**
   **/
  public SearchResultPage page(Integer page) {
    this.page = page;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("page")
  public Integer getPage() {
    return page;
  }
  public void setPage(Integer page) {
    this.page = page;
  }

  /**
   **/
  public SearchResultPage values(List<SearchCodeSearchResult> values) {
    this.values = values;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("values")
  public List<SearchCodeSearchResult> getValues() {
    return values;
  }
  public void setValues(List<SearchCodeSearchResult> values) {
    this.values = values;
  }

  /**
   **/
  public SearchResultPage size(Long size) {
    this.size = size;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("size")
  public Long getSize() {
    return size;
  }
  public void setSize(Long size) {
    this.size = size;
  }

  /**
   **/
  public SearchResultPage querySubstituted(Boolean querySubstituted) {
    this.querySubstituted = querySubstituted;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("query_substituted")
  public Boolean getQuerySubstituted() {
    return querySubstituted;
  }
  public void setQuerySubstituted(Boolean querySubstituted) {
    this.querySubstituted = querySubstituted;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchResultPage searchResultPage = (SearchResultPage) o;
    return Objects.equals(next, searchResultPage.next) &&
        Objects.equals(pagelen, searchResultPage.pagelen) &&
        Objects.equals(previous, searchResultPage.previous) &&
        Objects.equals(page, searchResultPage.page) &&
        Objects.equals(values, searchResultPage.values) &&
        Objects.equals(size, searchResultPage.size) &&
        Objects.equals(querySubstituted, searchResultPage.querySubstituted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(next, pagelen, previous, page, values, size, querySubstituted);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchResultPage {\n");
    
    sb.append("    next: ").append(toIndentedString(next)).append("\n");
    sb.append("    pagelen: ").append(toIndentedString(pagelen)).append("\n");
    sb.append("    previous: ").append(toIndentedString(previous)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    values: ").append(toIndentedString(values)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    querySubstituted: ").append(toIndentedString(querySubstituted)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

