package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class WebhookSubscription extends Object  {
  

public enum SubjectTypeEnum {

    USER(String.valueOf("user")), REPOSITORY(String.valueOf("repository")), TEAM(String.valueOf("team"));


    private String value;

    SubjectTypeEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static SubjectTypeEnum fromValue(String v) {
        for (SubjectTypeEnum b : SubjectTypeEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid SubjectTypeEnum subjectType;
  private @Valid Boolean active;
  private @Valid String uuid;
  private @Valid Date createdAt;
  private @Valid String url;
 
public enum EventsEnum {

    PULLREQUEST_UNAPPROVED(String.valueOf("pullrequest:unapproved")), ISSUE_COMMENT_CREATED(String.valueOf("issue:comment_created")), PULLREQUEST_APPROVED(String.valueOf("pullrequest:approved")), REPO_CREATED(String.valueOf("repo:created")), REPO_DELETED(String.valueOf("repo:deleted")), REPO_IMPORTED(String.valueOf("repo:imported")), PULLREQUEST_COMMENT_UPDATED(String.valueOf("pullrequest:comment_updated")), ISSUE_UPDATED(String.valueOf("issue:updated")), PROJECT_UPDATED(String.valueOf("project:updated")), PULLREQUEST_COMMENT_CREATED(String.valueOf("pullrequest:comment_created")), REPO_COMMIT_STATUS_UPDATED(String.valueOf("repo:commit_status_updated")), PULLREQUEST_UPDATED(String.valueOf("pullrequest:updated")), ISSUE_CREATED(String.valueOf("issue:created")), REPO_FORK(String.valueOf("repo:fork")), PULLREQUEST_COMMENT_DELETED(String.valueOf("pullrequest:comment_deleted")), REPO_COMMIT_STATUS_CREATED(String.valueOf("repo:commit_status_created")), REPO_UPDATED(String.valueOf("repo:updated")), PULLREQUEST_REJECTED(String.valueOf("pullrequest:rejected")), PULLREQUEST_FULFILLED(String.valueOf("pullrequest:fulfilled")), REPO_PUSH(String.valueOf("repo:push")), PULLREQUEST_CREATED(String.valueOf("pullrequest:created")), REPO_TRANSFER(String.valueOf("repo:transfer")), REPO_COMMIT_COMMENT_CREATED(String.valueOf("repo:commit_comment_created"));


    private String value;

    EventsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static EventsEnum fromValue(String v) {
        for (EventsEnum b : EventsEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid List<EventsEnum> events = new ArrayList<EventsEnum>();
  private @Valid Object subject = null;
  private @Valid String description;

  /**
   * The type of entity, which is &#x60;repository&#x60; in the case of webhook subscriptions on repositories.
   **/
  public WebhookSubscription subjectType(SubjectTypeEnum subjectType) {
    this.subjectType = subjectType;
    return this;
  }

  
  @ApiModelProperty(value = "The type of entity, which is `repository` in the case of webhook subscriptions on repositories.")
  @JsonProperty("subject_type")
  public SubjectTypeEnum getSubjectType() {
    return subjectType;
  }
  public void setSubjectType(SubjectTypeEnum subjectType) {
    this.subjectType = subjectType;
  }

  /**
   **/
  public WebhookSubscription active(Boolean active) {
    this.active = active;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("active")
  public Boolean getActive() {
    return active;
  }
  public void setActive(Boolean active) {
    this.active = active;
  }

  /**
   * The webhook&#39;s id
   **/
  public WebhookSubscription uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The webhook's id")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   **/
  public WebhookSubscription createdAt(Date createdAt) {
    this.createdAt = createdAt;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("created_at")
  public Date getCreatedAt() {
    return createdAt;
  }
  public void setCreatedAt(Date createdAt) {
    this.createdAt = createdAt;
  }

  /**
   * The URL events get delivered to.
   **/
  public WebhookSubscription url(String url) {
    this.url = url;
    return this;
  }

  
  @ApiModelProperty(value = "The URL events get delivered to.")
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * The events this webhook is subscribed to.
   **/
  public WebhookSubscription events(List<EventsEnum> events) {
    this.events = events;
    return this;
  }

  
  @ApiModelProperty(value = "The events this webhook is subscribed to.")
  @JsonProperty("events")
 @Size(min=1)  public List<EventsEnum> getEvents() {
    return events;
  }
  public void setEvents(List<EventsEnum> events) {
    this.events = events;
  }

  /**
   **/
  public WebhookSubscription subject(Object subject) {
    this.subject = subject;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("subject")
  public Object getSubject() {
    return subject;
  }
  public void setSubject(Object subject) {
    this.subject = subject;
  }

  /**
   * A user-defined description of the webhook.
   **/
  public WebhookSubscription description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "A user-defined description of the webhook.")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebhookSubscription webhookSubscription = (WebhookSubscription) o;
    return Objects.equals(subjectType, webhookSubscription.subjectType) &&
        Objects.equals(active, webhookSubscription.active) &&
        Objects.equals(uuid, webhookSubscription.uuid) &&
        Objects.equals(createdAt, webhookSubscription.createdAt) &&
        Objects.equals(url, webhookSubscription.url) &&
        Objects.equals(events, webhookSubscription.events) &&
        Objects.equals(subject, webhookSubscription.subject) &&
        Objects.equals(description, webhookSubscription.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subjectType, active, uuid, createdAt, url, events, subject, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebhookSubscription {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    subjectType: ").append(toIndentedString(subjectType)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    events: ").append(toIndentedString(events)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

