/*
 * Decompiled with CFR 0.152.
 */
package se.redmind.rmtest.cucumber.web;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import cucumber.api.DataTable;
import cucumber.api.java.After;
import cucumber.api.java.en.And;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import se.redmind.rmtest.WebDriverWrapper;
import se.redmind.rmtest.config.Configuration;
import se.redmind.utils.Try;

public class WebDriverSteps {
    private static final AtomicInteger LOCAL_COUNTER = new AtomicInteger();
    private static final String THAT = "(?:that )?";
    private static final String THE_USER = "(?:.*)?";
    private static final String THE_ELEMENT = "(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)?";
    private static final String DO_SOMETHING = "(click|clear|submit|select|hover)(?:s? (?:on|in))?";
    private static final String INPUT = "(?:input|type)(?:s? (?:on|in))?";
    private static final String IDENTIFIED_BY = "(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\"";
    private static final String THE_ELEMENT_IDENTIFIED_BY = "(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\"";
    private static final String THIS_ELEMENT = "(?:(?:this|the|an) element(?:s)?|it(?:s)?)";
    private static final String MATCHES = "(!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches)";
    private static final String QUOTED_CONTENT = "\"([^\"]*)\"";
    private static final String VARIABLE = "[_a-zA-Z][_\\-\\.\\w]*";
    private static final String NAMED = "\"([_a-zA-Z][_\\-\\.\\w]*)\"";
    private static final Pattern ALIAS = Pattern.compile("(.*)(?:\\$\\{([\\w\\(\\)]+)\\})(.*)");
    private final Map<String, By> aliasedLocations = new LinkedHashMap<String, By>();
    private final Map<String, String> aliasedValues = new LinkedHashMap<String, String>();
    private final WebDriverWrapper<WebDriver> driverWrapper;
    private final WebDriver driver;
    private WebElement element;
    private By elementLocation;

    public WebDriverSteps(WebDriverWrapper<WebDriver> driverWrapper) {
        this.driverWrapper = driverWrapper;
        this.driver = driverWrapper.getDriver();
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    @After
    public void after() {
        if (!this.driverWrapper.reuseDriverBetweenTests()) {
            this.driverWrapper.stopDriver();
        }
    }

    @When(value="^(?:that )?(?:.*)? know(?:s)?( the value of)? (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" as \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void that_we_know_the_element_named_as(String asValue, String type, String id, String alias) {
        alias = this.valueOf(alias);
        if (type != null && !"value".equals(type)) {
            if (asValue == null) {
                this.aliasedLocations.put(alias, this.by(type, id));
            } else {
                this.aliasedValues.put(alias, this.getValueOf(this.find(this.by(type, id))));
            }
        } else {
            this.aliasedValues.put(alias, this.valueOf(id));
        }
    }

    @Then(value="^(?:that )?(?:.*)? know(?:s)? (?:(?:this|the|an) element(?:s)?|it(?:s)?) attribute \"([^\"]*)\" as \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void we_know_its_attribute_as(String attribute, String alias) {
        this.aliasedValues.put(alias, this.element.getAttribute(attribute));
    }

    @Then(value="^(?:that )?(?:.*)? know(?:s)? (?:(?:this|the|an) element(?:s)?|it(?:s)?) property \"([^\"]*)\" as \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void we_know_its_property_as(String property, String alias) {
        this.aliasedValues.put(alias, this.element.getCssValue(property));
    }

    @Given(value="^th(?:is|ose|ese) alias(?:es)?:$")
    public void these_aliases(List<Map<String, String>> newAliases) {
        newAliases.forEach(alias -> {
            String value = (String)alias.get("value");
            if (!value.matches(VARIABLE)) {
                throw new IllegalArgumentException("alias " + value + " must match " + NAMED);
            }
            this.aliasedLocations.put(value, this.by((String)alias.get("type"), (String)alias.get("id")));
        });
    }

    @Given(value="^the aliases defined in the file \"([^\"]*)\"$")
    public void the_aliases_defined_in_the_file(String fileName) throws IOException {
        Splitter splitter = Splitter.on((String)"|").trimResults().omitEmptyStrings();
        List lines = Files.readLines((File)new File(fileName), (Charset)Charset.defaultCharset());
        List rows = lines.stream().map(line -> splitter.splitToList((CharSequence)line)).collect(Collectors.toList());
        this.these_aliases(DataTable.create(rows).asMaps(String.class, String.class));
    }

    @When(value="^(?:that )?(?:.*)? navigate(?:s)? to \"([^\"]*)\"$")
    public void we_navigate_to(String url) {
        String resolvedUrl = this.valueOf(url);
        this.driver.navigate().to(resolvedUrl);
        Assert.assertTrue((String)("couldn't navigate to url '" + resolvedUrl + "'"), (boolean)this.getDriver().getCurrentUrl().startsWith("http"));
    }

    @When(value="^(?:that )?(?:.*)? (?:(?:go(?:es) )?(back|forward|refresh(?:es)?))$")
    public void we_navigate(String action) {
        switch (action) {
            case "back": {
                this.driver.navigate().back();
                break;
            }
            case "forward": {
                this.driver.navigate().forward();
                break;
            }
            case "refresh": {
                this.driver.navigate().refresh();
            }
        }
    }

    @Given(value="^(?:that )?(?:.*)? switch(?:es)? to the frame with (?:name|id) \"([^\"]*)\"$")
    public void that_we_switch_to_the_frame_with(String nameOrId) {
        this.driver.switchTo().frame(nameOrId);
    }

    @Given(value="^(?:that )?(?:.*)? switch(?:es)? to the default content$")
    public void that_we_switch_to_the_default_content() {
        this.driver.switchTo().defaultContent();
    }

    @Given(value="^(?:that )?(?:.*)? switch(?:es)? to the parent frame$")
    public void that_we_switch_to_the_parent_frame() {
        if (this.driver instanceof PhantomJSDriver) {
            throw new IllegalStateException("PhantomJSDriver doesn't support the parent frame location, see https://github.com/SeleniumHQ/selenium/issues/1737");
        }
        this.driver.switchTo().parentFrame();
    }

    @When(value="^(?:that )?(?:.*)? switch(?:es)? to the frame \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void that_we_switch_to_the_frame(String alias) {
        this.driver.switchTo().frame(this.find(this.by(null, alias)));
    }

    @And(value="^(?:that )?(?:.*)? switch(?:es)? to the frame with index (\\d+)$")
    public void that_we_switch_to_the_frame_with_index(int index) {
        this.driver.switchTo().frame(index);
    }

    @Given(value="^(?:that )?(?:.*)? add(?:s)? th(?:is|ose) cookie(?:s)?:$")
    public void that_we_add_those_cookies(List<Map<String, String>> data) {
        data.forEach(cookieAsMap -> {
            Cookie.Builder builder = new Cookie.Builder((String)cookieAsMap.get("name"), (String)cookieAsMap.get("value"));
            if (cookieAsMap.containsKey("domain")) {
                builder.domain((String)cookieAsMap.get("domain"));
            }
            if (cookieAsMap.containsKey("path")) {
                builder.path((String)cookieAsMap.get("path"));
            }
            if (cookieAsMap.containsKey("expiry")) {
                builder.expiresOn((java.util.Date)Date.valueOf((String)cookieAsMap.get("expiry")));
            }
            if (cookieAsMap.containsKey("isSecure")) {
                builder.isSecure(Boolean.valueOf((String)cookieAsMap.get("isSecure")).booleanValue());
            }
            if (cookieAsMap.containsKey("isHttpOnly")) {
                builder.isHttpOnly(Boolean.valueOf((String)cookieAsMap.get("isHttpOnly")).booleanValue());
            }
            this.driver.manage().addCookie(builder.build());
        });
    }

    @Given(value="^(?:that )?(?:.*)? delete(?:s)? the cookie \"([^\"]*)\"$")
    public void that_we_delete_the_cookie(String name) {
        this.driver.manage().deleteCookieNamed(name);
    }

    @Given(value="^(?:that )?(?:.*)? delete(?:s)? all the cookies$")
    public void that_we_delete_all_the_cookies() {
        this.driver.manage().deleteAllCookies();
    }

    @When(value="^(?:that )?(?:.*)? (click|clear|submit|select|hover)(?:s? (?:on|in))? (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\"$")
    public void that_we_do_something_on_the_element_identified_by(String action, String type, String id) {
        this.find(this.by(type, id));
        this.that_we_do_something_on_the_element_identified_by(action);
    }

    @When(value="^(?:that )?(?:.*)? (click|clear|submit|select|hover)(?:s? (?:on|in))? (?:(?:this|the|an) element(?:s)?|it(?:s)?)$")
    public void that_we_do_something_on_the_element_identified_by(String action) {
        switch (action) {
            case "click": {
                this.driverWrapper.waitForCondition(ExpectedConditions.elementToBeClickable((WebElement)this.element));
                this.action().moveToElement(this.element).click().perform();
                break;
            }
            case "clear": {
                this.element.clear();
                break;
            }
            case "submit": {
                this.element.submit();
                break;
            }
            case "hover": {
                new Actions(this.driver).moveToElement(this.element).perform();
            }
        }
    }

    @Given(value="^(?:that )?(?:.*)? maximize(?:s)? the window$")
    public void that_we_maximize_the_window() throws InterruptedException {
        this.the_window_is_maximized();
    }

    @When(value="^(?:that )?the window is maximized$")
    public void the_window_is_maximized() throws InterruptedException {
        this.driver.manage().window().maximize();
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.driverWrapper.getDriver().manage().window().setSize(new Dimension(1280, 950));
        }
    }

    @When(value="^(?:that )?(?:.*)? (?:press[es]?)(?:[es])? (.*)$")
    public void that_we_press(Keys keys) {
        this.element.sendKeys(new CharSequence[]{keys});
    }

    @When(value="^(?:that )?(?:.*)? (?:input|type)(?:s? (?:on|in))? \"([^\"]*)\"$")
    public void that_we_input(String content) {
        this.element.sendKeys(new CharSequence[]{this.valueOf(content)});
    }

    @When(value="^(?:that )?(?:.*)? (?:input|type)(?:s? (?:on|in))? \"([^\"]*)\" in (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\"$")
    public void that_we_input_in_the_element_identified_by(String content, String type, String id) {
        this.find(this.by(type, id)).sendKeys(new CharSequence[]{this.valueOf(content)});
    }

    @When(value="^(?:that )?(?:.*)? wait(?:s)? (\\d+) (\\w+)")
    public void we_wait(int amount, TimeUnit timeUnit) throws InterruptedException {
        timeUnit.sleep(amount);
    }

    @Then(value="^(?:that )?the title (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void the_title_matches(String not, String assertType, String expectedValue) {
        this.assertString(assertType, this.getNotNullOrEmpty(() -> this.driver.getTitle()), not == null, expectedValue);
    }

    @Then(value="^(?:that )?the page content (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void the_page_content_is(String not, String assertType, String expectedValue) {
        this.assertString(assertType, this.find(By.tagName((String)"body")).findElement(By.tagName((String)"pre")).getText(), not == null, expectedValue);
    }

    @Then(value="^(?:that )?(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void that_the_element_at_id_matches(String type, String id, String not, String assertType, String expectedValue) {
        if (type == null && !this.aliasedLocations.containsKey(id)) {
            this.assertString(assertType, id, not == null, expectedValue);
        } else {
            this.assertElement(assertType, this.find(this.by(type, id)), not == null, expectedValue);
        }
    }

    @Then(value="^(?:that )?(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?(?:is present|exists)$")
    public void the_element_with_id_is_present(String type, String id, String not) {
        if (not == null) {
            this.find(this.by(type, id));
        } else {
            Assert.assertTrue((boolean)this.doesNotFind(this.by(type, id)));
        }
    }

    @Then(value="^(?:that )?(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?is displayed$")
    public void the_element_with_id_is_displayed(String type, String id, String not) {
        this.find(this.by(type, id));
        this.this_element_is_displayed(not);
    }

    @Then(value="^(?:that )?(?:(?:this|the|an) element(?:s)?|it(?:s)?) (!)?is displayed$")
    public void this_element_is_displayed(String not) {
        this.assertCondition(() -> this.element.isDisplayed(), not == null);
    }

    @Then(value="^(?:that )?(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?is enabled$")
    public void the_element_with_id_is_enabled(String type, String id, String not) {
        this.find(this.by(type, id));
        this.this_element_is_enabled(not);
    }

    @Then(value="^(?:that )?(?:(?:this|the|an) element(?:s)?|it(?:s)?) (!)?is enabled$")
    public void this_element_is_enabled(String not) {
        this.assertCondition(() -> this.element.isEnabled(), not == null);
    }

    @Then(value="^(?:that )?(?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?is selected$")
    public void the_element_with_id_is_selected(String type, String id, String not) {
        this.find(this.by(type, id));
        this.this_element_is_selected(not);
    }

    @Then(value="^(?:that )?(?:(?:this|the|an) element(?:s)?|it(?:s)?) (!)?is selected$")
    public void this_element_is_selected(String not) {
        this.assertCondition(() -> this.element.isSelected(), not == null);
    }

    @Then(value="^(?:that )?the current url (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void the_current_url_ends_with(String not, String assertType, String expectedValue) {
        this.assertString(assertType, this.driver.getCurrentUrl(), not == null, expectedValue);
    }

    @Then(value="^(?:that )?executing \"([^\"]*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"?(.+)\"?$")
    public void executing_returns(String javascript, String not, String assertType, String expectedValue) {
        String value = String.valueOf(((JavascriptExecutor)this.driver).executeScript(this.valueOf(javascript), new Object[0]));
        this.assertString(assertType, value, not == null, expectedValue);
    }

    @Then(value="^(?:that )?(?:.*)? execute(?:s)? \"([^\"]*)\" as \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void we_execute_as(String javascript, String alias) {
        String value = String.valueOf(((JavascriptExecutor)this.driver).executeScript(this.valueOf(javascript), new Object[0]));
        this.aliasedValues.put(alias, value);
    }

    @Then(value="^(?:that )?evaluating \"([^\"]*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"?(.+)\"?$")
    public void evaluating(String javascript, String not, String assertType, String expectedValue) {
        String value = String.valueOf(((JavascriptExecutor)this.driver).executeScript("return " + this.valueOf(javascript) + ";", new Object[0]));
        this.assertString(assertType, value, not == null, expectedValue);
    }

    @Then(value="^(?:that )?(?:.*)? evaluate(?:s)? \"([^\"]*)\" as \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void we_evaluate_as(String javascript, String alias) {
        String value = String.valueOf(((JavascriptExecutor)this.driver).executeScript("return " + this.valueOf(javascript) + ";", new Object[0]));
        this.aliasedValues.put(alias, value);
    }

    @Then(value="^the amount of (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" equals (\\d+)$")
    public void the_amount_of_elements_with_xpath_equals(String type, String id, int amount) {
        Assert.assertEquals((long)amount, (long)this.driver.findElements(this.by(type, id)).size());
    }

    @Given(value="^(?:that )?(?:.*)? count(?:s)? (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" as \"([_a-zA-Z][_\\-\\.\\w]*)\"$")
    public void that_we_count_the_elements_with_xpath_as(String type, String id, String alias) {
        this.aliasedValues.put(alias, String.valueOf(this.driver.findElements(this.by(type, id)).size()));
    }

    @Then(value="^(?:that )?(?:(?:this|the|an) element(?:s)?|it(?:s)?) (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void this_element_matches(String not, String assertType, String expectedValue) {
        this.refreshElement();
        this.assertElement(assertType, this.element, not == null, this.valueOf(expectedValue));
    }

    @Then(value="^(?:that )?(?:(?:this|the|an) element(?:s)?|it(?:s)?) attribute \"([^\"]*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void this_element_attribute_matches(String attribute, String not, String assertType, String expectedValue) {
        this.assertString(assertType, this.element.getAttribute(attribute), not == null, expectedValue);
    }

    @Then(value="^(?:that )?the attribute \"([^\"]*)\" of (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void the_attribute_of_the_element_identified_by_matches(String attribute, String type, String id, String not, String assertType, String expectedValue) {
        this.find(this.by(type, id));
        this.this_element_attribute_matches(attribute, not, assertType, expectedValue);
    }

    @Then(value="^(?:that )?(?:(?:this|the|an) element(?:s)?|it(?:s)?) property \"([^\"]*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void this_element_property_matches(String property, String not, String assertType, String expectedValue) {
        this.assertString(assertType, this.element.getCssValue(property), not == null, expectedValue);
    }

    @Then(value="^(?:that )?the property \"([^\"]*)\" of (?:(?:the |an |a )?(?:frame|button|element|field|checkbox|radio|value)?(?:s)?)? ?(?:with (?:the )?)?(name(?:d)?|id|xpath|class|css|(?:partial )?link text|tag)? ?\"(.*)\" (!)?(reads|returns|is|equals|contains|starts with|ends with|links to|matches) \"([^\"]*)\"$")
    public void the_property_of_the_element_identified_by_matches(String property, String type, String id, String not, String assertType, String expectedValue) {
        this.find(this.by(type, id));
        this.this_element_property_matches(property, not, assertType, expectedValue);
    }

    public WebElement currentElement() {
        return this.element;
    }

    public By currentElementLocation() {
        return this.elementLocation;
    }

    private WebElement find(By elementLocation) {
        this.elementLocation = elementLocation;
        this.driverWrapper.driverFluentWait().until((Function)ExpectedConditions.presenceOfElementLocated((By)elementLocation));
        this.element = this.driver.findElement(elementLocation);
        return this.element;
    }

    private boolean doesNotFind(By elementLocation) {
        return ((List)((Try.SupplierTryer)Try.toGet(() -> this.driver.findElements(elementLocation)).until(result -> result.isEmpty()).delayRetriesBy((long)(Configuration.current().defaultTimeOut * 100))).nTimes(10)).isEmpty();
    }

    private void refreshElement() {
        this.find(this.elementLocation);
    }

    private Actions action() {
        return new Actions(this.driver);
    }

    private String get(Supplier<String> supplier) {
        return (String)((Try.SupplierTryer)Try.toGet(supplier).delayRetriesBy((long)(Configuration.current().defaultTimeOut * 100))).nTimes(10);
    }

    private String getNotNullOrEmpty(Supplier<String> supplier) {
        return (String)((Try.SupplierTryer)Try.toGet(supplier).until(value -> !Strings.isNullOrEmpty((String)value)).delayRetriesBy((long)(Configuration.current().defaultTimeOut * 100))).nTimes(10);
    }

    private String valueOf(String value) {
        return this.valueOf(value, false);
    }

    private String valueOf(String value, boolean readElementValue) {
        Matcher matcher;
        if (value.equals("UUID()")) {
            return UUID.randomUUID().toString();
        }
        if (value.equals("ID()")) {
            return String.valueOf(LOCAL_COUNTER.incrementAndGet());
        }
        if (readElementValue) {
            if (this.aliasedValues.containsKey(value)) {
                value = this.aliasedValues.get(value);
            }
            if (this.aliasedLocations.containsKey(value)) {
                value = this.getValueOf(this.find(this.aliasedLocations.get(value)));
            }
        }
        while ((matcher = ALIAS.matcher(value)).matches()) {
            value = matcher.group(1) + this.valueOf(matcher.group(2), true) + matcher.group(3);
        }
        return value;
    }

    private By by(String type, String id) {
        Preconditions.checkArgument(((id = this.valueOf(id)) != null ? 1 : 0) != 0);
        if (type == null) {
            return this.getAliasedLocation(id);
        }
        switch (type) {
            case "named": {
                return By.name((String)id);
            }
            case "id": {
                return By.id((String)id);
            }
            case "xpath": {
                return By.xpath((String)id);
            }
            case "class": {
                return By.className((String)id);
            }
            case "css": {
                return By.cssSelector((String)id);
            }
            case "link text": {
                return By.linkText((String)id);
            }
            case "partial link text": {
                return By.partialLinkText((String)id);
            }
            case "tag": {
                return By.tagName((String)id);
            }
        }
        throw new IllegalArgumentException("unknown parameter type: " + type + " value: " + id);
    }

    private By getAliasedLocation(String id) {
        if (this.aliasedLocations.containsKey(id)) {
            return this.aliasedLocations.get(id);
        }
        throw new IllegalArgumentException("unknown alias: " + id);
    }

    private void assertCondition(Supplier<Boolean> condition, boolean shouldBeTrue) {
        boolean state = (Boolean)((Try.SupplierTryer)Try.toGet(() -> (Boolean)condition.get()).until(value -> value == shouldBeTrue).delayRetriesBy((long)(Configuration.current().defaultTimeOut * 100))).defaultTo(value -> !shouldBeTrue).nTimes(10);
        Assert.assertEquals((Object)shouldBeTrue, (Object)state);
    }

    private void assertElement(String assertType, WebElement element, boolean shouldBeTrue, String expected) {
        expected = this.valueOf(expected);
        String value = this.getValueOf(element);
        if (assertType.equals("links to")) {
            assertType = "is";
        }
        this.assertString(assertType, value, shouldBeTrue, expected);
    }

    private String getValueOf(WebElement element) {
        switch (element.getTagName()) {
            case "input": {
                return element.getAttribute("value");
            }
            case "a": {
                return element.getAttribute("href");
            }
        }
        return this.getNotNullOrEmpty(() -> element.getText());
    }

    private void assertString(String assertType, String value, boolean shouldBeTrue, String expected) {
        value = this.valueOf(value);
        expected = this.valueOf(expected);
        switch (assertType) {
            case "reads": 
            case "returns": 
            case "is": 
            case "equals": {
                if (shouldBeTrue) {
                    Assert.assertEquals((Object)expected, (Object)value);
                    break;
                }
                Assert.assertNotEquals((Object)expected, (Object)value);
                break;
            }
            case "matches": {
                Assert.assertEquals((String)("'" + value + "' doesn't match '" + expected + "'"), (Object)shouldBeTrue, (Object)value.matches(expected));
                break;
            }
            case "contains": {
                Assert.assertEquals((String)("'" + value + "' doesn't contain '" + expected + "'"), (Object)shouldBeTrue, (Object)value.contains(expected));
                break;
            }
            case "starts with": {
                Assert.assertEquals((String)("'" + value + "' doesn't start with '" + expected + "'"), (Object)shouldBeTrue, (Object)value.startsWith(expected));
                break;
            }
            case "ends with": {
                Assert.assertEquals((String)("'" + value + "' doesn't end with '" + expected + "'"), (Object)shouldBeTrue, (Object)value.endsWith(expected));
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown assert type " + assertType);
            }
        }
    }
}

