/*
 * Decompiled with CFR 0.152.
 */
package yajco.generator.parsergen.metalexer;

import JFlex.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import metalexer.jflex.ML2JFlex;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import yajco.generator.util.RegexUtil;
import yajco.generator.util.Utilities;
import yajco.grammar.bnf.Grammar;
import yajco.model.Language;

public class MetaLexerScannerGenerator {
    private static final String METALEXER_DEFAULT_LAYOUT_TEMPLATE = "/yajco/generator/parsergen/metalexer/templates/DefaultLayoutTemplate.vsl";
    private static final String METALEXER_DEFAULT_COMPONENT_TEMPLATE = "/yajco/generator/parsergen/metalexer/templates/DefaultComponentTemplate.vsl";
    private static final String METALEXER_BEAVER_LAYOUT_TEMPLATE = "/yajco/generator/parsergen/metalexer/templates/BeaverLayoutTemplate.vsl";
    private VelocityEngine engine = new VelocityEngine();

    public void generateScanner(ProcessingEnvironment processingEnv, Language language, Grammar grammar, String parserClassName, String parserPackageName) throws IOException {
        String metalexerPackageName = parserPackageName + ".metalexer";
        FileObject fo = processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, metalexerPackageName, parserClassName + ".mll", new Element[0]);
        Writer writer = fo.openWriter();
        writer.write(this.generateMetaLexerDefaultLayout(language, grammar, parserClassName, parserPackageName));
        writer.flush();
        writer.close();
        fo = processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, metalexerPackageName, "beaver.mll", new Element[0]);
        writer = fo.openWriter();
        writer.write(this.generateMetaLexerBeaverLayout());
        writer.flush();
        writer.close();
        fo = processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, metalexerPackageName, parserClassName + ".mlc", new Element[0]);
        writer = fo.openWriter();
        writer.write(this.generateMetaLexerDefaultComponent(language, grammar, parserClassName, parserPackageName));
        writer.flush();
        writer.close();
        URI inputFileURI = fo.toUri();
        File inputFile = inputFileURI.isAbsolute() ? new File(inputFileURI) : new File(inputFileURI.toString());
        ML2JFlex.main((String[])new String[]{parserClassName, inputFile.getParent(), inputFile.getParent()});
        File jflexFile = new File(inputFile.getParentFile(), parserClassName + ".flex");
        Main.main((String[])new String[]{"-d", inputFile.getParentFile().getParent(), jflexFile.getCanonicalPath()});
    }

    private String generateMetaLexerDefaultLayout(Language language, Grammar grammar, String parserClassName, String parserPackageName) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("language", (Object)language);
        context.put("terminals", grammar.getTerminals().values());
        context.put("regexps", (Object)grammar.getTerminalPool());
        context.put("parserName", (Object)parserClassName);
        context.put("parserPackage", (Object)parserPackageName);
        context.put("defaultSymbolName", (Object)"SYMBOL");
        context.put("Utilities", Utilities.class);
        StringWriter writer = new StringWriter();
        this.engine.evaluate((Context)context, (Writer)writer, "", (Reader)new InputStreamReader(this.getClass().getResourceAsStream(METALEXER_DEFAULT_LAYOUT_TEMPLATE)));
        return writer.toString();
    }

    private String generateMetaLexerDefaultComponent(Language language, Grammar grammar, String parserClassName, String parserPackageName) throws IOException {
        VelocityContext context = new VelocityContext();
        context.put("language", (Object)language);
        context.put("terminals", grammar.getTerminals().values());
        context.put("regexps", (Object)grammar.getTerminalPool());
        context.put("parserName", (Object)parserClassName);
        context.put("parserPackage", (Object)parserPackageName);
        context.put("defaultSymbolName", (Object)"SYMBOL");
        context.put("Utilities", Utilities.class);
        context.put("RegexUtilities", RegexUtil.class);
        StringWriter writer = new StringWriter();
        this.engine.evaluate((Context)context, (Writer)writer, "", (Reader)new InputStreamReader(this.getClass().getResourceAsStream(METALEXER_DEFAULT_COMPONENT_TEMPLATE)));
        return writer.toString();
    }

    private String generateMetaLexerBeaverLayout() throws IOException {
        VelocityContext context = new VelocityContext();
        StringWriter writer = new StringWriter();
        this.engine.evaluate((Context)context, (Writer)writer, "", (Reader)new InputStreamReader(this.getClass().getResourceAsStream(METALEXER_BEAVER_LAYOUT_TEMPLATE)));
        return writer.toString();
    }
}

