package software.amazon.awscdk.services.batch;

/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 * <p>
 * The <code>AWS::Batch::JobDefinition</code> resource specifies the parameters for an AWS Batch job definition. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definitions.html">Job Definitions</a> in the ** .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * Object limits;
 * Object options;
 * Object parameters;
 * Object requests;
 * Object tags;
 * CfnJobDefinition cfnJobDefinition = CfnJobDefinition.Builder.create(this, "MyCfnJobDefinition")
 *         .type("type")
 *         // the properties below are optional
 *         .containerProperties(ContainerPropertiesProperty.builder()
 *                 .image("image")
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .environment(List.of(EnvironmentProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .executionRoleArn("executionRoleArn")
 *                 .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
 *                         .platformVersion("platformVersion")
 *                         .build())
 *                 .instanceType("instanceType")
 *                 .jobRoleArn("jobRoleArn")
 *                 .linuxParameters(LinuxParametersProperty.builder()
 *                         .devices(List.of(DeviceProperty.builder()
 *                                 .containerPath("containerPath")
 *                                 .hostPath("hostPath")
 *                                 .permissions(List.of("permissions"))
 *                                 .build()))
 *                         .initProcessEnabled(false)
 *                         .maxSwap(123)
 *                         .sharedMemorySize(123)
 *                         .swappiness(123)
 *                         .tmpfs(List.of(TmpfsProperty.builder()
 *                                 .containerPath("containerPath")
 *                                 .size(123)
 *                                 // the properties below are optional
 *                                 .mountOptions(List.of("mountOptions"))
 *                                 .build()))
 *                         .build())
 *                 .logConfiguration(LogConfigurationProperty.builder()
 *                         .logDriver("logDriver")
 *                         // the properties below are optional
 *                         .options(options)
 *                         .secretOptions(List.of(SecretProperty.builder()
 *                                 .name("name")
 *                                 .valueFrom("valueFrom")
 *                                 .build()))
 *                         .build())
 *                 .memory(123)
 *                 .mountPoints(List.of(MountPointsProperty.builder()
 *                         .containerPath("containerPath")
 *                         .readOnly(false)
 *                         .sourceVolume("sourceVolume")
 *                         .build()))
 *                 .networkConfiguration(NetworkConfigurationProperty.builder()
 *                         .assignPublicIp("assignPublicIp")
 *                         .build())
 *                 .privileged(false)
 *                 .readonlyRootFilesystem(false)
 *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .secrets(List.of(SecretProperty.builder()
 *                         .name("name")
 *                         .valueFrom("valueFrom")
 *                         .build()))
 *                 .ulimits(List.of(UlimitProperty.builder()
 *                         .hardLimit(123)
 *                         .name("name")
 *                         .softLimit(123)
 *                         .build()))
 *                 .user("user")
 *                 .vcpus(123)
 *                 .volumes(List.of(VolumesProperty.builder()
 *                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
 *                                 .fileSystemId("fileSystemId")
 *                                 // the properties below are optional
 *                                 .authorizationConfig(AuthorizationConfigProperty.builder()
 *                                         .accessPointId("accessPointId")
 *                                         .iam("iam")
 *                                         .build())
 *                                 .rootDirectory("rootDirectory")
 *                                 .transitEncryption("transitEncryption")
 *                                 .transitEncryptionPort(123)
 *                                 .build())
 *                         .host(VolumesHostProperty.builder()
 *                                 .sourcePath("sourcePath")
 *                                 .build())
 *                         .name("name")
 *                         .build()))
 *                 .build())
 *         .eksProperties(EksPropertiesProperty.builder()
 *                 .podProperties(PodPropertiesProperty.builder()
 *                         .containers(List.of(EksContainerProperty.builder()
 *                                 .image("image")
 *                                 // the properties below are optional
 *                                 .args(List.of("args"))
 *                                 .command(List.of("command"))
 *                                 .env(List.of(EksContainerEnvironmentVariableProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .value("value")
 *                                         .build()))
 *                                 .imagePullPolicy("imagePullPolicy")
 *                                 .name("name")
 *                                 .resources(ResourcesProperty.builder()
 *                                         .limits(limits)
 *                                         .requests(requests)
 *                                         .build())
 *                                 .securityContext(SecurityContextProperty.builder()
 *                                         .privileged(false)
 *                                         .readOnlyRootFilesystem(false)
 *                                         .runAsGroup(123)
 *                                         .runAsNonRoot(false)
 *                                         .runAsUser(123)
 *                                         .build())
 *                                 .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
 *                                         .mountPath("mountPath")
 *                                         .name("name")
 *                                         .readOnly(false)
 *                                         .build()))
 *                                 .build()))
 *                         .dnsPolicy("dnsPolicy")
 *                         .hostNetwork(false)
 *                         .serviceAccountName("serviceAccountName")
 *                         .volumes(List.of(EksVolumeProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .emptyDir(EmptyDirProperty.builder()
 *                                         .medium("medium")
 *                                         .sizeLimit("sizeLimit")
 *                                         .build())
 *                                 .hostPath(HostPathProperty.builder()
 *                                         .path("path")
 *                                         .build())
 *                                 .secret(SecretProperty.builder()
 *                                         .name("name")
 *                                         .valueFrom("valueFrom")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .jobDefinitionName("jobDefinitionName")
 *         .nodeProperties(NodePropertiesProperty.builder()
 *                 .mainNode(123)
 *                 .nodeRangeProperties(List.of(NodeRangePropertyProperty.builder()
 *                         .targetNodes("targetNodes")
 *                         // the properties below are optional
 *                         .container(ContainerPropertiesProperty.builder()
 *                                 .image("image")
 *                                 // the properties below are optional
 *                                 .command(List.of("command"))
 *                                 .environment(List.of(EnvironmentProperty.builder()
 *                                         .name("name")
 *                                         .value("value")
 *                                         .build()))
 *                                 .executionRoleArn("executionRoleArn")
 *                                 .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
 *                                         .platformVersion("platformVersion")
 *                                         .build())
 *                                 .instanceType("instanceType")
 *                                 .jobRoleArn("jobRoleArn")
 *                                 .linuxParameters(LinuxParametersProperty.builder()
 *                                         .devices(List.of(DeviceProperty.builder()
 *                                                 .containerPath("containerPath")
 *                                                 .hostPath("hostPath")
 *                                                 .permissions(List.of("permissions"))
 *                                                 .build()))
 *                                         .initProcessEnabled(false)
 *                                         .maxSwap(123)
 *                                         .sharedMemorySize(123)
 *                                         .swappiness(123)
 *                                         .tmpfs(List.of(TmpfsProperty.builder()
 *                                                 .containerPath("containerPath")
 *                                                 .size(123)
 *                                                 // the properties below are optional
 *                                                 .mountOptions(List.of("mountOptions"))
 *                                                 .build()))
 *                                         .build())
 *                                 .logConfiguration(LogConfigurationProperty.builder()
 *                                         .logDriver("logDriver")
 *                                         // the properties below are optional
 *                                         .options(options)
 *                                         .secretOptions(List.of(SecretProperty.builder()
 *                                                 .name("name")
 *                                                 .valueFrom("valueFrom")
 *                                                 .build()))
 *                                         .build())
 *                                 .memory(123)
 *                                 .mountPoints(List.of(MountPointsProperty.builder()
 *                                         .containerPath("containerPath")
 *                                         .readOnly(false)
 *                                         .sourceVolume("sourceVolume")
 *                                         .build()))
 *                                 .networkConfiguration(NetworkConfigurationProperty.builder()
 *                                         .assignPublicIp("assignPublicIp")
 *                                         .build())
 *                                 .privileged(false)
 *                                 .readonlyRootFilesystem(false)
 *                                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
 *                                         .type("type")
 *                                         .value("value")
 *                                         .build()))
 *                                 .secrets(List.of(SecretProperty.builder()
 *                                         .name("name")
 *                                         .valueFrom("valueFrom")
 *                                         .build()))
 *                                 .ulimits(List.of(UlimitProperty.builder()
 *                                         .hardLimit(123)
 *                                         .name("name")
 *                                         .softLimit(123)
 *                                         .build()))
 *                                 .user("user")
 *                                 .vcpus(123)
 *                                 .volumes(List.of(VolumesProperty.builder()
 *                                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
 *                                                 .fileSystemId("fileSystemId")
 *                                                 // the properties below are optional
 *                                                 .authorizationConfig(AuthorizationConfigProperty.builder()
 *                                                         .accessPointId("accessPointId")
 *                                                         .iam("iam")
 *                                                         .build())
 *                                                 .rootDirectory("rootDirectory")
 *                                                 .transitEncryption("transitEncryption")
 *                                                 .transitEncryptionPort(123)
 *                                                 .build())
 *                                         .host(VolumesHostProperty.builder()
 *                                                 .sourcePath("sourcePath")
 *                                                 .build())
 *                                         .name("name")
 *                                         .build()))
 *                                 .build())
 *                         .build()))
 *                 .numNodes(123)
 *                 .build())
 *         .parameters(parameters)
 *         .platformCapabilities(List.of("platformCapabilities"))
 *         .propagateTags(false)
 *         .retryStrategy(RetryStrategyProperty.builder()
 *                 .attempts(123)
 *                 .evaluateOnExit(List.of(EvaluateOnExitProperty.builder()
 *                         .action("action")
 *                         // the properties below are optional
 *                         .onExitCode("onExitCode")
 *                         .onReason("onReason")
 *                         .onStatusReason("onStatusReason")
 *                         .build()))
 *                 .build())
 *         .schedulingPriority(123)
 *         .tags(tags)
 *         .timeout(TimeoutProperty.builder()
 *                 .attemptDurationSeconds(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:26.932Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition")
public class CfnJobDefinition extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.CfnJobDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Batch::JobDefinition`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJobDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.CfnJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags that are applied to the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * Default parameters or parameter substitution placeholders that are set in the job definition.
     * <p>
     * Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getParameters() {
        return software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Default parameters or parameter substitution placeholders that are set in the job definition.
     * <p>
     * Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <em>AWS Batch User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "parameters", java.util.Objects.requireNonNull(value, "parameters is required"));
    }

    /**
     * The type of job definition.
     * <p>
     * For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If the job is run on Fargate resources, then <code>multinode</code> isn't supported.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of job definition.
     * <p>
     * For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If the job is run on Fargate resources, then <code>multinode</code> isn't supported.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * An object with various properties specific to Amazon ECS based jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContainerProperties() {
        return software.amazon.jsii.Kernel.get(this, "containerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with various properties specific to Amazon ECS based jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "containerProperties", value);
    }

    /**
     * An object with various properties specific to Amazon ECS based jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "containerProperties", value);
    }

    /**
     * An object with various properties that are specific to Amazon EKS based jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEksProperties() {
        return software.amazon.jsii.Kernel.get(this, "eksProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with various properties that are specific to Amazon EKS based jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEksProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eksProperties", value);
    }

    /**
     * An object with various properties that are specific to Amazon EKS based jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEksProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.EksPropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "eksProperties", value);
    }

    /**
     * The name of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobDefinitionName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobDefinitionName", value);
    }

    /**
     * An object with various properties that are specific to multi-node parallel jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     * <p>
     * <blockquote>
     * <p>
     * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeProperties() {
        return software.amazon.jsii.Kernel.get(this, "nodeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with various properties that are specific to multi-node parallel jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     * <p>
     * <blockquote>
     * <p>
     * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodeProperties", value);
    }

    /**
     * An object with various properties that are specific to multi-node parallel jobs.
     * <p>
     * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
     * <p>
     * <blockquote>
     * <p>
     * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "nodeProperties", value);
    }

    /**
     * The platform capabilities required by the job definition.
     * <p>
     * If no value is specified, it defaults to <code>EC2</code> . Jobs run on Fargate resources specify <code>FARGATE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPlatformCapabilities() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "platformCapabilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The platform capabilities required by the job definition.
     * <p>
     * If no value is specified, it defaults to <code>EC2</code> . Jobs run on Fargate resources specify <code>FARGATE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformCapabilities(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "platformCapabilities", value);
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     * <p>
     * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPropagateTags() {
        return software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     * <p>
     * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTags(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "propagateTags", value);
    }

    /**
     * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
     * <p>
     * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "propagateTags", value);
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetryStrategy() {
        return software.amazon.jsii.Kernel.get(this, "retryStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetryStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "retryStrategy", value);
    }

    /**
     * The retry strategy to use for failed jobs that are submitted with this job definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetryStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty value) {
        software.amazon.jsii.Kernel.set(this, "retryStrategy", value);
    }

    /**
     * The scheduling priority of the job definition.
     * <p>
     * This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The scheduling priority of the job definition.
     * <p>
     * This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulingPriority(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "schedulingPriority", value);
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty value) {
        software.amazon.jsii.Kernel.set(this, "timeout", value);
    }
    /**
     * The authorization configuration details for the Amazon EFS file system.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * AuthorizationConfigProperty authorizationConfigProperty = AuthorizationConfigProperty.builder()
     *         .accessPointId("accessPointId")
     *         .iam("iam")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthorizationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthorizationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EFS access point ID to use.
         * <p>
         * If an access point is specified, the root directory value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code> . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS access points</a> in the <em>Amazon Elastic File System User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessPointId() {
            return null;
        }

        /**
         * Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
         * <p>
         * If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code> . If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints">Using Amazon EFS access points</a> in the <em>AWS Batch User Guide</em> . EFS IAM authorization requires that <code>TransitEncryption</code> be <code>ENABLED</code> and that a <code>JobRoleArn</code> is specified.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIam() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            java.lang.String accessPointId;
            java.lang.String iam;

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getAccessPointId}
             * @param accessPointId The Amazon EFS access point ID to use.
             *                      If an access point is specified, the root directory value specified in the <code>EFSVolumeConfiguration</code> must either be omitted or set to <code>/</code> which enforces the path set on the EFS access point. If an access point is used, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code> . For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html">Working with Amazon EFS access points</a> in the <em>Amazon Elastic File System User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessPointId(java.lang.String accessPointId) {
                this.accessPointId = accessPointId;
                return this;
            }

            /**
             * Sets the value of {@link AuthorizationConfigProperty#getIam}
             * @param iam Whether or not to use the AWS Batch job IAM role defined in a job definition when mounting the Amazon EFS file system.
             *            If enabled, transit encryption must be enabled in the <code>EFSVolumeConfiguration</code> . If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html#efs-volume-accesspoints">Using Amazon EFS access points</a> in the <em>AWS Batch User Guide</em> . EFS IAM authorization requires that <code>TransitEncryption</code> be <code>ENABLED</code> and that a <code>JobRoleArn</code> is specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iam(java.lang.String iam) {
                this.iam = iam;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthorizationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthorizationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthorizationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthorizationConfigProperty {
            private final java.lang.String accessPointId;
            private final java.lang.String iam;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessPointId = software.amazon.jsii.Kernel.get(this, "accessPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iam = software.amazon.jsii.Kernel.get(this, "iam", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessPointId = builder.accessPointId;
                this.iam = builder.iam;
            }

            @Override
            public final java.lang.String getAccessPointId() {
                return this.accessPointId;
            }

            @Override
            public final java.lang.String getIam() {
                return this.iam;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessPointId() != null) {
                    data.set("accessPointId", om.valueToTree(this.getAccessPointId()));
                }
                if (this.getIam() != null) {
                    data.set("iam", om.valueToTree(this.getIam()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.AuthorizationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthorizationConfigProperty.Jsii$Proxy that = (AuthorizationConfigProperty.Jsii$Proxy) o;

                if (this.accessPointId != null ? !this.accessPointId.equals(that.accessPointId) : that.accessPointId != null) return false;
                return this.iam != null ? this.iam.equals(that.iam) : that.iam == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessPointId != null ? this.accessPointId.hashCode() : 0;
                result = 31 * result + (this.iam != null ? this.iam.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Container properties are used for Amazon ECS based job definitions.
     * <p>
     * These properties to describe the container that's launched as part of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * ContainerPropertiesProperty containerPropertiesProperty = ContainerPropertiesProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .command(List.of("command"))
     *         .environment(List.of(EnvironmentProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .executionRoleArn("executionRoleArn")
     *         .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
     *                 .platformVersion("platformVersion")
     *                 .build())
     *         .instanceType("instanceType")
     *         .jobRoleArn("jobRoleArn")
     *         .linuxParameters(LinuxParametersProperty.builder()
     *                 .devices(List.of(DeviceProperty.builder()
     *                         .containerPath("containerPath")
     *                         .hostPath("hostPath")
     *                         .permissions(List.of("permissions"))
     *                         .build()))
     *                 .initProcessEnabled(false)
     *                 .maxSwap(123)
     *                 .sharedMemorySize(123)
     *                 .swappiness(123)
     *                 .tmpfs(List.of(TmpfsProperty.builder()
     *                         .containerPath("containerPath")
     *                         .size(123)
     *                         // the properties below are optional
     *                         .mountOptions(List.of("mountOptions"))
     *                         .build()))
     *                 .build())
     *         .logConfiguration(LogConfigurationProperty.builder()
     *                 .logDriver("logDriver")
     *                 // the properties below are optional
     *                 .options(options)
     *                 .secretOptions(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .build())
     *         .memory(123)
     *         .mountPoints(List.of(MountPointsProperty.builder()
     *                 .containerPath("containerPath")
     *                 .readOnly(false)
     *                 .sourceVolume("sourceVolume")
     *                 .build()))
     *         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                 .assignPublicIp("assignPublicIp")
     *                 .build())
     *         .privileged(false)
     *         .readonlyRootFilesystem(false)
     *         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                 .type("type")
     *                 .value("value")
     *                 .build()))
     *         .secrets(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .ulimits(List.of(UlimitProperty.builder()
     *                 .hardLimit(123)
     *                 .name("name")
     *                 .softLimit(123)
     *                 .build()))
     *         .user("user")
     *         .vcpus(123)
     *         .volumes(List.of(VolumesProperty.builder()
     *                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                         .fileSystemId("fileSystemId")
     *                         // the properties below are optional
     *                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                 .accessPointId("accessPointId")
     *                                 .iam("iam")
     *                                 .build())
     *                         .rootDirectory("rootDirectory")
     *                         .transitEncryption("transitEncryption")
     *                         .transitEncryptionPort(123)
     *                         .build())
     *                 .host(VolumesHostProperty.builder()
     *                         .sourcePath("sourcePath")
     *                         .build())
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.ContainerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ContainerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContainerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The image used to start a container.
         * <p>
         * This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with <code>*repository-url* / *image* : *tag*</code> . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to <code>Image</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter of <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>Images in Amazon ECR Public repositories use the full <code>registry/repository[:tag]</code> or <code>registry/repository[&#64;digest]</code> naming conventions. For example, <code>public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*</code> .</li>
         * <li>Images in Amazon ECR repositories use the full registry and repository URI (for example, <code>123456789012.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code> ).</li>
         * <li>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code> ).</li>
         * <li>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code> ).</li>
         * <li>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code> ).</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * The command that's passed to the container.
         * <p>
         * This parameter maps to <code>Cmd</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * This parameter maps to <code>Env</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
         * <p>
         * For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
            return null;
        }

        /**
         * The platform configuration for jobs that are running on Fargate resources.
         * <p>
         * Jobs that are running on EC2 resources must not specify this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFargatePlatformConfiguration() {
            return null;
        }

        /**
         * The instance type to use for a multi-node parallel job.
         * <p>
         * All node groups in a multi-node parallel job must use the same instance type.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJobRoleArn() {
            return null;
        }

        /**
         * Linux-specific modifications that are applied to the container, such as details for device mappings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLinuxParameters() {
            return null;
        }

        /**
         * The log configuration specification for the container.
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
         * <p>
         * <blockquote>
         * <p>
         * AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <code>LogConfiguration</code> data type).
         * <p>
         * </blockquote>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         * <p>
         * <blockquote>
         * <p>
         * The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition.
         * <p>
         * It's not supported for jobs running on Fargate resources. For jobs that run on EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * The mount points for data volumes in your container.
         * <p>
         * This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMountPoints() {
            return null;
        }

        /**
         * The network configuration for jobs that are running on Fargate resources.
         * <p>
         * Jobs that are running on EC2 resources must not specify this parameter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
            return null;
        }

        /**
         * When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user).
         * <p>
         * This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The default value is false.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * When this parameter is true, the container is given read-only access to its root file system.
         * <p>
         * This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadonlyRootFilesystem() {
            return null;
        }

        /**
         * The type and amount of resources to assign to a container.
         * <p>
         * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRequirements() {
            return null;
        }

        /**
         * The secrets for the container.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecrets() {
            return null;
        }

        /**
         * A list of `ulimits` to set in the container.
         * <p>
         * This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUlimits() {
            return null;
        }

        /**
         * The user name to use inside the container.
         * <p>
         * This parameter maps to <code>User</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return null;
        }

        /**
         * This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition.
         * <p>
         * It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the number of vCPUs reserved for the job.
         * <p>
         * Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
            return null;
        }

        /**
         * A list of data volumes used in a job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContainerPropertiesProperty> {
            java.lang.String image;
            java.util.List<java.lang.String> command;
            java.lang.Object environment;
            java.lang.String executionRoleArn;
            java.lang.Object fargatePlatformConfiguration;
            java.lang.String instanceType;
            java.lang.String jobRoleArn;
            java.lang.Object linuxParameters;
            java.lang.Object logConfiguration;
            java.lang.Number memory;
            java.lang.Object mountPoints;
            java.lang.Object networkConfiguration;
            java.lang.Object privileged;
            java.lang.Object readonlyRootFilesystem;
            java.lang.Object resourceRequirements;
            java.lang.Object secrets;
            java.lang.Object ulimits;
            java.lang.String user;
            java.lang.Number vcpus;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getImage}
             * @param image The image used to start a container. This parameter is required.
             *              This string is passed directly to the Docker daemon. Images in the Docker Hub registry are available by default. Other repositories are specified with <code>*repository-url* / *image* : *tag*</code> . It can be 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), underscores (_), colons (:), periods (.), forward slashes (/), and number signs (#). This parameter maps to <code>Image</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>IMAGE</code> parameter of <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              Docker image architecture must match the processor architecture of the compute resources that they're scheduled on. For example, ARM-based Docker images can only run on ARM-based compute resources.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li>Images in Amazon ECR Public repositories use the full <code>registry/repository[:tag]</code> or <code>registry/repository[&#64;digest]</code> naming conventions. For example, <code>public.ecr.aws/ *registry_alias* / *my-web-app* : *latest*</code> .</li>
             *              <li>Images in Amazon ECR repositories use the full registry and repository URI (for example, <code>123456789012.dkr.ecr.&lt;region-name&gt;.amazonaws.com/&lt;repository-name&gt;</code> ).</li>
             *              <li>Images in official repositories on Docker Hub use a single name (for example, <code>ubuntu</code> or <code>mongo</code> ).</li>
             *              <li>Images in other repositories on Docker Hub are qualified with an organization name (for example, <code>amazon/amazon-ecs-agent</code> ).</li>
             *              <li>Images in other online repositories are qualified further by a domain name (for example, <code>quay.io/assemblyline/ubuntu</code> ).</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getCommand}
             * @param command The command that's passed to the container.
             *                This parameter maps to <code>Cmd</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>COMMAND</code> parameter to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">https://docs.docker.com/engine/reference/builder/#cmd</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to <code>Env</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.core.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getEnvironment}
             * @param environment The environment variables to pass to a container.
             *                    This parameter maps to <code>Env</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--env</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    We don't recommend using plaintext environment variables for sensitive information, such as credential data. &gt; Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.List<? extends java.lang.Object> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getExecutionRoleArn}
             * @param executionRoleArn The Amazon Resource Name (ARN) of the execution role that AWS Batch can assume.
             *                         For jobs that run on Fargate resources, you must provide an execution role. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/execution-IAM-role.html">AWS Batch execution IAM role</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionRoleArn(java.lang.String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getFargatePlatformConfiguration}
             * @param fargatePlatformConfiguration The platform configuration for jobs that are running on Fargate resources.
             *                                     Jobs that are running on EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fargatePlatformConfiguration(software.amazon.awscdk.core.IResolvable fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getFargatePlatformConfiguration}
             * @param fargatePlatformConfiguration The platform configuration for jobs that are running on Fargate resources.
             *                                     Jobs that are running on EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fargatePlatformConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.FargatePlatformConfigurationProperty fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getInstanceType}
             * @param instanceType The instance type to use for a multi-node parallel job.
             *                     All node groups in a multi-node parallel job must use the same instance type.
             *                     <p>
             *                     <blockquote>
             *                     <p>
             *                     This parameter isn't applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn't be provided.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getJobRoleArn}
             * @param jobRoleArn The Amazon Resource Name (ARN) of the IAM role that the container can assume for AWS permissions.
             *                   For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobRoleArn(java.lang.String jobRoleArn) {
                this.jobRoleArn = jobRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.core.IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLinuxParameters}
             * @param linuxParameters Linux-specific modifications that are applied to the container, such as details for device mappings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder linuxParameters(software.amazon.awscdk.services.batch.CfnJobDefinition.LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <code>LogConfiguration</code> data type).
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.core.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getLogConfiguration}
             * @param logConfiguration The log configuration specification for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . By default, containers use the same logging driver that the Docker daemon uses. However the container might use a different logging driver than the Docker daemon by specifying a log driver with this parameter in the container definition. To use a different logging driver for a container, the log system must be configured properly on the container instance (or on a different log server for remote logging options). For more information on the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         AWS Batch currently supports a subset of the logging drivers available to the Docker daemon (shown in the <code>LogConfiguration</code> data type).
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         The Amazon ECS container agent running on a container instance must register the logging drivers available on that instance with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMemory}
             * @param memory This parameter is deprecated, use `resourceRequirements` to specify the memory requirements for the job definition.
             *               It's not supported for jobs running on Fargate resources. For jobs that run on EC2 resources, it specifies the memory hard limit (in MiB) for a container. If your container attempts to exceed the specified number, it's terminated. You must specify at least 4 MiB of memory for a job using this parameter. The memory hard limit can be specified in several places. It must be specified for each node at least once.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(software.amazon.awscdk.core.IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getMountPoints}
             * @param mountPoints The mount points for data volumes in your container.
             *                    This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--volume</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPoints(java.util.List<? extends java.lang.Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for jobs that are running on Fargate resources.
             *                             Jobs that are running on EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.core.IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getNetworkConfiguration}
             * @param networkConfiguration The network configuration for jobs that are running on Fargate resources.
             *                             Jobs that are running on EC2 resources must not specify this parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getPrivileged}
             * @param privileged When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user).
             *                   This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The default value is false.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getPrivileged}
             * @param privileged When this parameter is true, the container is given elevated permissions on the host container instance (similar to the `root` user).
             *                   This parameter maps to <code>Privileged</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--privileged</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The default value is false.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided, or specified as false.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.core.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(java.lang.Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getReadonlyRootFilesystem}
             * @param readonlyRootFilesystem When this parameter is true, the container is given read-only access to its root file system.
             *                               This parameter maps to <code>ReadonlyRootfs</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--read-only</code> option to <code>docker run</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readonlyRootFilesystem(software.amazon.awscdk.core.IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of resources to assign to a container.
             *                             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(software.amazon.awscdk.core.IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getResourceRequirements}
             * @param resourceRequirements The type and amount of resources to assign to a container.
             *                             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRequirements(java.util.List<? extends java.lang.Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getSecrets}
             * @param secrets The secrets for the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(software.amazon.awscdk.core.IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getSecrets}
             * @param secrets The secrets for the container.
             *                For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secrets(java.util.List<? extends java.lang.Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUlimits}
             * @param ulimits A list of `ulimits` to set in the container.
             *                This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(software.amazon.awscdk.core.IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUlimits}
             * @param ulimits A list of `ulimits` to set in the container.
             *                This parameter maps to <code>Ulimits</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--ulimit</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ulimits(java.util.List<? extends java.lang.Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getUser}
             * @param user The user name to use inside the container.
             *             This parameter maps to <code>User</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--user</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVcpus}
             * @param vcpus This parameter is deprecated, use `resourceRequirements` to specify the vCPU requirements for the job definition.
             *              It's not supported for jobs running on Fargate resources. For jobs running on EC2 resources, it specifies the number of vCPUs reserved for the job.
             *              <p>
             *              Each vCPU is equivalent to 1,024 CPU shares. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . The number of vCPUs must be specified but can be specified in several places. You must specify it at least once for each node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vcpus(java.lang.Number vcpus) {
                this.vcpus = vcpus;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVolumes}
             * @param volumes A list of data volumes used in a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.core.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link ContainerPropertiesProperty#getVolumes}
             * @param volumes A list of data volumes used in a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContainerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContainerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContainerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerPropertiesProperty {
            private final java.lang.String image;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object environment;
            private final java.lang.String executionRoleArn;
            private final java.lang.Object fargatePlatformConfiguration;
            private final java.lang.String instanceType;
            private final java.lang.String jobRoleArn;
            private final java.lang.Object linuxParameters;
            private final java.lang.Object logConfiguration;
            private final java.lang.Number memory;
            private final java.lang.Object mountPoints;
            private final java.lang.Object networkConfiguration;
            private final java.lang.Object privileged;
            private final java.lang.Object readonlyRootFilesystem;
            private final java.lang.Object resourceRequirements;
            private final java.lang.Object secrets;
            private final java.lang.Object ulimits;
            private final java.lang.String user;
            private final java.lang.Number vcpus;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fargatePlatformConfiguration = software.amazon.jsii.Kernel.get(this, "fargatePlatformConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.jobRoleArn = software.amazon.jsii.Kernel.get(this, "jobRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.linuxParameters = software.amazon.jsii.Kernel.get(this, "linuxParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkConfiguration = software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readonlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readonlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceRequirements = software.amazon.jsii.Kernel.get(this, "resourceRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ulimits = software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vcpus = software.amazon.jsii.Kernel.get(this, "vcpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.command = builder.command;
                this.environment = builder.environment;
                this.executionRoleArn = builder.executionRoleArn;
                this.fargatePlatformConfiguration = builder.fargatePlatformConfiguration;
                this.instanceType = builder.instanceType;
                this.jobRoleArn = builder.jobRoleArn;
                this.linuxParameters = builder.linuxParameters;
                this.logConfiguration = builder.logConfiguration;
                this.memory = builder.memory;
                this.mountPoints = builder.mountPoints;
                this.networkConfiguration = builder.networkConfiguration;
                this.privileged = builder.privileged;
                this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
                this.resourceRequirements = builder.resourceRequirements;
                this.secrets = builder.secrets;
                this.ulimits = builder.ulimits;
                this.user = builder.user;
                this.vcpus = builder.vcpus;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getExecutionRoleArn() {
                return this.executionRoleArn;
            }

            @Override
            public final java.lang.Object getFargatePlatformConfiguration() {
                return this.fargatePlatformConfiguration;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getJobRoleArn() {
                return this.jobRoleArn;
            }

            @Override
            public final java.lang.Object getLinuxParameters() {
                return this.linuxParameters;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.Object getMountPoints() {
                return this.mountPoints;
            }

            @Override
            public final java.lang.Object getNetworkConfiguration() {
                return this.networkConfiguration;
            }

            @Override
            public final java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public final java.lang.Object getReadonlyRootFilesystem() {
                return this.readonlyRootFilesystem;
            }

            @Override
            public final java.lang.Object getResourceRequirements() {
                return this.resourceRequirements;
            }

            @Override
            public final java.lang.Object getSecrets() {
                return this.secrets;
            }

            @Override
            public final java.lang.Object getUlimits() {
                return this.ulimits;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            public final java.lang.Number getVcpus() {
                return this.vcpus;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getExecutionRoleArn() != null) {
                    data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
                }
                if (this.getFargatePlatformConfiguration() != null) {
                    data.set("fargatePlatformConfiguration", om.valueToTree(this.getFargatePlatformConfiguration()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getJobRoleArn() != null) {
                    data.set("jobRoleArn", om.valueToTree(this.getJobRoleArn()));
                }
                if (this.getLinuxParameters() != null) {
                    data.set("linuxParameters", om.valueToTree(this.getLinuxParameters()));
                }
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }
                if (this.getMountPoints() != null) {
                    data.set("mountPoints", om.valueToTree(this.getMountPoints()));
                }
                if (this.getNetworkConfiguration() != null) {
                    data.set("networkConfiguration", om.valueToTree(this.getNetworkConfiguration()));
                }
                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getReadonlyRootFilesystem() != null) {
                    data.set("readonlyRootFilesystem", om.valueToTree(this.getReadonlyRootFilesystem()));
                }
                if (this.getResourceRequirements() != null) {
                    data.set("resourceRequirements", om.valueToTree(this.getResourceRequirements()));
                }
                if (this.getSecrets() != null) {
                    data.set("secrets", om.valueToTree(this.getSecrets()));
                }
                if (this.getUlimits() != null) {
                    data.set("ulimits", om.valueToTree(this.getUlimits()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }
                if (this.getVcpus() != null) {
                    data.set("vcpus", om.valueToTree(this.getVcpus()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.ContainerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContainerPropertiesProperty.Jsii$Proxy that = (ContainerPropertiesProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
                if (this.fargatePlatformConfiguration != null ? !this.fargatePlatformConfiguration.equals(that.fargatePlatformConfiguration) : that.fargatePlatformConfiguration != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.jobRoleArn != null ? !this.jobRoleArn.equals(that.jobRoleArn) : that.jobRoleArn != null) return false;
                if (this.linuxParameters != null ? !this.linuxParameters.equals(that.linuxParameters) : that.linuxParameters != null) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
                if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
                if (this.networkConfiguration != null ? !this.networkConfiguration.equals(that.networkConfiguration) : that.networkConfiguration != null) return false;
                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.readonlyRootFilesystem != null ? !this.readonlyRootFilesystem.equals(that.readonlyRootFilesystem) : that.readonlyRootFilesystem != null) return false;
                if (this.resourceRequirements != null ? !this.resourceRequirements.equals(that.resourceRequirements) : that.resourceRequirements != null) return false;
                if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
                if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
                if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
                if (this.vcpus != null ? !this.vcpus.equals(that.vcpus) : that.vcpus != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
                result = 31 * result + (this.fargatePlatformConfiguration != null ? this.fargatePlatformConfiguration.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.jobRoleArn != null ? this.jobRoleArn.hashCode() : 0);
                result = 31 * result + (this.linuxParameters != null ? this.linuxParameters.hashCode() : 0);
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
                result = 31 * result + (this.networkConfiguration != null ? this.networkConfiguration.hashCode() : 0);
                result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
                result = 31 * result + (this.readonlyRootFilesystem != null ? this.readonlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.resourceRequirements != null ? this.resourceRequirements.hashCode() : 0);
                result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
                result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a container instance host device.
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * DeviceProperty deviceProperty = DeviceProperty.builder()
     *         .containerPath("containerPath")
     *         .hostPath("hostPath")
     *         .permissions(List.of("permissions"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path inside the container that's used to expose the host device.
         * <p>
         * By default, the <code>hostPath</code> value is used.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * The path for the device on the host container instance.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHostPath() {
            return null;
        }

        /**
         * The explicit permissions to provide to the container for the device.
         * <p>
         * By default, the container has permissions for <code>read</code> , <code>write</code> , and <code>mknod</code> for the device.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPermissions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceProperty> {
            java.lang.String containerPath;
            java.lang.String hostPath;
            java.util.List<java.lang.String> permissions;

            /**
             * Sets the value of {@link DeviceProperty#getContainerPath}
             * @param containerPath The path inside the container that's used to expose the host device.
             *                      By default, the <code>hostPath</code> value is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getHostPath}
             * @param hostPath The path for the device on the host container instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(java.lang.String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link DeviceProperty#getPermissions}
             * @param permissions The explicit permissions to provide to the container for the device.
             *                    By default, the container has permissions for <code>read</code> , <code>write</code> , and <code>mknod</code> for the device.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permissions(java.util.List<java.lang.String> permissions) {
                this.permissions = permissions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceProperty {
            private final java.lang.String containerPath;
            private final java.lang.String hostPath;
            private final java.util.List<java.lang.String> permissions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.hostPath = builder.hostPath;
                this.permissions = builder.permissions;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.String getHostPath() {
                return this.hostPath;
            }

            @Override
            public final java.util.List<java.lang.String> getPermissions() {
                return this.permissions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getHostPath() != null) {
                    data.set("hostPath", om.valueToTree(this.getHostPath()));
                }
                if (this.getPermissions() != null) {
                    data.set("permissions", om.valueToTree(this.getPermissions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.DeviceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceProperty.Jsii$Proxy that = (DeviceProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
                return this.permissions != null ? this.permissions.equals(that.permissions) : that.permissions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.hostPath != null ? this.hostPath.hashCode() : 0);
                result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This is used when you're using an Amazon Elastic File System file system for job storage.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html">Amazon EFS Volumes</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EfsVolumeConfigurationProperty efsVolumeConfigurationProperty = EfsVolumeConfigurationProperty.builder()
     *         .fileSystemId("fileSystemId")
     *         // the properties below are optional
     *         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                 .accessPointId("accessPointId")
     *                 .iam("iam")
     *                 .build())
     *         .rootDirectory("rootDirectory")
     *         .transitEncryption("transitEncryption")
     *         .transitEncryptionPort(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EfsVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EfsVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EfsVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon EFS file system ID to use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

        /**
         * The authorization configuration details for the Amazon EFS file system.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorizationConfig() {
            return null;
        }

        /**
         * The directory within the Amazon EFS file system to mount as the root directory inside the host.
         * <p>
         * If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying <code>/</code> has the same effect as omitting this parameter. The maximum length is 4,096 characters.
         * <p>
         * <blockquote>
         * <p>
         * If an EFS access point is specified in the <code>authorizationConfig</code> , the root directory parameter must either be omitted or set to <code>/</code> , which enforces the path set on the Amazon EFS access point.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRootDirectory() {
            return null;
        }

        /**
         * Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
         * <p>
         * Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting data in transit</a> in the <em>Amazon Elastic File System User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTransitEncryption() {
            return null;
        }

        /**
         * The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
         * <p>
         * If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS mount helper</a> in the <em>Amazon Elastic File System User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTransitEncryptionPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EfsVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EfsVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EfsVolumeConfigurationProperty> {
            java.lang.String fileSystemId;
            java.lang.Object authorizationConfig;
            java.lang.String rootDirectory;
            java.lang.String transitEncryption;
            java.lang.Number transitEncryptionPort;

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getFileSystemId}
             * @param fileSystemId The Amazon EFS file system ID to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileSystemId(java.lang.String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration details for the Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.core.IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getAuthorizationConfig}
             * @param authorizationConfig The authorization configuration details for the Amazon EFS file system.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationConfig(software.amazon.awscdk.services.batch.CfnJobDefinition.AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getRootDirectory}
             * @param rootDirectory The directory within the Amazon EFS file system to mount as the root directory inside the host.
             *                      If this parameter is omitted, the root of the Amazon EFS volume is used instead. Specifying <code>/</code> has the same effect as omitting this parameter. The maximum length is 4,096 characters.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      If an EFS access point is specified in the <code>authorizationConfig</code> , the root directory parameter must either be omitted or set to <code>/</code> , which enforces the path set on the Amazon EFS access point.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootDirectory(java.lang.String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getTransitEncryption}
             * @param transitEncryption Determines whether to enable encryption for Amazon EFS data in transit between the Amazon ECS host and the Amazon EFS server.
             *                          Transit encryption must be enabled if Amazon EFS IAM authorization is used. If this parameter is omitted, the default value of <code>DISABLED</code> is used. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html">Encrypting data in transit</a> in the <em>Amazon Elastic File System User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitEncryption(java.lang.String transitEncryption) {
                this.transitEncryption = transitEncryption;
                return this;
            }

            /**
             * Sets the value of {@link EfsVolumeConfigurationProperty#getTransitEncryptionPort}
             * @param transitEncryptionPort The port to use when sending encrypted data between the Amazon ECS host and the Amazon EFS server.
             *                              If you don't specify a transit encryption port, it uses the port selection strategy that the Amazon EFS mount helper uses. The value must be between 0 and 65,535. For more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html">EFS mount helper</a> in the <em>Amazon Elastic File System User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder transitEncryptionPort(java.lang.Number transitEncryptionPort) {
                this.transitEncryptionPort = transitEncryptionPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EfsVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EfsVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EfsVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EfsVolumeConfigurationProperty {
            private final java.lang.String fileSystemId;
            private final java.lang.Object authorizationConfig;
            private final java.lang.String rootDirectory;
            private final java.lang.String transitEncryption;
            private final java.lang.Number transitEncryptionPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationConfig = software.amazon.jsii.Kernel.get(this, "authorizationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rootDirectory = software.amazon.jsii.Kernel.get(this, "rootDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitEncryption = software.amazon.jsii.Kernel.get(this, "transitEncryption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.transitEncryptionPort = software.amazon.jsii.Kernel.get(this, "transitEncryptionPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
                this.authorizationConfig = builder.authorizationConfig;
                this.rootDirectory = builder.rootDirectory;
                this.transitEncryption = builder.transitEncryption;
                this.transitEncryptionPort = builder.transitEncryptionPort;
            }

            @Override
            public final java.lang.String getFileSystemId() {
                return this.fileSystemId;
            }

            @Override
            public final java.lang.Object getAuthorizationConfig() {
                return this.authorizationConfig;
            }

            @Override
            public final java.lang.String getRootDirectory() {
                return this.rootDirectory;
            }

            @Override
            public final java.lang.String getTransitEncryption() {
                return this.transitEncryption;
            }

            @Override
            public final java.lang.Number getTransitEncryptionPort() {
                return this.transitEncryptionPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
                if (this.getAuthorizationConfig() != null) {
                    data.set("authorizationConfig", om.valueToTree(this.getAuthorizationConfig()));
                }
                if (this.getRootDirectory() != null) {
                    data.set("rootDirectory", om.valueToTree(this.getRootDirectory()));
                }
                if (this.getTransitEncryption() != null) {
                    data.set("transitEncryption", om.valueToTree(this.getTransitEncryption()));
                }
                if (this.getTransitEncryptionPort() != null) {
                    data.set("transitEncryptionPort", om.valueToTree(this.getTransitEncryptionPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EfsVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EfsVolumeConfigurationProperty.Jsii$Proxy that = (EfsVolumeConfigurationProperty.Jsii$Proxy) o;

                if (!fileSystemId.equals(that.fileSystemId)) return false;
                if (this.authorizationConfig != null ? !this.authorizationConfig.equals(that.authorizationConfig) : that.authorizationConfig != null) return false;
                if (this.rootDirectory != null ? !this.rootDirectory.equals(that.rootDirectory) : that.rootDirectory != null) return false;
                if (this.transitEncryption != null ? !this.transitEncryption.equals(that.transitEncryption) : that.transitEncryption != null) return false;
                return this.transitEncryptionPort != null ? this.transitEncryptionPort.equals(that.transitEncryptionPort) : that.transitEncryptionPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileSystemId.hashCode();
                result = 31 * result + (this.authorizationConfig != null ? this.authorizationConfig.hashCode() : 0);
                result = 31 * result + (this.rootDirectory != null ? this.rootDirectory.hashCode() : 0);
                result = 31 * result + (this.transitEncryption != null ? this.transitEncryption.hashCode() : 0);
                result = 31 * result + (this.transitEncryptionPort != null ? this.transitEncryptionPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An environment variable.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksContainerEnvironmentVariableProperty eksContainerEnvironmentVariableProperty = EksContainerEnvironmentVariableProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EksContainerEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EksContainerEnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksContainerEnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksContainerEnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EksContainerEnvironmentVariableProperty#getName}
             * @param name The name of the environment variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerEnvironmentVariableProperty#getValue}
             * @param value The value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksContainerEnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksContainerEnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksContainerEnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerEnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EksContainerEnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksContainerEnvironmentVariableProperty.Jsii$Proxy that = (EksContainerEnvironmentVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * EKS container properties are used in job definitions for Amazon EKS based job definitions to describe the properties for a container node in the pod that's launched as part of a job.
     * <p>
     * This can't be specified for Amazon ECS based job definitions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object limits;
     * Object requests;
     * EksContainerProperty eksContainerProperty = EksContainerProperty.builder()
     *         .image("image")
     *         // the properties below are optional
     *         .args(List.of("args"))
     *         .command(List.of("command"))
     *         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build()))
     *         .imagePullPolicy("imagePullPolicy")
     *         .name("name")
     *         .resources(ResourcesProperty.builder()
     *                 .limits(limits)
     *                 .requests(requests)
     *                 .build())
     *         .securityContext(SecurityContextProperty.builder()
     *                 .privileged(false)
     *                 .readOnlyRootFilesystem(false)
     *                 .runAsGroup(123)
     *                 .runAsNonRoot(false)
     *                 .runAsUser(123)
     *                 .build())
     *         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                 .mountPath("mountPath")
     *                 .name("name")
     *                 .readOnly(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EksContainerProperty")
    @software.amazon.jsii.Jsii.Proxy(EksContainerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksContainerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Docker image used to start the container.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImage();

        /**
         * An array of arguments to the entrypoint.
         * <p>
         * If this isn't specified, the <code>CMD</code> of the container image is used. This corresponds to the <code>args</code> member in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> portion of the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/">Pod</a> in Kubernetes. Environment variable references are expanded using the container's environment.
         * <p>
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> , and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> is passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">CMD</a> in the <em>Dockerfile reference</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a pod</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getArgs() {
            return null;
        }

        /**
         * The entrypoint for the container.
         * <p>
         * This isn't run within a shell. If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used. Environment variable references are expanded using the container's environment.
         * <p>
         * If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. The entrypoint can't be updated. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint">ENTRYPOINT</a> in the <em>Dockerfile reference</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a container</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
            return null;
        }

        /**
         * The environment variables to pass to a container.
         * <p>
         * <blockquote>
         * <p>
         * Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnv() {
            return null;
        }

        /**
         * The image pull policy for the container.
         * <p>
         * Supported values are <code>Always</code> , <code>IfNotPresent</code> , and <code>Never</code> . This parameter defaults to <code>IfNotPresent</code> . However, if the <code>:latest</code> tag is specified, it defaults to <code>Always</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images">Updating images</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImagePullPolicy() {
            return null;
        }

        /**
         * The name of the container.
         * <p>
         * If the name isn't specified, the default name " <code>Default</code> " is used. Each container in a pod must have a unique name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The type and amount of resources to assign to a container.
         * <p>
         * The supported resources include <code>memory</code> , <code>cpu</code> , and <code>nvidia.com/gpu</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods and containers</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResources() {
            return null;
        }

        /**
         * The security context for a job.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityContext() {
            return null;
        }

        /**
         * The volume mounts for the container.
         * <p>
         * AWS Batch supports <code>emptyDir</code> , <code>hostPath</code> , and <code>secret</code> volume types. For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumeMounts() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksContainerProperty> {
            java.lang.String image;
            java.util.List<java.lang.String> args;
            java.util.List<java.lang.String> command;
            java.lang.Object env;
            java.lang.String imagePullPolicy;
            java.lang.String name;
            java.lang.Object resources;
            java.lang.Object securityContext;
            java.lang.Object volumeMounts;

            /**
             * Sets the value of {@link EksContainerProperty#getImage}
             * @param image The Docker image used to start the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder image(java.lang.String image) {
                this.image = image;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getArgs}
             * @param args An array of arguments to the entrypoint.
             *             If this isn't specified, the <code>CMD</code> of the container image is used. This corresponds to the <code>args</code> member in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> portion of the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/">Pod</a> in Kubernetes. Environment variable references are expanded using the container's environment.
             *             <p>
             *             If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> , and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> is passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#cmd">CMD</a> in the <em>Dockerfile reference</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a pod</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder args(java.util.List<java.lang.String> args) {
                this.args = args;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getCommand}
             * @param command The entrypoint for the container.
             *                This isn't run within a shell. If this isn't specified, the <code>ENTRYPOINT</code> of the container image is used. Environment variable references are expanded using the container's environment.
             *                <p>
             *                If the referenced environment variable doesn't exist, the reference in the command isn't changed. For example, if the reference is to " <code>$(NAME1)</code> " and the <code>NAME1</code> environment variable doesn't exist, the command string will remain " <code>$(NAME1)</code> ." <code>$$</code> is replaced with <code>$</code> and the resulting string isn't expanded. For example, <code>$$(VAR_NAME)</code> will be passed as <code>$(VAR_NAME)</code> whether or not the <code>VAR_NAME</code> environment variable exists. The entrypoint can't be updated. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/builder/#entrypoint">ENTRYPOINT</a> in the <em>Dockerfile reference</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/">Define a command and arguments for a container</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/reference/kubernetes-api/workload-resources/pod-v1/#entrypoint">Entrypoint</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder command(java.util.List<java.lang.String> command) {
                this.command = command;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getEnv}
             * @param env The environment variables to pass to a container.
             *            <blockquote>
             *            <p>
             *            Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder env(software.amazon.awscdk.core.IResolvable env) {
                this.env = env;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getEnv}
             * @param env The environment variables to pass to a container.
             *            <blockquote>
             *            <p>
             *            Environment variables cannot start with " <code>AWS_BATCH</code> ". This naming convention is reserved for variables that AWS Batch sets.
             *            <p>
             *            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder env(java.util.List<? extends java.lang.Object> env) {
                this.env = env;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getImagePullPolicy}
             * @param imagePullPolicy The image pull policy for the container.
             *                        Supported values are <code>Always</code> , <code>IfNotPresent</code> , and <code>Never</code> . This parameter defaults to <code>IfNotPresent</code> . However, if the <code>:latest</code> tag is specified, it defaults to <code>Always</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/containers/images/#updating-images">Updating images</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imagePullPolicy(java.lang.String imagePullPolicy) {
                this.imagePullPolicy = imagePullPolicy;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getName}
             * @param name The name of the container.
             *             If the name isn't specified, the default name " <code>Default</code> " is used. Each container in a pod must have a unique name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getResources}
             * @param resources The type and amount of resources to assign to a container.
             *                  The supported resources include <code>memory</code> , <code>cpu</code> , and <code>nvidia.com/gpu</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods and containers</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(software.amazon.awscdk.core.IResolvable resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getResources}
             * @param resources The type and amount of resources to assign to a container.
             *                  The supported resources include <code>memory</code> , <code>cpu</code> , and <code>nvidia.com/gpu</code> . For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/">Resource management for pods and containers</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resources(software.amazon.awscdk.services.batch.CfnJobDefinition.ResourcesProperty resources) {
                this.resources = resources;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getSecurityContext}
             * @param securityContext The security context for a job.
             *                        For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityContext(software.amazon.awscdk.core.IResolvable securityContext) {
                this.securityContext = securityContext;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getSecurityContext}
             * @param securityContext The security context for a job.
             *                        For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityContext(software.amazon.awscdk.services.batch.CfnJobDefinition.SecurityContextProperty securityContext) {
                this.securityContext = securityContext;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getVolumeMounts}
             * @param volumeMounts The volume mounts for the container.
             *                     AWS Batch supports <code>emptyDir</code> , <code>hostPath</code> , and <code>secret</code> volume types. For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeMounts(software.amazon.awscdk.core.IResolvable volumeMounts) {
                this.volumeMounts = volumeMounts;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerProperty#getVolumeMounts}
             * @param volumeMounts The volume mounts for the container.
             *                     AWS Batch supports <code>emptyDir</code> , <code>hostPath</code> , and <code>secret</code> volume types. For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeMounts(java.util.List<? extends java.lang.Object> volumeMounts) {
                this.volumeMounts = volumeMounts;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksContainerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksContainerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksContainerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerProperty {
            private final java.lang.String image;
            private final java.util.List<java.lang.String> args;
            private final java.util.List<java.lang.String> command;
            private final java.lang.Object env;
            private final java.lang.String imagePullPolicy;
            private final java.lang.String name;
            private final java.lang.Object resources;
            private final java.lang.Object securityContext;
            private final java.lang.Object volumeMounts;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.imagePullPolicy = software.amazon.jsii.Kernel.get(this, "imagePullPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resources = software.amazon.jsii.Kernel.get(this, "resources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityContext = software.amazon.jsii.Kernel.get(this, "securityContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeMounts = software.amazon.jsii.Kernel.get(this, "volumeMounts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
                this.args = builder.args;
                this.command = builder.command;
                this.env = builder.env;
                this.imagePullPolicy = builder.imagePullPolicy;
                this.name = builder.name;
                this.resources = builder.resources;
                this.securityContext = builder.securityContext;
                this.volumeMounts = builder.volumeMounts;
            }

            @Override
            public final java.lang.String getImage() {
                return this.image;
            }

            @Override
            public final java.util.List<java.lang.String> getArgs() {
                return this.args;
            }

            @Override
            public final java.util.List<java.lang.String> getCommand() {
                return this.command;
            }

            @Override
            public final java.lang.Object getEnv() {
                return this.env;
            }

            @Override
            public final java.lang.String getImagePullPolicy() {
                return this.imagePullPolicy;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getResources() {
                return this.resources;
            }

            @Override
            public final java.lang.Object getSecurityContext() {
                return this.securityContext;
            }

            @Override
            public final java.lang.Object getVolumeMounts() {
                return this.volumeMounts;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("image", om.valueToTree(this.getImage()));
                if (this.getArgs() != null) {
                    data.set("args", om.valueToTree(this.getArgs()));
                }
                if (this.getCommand() != null) {
                    data.set("command", om.valueToTree(this.getCommand()));
                }
                if (this.getEnv() != null) {
                    data.set("env", om.valueToTree(this.getEnv()));
                }
                if (this.getImagePullPolicy() != null) {
                    data.set("imagePullPolicy", om.valueToTree(this.getImagePullPolicy()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getResources() != null) {
                    data.set("resources", om.valueToTree(this.getResources()));
                }
                if (this.getSecurityContext() != null) {
                    data.set("securityContext", om.valueToTree(this.getSecurityContext()));
                }
                if (this.getVolumeMounts() != null) {
                    data.set("volumeMounts", om.valueToTree(this.getVolumeMounts()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EksContainerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksContainerProperty.Jsii$Proxy that = (EksContainerProperty.Jsii$Proxy) o;

                if (!image.equals(that.image)) return false;
                if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
                if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
                if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
                if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) return false;
                if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) return false;
                return this.volumeMounts != null ? this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts == null;
            }

            @Override
            public final int hashCode() {
                int result = this.image.hashCode();
                result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
                result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
                result = 31 * result + (this.env != null ? this.env.hashCode() : 0);
                result = 31 * result + (this.imagePullPolicy != null ? this.imagePullPolicy.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
                result = 31 * result + (this.securityContext != null ? this.securityContext.hashCode() : 0);
                result = 31 * result + (this.volumeMounts != null ? this.volumeMounts.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The volume mounts for a container for an Amazon EKS job.
     * <p>
     * For more information about volumes and volume mounts in Kubernetes, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/">Volumes</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksContainerVolumeMountProperty eksContainerVolumeMountProperty = EksContainerVolumeMountProperty.builder()
     *         .mountPath("mountPath")
     *         .name("name")
     *         .readOnly(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EksContainerVolumeMountProperty")
    @software.amazon.jsii.Jsii.Proxy(EksContainerVolumeMountProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksContainerVolumeMountProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path on the container where the volume is mounted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMountPath() {
            return null;
        }

        /**
         * The name the volume mount.
         * <p>
         * This must match the name of one of the volumes in the pod.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * If this value is `true` , the container has read-only access to the volume.
         * <p>
         * Otherwise, the container can write to the volume. The default value is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksContainerVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksContainerVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksContainerVolumeMountProperty> {
            java.lang.String mountPath;
            java.lang.String name;
            java.lang.Object readOnly;

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getMountPath}
             * @param mountPath The path on the container where the volume is mounted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountPath(java.lang.String mountPath) {
                this.mountPath = mountPath;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getName}
             * @param name The name the volume mount.
             *             This must match the name of one of the volumes in the pod.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getReadOnly}
             * @param readOnly If this value is `true` , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link EksContainerVolumeMountProperty#getReadOnly}
             * @param readOnly If this value is `true` , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.core.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksContainerVolumeMountProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksContainerVolumeMountProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksContainerVolumeMountProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksContainerVolumeMountProperty {
            private final java.lang.String mountPath;
            private final java.lang.String name;
            private final java.lang.Object readOnly;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mountPath = software.amazon.jsii.Kernel.get(this, "mountPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mountPath = builder.mountPath;
                this.name = builder.name;
                this.readOnly = builder.readOnly;
            }

            @Override
            public final java.lang.String getMountPath() {
                return this.mountPath;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMountPath() != null) {
                    data.set("mountPath", om.valueToTree(this.getMountPath()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EksContainerVolumeMountProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksContainerVolumeMountProperty.Jsii$Proxy that = (EksContainerVolumeMountProperty.Jsii$Proxy) o;

                if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.readOnly != null ? this.readOnly.equals(that.readOnly) : that.readOnly == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mountPath != null ? this.mountPath.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that contains the properties for the Kubernetes resources of a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object limits;
     * Object requests;
     * EksPropertiesProperty eksPropertiesProperty = EksPropertiesProperty.builder()
     *         .podProperties(PodPropertiesProperty.builder()
     *                 .containers(List.of(EksContainerProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .args(List.of("args"))
     *                         .command(List.of("command"))
     *                         .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .imagePullPolicy("imagePullPolicy")
     *                         .name("name")
     *                         .resources(ResourcesProperty.builder()
     *                                 .limits(limits)
     *                                 .requests(requests)
     *                                 .build())
     *                         .securityContext(SecurityContextProperty.builder()
     *                                 .privileged(false)
     *                                 .readOnlyRootFilesystem(false)
     *                                 .runAsGroup(123)
     *                                 .runAsNonRoot(false)
     *                                 .runAsUser(123)
     *                                 .build())
     *                         .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                                 .mountPath("mountPath")
     *                                 .name("name")
     *                                 .readOnly(false)
     *                                 .build()))
     *                         .build()))
     *                 .dnsPolicy("dnsPolicy")
     *                 .hostNetwork(false)
     *                 .serviceAccountName("serviceAccountName")
     *                 .volumes(List.of(EksVolumeProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .emptyDir(EmptyDirProperty.builder()
     *                                 .medium("medium")
     *                                 .sizeLimit("sizeLimit")
     *                                 .build())
     *                         .hostPath(HostPathProperty.builder()
     *                                 .path("path")
     *                                 .build())
     *                         .secret(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EksPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EksPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties for the Kubernetes pod resources of a job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPodProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksPropertiesProperty> {
            java.lang.Object podProperties;

            /**
             * Sets the value of {@link EksPropertiesProperty#getPodProperties}
             * @param podProperties The properties for the Kubernetes pod resources of a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder podProperties(software.amazon.awscdk.core.IResolvable podProperties) {
                this.podProperties = podProperties;
                return this;
            }

            /**
             * Sets the value of {@link EksPropertiesProperty#getPodProperties}
             * @param podProperties The properties for the Kubernetes pod resources of a job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder podProperties(software.amazon.awscdk.services.batch.CfnJobDefinition.PodPropertiesProperty podProperties) {
                this.podProperties = podProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksPropertiesProperty {
            private final java.lang.Object podProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.podProperties = software.amazon.jsii.Kernel.get(this, "podProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.podProperties = builder.podProperties;
            }

            @Override
            public final java.lang.Object getPodProperties() {
                return this.podProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPodProperties() != null) {
                    data.set("podProperties", om.valueToTree(this.getPodProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EksPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksPropertiesProperty.Jsii$Proxy that = (EksPropertiesProperty.Jsii$Proxy) o;

                return this.podProperties != null ? this.podProperties.equals(that.podProperties) : that.podProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.podProperties != null ? this.podProperties.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon EKS volume for a job definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EksVolumeProperty eksVolumeProperty = EksVolumeProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .emptyDir(EmptyDirProperty.builder()
     *                 .medium("medium")
     *                 .sizeLimit("sizeLimit")
     *                 .build())
     *         .hostPath(HostPathProperty.builder()
     *                 .path("path")
     *                 .build())
     *         .secret(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EksVolumeProperty")
    @software.amazon.jsii.Jsii.Proxy(EksVolumeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EksVolumeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the volume.
         * <p>
         * The name must be allowed as a DNS subdomain name. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain names</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specifies the configuration of a Kubernetes `emptyDir` volume.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmptyDir() {
            return null;
        }

        /**
         * Specifies the configuration of a Kubernetes `hostPath` volume.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostPath() {
            return null;
        }

        /**
         * Specifies the configuration of a Kubernetes `secret` volume.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EksVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EksVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EksVolumeProperty> {
            java.lang.String name;
            java.lang.Object emptyDir;
            java.lang.Object hostPath;
            java.lang.Object secret;

            /**
             * Sets the value of {@link EksVolumeProperty#getName}
             * @param name The name of the volume. This parameter is required.
             *             The name must be allowed as a DNS subdomain name. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">DNS subdomain names</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getEmptyDir}
             * @param emptyDir Specifies the configuration of a Kubernetes `emptyDir` volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyDir(software.amazon.awscdk.core.IResolvable emptyDir) {
                this.emptyDir = emptyDir;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getEmptyDir}
             * @param emptyDir Specifies the configuration of a Kubernetes `emptyDir` volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emptyDir(software.amazon.awscdk.services.batch.CfnJobDefinition.EmptyDirProperty emptyDir) {
                this.emptyDir = emptyDir;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getHostPath}
             * @param hostPath Specifies the configuration of a Kubernetes `hostPath` volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(software.amazon.awscdk.core.IResolvable hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getHostPath}
             * @param hostPath Specifies the configuration of a Kubernetes `hostPath` volume.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostPath(software.amazon.awscdk.services.batch.CfnJobDefinition.HostPathProperty hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getSecret}
             * @param secret Specifies the configuration of a Kubernetes `secret` volume.
             *               For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(software.amazon.awscdk.core.IResolvable secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Sets the value of {@link EksVolumeProperty#getSecret}
             * @param secret Specifies the configuration of a Kubernetes `secret` volume.
             *               For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#secret">secret</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(software.amazon.awscdk.services.batch.CfnJobDefinition.SecretProperty secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EksVolumeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EksVolumeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EksVolumeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksVolumeProperty {
            private final java.lang.String name;
            private final java.lang.Object emptyDir;
            private final java.lang.Object hostPath;
            private final java.lang.Object secret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.emptyDir = software.amazon.jsii.Kernel.get(this, "emptyDir", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostPath = software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secret = software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.emptyDir = builder.emptyDir;
                this.hostPath = builder.hostPath;
                this.secret = builder.secret;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getEmptyDir() {
                return this.emptyDir;
            }

            @Override
            public final java.lang.Object getHostPath() {
                return this.hostPath;
            }

            @Override
            public final java.lang.Object getSecret() {
                return this.secret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getEmptyDir() != null) {
                    data.set("emptyDir", om.valueToTree(this.getEmptyDir()));
                }
                if (this.getHostPath() != null) {
                    data.set("hostPath", om.valueToTree(this.getHostPath()));
                }
                if (this.getSecret() != null) {
                    data.set("secret", om.valueToTree(this.getSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EksVolumeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EksVolumeProperty.Jsii$Proxy that = (EksVolumeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.emptyDir != null ? !this.emptyDir.equals(that.emptyDir) : that.emptyDir != null) return false;
                if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) return false;
                return this.secret != null ? this.secret.equals(that.secret) : that.secret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.emptyDir != null ? this.emptyDir.hashCode() : 0);
                result = 31 * result + (this.hostPath != null ? this.hostPath.hashCode() : 0);
                result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a Kubernetes `emptyDir` volume.
     * <p>
     * An <code>emptyDir</code> volume is first created when a pod is assigned to a node. It exists as long as that pod is running on that node. The <code>emptyDir</code> volume is initially empty. All containers in the pod can read and write the files in the <code>emptyDir</code> volume. However, the <code>emptyDir</code> volume can be mounted at the same or different paths in each container. When a pod is removed from a node for any reason, the data in the <code>emptyDir</code> is deleted permanently. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#emptydir">emptyDir</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EmptyDirProperty emptyDirProperty = EmptyDirProperty.builder()
     *         .medium("medium")
     *         .sizeLimit("sizeLimit")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EmptyDirProperty")
    @software.amazon.jsii.Jsii.Proxy(EmptyDirProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmptyDirProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The medium to store the volume.
         * <p>
         * The default value is an empty string, which uses the storage of the node.
         * <p>
         * <ul>
         * <li><strong>""</strong> - <em>(Default)</em> Use the disk storage of the node.</li>
         * <li><strong>"Memory"</strong> - Use the <code>tmpfs</code> volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMedium() {
            return null;
        }

        /**
         * The maximum size of the volume.
         * <p>
         * By default, there's no maximum size defined.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSizeLimit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmptyDirProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmptyDirProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmptyDirProperty> {
            java.lang.String medium;
            java.lang.String sizeLimit;

            /**
             * Sets the value of {@link EmptyDirProperty#getMedium}
             * @param medium The medium to store the volume.
             *               The default value is an empty string, which uses the storage of the node.
             *               <p>
             *               <ul>
             *               <li><strong>""</strong> - <em>(Default)</em> Use the disk storage of the node.</li>
             *               <li><strong>"Memory"</strong> - Use the <code>tmpfs</code> volume that's backed by the RAM of the node. Contents of the volume are lost when the node reboots, and any storage on the volume counts against the container's memory limit.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder medium(java.lang.String medium) {
                this.medium = medium;
                return this;
            }

            /**
             * Sets the value of {@link EmptyDirProperty#getSizeLimit}
             * @param sizeLimit The maximum size of the volume.
             *                  By default, there's no maximum size defined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeLimit(java.lang.String sizeLimit) {
                this.sizeLimit = sizeLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmptyDirProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmptyDirProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmptyDirProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmptyDirProperty {
            private final java.lang.String medium;
            private final java.lang.String sizeLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.medium = software.amazon.jsii.Kernel.get(this, "medium", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sizeLimit = software.amazon.jsii.Kernel.get(this, "sizeLimit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.medium = builder.medium;
                this.sizeLimit = builder.sizeLimit;
            }

            @Override
            public final java.lang.String getMedium() {
                return this.medium;
            }

            @Override
            public final java.lang.String getSizeLimit() {
                return this.sizeLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMedium() != null) {
                    data.set("medium", om.valueToTree(this.getMedium()));
                }
                if (this.getSizeLimit() != null) {
                    data.set("sizeLimit", om.valueToTree(this.getSizeLimit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EmptyDirProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmptyDirProperty.Jsii$Proxy that = (EmptyDirProperty.Jsii$Proxy) o;

                if (this.medium != null ? !this.medium.equals(that.medium) : that.medium != null) return false;
                return this.sizeLimit != null ? this.sizeLimit.equals(that.sizeLimit) : that.sizeLimit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.medium != null ? this.medium.hashCode() : 0;
                result = 31 * result + (this.sizeLimit != null ? this.sizeLimit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Environment property type specifies environment variables to use in a job definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EnvironmentProperty environmentProperty = EnvironmentProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the environment variable.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EnvironmentProperty#getName}
             * @param name The name of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getValue}
             * @param value The value of the environment variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an array of up to 5 conditions to be met, and an action to take ( `RETRY` or `EXIT` ) if all conditions are met.
     * <p>
     * If none of the <code>EvaluateOnExit</code> conditions in a <code>RetryStrategy</code> match, then the job is retried.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * EvaluateOnExitProperty evaluateOnExitProperty = EvaluateOnExitProperty.builder()
     *         .action("action")
     *         // the properties below are optional
     *         .onExitCode("onExitCode")
     *         .onReason("onReason")
     *         .onStatusReason("onStatusReason")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.EvaluateOnExitProperty")
    @software.amazon.jsii.Jsii.Proxy(EvaluateOnExitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EvaluateOnExitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met.
         * <p>
         * The values aren't case sensitive.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job.
         * <p>
         * The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
         * <p>
         * The string can contain up to 512 characters.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnExitCode() {
            return null;
        }

        /**
         * Contains a glob pattern to match against the `Reason` returned for a job.
         * <p>
         * The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnReason() {
            return null;
        }

        /**
         * Contains a glob pattern to match against the `StatusReason` returned for a job.
         * <p>
         * The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnStatusReason() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EvaluateOnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EvaluateOnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EvaluateOnExitProperty> {
            java.lang.String action;
            java.lang.String onExitCode;
            java.lang.String onReason;
            java.lang.String onStatusReason;

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getAction}
             * @param action Specifies the action to take if all of the specified conditions ( `onStatusReason` , `onReason` , and `onExitCode` ) are met. This parameter is required.
             *               The values aren't case sensitive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getOnExitCode}
             * @param onExitCode Contains a glob pattern to match against the decimal representation of the `ExitCode` returned for a job.
             *                   The pattern can be up to 512 characters long. It can contain only numbers, and can end with an asterisk (*) so that only the start of the string needs to be an exact match.
             *                   <p>
             *                   The string can contain up to 512 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onExitCode(java.lang.String onExitCode) {
                this.onExitCode = onExitCode;
                return this;
            }

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getOnReason}
             * @param onReason Contains a glob pattern to match against the `Reason` returned for a job.
             *                 The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white space (including spaces and tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onReason(java.lang.String onReason) {
                this.onReason = onReason;
                return this;
            }

            /**
             * Sets the value of {@link EvaluateOnExitProperty#getOnStatusReason}
             * @param onStatusReason Contains a glob pattern to match against the `StatusReason` returned for a job.
             *                       The pattern can contain up to 512 characters. It can contain letters, numbers, periods (.), colons (:), and white spaces (including spaces or tabs). It can optionally end with an asterisk (*) so that only the start of the string needs to be an exact match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onStatusReason(java.lang.String onStatusReason) {
                this.onStatusReason = onStatusReason;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EvaluateOnExitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EvaluateOnExitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EvaluateOnExitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EvaluateOnExitProperty {
            private final java.lang.String action;
            private final java.lang.String onExitCode;
            private final java.lang.String onReason;
            private final java.lang.String onStatusReason;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onExitCode = software.amazon.jsii.Kernel.get(this, "onExitCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onReason = software.amazon.jsii.Kernel.get(this, "onReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onStatusReason = software.amazon.jsii.Kernel.get(this, "onStatusReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.onExitCode = builder.onExitCode;
                this.onReason = builder.onReason;
                this.onStatusReason = builder.onStatusReason;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getOnExitCode() {
                return this.onExitCode;
            }

            @Override
            public final java.lang.String getOnReason() {
                return this.onReason;
            }

            @Override
            public final java.lang.String getOnStatusReason() {
                return this.onStatusReason;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                if (this.getOnExitCode() != null) {
                    data.set("onExitCode", om.valueToTree(this.getOnExitCode()));
                }
                if (this.getOnReason() != null) {
                    data.set("onReason", om.valueToTree(this.getOnReason()));
                }
                if (this.getOnStatusReason() != null) {
                    data.set("onStatusReason", om.valueToTree(this.getOnStatusReason()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.EvaluateOnExitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EvaluateOnExitProperty.Jsii$Proxy that = (EvaluateOnExitProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (this.onExitCode != null ? !this.onExitCode.equals(that.onExitCode) : that.onExitCode != null) return false;
                if (this.onReason != null ? !this.onReason.equals(that.onReason) : that.onReason != null) return false;
                return this.onStatusReason != null ? this.onStatusReason.equals(that.onStatusReason) : that.onStatusReason == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.onExitCode != null ? this.onExitCode.hashCode() : 0);
                result = 31 * result + (this.onReason != null ? this.onReason.hashCode() : 0);
                result = 31 * result + (this.onStatusReason != null ? this.onStatusReason.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The platform configuration for jobs that are running on Fargate resources.
     * <p>
     * Jobs that run on EC2 resources must not specify this parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * FargatePlatformConfigurationProperty fargatePlatformConfigurationProperty = FargatePlatformConfigurationProperty.builder()
     *         .platformVersion("platformVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.FargatePlatformConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FargatePlatformConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FargatePlatformConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Fargate platform version where the jobs are running.
         * <p>
         * A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the AWS Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FargatePlatformConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FargatePlatformConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FargatePlatformConfigurationProperty> {
            java.lang.String platformVersion;

            /**
             * Sets the value of {@link FargatePlatformConfigurationProperty#getPlatformVersion}
             * @param platformVersion The AWS Fargate platform version where the jobs are running.
             *                        A platform version is specified only for jobs that are running on Fargate resources. If one isn't specified, the <code>LATEST</code> platform version is used by default. This uses a recent, approved version of the AWS Fargate platform for compute resources. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder platformVersion(java.lang.String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FargatePlatformConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FargatePlatformConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FargatePlatformConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargatePlatformConfigurationProperty {
            private final java.lang.String platformVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.platformVersion = builder.platformVersion;
            }

            @Override
            public final java.lang.String getPlatformVersion() {
                return this.platformVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPlatformVersion() != null) {
                    data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.FargatePlatformConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FargatePlatformConfigurationProperty.Jsii$Proxy that = (FargatePlatformConfigurationProperty.Jsii$Proxy) o;

                return this.platformVersion != null ? this.platformVersion.equals(that.platformVersion) : that.platformVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.platformVersion != null ? this.platformVersion.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the configuration of a Kubernetes `hostPath` volume.
     * <p>
     * A <code>hostPath</code> volume mounts an existing file or directory from the host node's filesystem into your pod. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/storage/volumes/#hostpath">hostPath</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * HostPathProperty hostPathProperty = HostPathProperty.builder()
     *         .path("path")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.HostPathProperty")
    @software.amazon.jsii.Jsii.Proxy(HostPathProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostPathProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path of the file or directory on the host to mount into containers on the pod.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostPathProperty> {
            java.lang.String path;

            /**
             * Sets the value of {@link HostPathProperty#getPath}
             * @param path The path of the file or directory on the host to mount into containers on the pod.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostPathProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostPathProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostPathProperty {
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.path = builder.path;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.HostPathProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostPathProperty.Jsii$Proxy that = (HostPathProperty.Jsii$Proxy) o;

                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public final int hashCode() {
                int result = this.path != null ? this.path.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Linux-specific modifications that are applied to the container, such as details for device mappings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * LinuxParametersProperty linuxParametersProperty = LinuxParametersProperty.builder()
     *         .devices(List.of(DeviceProperty.builder()
     *                 .containerPath("containerPath")
     *                 .hostPath("hostPath")
     *                 .permissions(List.of("permissions"))
     *                 .build()))
     *         .initProcessEnabled(false)
     *         .maxSwap(123)
     *         .sharedMemorySize(123)
     *         .swappiness(123)
     *         .tmpfs(List.of(TmpfsProperty.builder()
     *                 .containerPath("containerPath")
     *                 .size(123)
     *                 // the properties below are optional
     *                 .mountOptions(List.of("mountOptions"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(LinuxParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LinuxParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Any of the host devices to expose to the container.
         * <p>
         * This parameter maps to <code>Devices</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDevices() {
            return null;
        }

        /**
         * If true, run an `init` process inside the container that forwards signals and reaps processes.
         * <p>
         * This parameter maps to the <code>--init</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInitProcessEnabled() {
            return null;
        }

        /**
         * The total amount of swap memory (in MiB) a container can use.
         * <p>
         * This parameter is translated to the <code>--memory-swap</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> where the value is the sum of the container memory plus the <code>maxSwap</code> value. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details"><code>--memory-swap</code> details</a> in the Docker documentation.
         * <p>
         * If a <code>maxSwap</code> value of <code>0</code> is specified, the container doesn't use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container doesn't use the swap configuration for the container instance that it's running on. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSwap() {
            return null;
        }

        /**
         * The value for the size (in MiB) of the `/dev/shm` volume.
         * <p>
         * This parameter maps to the <code>--shm-size</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSharedMemorySize() {
            return null;
        }

        /**
         * You can use this parameter to tune a container's memory swappiness behavior.
         * <p>
         * A <code>swappiness</code> value of <code>0</code> causes swapping to not occur unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> causes pages to be swapped aggressively. Valid values are whole numbers between <code>0</code> and <code>100</code> . If the <code>swappiness</code> parameter isn't specified, a default value of <code>60</code> is used. If a value isn't specified for <code>maxSwap</code> , then this parameter is ignored. If <code>maxSwap</code> is set to 0, the container doesn't use swap. This parameter maps to the <code>--memory-swappiness</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * Consider the following when you use a per-container swap configuration.
         * <p>
         * <ul>
         * <li>Swap space must be enabled and allocated on the container instance for the containers to use.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html">Instance store swap volumes</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> or <a href="https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/">How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?</a>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>The swap space parameters are only supported for job definitions using EC2 resources.</li>
         * <li>If the <code>maxSwap</code> and <code>swappiness</code> parameters are omitted from a job definition, each container has a default <code>swappiness</code> value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSwappiness() {
            return null;
        }

        /**
         * The container path, mount options, and size (in MiB) of the `tmpfs` mount.
         * <p>
         * This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTmpfs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            java.lang.Object devices;
            java.lang.Object initProcessEnabled;
            java.lang.Number maxSwap;
            java.lang.Number sharedMemorySize;
            java.lang.Number swappiness;
            java.lang.Object tmpfs;

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices Any of the host devices to expose to the container.
             *                This parameter maps to <code>Devices</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(software.amazon.awscdk.core.IResolvable devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getDevices}
             * @param devices Any of the host devices to expose to the container.
             *                This parameter maps to <code>Devices</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--device</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(java.util.List<? extends java.lang.Object> devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getInitProcessEnabled}
             * @param initProcessEnabled If true, run an `init` process inside the container that forwards signals and reaps processes.
             *                           This parameter maps to the <code>--init</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initProcessEnabled(java.lang.Boolean initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getInitProcessEnabled}
             * @param initProcessEnabled If true, run an `init` process inside the container that forwards signals and reaps processes.
             *                           This parameter maps to the <code>--init</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . This parameter requires version 1.25 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder initProcessEnabled(software.amazon.awscdk.core.IResolvable initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getMaxSwap}
             * @param maxSwap The total amount of swap memory (in MiB) a container can use.
             *                This parameter is translated to the <code>--memory-swap</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> where the value is the sum of the container memory plus the <code>maxSwap</code> value. For more information, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/resource_constraints/#--memory-swap-details"><code>--memory-swap</code> details</a> in the Docker documentation.
             *                <p>
             *                If a <code>maxSwap</code> value of <code>0</code> is specified, the container doesn't use swap. Accepted values are <code>0</code> or any positive integer. If the <code>maxSwap</code> parameter is omitted, the container doesn't use the swap configuration for the container instance that it's running on. A <code>maxSwap</code> value must be set for the <code>swappiness</code> parameter to be used.
             *                <p>
             *                <blockquote>
             *                <p>
             *                This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxSwap(java.lang.Number maxSwap) {
                this.maxSwap = maxSwap;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getSharedMemorySize}
             * @param sharedMemorySize The value for the size (in MiB) of the `/dev/shm` volume.
             *                         This parameter maps to the <code>--shm-size</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sharedMemorySize(java.lang.Number sharedMemorySize) {
                this.sharedMemorySize = sharedMemorySize;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getSwappiness}
             * @param swappiness You can use this parameter to tune a container's memory swappiness behavior.
             *                   A <code>swappiness</code> value of <code>0</code> causes swapping to not occur unless absolutely necessary. A <code>swappiness</code> value of <code>100</code> causes pages to be swapped aggressively. Valid values are whole numbers between <code>0</code> and <code>100</code> . If the <code>swappiness</code> parameter isn't specified, a default value of <code>60</code> is used. If a value isn't specified for <code>maxSwap</code> , then this parameter is ignored. If <code>maxSwap</code> is set to 0, the container doesn't use swap. This parameter maps to the <code>--memory-swappiness</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *                   <p>
             *                   Consider the following when you use a per-container swap configuration.
             *                   <p>
             *                   <ul>
             *                   <li>Swap space must be enabled and allocated on the container instance for the containers to use.</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   By default, the Amazon ECS optimized AMIs don't have swap enabled. You must enable swap on the instance to use this feature. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-store-swap-volumes.html">Instance store swap volumes</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> or <a href="https://docs.aws.amazon.com/premiumsupport/knowledge-center/ec2-memory-swap-file/">How do I allocate memory to work as swap space in an Amazon EC2 instance by using a swap file?</a>
             *                   <p>
             *                   </blockquote>
             *                   <p>
             *                   <ul>
             *                   <li>The swap space parameters are only supported for job definitions using EC2 resources.</li>
             *                   <li>If the <code>maxSwap</code> and <code>swappiness</code> parameters are omitted from a job definition, each container has a default <code>swappiness</code> value of 60. Moreover, the total swap usage is limited to two times the memory reservation of the container.</li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide it for these jobs.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder swappiness(java.lang.Number swappiness) {
                this.swappiness = swappiness;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getTmpfs}
             * @param tmpfs The container path, mount options, and size (in MiB) of the `tmpfs` mount.
             *              This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tmpfs(software.amazon.awscdk.core.IResolvable tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            /**
             * Sets the value of {@link LinuxParametersProperty#getTmpfs}
             * @param tmpfs The container path, mount options, and size (in MiB) of the `tmpfs` mount.
             *              This parameter maps to the <code>--tmpfs</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              This parameter isn't applicable to jobs that are running on Fargate resources. Don't provide this parameter for this resource type.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tmpfs(java.util.List<? extends java.lang.Object> tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LinuxParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LinuxParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LinuxParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxParametersProperty {
            private final java.lang.Object devices;
            private final java.lang.Object initProcessEnabled;
            private final java.lang.Number maxSwap;
            private final java.lang.Number sharedMemorySize;
            private final java.lang.Number swappiness;
            private final java.lang.Object tmpfs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.devices = software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.initProcessEnabled = software.amazon.jsii.Kernel.get(this, "initProcessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxSwap = software.amazon.jsii.Kernel.get(this, "maxSwap", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sharedMemorySize = software.amazon.jsii.Kernel.get(this, "sharedMemorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.swappiness = software.amazon.jsii.Kernel.get(this, "swappiness", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.tmpfs = software.amazon.jsii.Kernel.get(this, "tmpfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.devices = builder.devices;
                this.initProcessEnabled = builder.initProcessEnabled;
                this.maxSwap = builder.maxSwap;
                this.sharedMemorySize = builder.sharedMemorySize;
                this.swappiness = builder.swappiness;
                this.tmpfs = builder.tmpfs;
            }

            @Override
            public final java.lang.Object getDevices() {
                return this.devices;
            }

            @Override
            public final java.lang.Object getInitProcessEnabled() {
                return this.initProcessEnabled;
            }

            @Override
            public final java.lang.Number getMaxSwap() {
                return this.maxSwap;
            }

            @Override
            public final java.lang.Number getSharedMemorySize() {
                return this.sharedMemorySize;
            }

            @Override
            public final java.lang.Number getSwappiness() {
                return this.swappiness;
            }

            @Override
            public final java.lang.Object getTmpfs() {
                return this.tmpfs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDevices() != null) {
                    data.set("devices", om.valueToTree(this.getDevices()));
                }
                if (this.getInitProcessEnabled() != null) {
                    data.set("initProcessEnabled", om.valueToTree(this.getInitProcessEnabled()));
                }
                if (this.getMaxSwap() != null) {
                    data.set("maxSwap", om.valueToTree(this.getMaxSwap()));
                }
                if (this.getSharedMemorySize() != null) {
                    data.set("sharedMemorySize", om.valueToTree(this.getSharedMemorySize()));
                }
                if (this.getSwappiness() != null) {
                    data.set("swappiness", om.valueToTree(this.getSwappiness()));
                }
                if (this.getTmpfs() != null) {
                    data.set("tmpfs", om.valueToTree(this.getTmpfs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.LinuxParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LinuxParametersProperty.Jsii$Proxy that = (LinuxParametersProperty.Jsii$Proxy) o;

                if (this.devices != null ? !this.devices.equals(that.devices) : that.devices != null) return false;
                if (this.initProcessEnabled != null ? !this.initProcessEnabled.equals(that.initProcessEnabled) : that.initProcessEnabled != null) return false;
                if (this.maxSwap != null ? !this.maxSwap.equals(that.maxSwap) : that.maxSwap != null) return false;
                if (this.sharedMemorySize != null ? !this.sharedMemorySize.equals(that.sharedMemorySize) : that.sharedMemorySize != null) return false;
                if (this.swappiness != null ? !this.swappiness.equals(that.swappiness) : that.swappiness != null) return false;
                return this.tmpfs != null ? this.tmpfs.equals(that.tmpfs) : that.tmpfs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.devices != null ? this.devices.hashCode() : 0;
                result = 31 * result + (this.initProcessEnabled != null ? this.initProcessEnabled.hashCode() : 0);
                result = 31 * result + (this.maxSwap != null ? this.maxSwap.hashCode() : 0);
                result = 31 * result + (this.sharedMemorySize != null ? this.sharedMemorySize.hashCode() : 0);
                result = 31 * result + (this.swappiness != null ? this.swappiness.hashCode() : 0);
                result = 31 * result + (this.tmpfs != null ? this.tmpfs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Log configuration options to send to a custom log driver for the container.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * LogConfigurationProperty logConfigurationProperty = LogConfigurationProperty.builder()
     *         .logDriver("logDriver")
     *         // the properties below are optional
     *         .options(options)
     *         .secretOptions(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.LogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The log driver to use for the container.
         * <p>
         * The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.
         * <p>
         * The supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , and <code>splunk</code> .
         * <p>
         * <blockquote>
         * <p>
         * Jobs that are running on Fargate resources are restricted to the <code>awslogs</code> and <code>splunk</code> log drivers.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>awslogs</strong> - Specifies the Amazon CloudWatch Logs logging driver. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html">Using the awslogs log driver</a> in the <em>AWS Batch User Guide</em> and <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/">Amazon CloudWatch Logs logging driver</a> in the Docker documentation.</li>
         * <li><strong>fluentd</strong> - Specifies the Fluentd logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/">Fluentd logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>gelf</strong> - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/">Graylog Extended Format logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>journald</strong> - Specifies the journald logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/">Journald logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>json-file</strong> - Specifies the JSON file logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/">JSON File logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>splunk</strong> - Specifies the Splunk logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/">Splunk logging driver</a> in the <em>Docker documentation</em> .</li>
         * <li><strong>syslog</strong> - Specifies the syslog logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/">Syslog logging driver</a> in the <em>Docker documentation</em> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software.
         * <p>
         * </blockquote>
         * <p>
         * This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogDriver();

        /**
         * The configuration options to send to the log driver.
         * <p>
         * This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * The secrets to pass to the log configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            java.lang.String logDriver;
            java.lang.Object options;
            java.lang.Object secretOptions;

            /**
             * Sets the value of {@link LogConfigurationProperty#getLogDriver}
             * @param logDriver The log driver to use for the container. This parameter is required.
             *                  The valid values that are listed for this parameter are log drivers that the Amazon ECS container agent can communicate with by default.
             *                  <p>
             *                  The supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , and <code>splunk</code> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  Jobs that are running on Fargate resources are restricted to the <code>awslogs</code> and <code>splunk</code> log drivers.
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  <ul>
             *                  <li><strong>awslogs</strong> - Specifies the Amazon CloudWatch Logs logging driver. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/using_awslogs.html">Using the awslogs log driver</a> in the <em>AWS Batch User Guide</em> and <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/awslogs/">Amazon CloudWatch Logs logging driver</a> in the Docker documentation.</li>
             *                  <li><strong>fluentd</strong> - Specifies the Fluentd logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/fluentd/">Fluentd logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>gelf</strong> - Specifies the Graylog Extended Format (GELF) logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/gelf/">Graylog Extended Format logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>journald</strong> - Specifies the journald logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/journald/">Journald logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>json-file</strong> - Specifies the JSON file logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/json-file/">JSON File logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>splunk</strong> - Specifies the Splunk logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/splunk/">Splunk logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  <li><strong>syslog</strong> - Specifies the syslog logging driver. For more information including usage and options, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/config/containers/logging/syslog/">Syslog logging driver</a> in the <em>Docker documentation</em> .</li>
             *                  </ul>
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If you have a custom driver that's not listed earlier that you want to work with the Amazon ECS container agent, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you want to have included. However, Amazon Web Services doesn't currently support running modified copies of this software.
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  This parameter requires version 1.18 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDriver(java.lang.String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getOptions}
             * @param options The configuration options to send to the log driver.
             *                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version | grep "Server API version"</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.lang.Object options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(software.amazon.awscdk.core.IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(java.util.List<? extends java.lang.Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigurationProperty {
            private final java.lang.String logDriver;
            private final java.lang.Object options;
            private final java.lang.Object secretOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDriver = java.util.Objects.requireNonNull(builder.logDriver, "logDriver is required");
                this.options = builder.options;
                this.secretOptions = builder.secretOptions;
            }

            @Override
            public final java.lang.String getLogDriver() {
                return this.logDriver;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getSecretOptions() {
                return this.secretOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logDriver", om.valueToTree(this.getLogDriver()));
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getSecretOptions() != null) {
                    data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.LogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigurationProperty.Jsii$Proxy that = (LogConfigurationProperty.Jsii$Proxy) o;

                if (!logDriver.equals(that.logDriver)) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logDriver.hashCode();
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for a Docker volume mount point that's used in a job's container properties.
     * <p>
     * This parameter maps to <code>Volumes</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/api/docker_remote_api_v1.19/#create-a-container">Create a container</a> section of the <em>Docker Remote API</em> and the <code>--volume</code> option to docker run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * MountPointsProperty mountPointsProperty = MountPointsProperty.builder()
     *         .containerPath("containerPath")
     *         .readOnly(false)
     *         .sourceVolume("sourceVolume")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.MountPointsProperty")
    @software.amazon.jsii.Jsii.Proxy(MountPointsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MountPointsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path on the container where the host volume is mounted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerPath() {
            return null;
        }

        /**
         * If this value is `true` , the container has read-only access to the volume.
         * <p>
         * Otherwise, the container can write to the volume. The default value is <code>false</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnly() {
            return null;
        }

        /**
         * The name of the volume to mount.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MountPointsProperty> {
            java.lang.String containerPath;
            java.lang.Object readOnly;
            java.lang.String sourceVolume;

            /**
             * Sets the value of {@link MountPointsProperty#getContainerPath}
             * @param containerPath The path on the container where the host volume is mounted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getReadOnly}
             * @param readOnly If this value is `true` , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(java.lang.Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getReadOnly}
             * @param readOnly If this value is `true` , the container has read-only access to the volume.
             *                 Otherwise, the container can write to the volume. The default value is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnly(software.amazon.awscdk.core.IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            /**
             * Sets the value of {@link MountPointsProperty#getSourceVolume}
             * @param sourceVolume The name of the volume to mount.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceVolume(java.lang.String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MountPointsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MountPointsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MountPointsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MountPointsProperty {
            private final java.lang.String containerPath;
            private final java.lang.Object readOnly;
            private final java.lang.String sourceVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceVolume = software.amazon.jsii.Kernel.get(this, "sourceVolume", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = builder.containerPath;
                this.readOnly = builder.readOnly;
                this.sourceVolume = builder.sourceVolume;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.Object getReadOnly() {
                return this.readOnly;
            }

            @Override
            public final java.lang.String getSourceVolume() {
                return this.sourceVolume;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerPath() != null) {
                    data.set("containerPath", om.valueToTree(this.getContainerPath()));
                }
                if (this.getReadOnly() != null) {
                    data.set("readOnly", om.valueToTree(this.getReadOnly()));
                }
                if (this.getSourceVolume() != null) {
                    data.set("sourceVolume", om.valueToTree(this.getSourceVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.MountPointsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MountPointsProperty.Jsii$Proxy that = (MountPointsProperty.Jsii$Proxy) o;

                if (this.containerPath != null ? !this.containerPath.equals(that.containerPath) : that.containerPath != null) return false;
                if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
                return this.sourceVolume != null ? this.sourceVolume.equals(that.sourceVolume) : that.sourceVolume == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath != null ? this.containerPath.hashCode() : 0;
                result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
                result = 31 * result + (this.sourceVolume != null ? this.sourceVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for jobs that are running on Fargate resources.
     * <p>
     * Jobs that are running on EC2 resources must not specify this parameter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .assignPublicIp("assignPublicIp")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the job has a public IP address.
         * <p>
         * For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . The default value is " <code>DISABLED</code> ".
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.String assignPublicIp;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp Indicates whether the job has a public IP address.
             *                       For a job that's running on Fargate resources in a private subnet to send outbound traffic to the internet (for example, to pull container images), the private subnet requires a NAT gateway be attached to route requests to the internet. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Amazon ECS task networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> . The default value is " <code>DISABLED</code> ".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.String assignPublicIp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assignPublicIp = builder.assignPublicIp;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.assignPublicIp != null ? this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the node properties of a multi-node parallel job.
     * <p>
     * <blockquote>
     * <p>
     * Node properties can't be specified for Amazon EKS based job definitions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * NodePropertiesProperty nodePropertiesProperty = NodePropertiesProperty.builder()
     *         .mainNode(123)
     *         .nodeRangeProperties(List.of(NodeRangePropertyProperty.builder()
     *                 .targetNodes("targetNodes")
     *                 // the properties below are optional
     *                 .container(ContainerPropertiesProperty.builder()
     *                         .image("image")
     *                         // the properties below are optional
     *                         .command(List.of("command"))
     *                         .environment(List.of(EnvironmentProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .executionRoleArn("executionRoleArn")
     *                         .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
     *                                 .platformVersion("platformVersion")
     *                                 .build())
     *                         .instanceType("instanceType")
     *                         .jobRoleArn("jobRoleArn")
     *                         .linuxParameters(LinuxParametersProperty.builder()
     *                                 .devices(List.of(DeviceProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .hostPath("hostPath")
     *                                         .permissions(List.of("permissions"))
     *                                         .build()))
     *                                 .initProcessEnabled(false)
     *                                 .maxSwap(123)
     *                                 .sharedMemorySize(123)
     *                                 .swappiness(123)
     *                                 .tmpfs(List.of(TmpfsProperty.builder()
     *                                         .containerPath("containerPath")
     *                                         .size(123)
     *                                         // the properties below are optional
     *                                         .mountOptions(List.of("mountOptions"))
     *                                         .build()))
     *                                 .build())
     *                         .logConfiguration(LogConfigurationProperty.builder()
     *                                 .logDriver("logDriver")
     *                                 // the properties below are optional
     *                                 .options(options)
     *                                 .secretOptions(List.of(SecretProperty.builder()
     *                                         .name("name")
     *                                         .valueFrom("valueFrom")
     *                                         .build()))
     *                                 .build())
     *                         .memory(123)
     *                         .mountPoints(List.of(MountPointsProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .readOnly(false)
     *                                 .sourceVolume("sourceVolume")
     *                                 .build()))
     *                         .networkConfiguration(NetworkConfigurationProperty.builder()
     *                                 .assignPublicIp("assignPublicIp")
     *                                 .build())
     *                         .privileged(false)
     *                         .readonlyRootFilesystem(false)
     *                         .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                                 .type("type")
     *                                 .value("value")
     *                                 .build()))
     *                         .secrets(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .ulimits(List.of(UlimitProperty.builder()
     *                                 .hardLimit(123)
     *                                 .name("name")
     *                                 .softLimit(123)
     *                                 .build()))
     *                         .user("user")
     *                         .vcpus(123)
     *                         .volumes(List.of(VolumesProperty.builder()
     *                                 .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                         .fileSystemId("fileSystemId")
     *                                         // the properties below are optional
     *                                         .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                                 .accessPointId("accessPointId")
     *                                                 .iam("iam")
     *                                                 .build())
     *                                         .rootDirectory("rootDirectory")
     *                                         .transitEncryption("transitEncryption")
     *                                         .transitEncryptionPort(123)
     *                                         .build())
     *                                 .host(VolumesHostProperty.builder()
     *                                         .sourcePath("sourcePath")
     *                                         .build())
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build()))
     *         .numNodes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.NodePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(NodePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the node index for the main node of a multi-node parallel job.
         * <p>
         * This node index value must be fewer than the number of nodes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMainNode();

        /**
         * A list of node ranges and their properties that are associated with a multi-node parallel job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNodeRangeProperties();

        /**
         * The number of nodes that are associated with a multi-node parallel job.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getNumNodes();

        /**
         * @return a {@link Builder} of {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodePropertiesProperty> {
            java.lang.Number mainNode;
            java.lang.Object nodeRangeProperties;
            java.lang.Number numNodes;

            /**
             * Sets the value of {@link NodePropertiesProperty#getMainNode}
             * @param mainNode Specifies the node index for the main node of a multi-node parallel job. This parameter is required.
             *                 This node index value must be fewer than the number of nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mainNode(java.lang.Number mainNode) {
                this.mainNode = mainNode;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNodeRangeProperties}
             * @param nodeRangeProperties A list of node ranges and their properties that are associated with a multi-node parallel job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeRangeProperties(software.amazon.awscdk.core.IResolvable nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNodeRangeProperties}
             * @param nodeRangeProperties A list of node ranges and their properties that are associated with a multi-node parallel job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeRangeProperties(java.util.List<? extends java.lang.Object> nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            /**
             * Sets the value of {@link NodePropertiesProperty#getNumNodes}
             * @param numNodes The number of nodes that are associated with a multi-node parallel job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numNodes(java.lang.Number numNodes) {
                this.numNodes = numNodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodePropertiesProperty {
            private final java.lang.Number mainNode;
            private final java.lang.Object nodeRangeProperties;
            private final java.lang.Number numNodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mainNode = software.amazon.jsii.Kernel.get(this, "mainNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.nodeRangeProperties = software.amazon.jsii.Kernel.get(this, "nodeRangeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.numNodes = software.amazon.jsii.Kernel.get(this, "numNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mainNode = java.util.Objects.requireNonNull(builder.mainNode, "mainNode is required");
                this.nodeRangeProperties = java.util.Objects.requireNonNull(builder.nodeRangeProperties, "nodeRangeProperties is required");
                this.numNodes = java.util.Objects.requireNonNull(builder.numNodes, "numNodes is required");
            }

            @Override
            public final java.lang.Number getMainNode() {
                return this.mainNode;
            }

            @Override
            public final java.lang.Object getNodeRangeProperties() {
                return this.nodeRangeProperties;
            }

            @Override
            public final java.lang.Number getNumNodes() {
                return this.numNodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mainNode", om.valueToTree(this.getMainNode()));
                data.set("nodeRangeProperties", om.valueToTree(this.getNodeRangeProperties()));
                data.set("numNodes", om.valueToTree(this.getNumNodes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.NodePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodePropertiesProperty.Jsii$Proxy that = (NodePropertiesProperty.Jsii$Proxy) o;

                if (!mainNode.equals(that.mainNode)) return false;
                if (!nodeRangeProperties.equals(that.nodeRangeProperties)) return false;
                return this.numNodes.equals(that.numNodes);
            }

            @Override
            public final int hashCode() {
                int result = this.mainNode.hashCode();
                result = 31 * result + (this.nodeRangeProperties.hashCode());
                result = 31 * result + (this.numNodes.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the properties of the node range for a multi-node parallel job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object options;
     * NodeRangePropertyProperty nodeRangePropertyProperty = NodeRangePropertyProperty.builder()
     *         .targetNodes("targetNodes")
     *         // the properties below are optional
     *         .container(ContainerPropertiesProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .command(List.of("command"))
     *                 .environment(List.of(EnvironmentProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .executionRoleArn("executionRoleArn")
     *                 .fargatePlatformConfiguration(FargatePlatformConfigurationProperty.builder()
     *                         .platformVersion("platformVersion")
     *                         .build())
     *                 .instanceType("instanceType")
     *                 .jobRoleArn("jobRoleArn")
     *                 .linuxParameters(LinuxParametersProperty.builder()
     *                         .devices(List.of(DeviceProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .hostPath("hostPath")
     *                                 .permissions(List.of("permissions"))
     *                                 .build()))
     *                         .initProcessEnabled(false)
     *                         .maxSwap(123)
     *                         .sharedMemorySize(123)
     *                         .swappiness(123)
     *                         .tmpfs(List.of(TmpfsProperty.builder()
     *                                 .containerPath("containerPath")
     *                                 .size(123)
     *                                 // the properties below are optional
     *                                 .mountOptions(List.of("mountOptions"))
     *                                 .build()))
     *                         .build())
     *                 .logConfiguration(LogConfigurationProperty.builder()
     *                         .logDriver("logDriver")
     *                         // the properties below are optional
     *                         .options(options)
     *                         .secretOptions(List.of(SecretProperty.builder()
     *                                 .name("name")
     *                                 .valueFrom("valueFrom")
     *                                 .build()))
     *                         .build())
     *                 .memory(123)
     *                 .mountPoints(List.of(MountPointsProperty.builder()
     *                         .containerPath("containerPath")
     *                         .readOnly(false)
     *                         .sourceVolume("sourceVolume")
     *                         .build()))
     *                 .networkConfiguration(NetworkConfigurationProperty.builder()
     *                         .assignPublicIp("assignPublicIp")
     *                         .build())
     *                 .privileged(false)
     *                 .readonlyRootFilesystem(false)
     *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
     *                         .type("type")
     *                         .value("value")
     *                         .build()))
     *                 .secrets(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .ulimits(List.of(UlimitProperty.builder()
     *                         .hardLimit(123)
     *                         .name("name")
     *                         .softLimit(123)
     *                         .build()))
     *                 .user("user")
     *                 .vcpus(123)
     *                 .volumes(List.of(VolumesProperty.builder()
     *                         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                                 .fileSystemId("fileSystemId")
     *                                 // the properties below are optional
     *                                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                                         .accessPointId("accessPointId")
     *                                         .iam("iam")
     *                                         .build())
     *                                 .rootDirectory("rootDirectory")
     *                                 .transitEncryption("transitEncryption")
     *                                 .transitEncryptionPort(123)
     *                                 .build())
     *                         .host(VolumesHostProperty.builder()
     *                                 .sourcePath("sourcePath")
     *                                 .build())
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.NodeRangePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeRangePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeRangePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The range of nodes, using node index values.
         * <p>
         * A range of <code>0:3</code> indicates nodes with index values of <code>0</code> through <code>3</code> . If the starting range value is omitted ( <code>:n</code> ), then <code>0</code> is used to start the range. If the ending range value is omitted ( <code>n:</code> ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( <code>0:n</code> ). You can nest node ranges (for example, <code>0:10</code> and <code>4:5</code> ). In this case, the <code>4:5</code> range properties override the <code>0:10</code> properties.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetNodes();

        /**
         * The container details for the node range.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeRangePropertyProperty> {
            java.lang.String targetNodes;
            java.lang.Object container;

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getTargetNodes}
             * @param targetNodes The range of nodes, using node index values. This parameter is required.
             *                    A range of <code>0:3</code> indicates nodes with index values of <code>0</code> through <code>3</code> . If the starting range value is omitted ( <code>:n</code> ), then <code>0</code> is used to start the range. If the ending range value is omitted ( <code>n:</code> ), then the highest possible node index is used to end the range. Your accumulative node ranges must account for all nodes ( <code>0:n</code> ). You can nest node ranges (for example, <code>0:10</code> and <code>4:5</code> ). In this case, the <code>4:5</code> range properties override the <code>0:10</code> properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetNodes(java.lang.String targetNodes) {
                this.targetNodes = targetNodes;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getContainer}
             * @param container The container details for the node range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.core.IResolvable container) {
                this.container = container;
                return this;
            }

            /**
             * Sets the value of {@link NodeRangePropertyProperty#getContainer}
             * @param container The container details for the node range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder container(software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty container) {
                this.container = container;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeRangePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeRangePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeRangePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeRangePropertyProperty {
            private final java.lang.String targetNodes;
            private final java.lang.Object container;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetNodes = software.amazon.jsii.Kernel.get(this, "targetNodes", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetNodes = java.util.Objects.requireNonNull(builder.targetNodes, "targetNodes is required");
                this.container = builder.container;
            }

            @Override
            public final java.lang.String getTargetNodes() {
                return this.targetNodes;
            }

            @Override
            public final java.lang.Object getContainer() {
                return this.container;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetNodes", om.valueToTree(this.getTargetNodes()));
                if (this.getContainer() != null) {
                    data.set("container", om.valueToTree(this.getContainer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.NodeRangePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeRangePropertyProperty.Jsii$Proxy that = (NodeRangePropertyProperty.Jsii$Proxy) o;

                if (!targetNodes.equals(that.targetNodes)) return false;
                return this.container != null ? this.container.equals(that.container) : that.container == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetNodes.hashCode();
                result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties for the pod.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object limits;
     * Object requests;
     * PodPropertiesProperty podPropertiesProperty = PodPropertiesProperty.builder()
     *         .containers(List.of(EksContainerProperty.builder()
     *                 .image("image")
     *                 // the properties below are optional
     *                 .args(List.of("args"))
     *                 .command(List.of("command"))
     *                 .env(List.of(EksContainerEnvironmentVariableProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .imagePullPolicy("imagePullPolicy")
     *                 .name("name")
     *                 .resources(ResourcesProperty.builder()
     *                         .limits(limits)
     *                         .requests(requests)
     *                         .build())
     *                 .securityContext(SecurityContextProperty.builder()
     *                         .privileged(false)
     *                         .readOnlyRootFilesystem(false)
     *                         .runAsGroup(123)
     *                         .runAsNonRoot(false)
     *                         .runAsUser(123)
     *                         .build())
     *                 .volumeMounts(List.of(EksContainerVolumeMountProperty.builder()
     *                         .mountPath("mountPath")
     *                         .name("name")
     *                         .readOnly(false)
     *                         .build()))
     *                 .build()))
     *         .dnsPolicy("dnsPolicy")
     *         .hostNetwork(false)
     *         .serviceAccountName("serviceAccountName")
     *         .volumes(List.of(EksVolumeProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .emptyDir(EmptyDirProperty.builder()
     *                         .medium("medium")
     *                         .sizeLimit("sizeLimit")
     *                         .build())
     *                 .hostPath(HostPathProperty.builder()
     *                         .path("path")
     *                         .build())
     *                 .secret(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.PodPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(PodPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PodPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties of the container that's used on the Amazon EKS pod.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContainers() {
            return null;
        }

        /**
         * The DNS policy for the pod.
         * <p>
         * The default value is <code>ClusterFirst</code> . If the <code>hostNetwork</code> parameter is not specified, the default is <code>ClusterFirstWithHostNet</code> . <code>ClusterFirst</code> indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. If no value was specified for <code>dnsPolicy</code> in the <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html">RegisterJobDefinition</a> API operation, then no value will be returned for <code>dnsPolicy</code> by either of <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html">DescribeJobDefinitions</a> or <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html">DescribeJobs</a> API operations. The pod spec setting will contain either <code>ClusterFirst</code> or <code>ClusterFirstWithHostNet</code> , depending on the value of the <code>hostNetwork</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">Pod's DNS policy</a> in the <em>Kubernetes documentation</em> .
         * <p>
         * Valid values: <code>Default</code> | <code>ClusterFirst</code> | <code>ClusterFirstWithHostNet</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsPolicy() {
            return null;
        }

        /**
         * Indicates if the pod uses the hosts' network IP address.
         * <p>
         * The default value is <code>true</code> . Setting this to <code>false</code> enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host namespaces</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod networking</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostNetwork() {
            return null;
        }

        /**
         * The name of the service account that's used to run the pod.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html">Kubernetes service accounts</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">Configure a Kubernetes service account to assume an IAM role</a> in the <em>Amazon EKS User Guide</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Configure service accounts for pods</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccountName() {
            return null;
        }

        /**
         * Specifies the volumes for a job definition that uses Amazon EKS resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PodPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PodPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PodPropertiesProperty> {
            java.lang.Object containers;
            java.lang.String dnsPolicy;
            java.lang.Object hostNetwork;
            java.lang.String serviceAccountName;
            java.lang.Object volumes;

            /**
             * Sets the value of {@link PodPropertiesProperty#getContainers}
             * @param containers The properties of the container that's used on the Amazon EKS pod.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(software.amazon.awscdk.core.IResolvable containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getContainers}
             * @param containers The properties of the container that's used on the Amazon EKS pod.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containers(java.util.List<? extends java.lang.Object> containers) {
                this.containers = containers;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getDnsPolicy}
             * @param dnsPolicy The DNS policy for the pod.
             *                  The default value is <code>ClusterFirst</code> . If the <code>hostNetwork</code> parameter is not specified, the default is <code>ClusterFirstWithHostNet</code> . <code>ClusterFirst</code> indicates that any DNS query that does not match the configured cluster domain suffix is forwarded to the upstream nameserver inherited from the node. If no value was specified for <code>dnsPolicy</code> in the <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_RegisterJobDefinition.html">RegisterJobDefinition</a> API operation, then no value will be returned for <code>dnsPolicy</code> by either of <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobDefinitions.html">DescribeJobDefinitions</a> or <a href="https://docs.aws.amazon.com/batch/latest/APIReference/API_DescribeJobs.html">DescribeJobs</a> API operations. The pod spec setting will contain either <code>ClusterFirst</code> or <code>ClusterFirstWithHostNet</code> , depending on the value of the <code>hostNetwork</code> parameter. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">Pod's DNS policy</a> in the <em>Kubernetes documentation</em> .
             *                  <p>
             *                  Valid values: <code>Default</code> | <code>ClusterFirst</code> | <code>ClusterFirstWithHostNet</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsPolicy(java.lang.String dnsPolicy) {
                this.dnsPolicy = dnsPolicy;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getHostNetwork}
             * @param hostNetwork Indicates if the pod uses the hosts' network IP address.
             *                    The default value is <code>true</code> . Setting this to <code>false</code> enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host namespaces</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod networking</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostNetwork(java.lang.Boolean hostNetwork) {
                this.hostNetwork = hostNetwork;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getHostNetwork}
             * @param hostNetwork Indicates if the pod uses the hosts' network IP address.
             *                    The default value is <code>true</code> . Setting this to <code>false</code> enables the Kubernetes pod networking model. Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections. For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#host-namespaces">Host namespaces</a> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">Pod networking</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostNetwork(software.amazon.awscdk.core.IResolvable hostNetwork) {
                this.hostNetwork = hostNetwork;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getServiceAccountName}
             * @param serviceAccountName The name of the service account that's used to run the pod.
             *                           For more information, see <a href="https://docs.aws.amazon.com/eks/latest/userguide/service-accounts.html">Kubernetes service accounts</a> and <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">Configure a Kubernetes service account to assume an IAM role</a> in the <em>Amazon EKS User Guide</em> and <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/">Configure service accounts for pods</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccountName(java.lang.String serviceAccountName) {
                this.serviceAccountName = serviceAccountName;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getVolumes}
             * @param volumes Specifies the volumes for a job definition that uses Amazon EKS resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(software.amazon.awscdk.core.IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Sets the value of {@link PodPropertiesProperty#getVolumes}
             * @param volumes Specifies the volumes for a job definition that uses Amazon EKS resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PodPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PodPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PodPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PodPropertiesProperty {
            private final java.lang.Object containers;
            private final java.lang.String dnsPolicy;
            private final java.lang.Object hostNetwork;
            private final java.lang.String serviceAccountName;
            private final java.lang.Object volumes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containers = software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dnsPolicy = software.amazon.jsii.Kernel.get(this, "dnsPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostNetwork = software.amazon.jsii.Kernel.get(this, "hostNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceAccountName = software.amazon.jsii.Kernel.get(this, "serviceAccountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containers = builder.containers;
                this.dnsPolicy = builder.dnsPolicy;
                this.hostNetwork = builder.hostNetwork;
                this.serviceAccountName = builder.serviceAccountName;
                this.volumes = builder.volumes;
            }

            @Override
            public final java.lang.Object getContainers() {
                return this.containers;
            }

            @Override
            public final java.lang.String getDnsPolicy() {
                return this.dnsPolicy;
            }

            @Override
            public final java.lang.Object getHostNetwork() {
                return this.hostNetwork;
            }

            @Override
            public final java.lang.String getServiceAccountName() {
                return this.serviceAccountName;
            }

            @Override
            public final java.lang.Object getVolumes() {
                return this.volumes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainers() != null) {
                    data.set("containers", om.valueToTree(this.getContainers()));
                }
                if (this.getDnsPolicy() != null) {
                    data.set("dnsPolicy", om.valueToTree(this.getDnsPolicy()));
                }
                if (this.getHostNetwork() != null) {
                    data.set("hostNetwork", om.valueToTree(this.getHostNetwork()));
                }
                if (this.getServiceAccountName() != null) {
                    data.set("serviceAccountName", om.valueToTree(this.getServiceAccountName()));
                }
                if (this.getVolumes() != null) {
                    data.set("volumes", om.valueToTree(this.getVolumes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.PodPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PodPropertiesProperty.Jsii$Proxy that = (PodPropertiesProperty.Jsii$Proxy) o;

                if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) return false;
                if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) return false;
                if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) return false;
                if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) return false;
                return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containers != null ? this.containers.hashCode() : 0;
                result = 31 * result + (this.dnsPolicy != null ? this.dnsPolicy.hashCode() : 0);
                result = 31 * result + (this.hostNetwork != null ? this.hostNetwork.hashCode() : 0);
                result = 31 * result + (this.serviceAccountName != null ? this.serviceAccountName.hashCode() : 0);
                result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type and amount of a resource to assign to a container.
     * <p>
     * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * ResourceRequirementProperty resourceRequirementProperty = ResourceRequirementProperty.builder()
     *         .type("type")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceRequirementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceRequirementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of resource to assign to a container.
         * <p>
         * The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.
         * <p>
         * <ul>
         * <li><strong>type="GPU"</strong> - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * GPUs aren't available for jobs that are running on Fargate resources.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>type="MEMORY"</strong> - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.
         * <p>
         * <ul>
         * <li><strong>value = 512</strong> - <code>VCPU</code> = 0.25</li>
         * <li><strong>value = 1024</strong> - <code>VCPU</code> = 0.25 or 0.5</li>
         * <li><strong>value = 2048</strong> - <code>VCPU</code> = 0.25, 0.5, or 1</li>
         * <li><strong>value = 3072</strong> - <code>VCPU</code> = 0.5, or 1</li>
         * <li><strong>value = 4096</strong> - <code>VCPU</code> = 0.5, 1, or 2</li>
         * <li><strong>value = 5120, 6144, or 7168</strong> - <code>VCPU</code> = 1 or 2</li>
         * <li><strong>value = 8192</strong> - <code>VCPU</code> = 1, 2, or 4</li>
         * <li><strong>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</strong> - <code>VCPU</code> = 2 or 4</li>
         * <li><strong>value = 16384</strong> - <code>VCPU</code> = 2, 4, or 8</li>
         * <li><strong>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</strong> - <code>VCPU</code> = 4</li>
         * <li><strong>value = 20480, 24576, or 28672</strong> - <code>VCPU</code> = 4 or 8</li>
         * <li><strong>value = 36864, 45056, 53248, or 61440</strong> - <code>VCPU</code> = 8</li>
         * <li><strong>value = 32768, 40960, 49152, or 57344</strong> - <code>VCPU</code> = 8 or 16</li>
         * <li><strong>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</strong> - <code>VCPU</code> = 16</li>
         * <li><strong>type="VCPU"</strong> - The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</li>
         * </ul>
         * <p>
         * The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">AWS Fargate quotas</a> in the <em>AWS General Reference</em> .
         * <p>
         * For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
         * <p>
         * <ul>
         * <li><strong>value = 0.25</strong> - <code>MEMORY</code> = 512, 1024, or 2048</li>
         * <li><strong>value = 0.5</strong> - <code>MEMORY</code> = 1024, 2048, 3072, or 4096</li>
         * <li><strong>value = 1</strong> - <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</li>
         * <li><strong>value = 2</strong> - <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</li>
         * <li><strong>value = 4</strong> - <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</li>
         * <li><strong>value = 8</strong> - <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440</li>
         * <li><strong>value = 16</strong> - <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            java.lang.String type;
            java.lang.String value;

            /**
             * Sets the value of {@link ResourceRequirementProperty#getType}
             * @param type The type of resource to assign to a container.
             *             The supported resources include <code>GPU</code> , <code>MEMORY</code> , and <code>VCPU</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ResourceRequirementProperty#getValue}
             * @param value The quantity of the specified resource to reserve for the container. The values vary based on the `type` specified.
             *              <ul>
             *              <li><strong>type="GPU"</strong> - The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn't exceed the number of available GPUs on the compute resource that the job is launched on.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              GPUs aren't available for jobs that are running on Fargate resources.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><strong>type="MEMORY"</strong> - The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> .</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
             *              <p>
             *              </blockquote>
             *              <p>
             *              For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.
             *              <p>
             *              <ul>
             *              <li><strong>value = 512</strong> - <code>VCPU</code> = 0.25</li>
             *              <li><strong>value = 1024</strong> - <code>VCPU</code> = 0.25 or 0.5</li>
             *              <li><strong>value = 2048</strong> - <code>VCPU</code> = 0.25, 0.5, or 1</li>
             *              <li><strong>value = 3072</strong> - <code>VCPU</code> = 0.5, or 1</li>
             *              <li><strong>value = 4096</strong> - <code>VCPU</code> = 0.5, 1, or 2</li>
             *              <li><strong>value = 5120, 6144, or 7168</strong> - <code>VCPU</code> = 1 or 2</li>
             *              <li><strong>value = 8192</strong> - <code>VCPU</code> = 1, 2, or 4</li>
             *              <li><strong>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</strong> - <code>VCPU</code> = 2 or 4</li>
             *              <li><strong>value = 16384</strong> - <code>VCPU</code> = 2, 4, or 8</li>
             *              <li><strong>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</strong> - <code>VCPU</code> = 4</li>
             *              <li><strong>value = 20480, 24576, or 28672</strong> - <code>VCPU</code> = 4 or 8</li>
             *              <li><strong>value = 36864, 45056, 53248, or 61440</strong> - <code>VCPU</code> = 8</li>
             *              <li><strong>value = 32768, 40960, 49152, or 57344</strong> - <code>VCPU</code> = 8 or 16</li>
             *              <li><strong>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</strong> - <code>VCPU</code> = 16</li>
             *              <li><strong>type="VCPU"</strong> - The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/#create-a-container">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/run/">docker run</a> . Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</li>
             *              </ul>
             *              <p>
             *              The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">AWS Fargate quotas</a> in the <em>AWS General Reference</em> .
             *              <p>
             *              For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16
             *              <p>
             *              <ul>
             *              <li><strong>value = 0.25</strong> - <code>MEMORY</code> = 512, 1024, or 2048</li>
             *              <li><strong>value = 0.5</strong> - <code>MEMORY</code> = 1024, 2048, 3072, or 4096</li>
             *              <li><strong>value = 1</strong> - <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</li>
             *              <li><strong>value = 2</strong> - <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</li>
             *              <li><strong>value = 4</strong> - <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</li>
             *              <li><strong>value = 8</strong> - <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440</li>
             *              <li><strong>value = 16</strong> - <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceRequirementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceRequirementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceRequirementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceRequirementProperty {
            private final java.lang.String type;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.ResourceRequirementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceRequirementProperty.Jsii$Proxy that = (ResourceRequirementProperty.Jsii$Proxy) o;

                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The type and quantity of the resources to request for the container.
     * <p>
     * The values vary based on the <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code> or the <code>requests</code> objects.
     * <p>
     * <ul>
     * <li><strong>memory</strong> - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * <ul>
     * <li><strong>cpu</strong> - The number of CPUs that are reserved for the container. Values must be an even multiple of <code>0.25</code> . <code>cpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>cpu</code> is specified in both, then the value that's specified in <code>limits</code> must be at least as large as the value that's specified in <code>requests</code> .</li>
     * <li><strong>nvidia.com/gpu</strong> - The number of GPUs that are reserved for the container. Values must be a whole integer. <code>nvidia.com/gpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * Object limits;
     * Object requests;
     * ResourcesProperty resourcesProperty = ResourcesProperty.builder()
     *         .limits(limits)
     *         .requests(requests)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.ResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type and quantity of the resources to reserve for the container.
         * <p>
         * The values vary based on the <code>name</code> that's specified. Resources can be requested using either the <code>limits</code> or the <code>requests</code> objects.
         * <p>
         * <ul>
         * <li><strong>memory</strong> - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both places, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>cpu</strong> - The number of CPUs that's reserved for the container. Values must be an even multiple of <code>0.25</code> . <code>cpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>cpu</code> is specified in both places, then the value that's specified in <code>limits</code> must be at least as large as the value that's specified in <code>requests</code> .</li>
         * <li><strong>nvidia.com/gpu</strong> - The number of GPUs that's reserved for the container. Values must be a whole integer. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both places, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLimits() {
            return null;
        }

        /**
         * The type and quantity of the resources to request for the container.
         * <p>
         * The values vary based on the <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code> or the <code>requests</code> objects.
         * <p>
         * <ul>
         * <li><strong>memory</strong> - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><strong>cpu</strong> - The number of CPUs that are reserved for the container. Values must be an even multiple of <code>0.25</code> . <code>cpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>cpu</code> is specified in both, then the value that's specified in <code>limits</code> must be at least as large as the value that's specified in <code>requests</code> .</li>
         * <li><strong>nvidia.com/gpu</strong> - The number of GPUs that are reserved for the container. Values must be a whole integer. <code>nvidia.com/gpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequests() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourcesProperty> {
            java.lang.Object limits;
            java.lang.Object requests;

            /**
             * Sets the value of {@link ResourcesProperty#getLimits}
             * @param limits The type and quantity of the resources to reserve for the container.
             *               The values vary based on the <code>name</code> that's specified. Resources can be requested using either the <code>limits</code> or the <code>requests</code> objects.
             *               <p>
             *               <ul>
             *               <li><strong>memory</strong> - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both places, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               To maximize your resource utilization, provide your jobs with as much memory as possible for the specific instance type that you are using. To learn how, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li><strong>cpu</strong> - The number of CPUs that's reserved for the container. Values must be an even multiple of <code>0.25</code> . <code>cpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>cpu</code> is specified in both places, then the value that's specified in <code>limits</code> must be at least as large as the value that's specified in <code>requests</code> .</li>
             *               <li><strong>nvidia.com/gpu</strong> - The number of GPUs that's reserved for the container. Values must be a whole integer. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both places, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limits(java.lang.Object limits) {
                this.limits = limits;
                return this;
            }

            /**
             * Sets the value of {@link ResourcesProperty#getRequests}
             * @param requests The type and quantity of the resources to request for the container.
             *                 The values vary based on the <code>name</code> that's specified. Resources can be requested by using either the <code>limits</code> or the <code>requests</code> objects.
             *                 <p>
             *                 <ul>
             *                 <li><strong>memory</strong> - The memory hard limit (in MiB) for the container, using whole integers, with a "Mi" suffix. If your container attempts to exceed the memory specified, the container is terminated. You must specify at least 4 MiB of memory for a job. <code>memory</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>memory</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
             *                 </ul>
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 If you're trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <em>AWS Batch User Guide</em> .
             *                 <p>
             *                 </blockquote>
             *                 <p>
             *                 <ul>
             *                 <li><strong>cpu</strong> - The number of CPUs that are reserved for the container. Values must be an even multiple of <code>0.25</code> . <code>cpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>cpu</code> is specified in both, then the value that's specified in <code>limits</code> must be at least as large as the value that's specified in <code>requests</code> .</li>
             *                 <li><strong>nvidia.com/gpu</strong> - The number of GPUs that are reserved for the container. Values must be a whole integer. <code>nvidia.com/gpu</code> can be specified in <code>limits</code> , <code>requests</code> , or both. If <code>nvidia.com/gpu</code> is specified in both, then the value that's specified in <code>limits</code> must be equal to the value that's specified in <code>requests</code> .</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requests(java.lang.Object requests) {
                this.requests = requests;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcesProperty {
            private final java.lang.Object limits;
            private final java.lang.Object requests;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.limits = software.amazon.jsii.Kernel.get(this, "limits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requests = software.amazon.jsii.Kernel.get(this, "requests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.limits = builder.limits;
                this.requests = builder.requests;
            }

            @Override
            public final java.lang.Object getLimits() {
                return this.limits;
            }

            @Override
            public final java.lang.Object getRequests() {
                return this.requests;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLimits() != null) {
                    data.set("limits", om.valueToTree(this.getLimits()));
                }
                if (this.getRequests() != null) {
                    data.set("requests", om.valueToTree(this.getRequests()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.ResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourcesProperty.Jsii$Proxy that = (ResourcesProperty.Jsii$Proxy) o;

                if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) return false;
                return this.requests != null ? this.requests.equals(that.requests) : that.requests == null;
            }

            @Override
            public final int hashCode() {
                int result = this.limits != null ? this.limits.hashCode() : 0;
                result = 31 * result + (this.requests != null ? this.requests.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The retry strategy that's associated with a job.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html">Automated job retries</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * RetryStrategyProperty retryStrategyProperty = RetryStrategyProperty.builder()
     *         .attempts(123)
     *         .evaluateOnExit(List.of(EvaluateOnExitProperty.builder()
     *                 .action("action")
     *                 // the properties below are optional
     *                 .onExitCode("onExitCode")
     *                 .onReason("onReason")
     *                 .onStatusReason("onStatusReason")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.RetryStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of times to move a job to the `RUNNABLE` status.
         * <p>
         * You can specify between 1 and 10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttempts() {
            return null;
        }

        /**
         * Array of up to 5 objects that specify the conditions where jobs are retried or failed.
         * <p>
         * If this parameter is specified, then the <code>attempts</code> parameter must also be specified. If none of the listed conditions match, then the job is retried.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvaluateOnExit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryStrategyProperty> {
            java.lang.Number attempts;
            java.lang.Object evaluateOnExit;

            /**
             * Sets the value of {@link RetryStrategyProperty#getAttempts}
             * @param attempts The number of times to move a job to the `RUNNABLE` status.
             *                 You can specify between 1 and 10 attempts. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attempts(java.lang.Number attempts) {
                this.attempts = attempts;
                return this;
            }

            /**
             * Sets the value of {@link RetryStrategyProperty#getEvaluateOnExit}
             * @param evaluateOnExit Array of up to 5 objects that specify the conditions where jobs are retried or failed.
             *                       If this parameter is specified, then the <code>attempts</code> parameter must also be specified. If none of the listed conditions match, then the job is retried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateOnExit(software.amazon.awscdk.core.IResolvable evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            /**
             * Sets the value of {@link RetryStrategyProperty#getEvaluateOnExit}
             * @param evaluateOnExit Array of up to 5 objects that specify the conditions where jobs are retried or failed.
             *                       If this parameter is specified, then the <code>attempts</code> parameter must also be specified. If none of the listed conditions match, then the job is retried.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluateOnExit(java.util.List<? extends java.lang.Object> evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryStrategyProperty {
            private final java.lang.Number attempts;
            private final java.lang.Object evaluateOnExit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attempts = software.amazon.jsii.Kernel.get(this, "attempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.evaluateOnExit = software.amazon.jsii.Kernel.get(this, "evaluateOnExit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attempts = builder.attempts;
                this.evaluateOnExit = builder.evaluateOnExit;
            }

            @Override
            public final java.lang.Number getAttempts() {
                return this.attempts;
            }

            @Override
            public final java.lang.Object getEvaluateOnExit() {
                return this.evaluateOnExit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttempts() != null) {
                    data.set("attempts", om.valueToTree(this.getAttempts()));
                }
                if (this.getEvaluateOnExit() != null) {
                    data.set("evaluateOnExit", om.valueToTree(this.getEvaluateOnExit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.RetryStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryStrategyProperty.Jsii$Proxy that = (RetryStrategyProperty.Jsii$Proxy) o;

                if (this.attempts != null ? !this.attempts.equals(that.attempts) : that.attempts != null) return false;
                return this.evaluateOnExit != null ? this.evaluateOnExit.equals(that.evaluateOnExit) : that.evaluateOnExit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attempts != null ? this.attempts.hashCode() : 0;
                result = 31 * result + (this.evaluateOnExit != null ? this.evaluateOnExit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the secret to expose to your container.
     * <p>
     * Secrets can be exposed to a container in the following ways:
     * <p>
     * <ul>
     * <li>To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container definition parameter.</li>
     * <li>To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code> container definition parameter.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * SecretProperty secretProperty = SecretProperty.builder()
     *         .name("name")
     *         .valueFrom("valueFrom")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.SecretProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secret.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The secret to expose to the container.
         * <p>
         * The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
         * <p>
         * <blockquote>
         * <p>
         * If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueFrom();

        /**
         * @return a {@link Builder} of {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretProperty> {
            java.lang.String name;
            java.lang.String valueFrom;

            /**
             * Sets the value of {@link SecretProperty#getName}
             * @param name The name of the secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SecretProperty#getValueFrom}
             * @param valueFrom The secret to expose to the container. This parameter is required.
             *                  The supported values are either the full Amazon Resource Name (ARN) of the AWS Secrets Manager secret or the full ARN of the parameter in the AWS Systems Manager Parameter Store.
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If the AWS Systems Manager Parameter Store parameter exists in the same Region as the job you're launching, then you can use either the full Amazon Resource Name (ARN) or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueFrom(java.lang.String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProperty {
            private final java.lang.String name;
            private final java.lang.String valueFrom;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueFrom = software.amazon.jsii.Kernel.get(this, "valueFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueFrom = java.util.Objects.requireNonNull(builder.valueFrom, "valueFrom is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueFrom() {
                return this.valueFrom;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("valueFrom", om.valueToTree(this.getValueFrom()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.SecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretProperty.Jsii$Proxy that = (SecretProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.valueFrom.equals(that.valueFrom);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.valueFrom.hashCode());
                return result;
            }
        }
    }
    /**
     * The security context for a job.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/tasks/configure-pod-container/security-context/">Configure a security context for a pod or container</a> in the <em>Kubernetes documentation</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * SecurityContextProperty securityContextProperty = SecurityContextProperty.builder()
     *         .privileged(false)
     *         .readOnlyRootFilesystem(false)
     *         .runAsGroup(123)
     *         .runAsNonRoot(false)
     *         .runAsUser(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.SecurityContextProperty")
    @software.amazon.jsii.Jsii.Proxy(SecurityContextProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecurityContextProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When this parameter is `true` , the container is given elevated permissions on the host container instance.
         * <p>
         * The level of permissions are similar to the <code>root</code> user permissions. The default value is <code>false</code> . This parameter maps to <code>privileged</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod security policies</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrivileged() {
            return null;
        }

        /**
         * When this parameter is `true` , the container is given read-only access to its root file system.
         * <p>
         * The default value is <code>false</code> . This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">Volumes and file systems pod security policies</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReadOnlyRootFilesystem() {
            return null;
        }

        /**
         * When this parameter is specified, the container is run as the specified group ID ( `gid` ).
         * <p>
         * If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsGroup() {
            return null;
        }

        /**
         * When this parameter is specified, the container is run as a user with a `uid` other than 0.
         * <p>
         * If this parameter isn't specified, so such rule is enforced. This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRunAsNonRoot() {
            return null;
        }

        /**
         * When this parameter is specified, the container is run as the specified user ID ( `uid` ).
         * <p>
         * If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to <code>RunAsUser</code> and <code>MustRanAs</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunAsUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecurityContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecurityContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecurityContextProperty> {
            java.lang.Object privileged;
            java.lang.Object readOnlyRootFilesystem;
            java.lang.Number runAsGroup;
            java.lang.Object runAsNonRoot;
            java.lang.Number runAsUser;

            /**
             * Sets the value of {@link SecurityContextProperty#getPrivileged}
             * @param privileged When this parameter is `true` , the container is given elevated permissions on the host container instance.
             *                   The level of permissions are similar to the <code>root</code> user permissions. The default value is <code>false</code> . This parameter maps to <code>privileged</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(java.lang.Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getPrivileged}
             * @param privileged When this parameter is `true` , the container is given elevated permissions on the host container instance.
             *                   The level of permissions are similar to the <code>root</code> user permissions. The default value is <code>false</code> . This parameter maps to <code>privileged</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#privileged">Privileged pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privileged(software.amazon.awscdk.core.IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getReadOnlyRootFilesystem}
             * @param readOnlyRootFilesystem When this parameter is `true` , the container is given read-only access to its root file system.
             *                               The default value is <code>false</code> . This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">Volumes and file systems pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnlyRootFilesystem(java.lang.Boolean readOnlyRootFilesystem) {
                this.readOnlyRootFilesystem = readOnlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getReadOnlyRootFilesystem}
             * @param readOnlyRootFilesystem When this parameter is `true` , the container is given read-only access to its root file system.
             *                               The default value is <code>false</code> . This parameter maps to <code>ReadOnlyRootFilesystem</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#volumes-and-file-systems">Volumes and file systems pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readOnlyRootFilesystem(software.amazon.awscdk.core.IResolvable readOnlyRootFilesystem) {
                this.readOnlyRootFilesystem = readOnlyRootFilesystem;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsGroup}
             * @param runAsGroup When this parameter is specified, the container is run as the specified group ID ( `gid` ).
             *                   If this parameter isn't specified, the default is the group that's specified in the image metadata. This parameter maps to <code>RunAsGroup</code> and <code>MustRunAs</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsGroup(java.lang.Number runAsGroup) {
                this.runAsGroup = runAsGroup;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsNonRoot}
             * @param runAsNonRoot When this parameter is specified, the container is run as a user with a `uid` other than 0.
             *                     If this parameter isn't specified, so such rule is enforced. This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsNonRoot(java.lang.Boolean runAsNonRoot) {
                this.runAsNonRoot = runAsNonRoot;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsNonRoot}
             * @param runAsNonRoot When this parameter is specified, the container is run as a user with a `uid` other than 0.
             *                     If this parameter isn't specified, so such rule is enforced. This parameter maps to <code>RunAsUser</code> and <code>MustRunAsNonRoot</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsNonRoot(software.amazon.awscdk.core.IResolvable runAsNonRoot) {
                this.runAsNonRoot = runAsNonRoot;
                return this;
            }

            /**
             * Sets the value of {@link SecurityContextProperty#getRunAsUser}
             * @param runAsUser When this parameter is specified, the container is run as the specified user ID ( `uid` ).
             *                  If this parameter isn't specified, the default is the user that's specified in the image metadata. This parameter maps to <code>RunAsUser</code> and <code>MustRanAs</code> policy in the <a href="https://docs.aws.amazon.com/https://kubernetes.io/docs/concepts/security/pod-security-policy/#users-and-groups">Users and groups pod security policies</a> in the <em>Kubernetes documentation</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAsUser(java.lang.Number runAsUser) {
                this.runAsUser = runAsUser;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecurityContextProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecurityContextProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecurityContextProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityContextProperty {
            private final java.lang.Object privileged;
            private final java.lang.Object readOnlyRootFilesystem;
            private final java.lang.Number runAsGroup;
            private final java.lang.Object runAsNonRoot;
            private final java.lang.Number runAsUser;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readOnlyRootFilesystem = software.amazon.jsii.Kernel.get(this, "readOnlyRootFilesystem", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runAsGroup = software.amazon.jsii.Kernel.get(this, "runAsGroup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.runAsNonRoot = software.amazon.jsii.Kernel.get(this, "runAsNonRoot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runAsUser = software.amazon.jsii.Kernel.get(this, "runAsUser", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.privileged = builder.privileged;
                this.readOnlyRootFilesystem = builder.readOnlyRootFilesystem;
                this.runAsGroup = builder.runAsGroup;
                this.runAsNonRoot = builder.runAsNonRoot;
                this.runAsUser = builder.runAsUser;
            }

            @Override
            public final java.lang.Object getPrivileged() {
                return this.privileged;
            }

            @Override
            public final java.lang.Object getReadOnlyRootFilesystem() {
                return this.readOnlyRootFilesystem;
            }

            @Override
            public final java.lang.Number getRunAsGroup() {
                return this.runAsGroup;
            }

            @Override
            public final java.lang.Object getRunAsNonRoot() {
                return this.runAsNonRoot;
            }

            @Override
            public final java.lang.Number getRunAsUser() {
                return this.runAsUser;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrivileged() != null) {
                    data.set("privileged", om.valueToTree(this.getPrivileged()));
                }
                if (this.getReadOnlyRootFilesystem() != null) {
                    data.set("readOnlyRootFilesystem", om.valueToTree(this.getReadOnlyRootFilesystem()));
                }
                if (this.getRunAsGroup() != null) {
                    data.set("runAsGroup", om.valueToTree(this.getRunAsGroup()));
                }
                if (this.getRunAsNonRoot() != null) {
                    data.set("runAsNonRoot", om.valueToTree(this.getRunAsNonRoot()));
                }
                if (this.getRunAsUser() != null) {
                    data.set("runAsUser", om.valueToTree(this.getRunAsUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.SecurityContextProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecurityContextProperty.Jsii$Proxy that = (SecurityContextProperty.Jsii$Proxy) o;

                if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
                if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) return false;
                if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) return false;
                if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) return false;
                return this.runAsUser != null ? this.runAsUser.equals(that.runAsUser) : that.runAsUser == null;
            }

            @Override
            public final int hashCode() {
                int result = this.privileged != null ? this.privileged.hashCode() : 0;
                result = 31 * result + (this.readOnlyRootFilesystem != null ? this.readOnlyRootFilesystem.hashCode() : 0);
                result = 31 * result + (this.runAsGroup != null ? this.runAsGroup.hashCode() : 0);
                result = 31 * result + (this.runAsNonRoot != null ? this.runAsNonRoot.hashCode() : 0);
                result = 31 * result + (this.runAsUser != null ? this.runAsUser.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a job timeout configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * TimeoutProperty timeoutProperty = TimeoutProperty.builder()
     *         .attemptDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.TimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp.
         * <p>
         * After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.
         * <p>
         * For array jobs, the timeout applies to the child jobs, not to the parent array job.
         * <p>
         * For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAttemptDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeoutProperty> {
            java.lang.Number attemptDurationSeconds;

            /**
             * Sets the value of {@link TimeoutProperty#getAttemptDurationSeconds}
             * @param attemptDurationSeconds The job timeout time (in seconds) that's measured from the job attempt's `startedAt` timestamp.
             *                               After this time passes, AWS Batch terminates your jobs if they aren't finished. The minimum value for the timeout is 60 seconds.
             *                               <p>
             *                               For array jobs, the timeout applies to the child jobs, not to the parent array job.
             *                               <p>
             *                               For multi-node parallel (MNP) jobs, the timeout applies to the whole job, not to the individual nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attemptDurationSeconds(java.lang.Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeoutProperty {
            private final java.lang.Number attemptDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attemptDurationSeconds = software.amazon.jsii.Kernel.get(this, "attemptDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attemptDurationSeconds = builder.attemptDurationSeconds;
            }

            @Override
            public final java.lang.Number getAttemptDurationSeconds() {
                return this.attemptDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAttemptDurationSeconds() != null) {
                    data.set("attemptDurationSeconds", om.valueToTree(this.getAttemptDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.TimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeoutProperty.Jsii$Proxy that = (TimeoutProperty.Jsii$Proxy) o;

                return this.attemptDurationSeconds != null ? this.attemptDurationSeconds.equals(that.attemptDurationSeconds) : that.attemptDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.attemptDurationSeconds != null ? this.attemptDurationSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The container path, mount options, and size of the `tmpfs` mount.
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * TmpfsProperty tmpfsProperty = TmpfsProperty.builder()
     *         .containerPath("containerPath")
     *         .size(123)
     *         // the properties below are optional
     *         .mountOptions(List.of("mountOptions"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.TmpfsProperty")
    @software.amazon.jsii.Jsii.Proxy(TmpfsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TmpfsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The absolute file path in the container where the `tmpfs` volume is mounted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContainerPath();

        /**
         * The size (in MiB) of the `tmpfs` volume.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSize();

        /**
         * The list of `tmpfs` volume mount options.
         * <p>
         * Valid values: " <code>defaults</code> " | " <code>ro</code> " | " <code>rw</code> " | " <code>suid</code> " | " <code>nosuid</code> " | " <code>dev</code> " | " <code>nodev</code> " | " <code>exec</code> " | " <code>noexec</code> " | " <code>sync</code> " | " <code>async</code> " | " <code>dirsync</code> " | " <code>remount</code> " | " <code>mand</code> " | " <code>nomand</code> " | " <code>atime</code> " | " <code>noatime</code> " | " <code>diratime</code> " | " <code>nodiratime</code> " | " <code>bind</code> " | " <code>rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime</code> " | " <code>norelatime</code> " | " <code>strictatime</code> " | " <code>nostrictatime</code> " | " <code>mode</code> " | " <code>uid</code> " | " <code>gid</code> " | " <code>nr_inodes</code> " | " <code>nr_blocks</code> " | " <code>mpol</code> "
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMountOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TmpfsProperty> {
            java.lang.String containerPath;
            java.lang.Number size;
            java.util.List<java.lang.String> mountOptions;

            /**
             * Sets the value of {@link TmpfsProperty#getContainerPath}
             * @param containerPath The absolute file path in the container where the `tmpfs` volume is mounted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPath(java.lang.String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            /**
             * Sets the value of {@link TmpfsProperty#getSize}
             * @param size The size (in MiB) of the `tmpfs` volume. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder size(java.lang.Number size) {
                this.size = size;
                return this;
            }

            /**
             * Sets the value of {@link TmpfsProperty#getMountOptions}
             * @param mountOptions The list of `tmpfs` volume mount options.
             *                     Valid values: " <code>defaults</code> " | " <code>ro</code> " | " <code>rw</code> " | " <code>suid</code> " | " <code>nosuid</code> " | " <code>dev</code> " | " <code>nodev</code> " | " <code>exec</code> " | " <code>noexec</code> " | " <code>sync</code> " | " <code>async</code> " | " <code>dirsync</code> " | " <code>remount</code> " | " <code>mand</code> " | " <code>nomand</code> " | " <code>atime</code> " | " <code>noatime</code> " | " <code>diratime</code> " | " <code>nodiratime</code> " | " <code>bind</code> " | " <code>rbind" | "unbindable" | "runbindable" | "private" | "rprivate" | "shared" | "rshared" | "slave" | "rslave" | "relatime</code> " | " <code>norelatime</code> " | " <code>strictatime</code> " | " <code>nostrictatime</code> " | " <code>mode</code> " | " <code>uid</code> " | " <code>gid</code> " | " <code>nr_inodes</code> " | " <code>nr_blocks</code> " | " <code>mpol</code> "
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mountOptions(java.util.List<java.lang.String> mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TmpfsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TmpfsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TmpfsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TmpfsProperty {
            private final java.lang.String containerPath;
            private final java.lang.Number size;
            private final java.util.List<java.lang.String> mountOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerPath = software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.size = software.amazon.jsii.Kernel.get(this, "size", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mountOptions = software.amazon.jsii.Kernel.get(this, "mountOptions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerPath = java.util.Objects.requireNonNull(builder.containerPath, "containerPath is required");
                this.size = java.util.Objects.requireNonNull(builder.size, "size is required");
                this.mountOptions = builder.mountOptions;
            }

            @Override
            public final java.lang.String getContainerPath() {
                return this.containerPath;
            }

            @Override
            public final java.lang.Number getSize() {
                return this.size;
            }

            @Override
            public final java.util.List<java.lang.String> getMountOptions() {
                return this.mountOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("containerPath", om.valueToTree(this.getContainerPath()));
                data.set("size", om.valueToTree(this.getSize()));
                if (this.getMountOptions() != null) {
                    data.set("mountOptions", om.valueToTree(this.getMountOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.TmpfsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TmpfsProperty.Jsii$Proxy that = (TmpfsProperty.Jsii$Proxy) o;

                if (!containerPath.equals(that.containerPath)) return false;
                if (!size.equals(that.size)) return false;
                return this.mountOptions != null ? this.mountOptions.equals(that.mountOptions) : that.mountOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerPath.hashCode();
                result = 31 * result + (this.size.hashCode());
                result = 31 * result + (this.mountOptions != null ? this.mountOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ulimit` settings to pass to the container.
     * <p>
     * <blockquote>
     * <p>
     * This object isn't applicable to jobs that are running on Fargate resources.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * UlimitProperty ulimitProperty = UlimitProperty.builder()
     *         .hardLimit(123)
     *         .name("name")
     *         .softLimit(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii.Proxy(UlimitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UlimitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hard limit for the `ulimit` type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHardLimit();

        /**
         * The `type` of the `ulimit` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The soft limit for the `ulimit` type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSoftLimit();

        /**
         * @return a {@link Builder} of {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UlimitProperty> {
            java.lang.Number hardLimit;
            java.lang.String name;
            java.lang.Number softLimit;

            /**
             * Sets the value of {@link UlimitProperty#getHardLimit}
             * @param hardLimit The hard limit for the `ulimit` type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hardLimit(java.lang.Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getName}
             * @param name The `type` of the `ulimit` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link UlimitProperty#getSoftLimit}
             * @param softLimit The soft limit for the `ulimit` type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder softLimit(java.lang.Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UlimitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UlimitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UlimitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UlimitProperty {
            private final java.lang.Number hardLimit;
            private final java.lang.String name;
            private final java.lang.Number softLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hardLimit = software.amazon.jsii.Kernel.get(this, "hardLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.softLimit = software.amazon.jsii.Kernel.get(this, "softLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hardLimit = java.util.Objects.requireNonNull(builder.hardLimit, "hardLimit is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.softLimit = java.util.Objects.requireNonNull(builder.softLimit, "softLimit is required");
            }

            @Override
            public final java.lang.Number getHardLimit() {
                return this.hardLimit;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Number getSoftLimit() {
                return this.softLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hardLimit", om.valueToTree(this.getHardLimit()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("softLimit", om.valueToTree(this.getSoftLimit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.UlimitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UlimitProperty.Jsii$Proxy that = (UlimitProperty.Jsii$Proxy) o;

                if (!hardLimit.equals(that.hardLimit)) return false;
                if (!name.equals(that.name)) return false;
                return this.softLimit.equals(that.softLimit);
            }

            @Override
            public final int hashCode() {
                int result = this.hardLimit.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.softLimit.hashCode());
                return result;
            }
        }
    }
    /**
     * Determine whether your data volume persists on the host container instance and where it's stored.
     * <p>
     * If this parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * VolumesHostProperty volumesHostProperty = VolumesHostProperty.builder()
     *         .sourcePath("sourcePath")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.VolumesHostProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumesHostProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumesHostProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path on the host container instance that's presented to the container.
         * <p>
         * If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourcePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumesHostProperty> {
            java.lang.String sourcePath;

            /**
             * Sets the value of {@link VolumesHostProperty#getSourcePath}
             * @param sourcePath The path on the host container instance that's presented to the container.
             *                   If this parameter is empty, then the Docker daemon has assigned a host path for you. If this parameter contains a file location, then the data volume persists at the specified location on the host container instance until you delete it manually. If the source path location doesn't exist on the host container instance, the Docker daemon creates it. If the location does exist, the contents of the source path folder are exported.
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter isn't applicable to jobs that run on Fargate resources. Don't provide this for these jobs.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourcePath(java.lang.String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumesHostProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumesHostProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumesHostProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumesHostProperty {
            private final java.lang.String sourcePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourcePath = software.amazon.jsii.Kernel.get(this, "sourcePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourcePath = builder.sourcePath;
            }

            @Override
            public final java.lang.String getSourcePath() {
                return this.sourcePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSourcePath() != null) {
                    data.set("sourcePath", om.valueToTree(this.getSourcePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.VolumesHostProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumesHostProperty.Jsii$Proxy that = (VolumesHostProperty.Jsii$Proxy) o;

                return this.sourcePath != null ? this.sourcePath.equals(that.sourcePath) : that.sourcePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourcePath != null ? this.sourcePath.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A list of volumes that are associated with the job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.batch.*;
     * VolumesProperty volumesProperty = VolumesProperty.builder()
     *         .efsVolumeConfiguration(EfsVolumeConfigurationProperty.builder()
     *                 .fileSystemId("fileSystemId")
     *                 // the properties below are optional
     *                 .authorizationConfig(AuthorizationConfigProperty.builder()
     *                         .accessPointId("accessPointId")
     *                         .iam("iam")
     *                         .build())
     *                 .rootDirectory("rootDirectory")
     *                 .transitEncryption("transitEncryption")
     *                 .transitEncryptionPort(123)
     *                 .build())
     *         .host(VolumesHostProperty.builder()
     *                 .sourcePath("sourcePath")
     *                 .build())
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.CfnJobDefinition.VolumesProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This is used when you're using an Amazon Elastic File System file system for job storage.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html">Amazon EFS Volumes</a> in the <em>AWS Batch User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEfsVolumeConfiguration() {
            return null;
        }

        /**
         * The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored.
         * <p>
         * If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
         * <p>
         * <blockquote>
         * <p>
         * This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHost() {
            return null;
        }

        /**
         * The name of the volume.
         * <p>
         * It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the <code>sourceVolume</code> parameter of container definition <code>mountPoints</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumesProperty> {
            java.lang.Object efsVolumeConfiguration;
            java.lang.Object host;
            java.lang.String name;

            /**
             * Sets the value of {@link VolumesProperty#getEfsVolumeConfiguration}
             * @param efsVolumeConfiguration This is used when you're using an Amazon Elastic File System file system for job storage.
             *                               For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html">Amazon EFS Volumes</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsVolumeConfiguration(software.amazon.awscdk.core.IResolvable efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getEfsVolumeConfiguration}
             * @param efsVolumeConfiguration This is used when you're using an Amazon Elastic File System file system for job storage.
             *                               For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html">Amazon EFS Volumes</a> in the <em>AWS Batch User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder efsVolumeConfiguration(software.amazon.awscdk.services.batch.CfnJobDefinition.EfsVolumeConfigurationProperty efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getHost}
             * @param host The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored.
             *             If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
             *             <p>
             *             <blockquote>
             *             <p>
             *             This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.core.IResolvable host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getHost}
             * @param host The contents of the `host` parameter determine whether your data volume persists on the host container instance and where it's stored.
             *             If the host parameter is empty, then the Docker daemon assigns a host path for your data volume. However, the data isn't guaranteed to persist after the containers that are associated with it stop running.
             *             <p>
             *             <blockquote>
             *             <p>
             *             This parameter isn't applicable to jobs that are running on Fargate resources and shouldn't be provided.
             *             <p>
             *             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(software.amazon.awscdk.services.batch.CfnJobDefinition.VolumesHostProperty host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link VolumesProperty#getName}
             * @param name The name of the volume.
             *             It can be up to 255 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_). This name is referenced in the <code>sourceVolume</code> parameter of container definition <code>mountPoints</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumesProperty {
            private final java.lang.Object efsVolumeConfiguration;
            private final java.lang.Object host;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.efsVolumeConfiguration = software.amazon.jsii.Kernel.get(this, "efsVolumeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
                this.host = builder.host;
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getEfsVolumeConfiguration() {
                return this.efsVolumeConfiguration;
            }

            @Override
            public final java.lang.Object getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEfsVolumeConfiguration() != null) {
                    data.set("efsVolumeConfiguration", om.valueToTree(this.getEfsVolumeConfiguration()));
                }
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.CfnJobDefinition.VolumesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumesProperty.Jsii$Proxy that = (VolumesProperty.Jsii$Proxy) o;

                if (this.efsVolumeConfiguration != null ? !this.efsVolumeConfiguration.equals(that.efsVolumeConfiguration) : that.efsVolumeConfiguration != null) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.efsVolumeConfiguration != null ? this.efsVolumeConfiguration.hashCode() : 0;
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.CfnJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.CfnJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.CfnJobDefinitionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.CfnJobDefinitionProps.Builder();
        }

        /**
         * The type of job definition.
         * <p>
         * For more information about multi-node parallel jobs, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/multi-node-job-def.html">Creating a multi-node parallel job definition</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If the job is run on Fargate resources, then <code>multinode</code> isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param type The type of job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * An object with various properties specific to Amazon ECS based jobs.
         * <p>
         * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
         * <p>
         * @return {@code this}
         * @param containerProperties An object with various properties specific to Amazon ECS based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(final software.amazon.awscdk.core.IResolvable containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }
        /**
         * An object with various properties specific to Amazon ECS based jobs.
         * <p>
         * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
         * <p>
         * @return {@code this}
         * @param containerProperties An object with various properties specific to Amazon ECS based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.ContainerPropertiesProperty containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        /**
         * An object with various properties that are specific to Amazon EKS based jobs.
         * <p>
         * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
         * <p>
         * @return {@code this}
         * @param eksProperties An object with various properties that are specific to Amazon EKS based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksProperties(final software.amazon.awscdk.core.IResolvable eksProperties) {
            this.props.eksProperties(eksProperties);
            return this;
        }
        /**
         * An object with various properties that are specific to Amazon EKS based jobs.
         * <p>
         * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
         * <p>
         * @return {@code this}
         * @param eksProperties An object with various properties that are specific to Amazon EKS based jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.EksPropertiesProperty eksProperties) {
            this.props.eksProperties(eksProperties);
            return this;
        }

        /**
         * The name of the job definition.
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * An object with various properties that are specific to multi-node parallel jobs.
         * <p>
         * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
         * <p>
         * <blockquote>
         * <p>
         * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param nodeProperties An object with various properties that are specific to multi-node parallel jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(final software.amazon.awscdk.core.IResolvable nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }
        /**
         * An object with various properties that are specific to multi-node parallel jobs.
         * <p>
         * Valid values are <code>containerProperties</code> , <code>eksProperties</code> , and <code>nodeProperties</code> . Only one can be specified.
         * <p>
         * <blockquote>
         * <p>
         * If the job runs on Fargate resources, don't specify <code>nodeProperties</code> . Use <code>containerProperties</code> instead.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param nodeProperties An object with various properties that are specific to multi-node parallel jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeProperties(final software.amazon.awscdk.services.batch.CfnJobDefinition.NodePropertiesProperty nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        /**
         * Default parameters or parameter substitution placeholders that are set in the job definition.
         * <p>
         * Parameters are specified as a key-value pair mapping. Parameters in a <code>SubmitJob</code> request override any corresponding parameter defaults from the job definition. For more information about specifying parameters, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html">Job definition parameters</a> in the <em>AWS Batch User Guide</em> .
         * <p>
         * @return {@code this}
         * @param parameters Default parameters or parameter substitution placeholders that are set in the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.lang.Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The platform capabilities required by the job definition.
         * <p>
         * If no value is specified, it defaults to <code>EC2</code> . Jobs run on Fargate resources specify <code>FARGATE</code> .
         * <p>
         * @return {@code this}
         * @param platformCapabilities The platform capabilities required by the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformCapabilities(final java.util.List<java.lang.String> platformCapabilities) {
            this.props.platformCapabilities(platformCapabilities);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         * <p>
         * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }
        /**
         * Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task.
         * <p>
         * If no value is specified, the tags aren't propagated. Tags can only be propagated to the tasks when the tasks are created. For tags with the same name, job tags are given priority over job definitions tags. If the total number of combined tags from the job and job definition is over 50, the job is moved to the <code>FAILED</code> state.
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the job or job definition to the corresponding Amazon ECS task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.core.IResolvable propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * <p>
         * @return {@code this}
         * @param retryStrategy The retry strategy to use for failed jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(final software.amazon.awscdk.core.IResolvable retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }
        /**
         * The retry strategy to use for failed jobs that are submitted with this job definition.
         * <p>
         * @return {@code this}
         * @param retryStrategy The retry strategy to use for failed jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategy(final software.amazon.awscdk.services.batch.CfnJobDefinition.RetryStrategyProperty retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        /**
         * The scheduling priority of the job definition.
         * <p>
         * This only affects jobs in job queues with a fair share policy. Jobs with a higher scheduling priority are scheduled before jobs with a lower scheduling priority.
         * <p>
         * @return {@code this}
         * @param schedulingPriority The scheduling priority of the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(final java.lang.Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        /**
         * The tags that are applied to the job definition.
         * <p>
         * @return {@code this}
         * @param tags The tags that are applied to the job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
         * <p>
         * @return {@code this}
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.IResolvable timeout) {
            this.props.timeout(timeout);
            return this;
        }
        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes, AWS Batch terminates your jobs if they aren't finished.
         * <p>
         * @return {@code this}
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.services.batch.CfnJobDefinition.TimeoutProperty timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.batch.CfnJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.CfnJobDefinition build() {
            return new software.amazon.awscdk.services.batch.CfnJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
