package software.amazon.awscdk.services.batch;

/**
 * (experimental) Properties for creating a new Compute Environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * ComputeEnvironment myComputeEnv = ComputeEnvironment.Builder.create(this, "ComputeEnv")
 *         .computeResources(ComputeResources.builder()
 *                 .image(EcsOptimizedAmi.Builder.create()
 *                         .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 *                         .build())
 *                 .vpc(vpc)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:27.100Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.ComputeEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(ComputeEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ComputeEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A name for the compute environment.
     * <p>
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     * <p>
     * Default: - CloudFormation-generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeEnvironmentName() {
        return null;
    }

    /**
     * (experimental) The details of the required compute resources for the managed compute environment.
     * <p>
     * If specified, and this is an unmanaged compute environment, will throw an error.
     * <p>
     * By default, AWS Batch managed compute environments use a recent, approved version of the
     * Amazon ECS-optimized AMI for compute resources.
     * <p>
     * Default: - CloudFormation defaults
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ComputeResources getComputeResources() {
        return null;
    }

    /**
     * (experimental) The state of the compute environment.
     * <p>
     * If the state is set to true, then the compute
     * environment accepts jobs from a queue and can scale out automatically based on queues.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * (experimental) Determines if AWS should manage the allocation of compute resources for processing jobs.
     * <p>
     * If set to false, then you are in charge of providing the compute resource details.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getManaged() {
        return null;
    }

    /**
     * (experimental) The IAM role used by Batch to make calls to other AWS services on your behalf for managing the resources that you use with the service.
     * <p>
     * By default, this role is created for you using
     * the AWS managed service policy for Batch.
     * <p>
     * Default: - Role using the 'service-role/AWSBatchServiceRole' policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getServiceRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ComputeEnvironmentProps> {
        java.lang.String computeEnvironmentName;
        software.amazon.awscdk.services.batch.ComputeResources computeResources;
        java.lang.Boolean enabled;
        java.lang.Boolean managed;
        software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Sets the value of {@link ComputeEnvironmentProps#getComputeEnvironmentName}
         * @param computeEnvironmentName A name for the compute environment.
         *                               Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeEnvironmentName(java.lang.String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link ComputeEnvironmentProps#getComputeResources}
         * @param computeResources The details of the required compute resources for the managed compute environment.
         *                         If specified, and this is an unmanaged compute environment, will throw an error.
         *                         <p>
         *                         By default, AWS Batch managed compute environments use a recent, approved version of the
         *                         Amazon ECS-optimized AMI for compute resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder computeResources(software.amazon.awscdk.services.batch.ComputeResources computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        /**
         * Sets the value of {@link ComputeEnvironmentProps#getEnabled}
         * @param enabled The state of the compute environment.
         *                If the state is set to true, then the compute
         *                environment accepts jobs from a queue and can scale out automatically based on queues.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ComputeEnvironmentProps#getManaged}
         * @param managed Determines if AWS should manage the allocation of compute resources for processing jobs.
         *                If set to false, then you are in charge of providing the compute resource details.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder managed(java.lang.Boolean managed) {
            this.managed = managed;
            return this;
        }

        /**
         * Sets the value of {@link ComputeEnvironmentProps#getServiceRole}
         * @param serviceRole The IAM role used by Batch to make calls to other AWS services on your behalf for managing the resources that you use with the service.
         *                    By default, this role is created for you using
         *                    the AWS managed service policy for Batch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ComputeEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ComputeEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComputeEnvironmentProps {
        private final java.lang.String computeEnvironmentName;
        private final software.amazon.awscdk.services.batch.ComputeResources computeResources;
        private final java.lang.Boolean enabled;
        private final java.lang.Boolean managed;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.computeEnvironmentName = software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeResources = software.amazon.jsii.Kernel.get(this, "computeResources", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ComputeResources.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.managed = software.amazon.jsii.Kernel.get(this, "managed", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.computeEnvironmentName = builder.computeEnvironmentName;
            this.computeResources = builder.computeResources;
            this.enabled = builder.enabled;
            this.managed = builder.managed;
            this.serviceRole = builder.serviceRole;
        }

        @Override
        public final java.lang.String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final software.amazon.awscdk.services.batch.ComputeResources getComputeResources() {
            return this.computeResources;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.Boolean getManaged() {
            return this.managed;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComputeEnvironmentName() != null) {
                data.set("computeEnvironmentName", om.valueToTree(this.getComputeEnvironmentName()));
            }
            if (this.getComputeResources() != null) {
                data.set("computeResources", om.valueToTree(this.getComputeResources()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getManaged() != null) {
                data.set("managed", om.valueToTree(this.getManaged()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.ComputeEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ComputeEnvironmentProps.Jsii$Proxy that = (ComputeEnvironmentProps.Jsii$Proxy) o;

            if (this.computeEnvironmentName != null ? !this.computeEnvironmentName.equals(that.computeEnvironmentName) : that.computeEnvironmentName != null) return false;
            if (this.computeResources != null ? !this.computeResources.equals(that.computeResources) : that.computeResources != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.managed != null ? !this.managed.equals(that.managed) : that.managed != null) return false;
            return this.serviceRole != null ? this.serviceRole.equals(that.serviceRole) : that.serviceRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.computeEnvironmentName != null ? this.computeEnvironmentName.hashCode() : 0;
            result = 31 * result + (this.computeResources != null ? this.computeResources.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.managed != null ? this.managed.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            return result;
        }
    }
}
