package software.amazon.awscdk.services.batch;

/**
 * (experimental) Exposed secret for log configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ssm.*;
 * JobDefinition.Builder.create(this, "job-def")
 *         .container(JobDefinitionContainer.builder()
 *                 .image(EcrImage.fromRegistry("docker/whalesay"))
 *                 .logConfiguration(LogConfiguration.builder()
 *                         .logDriver(LogDriver.AWSLOGS)
 *                         .options(Map.of("awslogs-region", "us-east-1"))
 *                         .secretOptions(List.of(ExposedSecret.fromParametersStore("xyz", StringParameter.fromStringParameterName(this, "parameter", "xyz"))))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:27.108Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.ExposedSecret")
public class ExposedSecret extends software.amazon.jsii.JsiiObject {

    protected ExposedSecret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExposedSecret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param optionName This parameter is required.
     * @param secretArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ExposedSecret(final @org.jetbrains.annotations.NotNull java.lang.String optionName, final @org.jetbrains.annotations.NotNull java.lang.String secretArn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(optionName, "optionName is required"), java.util.Objects.requireNonNull(secretArn, "secretArn is required") });
    }

    /**
     * (experimental) User Parameters Store Parameter.
     * <p>
     * @param optionName - The name of the option. This parameter is required.
     * @param parameter - A parameter from parameters store. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.ExposedSecret fromParametersStore(final @org.jetbrains.annotations.NotNull java.lang.String optionName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.ExposedSecret.class, "fromParametersStore", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ExposedSecret.class), new Object[] { java.util.Objects.requireNonNull(optionName, "optionName is required"), java.util.Objects.requireNonNull(parameter, "parameter is required") });
    }

    /**
     * (experimental) Use Secrets Manager Secret.
     * <p>
     * @param optionName - The name of the option. This parameter is required.
     * @param secret - A secret from secrets manager. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.ExposedSecret fromSecretsManager(final @org.jetbrains.annotations.NotNull java.lang.String optionName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.ExposedSecret.class, "fromSecretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ExposedSecret.class), new Object[] { java.util.Objects.requireNonNull(optionName, "optionName is required"), java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * (experimental) Name of the option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getOptionName() {
        return software.amazon.jsii.Kernel.get(this, "optionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Name of the option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setOptionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "optionName", java.util.Objects.requireNonNull(value, "optionName is required"));
    }

    /**
     * (experimental) ARN of the secret option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) ARN of the secret option.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void setSecretArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "secretArn", java.util.Objects.requireNonNull(value, "secretArn is required"));
    }
}
