package software.amazon.awscdk.services.batch;

/**
 * (experimental) Properties of a job definition container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ssm.*;
 * JobDefinition.Builder.create(this, "job-def")
 *         .container(JobDefinitionContainer.builder()
 *                 .image(EcrImage.fromRegistry("docker/whalesay"))
 *                 .logConfiguration(LogConfiguration.builder()
 *                         .logDriver(LogDriver.AWSLOGS)
 *                         .options(Map.of("awslogs-region", "us-east-1"))
 *                         .secretOptions(List.of(ExposedSecret.fromParametersStore("xyz", StringParameter.fromStringParameterName(this, "parameter", "xyz"))))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:27.119Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.batch.$Module.class, fqn = "@aws-cdk/aws-batch.JobDefinitionContainer")
@software.amazon.jsii.Jsii.Proxy(JobDefinitionContainer.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobDefinitionContainer extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The image used to start a container.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage getImage();

    /**
     * (experimental) Whether or not to assign a public IP to the job.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignPublicIp() {
        return null;
    }

    /**
     * (experimental) The command that is passed to the container.
     * <p>
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     * <p>
     * Default: - CMD value built into container image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommand() {
        return null;
    }

    /**
     * (experimental) The environment variables to pass to the container.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return null;
    }

    /**
     * (experimental) The IAM role that AWS Batch can assume.
     * <p>
     * Required when using Fargate.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getExecutionRole() {
        return null;
    }

    /**
     * (experimental) The number of physical GPUs to reserve for the container.
     * <p>
     * The number of GPUs reserved for all
     * containers in a job should not exceed the number of available GPUs on the compute resource that the job is launched on.
     * <p>
     * Default: - No GPU reservation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGpuCount() {
        return null;
    }

    /**
     * (experimental) The instance type to use for a multi-node parallel job.
     * <p>
     * Currently all node groups in a
     * multi-node parallel job must use the same instance type. This parameter is not valid
     * for single-node container jobs.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return null;
    }

    /**
     * (experimental) The IAM role that the container can assume for AWS permissions.
     * <p>
     * Default: - An IAM role will created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getJobRole() {
        return null;
    }

    /**
     * (experimental) Linux-specific modifications that are applied to the container, such as details for device mappings.
     * <p>
     * For now, only the <code>devices</code> property is supported.
     * <p>
     * Default: - None will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParams() {
        return null;
    }

    /**
     * (experimental) The log configuration specification for the container.
     * <p>
     * Default: - containers use the same logging driver that the Docker daemon uses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.LogConfiguration getLogConfiguration() {
        return null;
    }

    /**
     * (experimental) The hard limit (in MiB) of memory to present to the container.
     * <p>
     * If your container attempts to exceed
     * the memory specified here, the container is killed. You must specify at least 4 MiB of memory for EC2 and 512 MiB for Fargate.
     * <p>
     * Default: - 4 for EC2, 512 for Fargate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * (experimental) The mount points for data volumes in your container.
     * <p>
     * Default: - No mount points will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.MountPoint> getMountPoints() {
        return null;
    }

    /**
     * (experimental) Fargate platform version.
     * <p>
     * Default: - LATEST platform version will be used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    /**
     * (experimental) When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrivileged() {
        return null;
    }

    /**
     * (experimental) When this parameter is true, the container is given read-only access to its root file system.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReadOnly() {
        return null;
    }

    /**
     * (experimental) A list of ulimits to set in the container.
     * <p>
     * Default: - No limits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.Ulimit> getUlimits() {
        return null;
    }

    /**
     * (experimental) The user name to use inside the container.
     * <p>
     * Default: - None will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
        return null;
    }

    /**
     * (experimental) The number of vCPUs reserved for the container.
     * <p>
     * Each vCPU is equivalent to
     * 1,024 CPU shares. You must specify at least one vCPU for EC2 and 0.25 for Fargate.
     * <p>
     * Default: - 1 for EC2, 0.25 for Fargate
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVcpus() {
        return null;
    }

    /**
     * (experimental) A list of data volumes used in a job.
     * <p>
     * Default: - No data volumes will be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobDefinitionContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobDefinitionContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobDefinitionContainer> {
        software.amazon.awscdk.services.ecs.ContainerImage image;
        java.lang.Boolean assignPublicIp;
        java.util.List<java.lang.String> command;
        java.util.Map<java.lang.String, java.lang.String> environment;
        software.amazon.awscdk.services.iam.IRole executionRole;
        java.lang.Number gpuCount;
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.iam.IRole jobRole;
        software.amazon.awscdk.services.ecs.LinuxParameters linuxParams;
        software.amazon.awscdk.services.batch.LogConfiguration logConfiguration;
        java.lang.Number memoryLimitMiB;
        java.util.List<software.amazon.awscdk.services.ecs.MountPoint> mountPoints;
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        java.lang.Boolean privileged;
        java.lang.Boolean readOnly;
        java.util.List<software.amazon.awscdk.services.ecs.Ulimit> ulimits;
        java.lang.String user;
        java.lang.Number vcpus;
        java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Sets the value of {@link JobDefinitionContainer#getImage}
         * @param image The image used to start a container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getAssignPublicIp}
         * @param assignPublicIp Whether or not to assign a public IP to the job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assignPublicIp(java.lang.Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getEnvironment}
         * @param environment The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getExecutionRole}
         * @param executionRole The IAM role that AWS Batch can assume.
         *                      Required when using Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getGpuCount}
         * @param gpuCount The number of physical GPUs to reserve for the container.
         *                 The number of GPUs reserved for all
         *                 containers in a job should not exceed the number of available GPUs on the compute resource that the job is launched on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder gpuCount(java.lang.Number gpuCount) {
            this.gpuCount = gpuCount;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getInstanceType}
         * @param instanceType The instance type to use for a multi-node parallel job.
         *                     Currently all node groups in a
         *                     multi-node parallel job must use the same instance type. This parameter is not valid
         *                     for single-node container jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getJobRole}
         * @param jobRole The IAM role that the container can assume for AWS permissions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobRole(software.amazon.awscdk.services.iam.IRole jobRole) {
            this.jobRole = jobRole;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getLinuxParams}
         * @param linuxParams Linux-specific modifications that are applied to the container, such as details for device mappings.
         *                    For now, only the <code>devices</code> property is supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder linuxParams(software.amazon.awscdk.services.ecs.LinuxParameters linuxParams) {
            this.linuxParams = linuxParams;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getLogConfiguration}
         * @param logConfiguration The log configuration specification for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logConfiguration(software.amazon.awscdk.services.batch.LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getMemoryLimitMiB}
         * @param memoryLimitMiB The hard limit (in MiB) of memory to present to the container.
         *                       If your container attempts to exceed
         *                       the memory specified here, the container is killed. You must specify at least 4 MiB of memory for EC2 and 512 MiB for Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getMountPoints}
         * @param mountPoints The mount points for data volumes in your container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder mountPoints(java.util.List<? extends software.amazon.awscdk.services.ecs.MountPoint> mountPoints) {
            this.mountPoints = (java.util.List<software.amazon.awscdk.services.ecs.MountPoint>)mountPoints;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getPlatformVersion}
         * @param platformVersion Fargate platform version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getPrivileged}
         * @param privileged When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder privileged(java.lang.Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getReadOnly}
         * @param readOnly When this parameter is true, the container is given read-only access to its root file system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readOnly(java.lang.Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getUlimits}
         * @param ulimits A list of ulimits to set in the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder ulimits(java.util.List<? extends software.amazon.awscdk.services.ecs.Ulimit> ulimits) {
            this.ulimits = (java.util.List<software.amazon.awscdk.services.ecs.Ulimit>)ulimits;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getUser}
         * @param user The user name to use inside the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder user(java.lang.String user) {
            this.user = user;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getVcpus}
         * @param vcpus The number of vCPUs reserved for the container.
         *              Each vCPU is equivalent to
         *              1,024 CPU shares. You must specify at least one vCPU for EC2 and 0.25 for Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vcpus(java.lang.Number vcpus) {
            this.vcpus = vcpus;
            return this;
        }

        /**
         * Sets the value of {@link JobDefinitionContainer#getVolumes}
         * @param volumes A list of data volumes used in a job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobDefinitionContainer}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobDefinitionContainer build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobDefinitionContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobDefinitionContainer {
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final java.lang.Boolean assignPublicIp;
        private final java.util.List<java.lang.String> command;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.Number gpuCount;
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.iam.IRole jobRole;
        private final software.amazon.awscdk.services.ecs.LinuxParameters linuxParams;
        private final software.amazon.awscdk.services.batch.LogConfiguration logConfiguration;
        private final java.lang.Number memoryLimitMiB;
        private final java.util.List<software.amazon.awscdk.services.ecs.MountPoint> mountPoints;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final java.lang.Boolean privileged;
        private final java.lang.Boolean readOnly;
        private final java.util.List<software.amazon.awscdk.services.ecs.Ulimit> ulimits;
        private final java.lang.String user;
        private final java.lang.Number vcpus;
        private final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.gpuCount = software.amazon.jsii.Kernel.get(this, "gpuCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.jobRole = software.amazon.jsii.Kernel.get(this, "jobRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.linuxParams = software.amazon.jsii.Kernel.get(this, "linuxParams", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LinuxParameters.class));
            this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.LogConfiguration.class));
            this.memoryLimitMiB = software.amazon.jsii.Kernel.get(this, "memoryLimitMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.mountPoints = software.amazon.jsii.Kernel.get(this, "mountPoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.MountPoint.class)));
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.privileged = software.amazon.jsii.Kernel.get(this, "privileged", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readOnly = software.amazon.jsii.Kernel.get(this, "readOnly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ulimits = software.amazon.jsii.Kernel.get(this, "ulimits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Ulimit.class)));
            this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vcpus = software.amazon.jsii.Kernel.get(this, "vcpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.image = java.util.Objects.requireNonNull(builder.image, "image is required");
            this.assignPublicIp = builder.assignPublicIp;
            this.command = builder.command;
            this.environment = builder.environment;
            this.executionRole = builder.executionRole;
            this.gpuCount = builder.gpuCount;
            this.instanceType = builder.instanceType;
            this.jobRole = builder.jobRole;
            this.linuxParams = builder.linuxParams;
            this.logConfiguration = builder.logConfiguration;
            this.memoryLimitMiB = builder.memoryLimitMiB;
            this.mountPoints = (java.util.List<software.amazon.awscdk.services.ecs.MountPoint>)builder.mountPoints;
            this.platformVersion = builder.platformVersion;
            this.privileged = builder.privileged;
            this.readOnly = builder.readOnly;
            this.ulimits = (java.util.List<software.amazon.awscdk.services.ecs.Ulimit>)builder.ulimits;
            this.user = builder.user;
            this.vcpus = builder.vcpus;
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)builder.volumes;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final java.lang.Boolean getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.Number getGpuCount() {
            return this.gpuCount;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getJobRole() {
            return this.jobRole;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LinuxParameters getLinuxParams() {
            return this.linuxParams;
        }

        @Override
        public final software.amazon.awscdk.services.batch.LogConfiguration getLogConfiguration() {
            return this.logConfiguration;
        }

        @Override
        public final java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.MountPoint> getMountPoints() {
            return this.mountPoints;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final java.lang.Boolean getPrivileged() {
            return this.privileged;
        }

        @Override
        public final java.lang.Boolean getReadOnly() {
            return this.readOnly;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.Ulimit> getUlimits() {
            return this.ulimits;
        }

        @Override
        public final java.lang.String getUser() {
            return this.user;
        }

        @Override
        public final java.lang.Number getVcpus() {
            return this.vcpus;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("image", om.valueToTree(this.getImage()));
            if (this.getAssignPublicIp() != null) {
                data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getGpuCount() != null) {
                data.set("gpuCount", om.valueToTree(this.getGpuCount()));
            }
            if (this.getInstanceType() != null) {
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
            }
            if (this.getJobRole() != null) {
                data.set("jobRole", om.valueToTree(this.getJobRole()));
            }
            if (this.getLinuxParams() != null) {
                data.set("linuxParams", om.valueToTree(this.getLinuxParams()));
            }
            if (this.getLogConfiguration() != null) {
                data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getMountPoints() != null) {
                data.set("mountPoints", om.valueToTree(this.getMountPoints()));
            }
            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            if (this.getPrivileged() != null) {
                data.set("privileged", om.valueToTree(this.getPrivileged()));
            }
            if (this.getReadOnly() != null) {
                data.set("readOnly", om.valueToTree(this.getReadOnly()));
            }
            if (this.getUlimits() != null) {
                data.set("ulimits", om.valueToTree(this.getUlimits()));
            }
            if (this.getUser() != null) {
                data.set("user", om.valueToTree(this.getUser()));
            }
            if (this.getVcpus() != null) {
                data.set("vcpus", om.valueToTree(this.getVcpus()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-batch.JobDefinitionContainer"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobDefinitionContainer.Jsii$Proxy that = (JobDefinitionContainer.Jsii$Proxy) o;

            if (!image.equals(that.image)) return false;
            if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.gpuCount != null ? !this.gpuCount.equals(that.gpuCount) : that.gpuCount != null) return false;
            if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
            if (this.jobRole != null ? !this.jobRole.equals(that.jobRole) : that.jobRole != null) return false;
            if (this.linuxParams != null ? !this.linuxParams.equals(that.linuxParams) : that.linuxParams != null) return false;
            if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.mountPoints != null ? !this.mountPoints.equals(that.mountPoints) : that.mountPoints != null) return false;
            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) return false;
            if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) return false;
            if (this.ulimits != null ? !this.ulimits.equals(that.ulimits) : that.ulimits != null) return false;
            if (this.user != null ? !this.user.equals(that.user) : that.user != null) return false;
            if (this.vcpus != null ? !this.vcpus.equals(that.vcpus) : that.vcpus != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.image.hashCode();
            result = 31 * result + (this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.gpuCount != null ? this.gpuCount.hashCode() : 0);
            result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
            result = 31 * result + (this.jobRole != null ? this.jobRole.hashCode() : 0);
            result = 31 * result + (this.linuxParams != null ? this.linuxParams.hashCode() : 0);
            result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.mountPoints != null ? this.mountPoints.hashCode() : 0);
            result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
            result = 31 * result + (this.privileged != null ? this.privileged.hashCode() : 0);
            result = 31 * result + (this.readOnly != null ? this.readOnly.hashCode() : 0);
            result = 31 * result + (this.ulimits != null ? this.ulimits.hashCode() : 0);
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            result = 31 * result + (this.vcpus != null ? this.vcpus.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
