/**
 * <h1>AWS Lambda Layer with the NPM dependency proxy-agent</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module bundles the NPM dependency <a href="https://www.npmjs.com/package/proxy-agent"><code>proxy-agent</code></a>
 * as a local asset. It exposes constants <code>ASSET_FILE</code> and <code>LAYER_SOURCE_DIR</code> that can be consumed
 * via the CDK <code>Asset</code> construct.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>proxy-agent Version: 5.0.0</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * import aws.cdk.asset.node.proxy.agent.v5.ASSET_FILE;
 * import aws.cdk.asset.node.proxy.agent.v5.LAYER_SOURCE_DIR;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.services.s3.assets.*;
 * import software.amazon.awscdk.FileSystem;
 * 
 * Function fn;
 * 
 * Asset asset = Asset.Builder.create(this, "layer-asset")
 *         .path(ASSET_FILE)
 *         .assetHash(FileSystem.fingerprint(LAYER_SOURCE_DIR))
 *         .build();
 * 
 * fn.addLayers(LayerVersion.Builder.create(this, "ProxyAgentLayer")
 *         .code(Code.fromBucket(asset.getBucket(), asset.getS3ObjectKey()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * <a href="https://www.npmjs.com/package/proxy-agent"><code>proxy-agent</code></a> will be installed under <code>/nodejs/node_modules</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cdk.asset.node.proxy.agent.v5;
