package software.amazon.awscdk.cloudformation.include;

/**
 * Construction properties of {@link CfnInclude}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-02T00:24:13.476Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudformation.include.$Module.class, fqn = "@aws-cdk/cloudformation-include.CfnIncludeProps")
@software.amazon.jsii.Jsii.Proxy(CfnIncludeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIncludeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Path to the template file.
     * <p>
     * Both JSON and YAML template formats are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile();

    /**
     * Specifies the template files that define nested stacks that should be included.
     * <p>
     * If your template specifies a stack that isn't included here, it won't be created as a NestedStack
     * resource, and it won't be accessible from the {&#64;link CfnInclude.getNestedStack} method
     * (but will still be accessible from the {&#64;link CfnInclude.getResource} method).
     * <p>
     * If you include a stack here with an ID that isn't in the template,
     * or is in the template but is not a nested stack,
     * template creation will fail and an error will be thrown.
     * <p>
     * Default: - no nested stacks will be included
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> getLoadNestedStacks() {
        return null;
    }

    /**
     * Specifies parameters to be replaced by the values in this mapping.
     * <p>
     * Any parameters in the template that aren't specified here will be left unmodified.
     * If you include a parameter here with an ID that isn't in the template,
     * template creation will fail and an error will be thrown.
     * <p>
     * Default: - no parameters will be replaced
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return null;
    }

    /**
     * Whether the resources should have the same logical IDs in the resulting CDK template as they did in the original CloudFormation template file.
     * <p>
     * If you're vending a Construct using an existing CloudFormation template,
     * make sure to pass this as <code>false</code>.
     * <p>
     * <strong>Note</strong>: regardless of whether this option is true or false,
     * the {&#64;link CfnInclude.getResource} and related methods always uses the original logical ID of the resource/element,
     * as specified in the template file.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreserveLogicalIds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIncludeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIncludeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIncludeProps> {
        private java.lang.String templateFile;
        private java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks;
        private java.util.Map<java.lang.String, java.lang.Object> parameters;
        private java.lang.Boolean preserveLogicalIds;

        /**
         * Sets the value of {@link CfnIncludeProps#getTemplateFile}
         * @param templateFile Path to the template file. This parameter is required.
         *                     Both JSON and YAML template formats are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateFile(java.lang.String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getLoadNestedStacks}
         * @param loadNestedStacks Specifies the template files that define nested stacks that should be included.
         *                         If your template specifies a stack that isn't included here, it won't be created as a NestedStack
         *                         resource, and it won't be accessible from the {&#64;link CfnInclude.getNestedStack} method
         *                         (but will still be accessible from the {&#64;link CfnInclude.getResource} method).
         *                         <p>
         *                         If you include a stack here with an ID that isn't in the template,
         *                         or is in the template but is not a nested stack,
         *                         template creation will fail and an error will be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder loadNestedStacks(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks) {
            this.loadNestedStacks = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps>)loadNestedStacks;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getParameters}
         * @param parameters Specifies parameters to be replaced by the values in this mapping.
         *                   Any parameters in the template that aren't specified here will be left unmodified.
         *                   If you include a parameter here with an ID that isn't in the template,
         *                   template creation will fail and an error will be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnIncludeProps#getPreserveLogicalIds}
         * @param preserveLogicalIds Whether the resources should have the same logical IDs in the resulting CDK template as they did in the original CloudFormation template file.
         *                           If you're vending a Construct using an existing CloudFormation template,
         *                           make sure to pass this as <code>false</code>.
         *                           <p>
         *                           <strong>Note</strong>: regardless of whether this option is true or false,
         *                           the {&#64;link CfnInclude.getResource} and related methods always uses the original logical ID of the resource/element,
         *                           as specified in the template file.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preserveLogicalIds(java.lang.Boolean preserveLogicalIds) {
            this.preserveLogicalIds = preserveLogicalIds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIncludeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIncludeProps build() {
            return new Jsii$Proxy(templateFile, loadNestedStacks, parameters, preserveLogicalIds);
        }
    }

    /**
     * An implementation for {@link CfnIncludeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIncludeProps {
        private final java.lang.String templateFile;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.Boolean preserveLogicalIds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.templateFile = software.amazon.jsii.Kernel.get(this, "templateFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loadNestedStacks = software.amazon.jsii.Kernel.get(this, "loadNestedStacks", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudformation.include.CfnIncludeProps.class)));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.preserveLogicalIds = software.amazon.jsii.Kernel.get(this, "preserveLogicalIds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.String templateFile, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloudformation.include.CfnIncludeProps> loadNestedStacks, final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters, final java.lang.Boolean preserveLogicalIds) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.templateFile = java.util.Objects.requireNonNull(templateFile, "templateFile is required");
            this.loadNestedStacks = (java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps>)loadNestedStacks;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            this.preserveLogicalIds = preserveLogicalIds;
        }

        @Override
        public final java.lang.String getTemplateFile() {
            return this.templateFile;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloudformation.include.CfnIncludeProps> getLoadNestedStacks() {
            return this.loadNestedStacks;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Boolean getPreserveLogicalIds() {
            return this.preserveLogicalIds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("templateFile", om.valueToTree(this.getTemplateFile()));
            if (this.getLoadNestedStacks() != null) {
                data.set("loadNestedStacks", om.valueToTree(this.getLoadNestedStacks()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPreserveLogicalIds() != null) {
                data.set("preserveLogicalIds", om.valueToTree(this.getPreserveLogicalIds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloudformation-include.CfnIncludeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIncludeProps.Jsii$Proxy that = (CfnIncludeProps.Jsii$Proxy) o;

            if (!templateFile.equals(that.templateFile)) return false;
            if (this.loadNestedStacks != null ? !this.loadNestedStacks.equals(that.loadNestedStacks) : that.loadNestedStacks != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            return this.preserveLogicalIds != null ? this.preserveLogicalIds.equals(that.preserveLogicalIds) : that.preserveLogicalIds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.templateFile.hashCode();
            result = 31 * result + (this.loadNestedStacks != null ? this.loadNestedStacks.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.preserveLogicalIds != null ? this.preserveLogicalIds.hashCode() : 0);
            return result;
        }
    }
}
