package software.amazon.awscdk.cloudformation.include;

import static java.util.Arrays.asList;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;

import java.nio.charset.StandardCharsets;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import software.amazon.jsii.JsiiModule;

@software.amazon.jsii.Internal
public final class $Module extends JsiiModule {
    private static final Map<String, String> MODULE_TYPES = load();

    private static Map<String, String> load() {
        final Map<String, String> result = new HashMap<>();
        final ClassLoader cl = $Module.class.getClassLoader();
        try (final InputStream is = cl.getResourceAsStream("software/amazon/awscdk/cloudformation/include/$Module.txt");
             final Reader rd = new InputStreamReader(is, StandardCharsets.UTF_8);
             final BufferedReader br = new BufferedReader(rd)) {
            br.lines()
              .filter(line -> !line.trim().isEmpty())
              .forEach(line ->  {
                final String[] parts = line.split("=", 2);
                final String fqn = parts[0];
                final String className = parts[1];
                result.put(fqn, className);
            });
        }
        catch (final IOException exception) {
            throw new UncheckedIOException(exception);
        }
        return result;
    }

    private final Map<String, Class<?>> cache = new HashMap<>();

    public $Module() {
        super("@aws-cdk/cloudformation-include", "1.169.0", $Module.class, "cloudformation-include@1.169.0.jsii.tgz");
    }

    @Override
    public List<Class<? extends JsiiModule>> getDependencies() {
        return asList(software.amazon.awscdk.alexa.ask.$Module.class, software.amazon.awscdk.services.accessanalyzer.$Module.class, software.amazon.awscdk.services.acmpca.$Module.class, software.amazon.awscdk.services.amazonmq.$Module.class, software.amazon.awscdk.services.amplify.$Module.class, software.amazon.awscdk.services.amplifyuibuilder.$Module.class, software.amazon.awscdk.services.apigateway.$Module.class, software.amazon.awscdk.services.apigatewayv2.$Module.class, software.amazon.awscdk.services.appconfig.$Module.class, software.amazon.awscdk.services.appflow.$Module.class, software.amazon.awscdk.services.appintegrations.$Module.class, software.amazon.awscdk.services.applicationautoscaling.$Module.class, software.amazon.awscdk.services.applicationinsights.$Module.class, software.amazon.awscdk.services.appmesh.$Module.class, software.amazon.awscdk.services.apprunner.$Module.class, software.amazon.awscdk.services.appstream.$Module.class, software.amazon.awscdk.services.appsync.$Module.class, software.amazon.awscdk.services.aps.$Module.class, software.amazon.awscdk.services.athena.$Module.class, software.amazon.awscdk.services.auditmanager.$Module.class, software.amazon.awscdk.services.autoscaling.$Module.class, software.amazon.awscdk.services.autoscalingplans.$Module.class, software.amazon.awscdk.services.backup.$Module.class, software.amazon.awscdk.services.batch.$Module.class, software.amazon.awscdk.services.billingconductor.$Module.class, software.amazon.awscdk.services.budgets.$Module.class, software.amazon.awscdk.services.cassandra.$Module.class, software.amazon.awscdk.services.ce.$Module.class, software.amazon.awscdk.services.certificatemanager.$Module.class, software.amazon.awscdk.services.chatbot.$Module.class, software.amazon.awscdk.services.cloud9.$Module.class, software.amazon.awscdk.services.cloudfront.$Module.class, software.amazon.awscdk.services.cloudtrail.$Module.class, software.amazon.awscdk.services.cloudwatch.$Module.class, software.amazon.awscdk.services.codeartifact.$Module.class, software.amazon.awscdk.services.codebuild.$Module.class, software.amazon.awscdk.services.codecommit.$Module.class, software.amazon.awscdk.services.codedeploy.$Module.class, software.amazon.awscdk.services.codeguruprofiler.$Module.class, software.amazon.awscdk.services.codegurureviewer.$Module.class, software.amazon.awscdk.services.codepipeline.$Module.class, software.amazon.awscdk.services.codestar.$Module.class, software.amazon.awscdk.services.codestarconnections.$Module.class, software.amazon.awscdk.services.codestarnotifications.$Module.class, software.amazon.awscdk.services.cognito.$Module.class, software.amazon.awscdk.services.config.$Module.class, software.amazon.awscdk.services.connect.$Module.class, software.amazon.awscdk.services.cur.$Module.class, software.amazon.awscdk.services.customerprofiles.$Module.class, software.amazon.awscdk.services.databrew.$Module.class, software.amazon.awscdk.services.datapipeline.$Module.class, software.amazon.awscdk.services.datasync.$Module.class, software.amazon.awscdk.services.dax.$Module.class, software.amazon.awscdk.services.detective.$Module.class, software.amazon.awscdk.services.devopsguru.$Module.class, software.amazon.awscdk.services.directoryservice.$Module.class, software.amazon.awscdk.services.dlm.$Module.class, software.amazon.awscdk.services.dms.$Module.class, software.amazon.awscdk.services.docdb.$Module.class, software.amazon.awscdk.services.dynamodb.$Module.class, software.amazon.awscdk.services.ec2.$Module.class, software.amazon.awscdk.services.ecr.$Module.class, software.amazon.awscdk.services.ecs.$Module.class, software.amazon.awscdk.services.efs.$Module.class, software.amazon.awscdk.services.eks.$Module.class, software.amazon.awscdk.services.elasticache.$Module.class, software.amazon.awscdk.services.elasticbeanstalk.$Module.class, software.amazon.awscdk.services.elasticloadbalancing.$Module.class, software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, software.amazon.awscdk.services.elasticsearch.$Module.class, software.amazon.awscdk.services.emr.$Module.class, software.amazon.awscdk.services.emrcontainers.$Module.class, software.amazon.awscdk.services.emrserverless.$Module.class, software.amazon.awscdk.services.events.$Module.class, software.amazon.awscdk.services.eventschemas.$Module.class, software.amazon.awscdk.services.evidently.$Module.class, software.amazon.awscdk.services.finspace.$Module.class, software.amazon.awscdk.services.fis.$Module.class, software.amazon.awscdk.services.fms.$Module.class, software.amazon.awscdk.services.forecast.$Module.class, software.amazon.awscdk.services.frauddetector.$Module.class, software.amazon.awscdk.services.fsx.$Module.class, software.amazon.awscdk.services.gamelift.$Module.class, software.amazon.awscdk.services.globalaccelerator.$Module.class, software.amazon.awscdk.services.glue.$Module.class, software.amazon.awscdk.services.greengrass.$Module.class, software.amazon.awscdk.services.greengrassv2.$Module.class, software.amazon.awscdk.services.groundstation.$Module.class, software.amazon.awscdk.services.guardduty.$Module.class, software.amazon.awscdk.services.healthlake.$Module.class, software.amazon.awscdk.services.iam.$Module.class, software.amazon.awscdk.services.imagebuilder.$Module.class, software.amazon.awscdk.services.inspector.$Module.class, software.amazon.awscdk.services.inspectorv2.$Module.class, software.amazon.awscdk.services.iot.$Module.class, software.amazon.awscdk.services.iot1click.$Module.class, software.amazon.awscdk.services.iotanalytics.$Module.class, software.amazon.awscdk.services.iotcoredeviceadvisor.$Module.class, software.amazon.awscdk.services.iotevents.$Module.class, software.amazon.awscdk.services.iotfleethub.$Module.class, software.amazon.awscdk.services.iotsitewise.$Module.class, software.amazon.awscdk.services.iotthingsgraph.$Module.class, software.amazon.awscdk.services.iottwinmaker.$Module.class, software.amazon.awscdk.services.iotwireless.$Module.class, software.amazon.awscdk.services.ivs.$Module.class, software.amazon.awscdk.services.kafkaconnect.$Module.class, software.amazon.awscdk.services.kendra.$Module.class, software.amazon.awscdk.services.kinesis.$Module.class, software.amazon.awscdk.services.kinesisanalytics.$Module.class, software.amazon.awscdk.services.kinesisanalyticsv2.$Module.class, software.amazon.awscdk.services.kinesisfirehose.$Module.class, software.amazon.awscdk.services.kinesisvideo.$Module.class, software.amazon.awscdk.services.kms.$Module.class, software.amazon.awscdk.services.lakeformation.$Module.class, software.amazon.awscdk.services.lambda.$Module.class, software.amazon.awscdk.services.lex.$Module.class, software.amazon.awscdk.services.licensemanager.$Module.class, software.amazon.awscdk.services.lightsail.$Module.class, software.amazon.awscdk.services.location.$Module.class, software.amazon.awscdk.services.logs.$Module.class, software.amazon.awscdk.services.lookoutequipment.$Module.class, software.amazon.awscdk.services.lookoutmetrics.$Module.class, software.amazon.awscdk.services.lookoutvision.$Module.class, software.amazon.awscdk.services.macie.$Module.class, software.amazon.awscdk.services.managedblockchain.$Module.class, software.amazon.awscdk.services.mediaconnect.$Module.class, software.amazon.awscdk.services.mediaconvert.$Module.class, software.amazon.awscdk.services.medialive.$Module.class, software.amazon.awscdk.services.mediapackage.$Module.class, software.amazon.awscdk.services.mediastore.$Module.class, software.amazon.awscdk.services.mediatailor.$Module.class, software.amazon.awscdk.services.memorydb.$Module.class, software.amazon.awscdk.services.msk.$Module.class, software.amazon.awscdk.services.mwaa.$Module.class, software.amazon.awscdk.services.neptune.$Module.class, software.amazon.awscdk.services.networkfirewall.$Module.class, software.amazon.awscdk.services.networkmanager.$Module.class, software.amazon.awscdk.services.nimblestudio.$Module.class, software.amazon.awscdk.services.opensearchservice.$Module.class, software.amazon.awscdk.services.opsworks.$Module.class, software.amazon.awscdk.services.opsworkscm.$Module.class, software.amazon.awscdk.services.panorama.$Module.class, software.amazon.awscdk.services.personalize.$Module.class, software.amazon.awscdk.services.pinpoint.$Module.class, software.amazon.awscdk.services.pinpointemail.$Module.class, software.amazon.awscdk.services.qldb.$Module.class, software.amazon.awscdk.services.quicksight.$Module.class, software.amazon.awscdk.services.ram.$Module.class, software.amazon.awscdk.services.rds.$Module.class, software.amazon.awscdk.services.redshift.$Module.class, software.amazon.awscdk.services.redshiftserverless.$Module.class, software.amazon.awscdk.services.refactorspaces.$Module.class, software.amazon.awscdk.services.rekognition.$Module.class, software.amazon.awscdk.services.resiliencehub.$Module.class, software.amazon.awscdk.services.resourcegroups.$Module.class, software.amazon.awscdk.services.robomaker.$Module.class, software.amazon.awscdk.services.route53.$Module.class, software.amazon.awscdk.services.route53recoverycontrol.$Module.class, software.amazon.awscdk.services.route53recoveryreadiness.$Module.class, software.amazon.awscdk.services.route53resolver.$Module.class, software.amazon.awscdk.services.rum.$Module.class, software.amazon.awscdk.services.s3.$Module.class, software.amazon.awscdk.services.s3objectlambda.$Module.class, software.amazon.awscdk.services.s3outposts.$Module.class, software.amazon.awscdk.services.sagemaker.$Module.class, software.amazon.awscdk.services.sam.$Module.class, software.amazon.awscdk.services.sdb.$Module.class, software.amazon.awscdk.services.secretsmanager.$Module.class, software.amazon.awscdk.services.securityhub.$Module.class, software.amazon.awscdk.services.servicecatalog.$Module.class, software.amazon.awscdk.services.servicecatalogappregistry.$Module.class, software.amazon.awscdk.services.servicediscovery.$Module.class, software.amazon.awscdk.services.ses.$Module.class, software.amazon.awscdk.services.signer.$Module.class, software.amazon.awscdk.services.sns.$Module.class, software.amazon.awscdk.services.sqs.$Module.class, software.amazon.awscdk.services.ssm.$Module.class, software.amazon.awscdk.services.ssmcontacts.$Module.class, software.amazon.awscdk.services.ssmincidents.$Module.class, software.amazon.awscdk.services.sso.$Module.class, software.amazon.awscdk.services.stepfunctions.$Module.class, software.amazon.awscdk.services.synthetics.$Module.class, software.amazon.awscdk.services.timestream.$Module.class, software.amazon.awscdk.services.transfer.$Module.class, software.amazon.awscdk.services.voiceid.$Module.class, software.amazon.awscdk.services.waf.$Module.class, software.amazon.awscdk.services.waf.regional.$Module.class, software.amazon.awscdk.services.wafv2.$Module.class, software.amazon.awscdk.services.wisdom.$Module.class, software.amazon.awscdk.services.workspaces.$Module.class, software.amazon.awscdk.services.xray.$Module.class, software.amazon.awscdk.core.$Module.class, software.constructs.$Module.class);
    }

    @Override
    protected Class<?> resolveClass(final String fqn) throws ClassNotFoundException {
        if (!MODULE_TYPES.containsKey(fqn)) {
            throw new ClassNotFoundException("Unknown JSII type: " + fqn);
        }
        String className = MODULE_TYPES.get(fqn);
        if (!this.cache.containsKey(className)) {
            this.cache.put(className, this.findClass(className));
        }
        return this.cache.get(className);
    }

    private Class<?> findClass(final String binaryName) {
        try {
            return Class.forName(binaryName);
        }
        catch (final ClassNotFoundException exception) {
            throw new RuntimeException(exception);
        }
    }
}
