/**
 * <h1>Lambda Layer with KubeCtl v1.28</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module exports a single class called <code>KubectlV28Layer</code> which is a <code>lambda.LayerVersion</code> that
 * bundles the <a href="https://kubernetes.io/docs/reference/kubectl/kubectl/"><code>kubectl</code></a> and the
 * <a href="https://helm.sh/"><code>helm</code></a> command line.
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>Helm Version: 3.13.1</li>
 * <li>Kubectl Version: 1.28.2</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * // KubectlLayer bundles the 'kubectl' and 'helm' command lines
 * import { KubectlV28Layer } from '&#64;aws-cdk/lambda-layer-kubectl-v28';
 * import * as lambda from 'aws-cdk-lib/aws-lambda';
 * 
 * declare const fn: lambda.Function;
 * const kubectl = new KubectlV28Layer(this, 'KubectlLayer');
 * fn.addLayers(kubectl);
 * </pre></blockquote>
 * <p>
 * <code>kubectl</code> will be installed under <code>/opt/kubectl/kubectl</code>, and <code>helm</code> will be installed under <code>/opt/helm/helm</code>.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.cdk.lambdalayer.kubectl.v28;
