package software.amazon.awscdk.services.codebuild.codepipeline;
/**
 * Construction properties of the {@link PipelineBuildAction CodeBuild build CodePipeline Action}.
 */
public interface PipelineBuildActionProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The source to use as input for this build
     */
    software.amazon.awscdk.services.codepipeline.Artifact getInputArtifact();
    /**
     * The source to use as input for this build
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.Artifact value);
    /**
     * The name of the build's output artifact
     */
    java.lang.String getArtifactName();
    /**
     * The name of the build's output artifact
     */
    void setArtifactName(final java.lang.String value);
    /**
     * The build project
     */
    software.amazon.awscdk.services.codebuild.ProjectRef getProject();
    /**
     * The build project
     */
    void setProject(final software.amazon.awscdk.services.codebuild.ProjectRef value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link PipelineBuildActionProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * The source to use as input for this build
         */
        public ProjectStep withInputArtifact(final software.amazon.awscdk.services.codepipeline.Artifact value) {
            return new FullBuilder().withInputArtifact(value);
        }

        public interface ProjectStep {
            /**
             * The build project
             */
            Build withProject(final software.amazon.awscdk.services.codebuild.ProjectRef value);
        }

        public interface Build {
            /**
             * @return a new {@link PipelineBuildActionProps} object, initialized with the values set on this builder.
             */
            PipelineBuildActionProps build();
            /**
             * The name of the build's output artifact
             */
            Build withArtifactName(final java.lang.String value);
        }

        final class FullBuilder implements ProjectStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * The source to use as input for this build
             */
            public ProjectStep withInputArtifact(final software.amazon.awscdk.services.codepipeline.Artifact value) {
                java.util.Objects.requireNonNull(value, "PipelineBuildActionProps#inputArtifact is required");
                this.instance._inputArtifact = value;
                return this;
            }
            /**
             * The name of the build's output artifact
             */
            public Build withArtifactName(final java.lang.String value) {
                this.instance._artifactName = value;
                return this;
            }
            /**
             * The build project
             */
            public Build withProject(final software.amazon.awscdk.services.codebuild.ProjectRef value) {
                java.util.Objects.requireNonNull(value, "PipelineBuildActionProps#project is required");
                this.instance._project = value;
                return this;
            }
            public PipelineBuildActionProps build() {
                PipelineBuildActionProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link PipelineBuildActionProps}.
     */
    final class Jsii$Pojo implements PipelineBuildActionProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected software.amazon.awscdk.services.codepipeline.Artifact _inputArtifact;

        public software.amazon.awscdk.services.codepipeline.Artifact getInputArtifact() {
            return this._inputArtifact;
        }
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.Artifact value) {
            this._inputArtifact = value;
        }

        protected java.lang.String _artifactName;

        public java.lang.String getArtifactName() {
            return this._artifactName;
        }
        public void setArtifactName(final java.lang.String value) {
            this._artifactName = value;
        }

        protected software.amazon.awscdk.services.codebuild.ProjectRef _project;

        public software.amazon.awscdk.services.codebuild.ProjectRef getProject() {
            return this._project;
        }
        public void setProject(final software.amazon.awscdk.services.codebuild.ProjectRef value) {
            this._project = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.codepipeline.PipelineBuildActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * The source to use as input for this build
         */
        public software.amazon.awscdk.services.codepipeline.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.Artifact.class);
        }
        /**
         * The source to use as input for this build
         */
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.Artifact value) {
            this.jsiiSet("inputArtifact", java.util.Objects.requireNonNull(value, "inputArtifact is required"));
        }
        /**
         * The name of the build's output artifact
         */
        @javax.annotation.Nullable
        public java.lang.String getArtifactName() {
            return this.jsiiGet("artifactName", java.lang.String.class);
        }
        /**
         * The name of the build's output artifact
         */
        public void setArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("artifactName", value);
        }
        /**
         * The build project
         */
        public software.amazon.awscdk.services.codebuild.ProjectRef getProject() {
            return this.jsiiGet("project", software.amazon.awscdk.services.codebuild.ProjectRef.class);
        }
        /**
         * The build project
         */
        public void setProject(final software.amazon.awscdk.services.codebuild.ProjectRef value) {
            this.jsiiSet("project", java.util.Objects.requireNonNull(value, "project is required"));
        }
    }
}
