package software.amazon.awscdk.services.codepipeline.api;

/**
 * Specifies the constraints on the number of input and output
 * artifacts an action can have.
 * 
 * The constraints for each action type are documented on the
 * {@link https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html Pipeline Structure Reference} page.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:46:12.147Z")
public interface ActionArtifactBounds extends software.amazon.jsii.JsiiSerializable {
    java.lang.Number getMaxInputs();
    java.lang.Number getMaxOutputs();
    java.lang.Number getMinInputs();
    java.lang.Number getMinOutputs();

    /**
     * @return a {@link Builder} of {@link ActionArtifactBounds}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ActionArtifactBounds}
     */
    final class Builder {
        private java.lang.Number _maxInputs;
        private java.lang.Number _maxOutputs;
        private java.lang.Number _minInputs;
        private java.lang.Number _minOutputs;

        /**
         * Sets the value of MaxInputs
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withMaxInputs(final java.lang.Number value) {
            this._maxInputs = java.util.Objects.requireNonNull(value, "maxInputs is required");
            return this;
        }
        /**
         * Sets the value of MaxOutputs
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withMaxOutputs(final java.lang.Number value) {
            this._maxOutputs = java.util.Objects.requireNonNull(value, "maxOutputs is required");
            return this;
        }
        /**
         * Sets the value of MinInputs
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withMinInputs(final java.lang.Number value) {
            this._minInputs = java.util.Objects.requireNonNull(value, "minInputs is required");
            return this;
        }
        /**
         * Sets the value of MinOutputs
         * @param value the value to be set
         * @return {@code this}
         */
        public Builder withMinOutputs(final java.lang.Number value) {
            this._minOutputs = java.util.Objects.requireNonNull(value, "minOutputs is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionArtifactBounds}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ActionArtifactBounds build() {
            return new ActionArtifactBounds() {
                private final java.lang.Number $maxInputs = java.util.Objects.requireNonNull(_maxInputs, "maxInputs is required");
                private final java.lang.Number $maxOutputs = java.util.Objects.requireNonNull(_maxOutputs, "maxOutputs is required");
                private final java.lang.Number $minInputs = java.util.Objects.requireNonNull(_minInputs, "minInputs is required");
                private final java.lang.Number $minOutputs = java.util.Objects.requireNonNull(_minOutputs, "minOutputs is required");

                @Override
                public java.lang.Number getMaxInputs() {
                    return this.$maxInputs;
                }

                @Override
                public java.lang.Number getMaxOutputs() {
                    return this.$maxOutputs;
                }

                @Override
                public java.lang.Number getMinInputs() {
                    return this.$minInputs;
                }

                @Override
                public java.lang.Number getMinOutputs() {
                    return this.$minOutputs;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        @Override
        public java.lang.Number getMaxInputs() {
            return this.jsiiGet("maxInputs", java.lang.Number.class);
        }

        @Override
        public java.lang.Number getMaxOutputs() {
            return this.jsiiGet("maxOutputs", java.lang.Number.class);
        }

        @Override
        public java.lang.Number getMinInputs() {
            return this.jsiiGet("minInputs", java.lang.Number.class);
        }

        @Override
        public java.lang.Number getMinOutputs() {
            return this.jsiiGet("minOutputs", java.lang.Number.class);
        }
    }
}
