package software.amazon.awscdk.services.codepipeline.api;

/**
 * Construction properties of the low level {@link BuildAction build action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:46:12.151Z")
public interface BuildActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The source to use as input for this build.
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The source to use as input for this build.
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);
    /**
     * The service provider that the action calls. For example, a valid provider for Source actions is CodeBuild.
     */
    java.lang.String getProvider();
    /**
     * The service provider that the action calls. For example, a valid provider for Source actions is CodeBuild.
     */
    void setProvider(final java.lang.String value);
    /**
     * The name of the build's output artifact.
     */
    java.lang.String getArtifactName();
    /**
     * The name of the build's output artifact.
     */
    void setArtifactName(final java.lang.String value);
    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    java.lang.Object getConfiguration();
    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    void setConfiguration(final java.lang.Object value);

    /**
     * @return a {@link Builder} of {@link BuildActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BuildActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        private java.lang.String _provider;
        @javax.annotation.Nullable
        private java.lang.String _artifactName;
        @javax.annotation.Nullable
        private java.lang.Object _configuration;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for this build.
         * @return {@code this}
         */
        public Builder withInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
            return this;
        }
        /**
         * Sets the value of Provider
         * @param value The service provider that the action calls. For example, a valid provider for Source actions is CodeBuild.
         * @return {@code this}
         */
        public Builder withProvider(final java.lang.String value) {
            this._provider = java.util.Objects.requireNonNull(value, "provider is required");
            return this;
        }
        /**
         * Sets the value of ArtifactName
         * @param value The name of the build's output artifact.
         * @return {@code this}
         */
        public Builder withArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this._artifactName = value;
            return this;
        }
        /**
         * Sets the value of Configuration
         * @param value The action's configuration. These are key-value pairs that specify input values for an action.
For more information, see the AWS CodePipeline User Guide.

http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         * @return {@code this}
         */
        public Builder withConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
            this._configuration = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BuildActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BuildActionProps build() {
            return new BuildActionProps() {
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = java.util.Objects.requireNonNull(_inputArtifact, "inputArtifact is required");
                private java.lang.String $provider = java.util.Objects.requireNonNull(_provider, "provider is required");
                @javax.annotation.Nullable
                private java.lang.String $artifactName = _artifactName;
                @javax.annotation.Nullable
                private java.lang.Object $configuration = _configuration;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = java.util.Objects.requireNonNull(value, "inputArtifact is required");
                }

                @Override
                public java.lang.String getProvider() {
                    return this.$provider;
                }

                @Override
                public void setProvider(final java.lang.String value) {
                    this.$provider = java.util.Objects.requireNonNull(value, "provider is required");
                }

                @Override
                public java.lang.String getArtifactName() {
                    return this.$artifactName;
                }

                @Override
                public void setArtifactName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$artifactName = value;
                }

                @Override
                public java.lang.Object getConfiguration() {
                    return this.$configuration;
                }

                @Override
                public void setConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
                    this.$configuration = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.api.BuildActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The source to use as input for this build.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for this build.
         */
        @Override
        public void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", java.util.Objects.requireNonNull(value, "inputArtifact is required"));
        }

        /**
         * The service provider that the action calls. For example, a valid provider for Source actions is CodeBuild.
         */
        @Override
        public java.lang.String getProvider() {
            return this.jsiiGet("provider", java.lang.String.class);
        }

        /**
         * The service provider that the action calls. For example, a valid provider for Source actions is CodeBuild.
         */
        @Override
        public void setProvider(final java.lang.String value) {
            this.jsiiSet("provider", java.util.Objects.requireNonNull(value, "provider is required"));
        }

        /**
         * The name of the build's output artifact.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getArtifactName() {
            return this.jsiiGet("artifactName", java.lang.String.class);
        }

        /**
         * The name of the build's output artifact.
         */
        @Override
        public void setArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("artifactName", value);
        }

        /**
         * The action's configuration. These are key-value pairs that specify input values for an action.
         * For more information, see the AWS CodePipeline User Guide.
         * 
         * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getConfiguration() {
            return this.jsiiGet("configuration", java.lang.Object.class);
        }

        /**
         * The action's configuration. These are key-value pairs that specify input values for an action.
         * For more information, see the AWS CodePipeline User Guide.
         * 
         * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         */
        @Override
        public void setConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("configuration", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
