package software.amazon.awscdk.services.codepipeline.api;

/**
 * The abstract interface of a Pipeline Stage that is used by Actions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:46:12.152Z")
public interface IStage extends software.amazon.jsii.JsiiSerializable {
    /**
     * The physical, human-readable name of this Pipeline Stage.
     */
    java.lang.String getName();
    /**
     * The ARN of the Pipeline.
     */
    java.lang.String getPipelineArn();
    /**
     * The service Role of the Pipeline.
     */
    software.amazon.awscdk.services.iam.Role getPipelineRole();
    /**
     * Grants read & write permissions to the Pipeline's S3 Bucket to the given Identity.
     * @param identity the IAM Identity to grant the permissions to
     */
    void grantPipelineBucketReadWrite(final software.amazon.awscdk.services.iam.IPrincipal identity);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.api.IStage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The physical, human-readable name of this Pipeline Stage.
         */
        @Override
        public java.lang.String getName() {
            return this.jsiiGet("name", java.lang.String.class);
        }

        /**
         * The ARN of the Pipeline.
         */
        @Override
        public java.lang.String getPipelineArn() {
            return this.jsiiGet("pipelineArn", java.lang.String.class);
        }

        /**
         * The service Role of the Pipeline.
         */
        @Override
        public software.amazon.awscdk.services.iam.Role getPipelineRole() {
            return this.jsiiGet("pipelineRole", software.amazon.awscdk.services.iam.Role.class);
        }

        /**
         * Grants read & write permissions to the Pipeline's S3 Bucket to the given Identity.
         * @param identity the IAM Identity to grant the permissions to
         */
        @Override
        public void grantPipelineBucketReadWrite(final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantPipelineBucketReadWrite", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(identity, "identity is required")).toArray());
        }
    }
}
