package software.amazon.awscdk.services.codepipeline.api;

/**
 * Construction properties of the low-level {@link SourceAction source Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.6 (build 04cb6bb)", date = "2018-09-27T21:46:12.153Z")
public interface SourceActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps {
    /**
     * The name of the source's output artifact.
     * Output artifacts are used by CodePipeline as inputs into other actions.
     */
    java.lang.String getArtifactName();
    /**
     * The name of the source's output artifact.
     * Output artifacts are used by CodePipeline as inputs into other actions.
     */
    void setArtifactName(final java.lang.String value);
    /**
     * The service provider that the action calls.
     * For example, a valid provider for Source actions is "S3".
     */
    java.lang.String getProvider();
    /**
     * The service provider that the action calls.
     * For example, a valid provider for Source actions is "S3".
     */
    void setProvider(final java.lang.String value);
    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    java.lang.Object getConfiguration();
    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    void setConfiguration(final java.lang.Object value);
    /**
     * The source action owner (could be "AWS", "ThirdParty" or "Custom").
     * @default "AWS"
     */
    java.lang.String getOwner();
    /**
     * The source action owner (could be "AWS", "ThirdParty" or "Custom").
     * @default "AWS"
     */
    void setOwner(final java.lang.String value);
    /**
     * The source action verison.
     * @default "1"
     */
    java.lang.String getVersion();
    /**
     * The source action verison.
     * @default "1"
     */
    void setVersion(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link SourceActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link SourceActionProps}
     */
    final class Builder {
        private java.lang.String _artifactName;
        private java.lang.String _provider;
        @javax.annotation.Nullable
        private java.lang.Object _configuration;
        @javax.annotation.Nullable
        private java.lang.String _owner;
        @javax.annotation.Nullable
        private java.lang.String _version;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of ArtifactName
         * @param value The name of the source's output artifact.
Output artifacts are used by CodePipeline as inputs into other actions.
         * @return {@code this}
         */
        public Builder withArtifactName(final java.lang.String value) {
            this._artifactName = java.util.Objects.requireNonNull(value, "artifactName is required");
            return this;
        }
        /**
         * Sets the value of Provider
         * @param value The service provider that the action calls.
For example, a valid provider for Source actions is "S3".
         * @return {@code this}
         */
        public Builder withProvider(final java.lang.String value) {
            this._provider = java.util.Objects.requireNonNull(value, "provider is required");
            return this;
        }
        /**
         * Sets the value of Configuration
         * @param value The action's configuration. These are key-value pairs that specify input values for an action.
For more information, see the AWS CodePipeline User Guide.

http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         * @return {@code this}
         */
        public Builder withConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
            this._configuration = value;
            return this;
        }
        /**
         * Sets the value of Owner
         * @param value The source action owner (could be "AWS", "ThirdParty" or "Custom").
         * @return {@code this}
         */
        public Builder withOwner(@javax.annotation.Nullable final java.lang.String value) {
            this._owner = value;
            return this;
        }
        /**
         * Sets the value of Version
         * @param value The source action verison.
         * @return {@code this}
         */
        public Builder withVersion(@javax.annotation.Nullable final java.lang.String value) {
            this._version = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SourceActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public SourceActionProps build() {
            return new SourceActionProps() {
                private java.lang.String $artifactName = java.util.Objects.requireNonNull(_artifactName, "artifactName is required");
                private java.lang.String $provider = java.util.Objects.requireNonNull(_provider, "provider is required");
                @javax.annotation.Nullable
                private java.lang.Object $configuration = _configuration;
                @javax.annotation.Nullable
                private java.lang.String $owner = _owner;
                @javax.annotation.Nullable
                private java.lang.String $version = _version;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public java.lang.String getArtifactName() {
                    return this.$artifactName;
                }

                @Override
                public void setArtifactName(final java.lang.String value) {
                    this.$artifactName = java.util.Objects.requireNonNull(value, "artifactName is required");
                }

                @Override
                public java.lang.String getProvider() {
                    return this.$provider;
                }

                @Override
                public void setProvider(final java.lang.String value) {
                    this.$provider = java.util.Objects.requireNonNull(value, "provider is required");
                }

                @Override
                public java.lang.Object getConfiguration() {
                    return this.$configuration;
                }

                @Override
                public void setConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
                    this.$configuration = value;
                }

                @Override
                public java.lang.String getOwner() {
                    return this.$owner;
                }

                @Override
                public void setOwner(@javax.annotation.Nullable final java.lang.String value) {
                    this.$owner = value;
                }

                @Override
                public java.lang.String getVersion() {
                    return this.$version;
                }

                @Override
                public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                    this.$version = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.api.SourceActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the source's output artifact.
         * Output artifacts are used by CodePipeline as inputs into other actions.
         */
        @Override
        public java.lang.String getArtifactName() {
            return this.jsiiGet("artifactName", java.lang.String.class);
        }

        /**
         * The name of the source's output artifact.
         * Output artifacts are used by CodePipeline as inputs into other actions.
         */
        @Override
        public void setArtifactName(final java.lang.String value) {
            this.jsiiSet("artifactName", java.util.Objects.requireNonNull(value, "artifactName is required"));
        }

        /**
         * The service provider that the action calls.
         * For example, a valid provider for Source actions is "S3".
         */
        @Override
        public java.lang.String getProvider() {
            return this.jsiiGet("provider", java.lang.String.class);
        }

        /**
         * The service provider that the action calls.
         * For example, a valid provider for Source actions is "S3".
         */
        @Override
        public void setProvider(final java.lang.String value) {
            this.jsiiSet("provider", java.util.Objects.requireNonNull(value, "provider is required"));
        }

        /**
         * The action's configuration. These are key-value pairs that specify input values for an action.
         * For more information, see the AWS CodePipeline User Guide.
         * 
         * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getConfiguration() {
            return this.jsiiGet("configuration", java.lang.Object.class);
        }

        /**
         * The action's configuration. These are key-value pairs that specify input values for an action.
         * For more information, see the AWS CodePipeline User Guide.
         * 
         * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         */
        @Override
        public void setConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("configuration", value);
        }

        /**
         * The source action owner (could be "AWS", "ThirdParty" or "Custom").
         * @default "AWS"
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOwner() {
            return this.jsiiGet("owner", java.lang.String.class);
        }

        /**
         * The source action owner (could be "AWS", "ThirdParty" or "Custom").
         * @default "AWS"
         */
        @Override
        public void setOwner(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("owner", value);
        }

        /**
         * The source action verison.
         * @default "1"
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getVersion() {
            return this.jsiiGet("version", java.lang.String.class);
        }

        /**
         * The source action verison.
         * @default "1"
         */
        @Override
        public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("version", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
