package software.amazon.awscdk.services.codepipeline.api;

/**
 * An output artifact of an action. Artifacts can be used as input by some actions.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-12T09:54:54.477Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.api.$Module.class, fqn = "@aws-cdk/aws-codepipeline-api.Artifact")
public class Artifact extends software.amazon.awscdk.Construct {
    protected Artifact(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Artifact(final software.amazon.awscdk.services.codepipeline.api.Action parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }

    /**
     * Returns an ArtifactPath for a file within this artifact.
     * Output is in the form "<artifact-name>::<file-name>"
     * @param fileName The name of the file
     */
    public software.amazon.awscdk.services.codepipeline.api.ArtifactPath atPath(final java.lang.String fileName) {
        return this.jsiiCall("atPath", software.amazon.awscdk.services.codepipeline.api.ArtifactPath.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(fileName, "fileName is required")).toArray());
    }

    /**
     * Returns a token for a value inside a JSON file within this artifact.
     * @param jsonFile The JSON file name.
     * @param keyName The hash key.
     */
    public java.lang.String getParam(final java.lang.String jsonFile, final java.lang.String keyName) {
        return this.jsiiCall("getParam", java.lang.String.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(jsonFile, "jsonFile is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(keyName, "keyName is required"))).toArray());
    }

    /**
     * Returns a string representation of this construct.
     */
    @Override
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * The artifact attribute for the name of the S3 bucket where the artifact is stored.
     */
    public java.lang.String getBucketName() {
        return this.jsiiGet("bucketName", java.lang.String.class);
    }

    public java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * The artifact attribute for The name of the .zip file that contains the artifact that is
     * generated by AWS CodePipeline, such as 1ABCyZZ.zip.
     */
    public java.lang.String getObjectKey() {
        return this.jsiiGet("objectKey", java.lang.String.class);
    }

    /**
     * The artifact attribute of the Amazon Simple Storage Service (Amazon S3) URL of the artifact,
     * such as https://s3-us-west-2.amazonaws.com/artifactstorebucket-yivczw8jma0c/test/TemplateSo/1ABCyZZ.zip.
     */
    public java.lang.String getUrl() {
        return this.jsiiGet("url", java.lang.String.class);
    }
}
