package software.amazon.awscdk.services.codepipeline.api;

/**
 * The abstract view of an AWS CodePipeline as required and used by Actions.
 * It extends {@link events.IEventRuleTarget},
 * so this interface can be used as a Target for CloudWatch Events.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:19:56.998Z")
public interface IPipeline extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.IEventRuleTarget {
    /**
     * The ARN of the Pipeline.
     */
    java.lang.String getPipelineArn();
    /**
     * The name of the Pipeline.
     */
    java.lang.String getPipelineName();
    /**
     * The service Role of the Pipeline.
     */
    software.amazon.awscdk.services.iam.Role getRole();
    /**
     * The unique ID of the Pipeline Construct.
     */
    java.lang.String getUniqueId();
    /**
     * Grants read permissions to the Pipeline's S3 Bucket to the given Identity.
     * @param identity the IAM Identity to grant the permissions to
     */
    void grantBucketRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grants read permissions to the Pipeline's S3 Bucket to the given Identity.
     */
    void grantBucketRead();
    /**
     * Grants read & write permissions to the Pipeline's S3 Bucket to the given Identity.
     * @param identity the IAM Identity to grant the permissions to
     */
    void grantBucketReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity);
    /**
     * Grants read & write permissions to the Pipeline's S3 Bucket to the given Identity.
     */
    void grantBucketReadWrite();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.api.IPipeline {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the Pipeline.
         */
        @Override
        public java.lang.String getPipelineArn() {
            return this.jsiiGet("pipelineArn", java.lang.String.class);
        }

        /**
         * The name of the Pipeline.
         */
        @Override
        public java.lang.String getPipelineName() {
            return this.jsiiGet("pipelineName", java.lang.String.class);
        }

        /**
         * The service Role of the Pipeline.
         */
        @Override
        public software.amazon.awscdk.services.iam.Role getRole() {
            return this.jsiiGet("role", software.amazon.awscdk.services.iam.Role.class);
        }

        /**
         * The unique ID of the Pipeline Construct.
         */
        @Override
        public java.lang.String getUniqueId() {
            return this.jsiiGet("uniqueId", java.lang.String.class);
        }

        /**
         * Grants read permissions to the Pipeline's S3 Bucket to the given Identity.
         * @param identity the IAM Identity to grant the permissions to
         */
        @Override
        public void grantBucketRead(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantBucketRead", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants read permissions to the Pipeline's S3 Bucket to the given Identity.
         */
        @Override
        public void grantBucketRead() {
            this.jsiiCall("grantBucketRead", Void.class);
        }

        /**
         * Grants read & write permissions to the Pipeline's S3 Bucket to the given Identity.
         * @param identity the IAM Identity to grant the permissions to
         */
        @Override
        public void grantBucketReadWrite(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.IPrincipal identity) {
            this.jsiiCall("grantBucketReadWrite", Void.class, java.util.stream.Stream.of(identity).toArray());
        }

        /**
         * Grants read & write permissions to the Pipeline's S3 Bucket to the given Identity.
         */
        @Override
        public void grantBucketReadWrite() {
            this.jsiiCall("grantBucketReadWrite", Void.class);
        }

        /**
         * Returns the rule target specification.
         * NOTE: Do not use the various `inputXxx` options. They can be set in a call to `addTarget`.
         * @param ruleArn The ARN of the CloudWatch Event Rule that would trigger this target.
         * @param ruleUniqueId A unique ID for this rule. Can be used to implement idempotency.
         */
        @Override
        public software.amazon.awscdk.services.events.EventRuleTargetProps asEventRuleTarget(final java.lang.String ruleArn, final java.lang.String ruleUniqueId) {
            return this.jsiiCall("asEventRuleTarget", software.amazon.awscdk.services.events.EventRuleTargetProps.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(ruleArn, "ruleArn is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(ruleUniqueId, "ruleUniqueId is required"))).toArray());
        }
    }
}
