package software.amazon.awscdk.services.codepipeline.api;

/**
 * Construction properties of the low-level {@link TestAction test Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-13T10:25:20.486Z")
public interface TestActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.api.CommonActionProps, software.amazon.awscdk.services.codepipeline.api.CommonActionConstructProps {
    /**
     * The upper and lower bounds on the number of input and output artifacts for this Action.
     */
    software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds getArtifactBounds();
    /**
     * The upper and lower bounds on the number of input and output artifacts for this Action.
     */
    void setArtifactBounds(final software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds value);
    /**
     * The service provider that the action calls.
     * @example 'CodeBuild'
     */
    java.lang.String getProvider();
    /**
     * The service provider that the action calls.
     * @example 'CodeBuild'
     */
    void setProvider(final java.lang.String value);
    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    java.lang.Object getConfiguration();
    /**
     * The action's configuration. These are key-value pairs that specify input values for an action.
     * For more information, see the AWS CodePipeline User Guide.
     * 
     * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    void setConfiguration(final java.lang.Object value);
    /**
     * The source to use as input for this test.
     * @default CodePipeline will use the output of the last Action from a previous Stage as input
     */
    software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact();
    /**
     * The source to use as input for this test.
     * @default CodePipeline will use the output of the last Action from a previous Stage as input
     */
    void setInputArtifact(final software.amazon.awscdk.services.codepipeline.api.Artifact value);
    /**
     * The optional name of the output artifact.
     * If you provide a value here,
     * then the `outputArtifact` property of your Action will be non-null.
     * If you don't, `outputArtifact` will be `null`.
     * @default the Action will not have an output artifact
     */
    java.lang.String getOutputArtifactName();
    /**
     * The optional name of the output artifact.
     * If you provide a value here,
     * then the `outputArtifact` property of your Action will be non-null.
     * If you don't, `outputArtifact` will be `null`.
     * @default the Action will not have an output artifact
     */
    void setOutputArtifactName(final java.lang.String value);
    /**
     * The source action owner (could be 'AWS', 'ThirdParty' or 'Custom').
     * @default 'AWS'
     */
    java.lang.String getOwner();
    /**
     * The source action owner (could be 'AWS', 'ThirdParty' or 'Custom').
     * @default 'AWS'
     */
    void setOwner(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link TestActionProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TestActionProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds _artifactBounds;
        private java.lang.String _provider;
        @javax.annotation.Nullable
        private java.lang.Object _configuration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.codepipeline.api.Artifact _inputArtifact;
        @javax.annotation.Nullable
        private java.lang.String _outputArtifactName;
        @javax.annotation.Nullable
        private java.lang.String _owner;
        @javax.annotation.Nullable
        private java.lang.Number _runOrder;
        private software.amazon.awscdk.services.codepipeline.api.IStage _stage;

        /**
         * Sets the value of ArtifactBounds
         * @param value The upper and lower bounds on the number of input and output artifacts for this Action.
         * @return {@code this}
         */
        public Builder withArtifactBounds(final software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds value) {
            this._artifactBounds = java.util.Objects.requireNonNull(value, "artifactBounds is required");
            return this;
        }
        /**
         * Sets the value of Provider
         * @param value The service provider that the action calls.
         * @return {@code this}
         */
        public Builder withProvider(final java.lang.String value) {
            this._provider = java.util.Objects.requireNonNull(value, "provider is required");
            return this;
        }
        /**
         * Sets the value of Configuration
         * @param value The action's configuration. These are key-value pairs that specify input values for an action.
For more information, see the AWS CodePipeline User Guide.

http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         * @return {@code this}
         */
        public Builder withConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
            this._configuration = value;
            return this;
        }
        /**
         * Sets the value of InputArtifact
         * @param value The source to use as input for this test.
         * @return {@code this}
         */
        public Builder withInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this._inputArtifact = value;
            return this;
        }
        /**
         * Sets the value of OutputArtifactName
         * @param value The optional name of the output artifact.
If you provide a value here,
then the `outputArtifact` property of your Action will be non-null.
If you don't, `outputArtifact` will be `null`.
         * @return {@code this}
         */
        public Builder withOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this._outputArtifactName = value;
            return this;
        }
        /**
         * Sets the value of Owner
         * @param value The source action owner (could be 'AWS', 'ThirdParty' or 'Custom').
         * @return {@code this}
         */
        public Builder withOwner(@javax.annotation.Nullable final java.lang.String value) {
            this._owner = value;
            return this;
        }
        /**
         * Sets the value of RunOrder
         * @param value The runOrder property for this Action.
RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        public Builder withRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this._runOrder = value;
            return this;
        }
        /**
         * Sets the value of Stage
         * @param value The Pipeline Stage to add this Action to.
         * @return {@code this}
         */
        public Builder withStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this._stage = java.util.Objects.requireNonNull(value, "stage is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TestActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public TestActionProps build() {
            return new TestActionProps() {
                private software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds $artifactBounds = java.util.Objects.requireNonNull(_artifactBounds, "artifactBounds is required");
                private java.lang.String $provider = java.util.Objects.requireNonNull(_provider, "provider is required");
                @javax.annotation.Nullable
                private java.lang.Object $configuration = _configuration;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.codepipeline.api.Artifact $inputArtifact = _inputArtifact;
                @javax.annotation.Nullable
                private java.lang.String $outputArtifactName = _outputArtifactName;
                @javax.annotation.Nullable
                private java.lang.String $owner = _owner;
                @javax.annotation.Nullable
                private java.lang.Number $runOrder = _runOrder;
                private software.amazon.awscdk.services.codepipeline.api.IStage $stage = java.util.Objects.requireNonNull(_stage, "stage is required");

                @Override
                public software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds getArtifactBounds() {
                    return this.$artifactBounds;
                }

                @Override
                public void setArtifactBounds(final software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds value) {
                    this.$artifactBounds = java.util.Objects.requireNonNull(value, "artifactBounds is required");
                }

                @Override
                public java.lang.String getProvider() {
                    return this.$provider;
                }

                @Override
                public void setProvider(final java.lang.String value) {
                    this.$provider = java.util.Objects.requireNonNull(value, "provider is required");
                }

                @Override
                public java.lang.Object getConfiguration() {
                    return this.$configuration;
                }

                @Override
                public void setConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
                    this.$configuration = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
                    return this.$inputArtifact;
                }

                @Override
                public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
                    this.$inputArtifact = value;
                }

                @Override
                public java.lang.String getOutputArtifactName() {
                    return this.$outputArtifactName;
                }

                @Override
                public void setOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$outputArtifactName = value;
                }

                @Override
                public java.lang.String getOwner() {
                    return this.$owner;
                }

                @Override
                public void setOwner(@javax.annotation.Nullable final java.lang.String value) {
                    this.$owner = value;
                }

                @Override
                public java.lang.Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$runOrder = value;
                }

                @Override
                public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
                    return this.$stage;
                }

                @Override
                public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
                    this.$stage = java.util.Objects.requireNonNull(value, "stage is required");
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.api.TestActionProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The upper and lower bounds on the number of input and output artifacts for this Action.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds getArtifactBounds() {
            return this.jsiiGet("artifactBounds", software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds.class);
        }

        /**
         * The upper and lower bounds on the number of input and output artifacts for this Action.
         */
        @Override
        public void setArtifactBounds(final software.amazon.awscdk.services.codepipeline.api.ActionArtifactBounds value) {
            this.jsiiSet("artifactBounds", java.util.Objects.requireNonNull(value, "artifactBounds is required"));
        }

        /**
         * The service provider that the action calls.
         * @example 'CodeBuild'
         */
        @Override
        public java.lang.String getProvider() {
            return this.jsiiGet("provider", java.lang.String.class);
        }

        /**
         * The service provider that the action calls.
         * @example 'CodeBuild'
         */
        @Override
        public void setProvider(final java.lang.String value) {
            this.jsiiSet("provider", java.util.Objects.requireNonNull(value, "provider is required"));
        }

        /**
         * The action's configuration. These are key-value pairs that specify input values for an action.
         * For more information, see the AWS CodePipeline User Guide.
         * 
         * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getConfiguration() {
            return this.jsiiGet("configuration", java.lang.Object.class);
        }

        /**
         * The action's configuration. These are key-value pairs that specify input values for an action.
         * For more information, see the AWS CodePipeline User Guide.
         * 
         * http://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         */
        @Override
        public void setConfiguration(@javax.annotation.Nullable final java.lang.Object value) {
            this.jsiiSet("configuration", value);
        }

        /**
         * The source to use as input for this test.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.codepipeline.api.Artifact getInputArtifact() {
            return this.jsiiGet("inputArtifact", software.amazon.awscdk.services.codepipeline.api.Artifact.class);
        }

        /**
         * The source to use as input for this test.
         * @default CodePipeline will use the output of the last Action from a previous Stage as input
         */
        @Override
        public void setInputArtifact(@javax.annotation.Nullable final software.amazon.awscdk.services.codepipeline.api.Artifact value) {
            this.jsiiSet("inputArtifact", value);
        }

        /**
         * The optional name of the output artifact.
         * If you provide a value here,
         * then the `outputArtifact` property of your Action will be non-null.
         * If you don't, `outputArtifact` will be `null`.
         * @default the Action will not have an output artifact
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOutputArtifactName() {
            return this.jsiiGet("outputArtifactName", java.lang.String.class);
        }

        /**
         * The optional name of the output artifact.
         * If you provide a value here,
         * then the `outputArtifact` property of your Action will be non-null.
         * If you don't, `outputArtifact` will be `null`.
         * @default the Action will not have an output artifact
         */
        @Override
        public void setOutputArtifactName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("outputArtifactName", value);
        }

        /**
         * The source action owner (could be 'AWS', 'ThirdParty' or 'Custom').
         * @default 'AWS'
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getOwner() {
            return this.jsiiGet("owner", java.lang.String.class);
        }

        /**
         * The source action owner (could be 'AWS', 'ThirdParty' or 'Custom').
         * @default 'AWS'
         */
        @Override
        public void setOwner(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("owner", value);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getRunOrder() {
            return this.jsiiGet("runOrder", java.lang.Number.class);
        }

        /**
         * The runOrder property for this Action.
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @default 1
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         */
        @Override
        public void setRunOrder(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("runOrder", value);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public software.amazon.awscdk.services.codepipeline.api.IStage getStage() {
            return this.jsiiGet("stage", software.amazon.awscdk.services.codepipeline.api.IStage.class);
        }

        /**
         * The Pipeline Stage to add this Action to.
         */
        @Override
        public void setStage(final software.amazon.awscdk.services.codepipeline.api.IStage value) {
            this.jsiiSet("stage", java.util.Objects.requireNonNull(value, "stage is required"));
        }
    }
}
