/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResource;
import software.amazon.awscdk.services.codepipeline.ActionArtifactBounds;
import software.amazon.awscdk.services.codepipeline.ActionCategory;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ActionProperties
extends JsiiSerializable {
    public String getActionName();

    public ActionArtifactBounds getArtifactBounds();

    public ActionCategory getCategory();

    public String getProvider();

    public List<Artifact> getInputs();

    public List<Artifact> getOutputs();

    public String getOwner();

    public String getRegion();

    public IResource getResource();

    public IRole getRole();

    public Number getRunOrder();

    public String getVersion();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _actionName;
        private ActionArtifactBounds _artifactBounds;
        private ActionCategory _category;
        private String _provider;
        @Nullable
        private List<Artifact> _inputs;
        @Nullable
        private List<Artifact> _outputs;
        @Nullable
        private String _owner;
        @Nullable
        private String _region;
        @Nullable
        private IResource _resource;
        @Nullable
        private IRole _role;
        @Nullable
        private Number _runOrder;
        @Nullable
        private String _version;

        public Builder withActionName(String value) {
            this._actionName = Objects.requireNonNull(value, "actionName is required");
            return this;
        }

        public Builder withArtifactBounds(ActionArtifactBounds value) {
            this._artifactBounds = Objects.requireNonNull(value, "artifactBounds is required");
            return this;
        }

        public Builder withCategory(ActionCategory value) {
            this._category = Objects.requireNonNull(value, "category is required");
            return this;
        }

        public Builder withProvider(String value) {
            this._provider = Objects.requireNonNull(value, "provider is required");
            return this;
        }

        public Builder withInputs(@Nullable List<Artifact> value) {
            this._inputs = value;
            return this;
        }

        public Builder withOutputs(@Nullable List<Artifact> value) {
            this._outputs = value;
            return this;
        }

        public Builder withOwner(@Nullable String value) {
            this._owner = value;
            return this;
        }

        public Builder withRegion(@Nullable String value) {
            this._region = value;
            return this;
        }

        public Builder withResource(@Nullable IResource value) {
            this._resource = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withRunOrder(@Nullable Number value) {
            this._runOrder = value;
            return this;
        }

        public Builder withVersion(@Nullable String value) {
            this._version = value;
            return this;
        }

        public ActionProperties build() {
            return new ActionProperties(){
                private final String $actionName;
                private final ActionArtifactBounds $artifactBounds;
                private final ActionCategory $category;
                private final String $provider;
                @Nullable
                private final List<Artifact> $inputs;
                @Nullable
                private final List<Artifact> $outputs;
                @Nullable
                private final String $owner;
                @Nullable
                private final String $region;
                @Nullable
                private final IResource $resource;
                @Nullable
                private final IRole $role;
                @Nullable
                private final Number $runOrder;
                @Nullable
                private final String $version;
                {
                    this.$actionName = Objects.requireNonNull(_actionName, "actionName is required");
                    this.$artifactBounds = Objects.requireNonNull(_artifactBounds, "artifactBounds is required");
                    this.$category = Objects.requireNonNull(_category, "category is required");
                    this.$provider = Objects.requireNonNull(_provider, "provider is required");
                    this.$inputs = _inputs;
                    this.$outputs = _outputs;
                    this.$owner = _owner;
                    this.$region = _region;
                    this.$resource = _resource;
                    this.$role = _role;
                    this.$runOrder = _runOrder;
                    this.$version = _version;
                }

                @Override
                public String getActionName() {
                    return this.$actionName;
                }

                @Override
                public ActionArtifactBounds getArtifactBounds() {
                    return this.$artifactBounds;
                }

                @Override
                public ActionCategory getCategory() {
                    return this.$category;
                }

                @Override
                public String getProvider() {
                    return this.$provider;
                }

                @Override
                public List<Artifact> getInputs() {
                    return this.$inputs;
                }

                @Override
                public List<Artifact> getOutputs() {
                    return this.$outputs;
                }

                @Override
                public String getOwner() {
                    return this.$owner;
                }

                @Override
                public String getRegion() {
                    return this.$region;
                }

                @Override
                public IResource getResource() {
                    return this.$resource;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public Number getRunOrder() {
                    return this.$runOrder;
                }

                @Override
                public String getVersion() {
                    return this.$version;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("actionName", om.valueToTree((Object)this.getActionName()));
                    obj.set("artifactBounds", om.valueToTree((Object)this.getArtifactBounds()));
                    obj.set("category", om.valueToTree((Object)this.getCategory()));
                    obj.set("provider", om.valueToTree((Object)this.getProvider()));
                    if (this.getInputs() != null) {
                        obj.set("inputs", om.valueToTree(this.getInputs()));
                    }
                    if (this.getOutputs() != null) {
                        obj.set("outputs", om.valueToTree(this.getOutputs()));
                    }
                    if (this.getOwner() != null) {
                        obj.set("owner", om.valueToTree((Object)this.getOwner()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree((Object)this.getRegion()));
                    }
                    if (this.getResource() != null) {
                        obj.set("resource", om.valueToTree((Object)this.getResource()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    if (this.getRunOrder() != null) {
                        obj.set("runOrder", om.valueToTree((Object)this.getRunOrder()));
                    }
                    if (this.getVersion() != null) {
                        obj.set("version", om.valueToTree((Object)this.getVersion()));
                    }
                    return obj;
                }
            };
        }
    }
}

