/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.codepipeline.CfnCustomActionType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnCustomActionTypeProps
extends JsiiSerializable {
    public String getCategory();

    public Object getInputArtifactDetails();

    public Object getOutputArtifactDetails();

    public String getProvider();

    public String getVersion();

    public Object getConfigurationProperties();

    public Object getSettings();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _category;
        private Object _inputArtifactDetails;
        private Object _outputArtifactDetails;
        private String _provider;
        private String _version;
        @Nullable
        private Object _configurationProperties;
        @Nullable
        private Object _settings;

        public Builder withCategory(String value) {
            this._category = Objects.requireNonNull(value, "category is required");
            return this;
        }

        public Builder withInputArtifactDetails(CfnCustomActionType.ArtifactDetailsProperty value) {
            this._inputArtifactDetails = Objects.requireNonNull(value, "inputArtifactDetails is required");
            return this;
        }

        public Builder withInputArtifactDetails(IResolvable value) {
            this._inputArtifactDetails = Objects.requireNonNull(value, "inputArtifactDetails is required");
            return this;
        }

        public Builder withOutputArtifactDetails(CfnCustomActionType.ArtifactDetailsProperty value) {
            this._outputArtifactDetails = Objects.requireNonNull(value, "outputArtifactDetails is required");
            return this;
        }

        public Builder withOutputArtifactDetails(IResolvable value) {
            this._outputArtifactDetails = Objects.requireNonNull(value, "outputArtifactDetails is required");
            return this;
        }

        public Builder withProvider(String value) {
            this._provider = Objects.requireNonNull(value, "provider is required");
            return this;
        }

        public Builder withVersion(String value) {
            this._version = Objects.requireNonNull(value, "version is required");
            return this;
        }

        public Builder withConfigurationProperties(@Nullable IResolvable value) {
            this._configurationProperties = value;
            return this;
        }

        public Builder withConfigurationProperties(@Nullable List<Object> value) {
            this._configurationProperties = value;
            return this;
        }

        public Builder withSettings(@Nullable IResolvable value) {
            this._settings = value;
            return this;
        }

        public Builder withSettings(@Nullable CfnCustomActionType.SettingsProperty value) {
            this._settings = value;
            return this;
        }

        public CfnCustomActionTypeProps build() {
            return new CfnCustomActionTypeProps(){
                private final String $category;
                private final Object $inputArtifactDetails;
                private final Object $outputArtifactDetails;
                private final String $provider;
                private final String $version;
                @Nullable
                private final Object $configurationProperties;
                @Nullable
                private final Object $settings;
                {
                    this.$category = Objects.requireNonNull(_category, "category is required");
                    this.$inputArtifactDetails = Objects.requireNonNull(_inputArtifactDetails, "inputArtifactDetails is required");
                    this.$outputArtifactDetails = Objects.requireNonNull(_outputArtifactDetails, "outputArtifactDetails is required");
                    this.$provider = Objects.requireNonNull(_provider, "provider is required");
                    this.$version = Objects.requireNonNull(_version, "version is required");
                    this.$configurationProperties = _configurationProperties;
                    this.$settings = _settings;
                }

                @Override
                public String getCategory() {
                    return this.$category;
                }

                @Override
                public Object getInputArtifactDetails() {
                    return this.$inputArtifactDetails;
                }

                @Override
                public Object getOutputArtifactDetails() {
                    return this.$outputArtifactDetails;
                }

                @Override
                public String getProvider() {
                    return this.$provider;
                }

                @Override
                public String getVersion() {
                    return this.$version;
                }

                @Override
                public Object getConfigurationProperties() {
                    return this.$configurationProperties;
                }

                @Override
                public Object getSettings() {
                    return this.$settings;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("category", om.valueToTree((Object)this.getCategory()));
                    obj.set("inputArtifactDetails", om.valueToTree(this.getInputArtifactDetails()));
                    obj.set("outputArtifactDetails", om.valueToTree(this.getOutputArtifactDetails()));
                    obj.set("provider", om.valueToTree((Object)this.getProvider()));
                    obj.set("version", om.valueToTree((Object)this.getVersion()));
                    if (this.getConfigurationProperties() != null) {
                        obj.set("configurationProperties", om.valueToTree(this.getConfigurationProperties()));
                    }
                    if (this.getSettings() != null) {
                        obj.set("settings", om.valueToTree(this.getSettings()));
                    }
                    return obj;
                }
            };
        }
    }
}

