/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.codepipeline.CfnPipeline;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnPipelineProps
extends JsiiSerializable {
    public String getRoleArn();

    public Object getStages();

    public Object getArtifactStore();

    public Object getArtifactStores();

    public Object getDisableInboundStageTransitions();

    public String getName();

    public Object getRestartExecutionOnUpdate();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _roleArn;
        private Object _stages;
        @Nullable
        private Object _artifactStore;
        @Nullable
        private Object _artifactStores;
        @Nullable
        private Object _disableInboundStageTransitions;
        @Nullable
        private String _name;
        @Nullable
        private Object _restartExecutionOnUpdate;

        public Builder withRoleArn(String value) {
            this._roleArn = Objects.requireNonNull(value, "roleArn is required");
            return this;
        }

        public Builder withStages(IResolvable value) {
            this._stages = Objects.requireNonNull(value, "stages is required");
            return this;
        }

        public Builder withStages(List<Object> value) {
            this._stages = Objects.requireNonNull(value, "stages is required");
            return this;
        }

        public Builder withArtifactStore(@Nullable IResolvable value) {
            this._artifactStore = value;
            return this;
        }

        public Builder withArtifactStore(@Nullable CfnPipeline.ArtifactStoreProperty value) {
            this._artifactStore = value;
            return this;
        }

        public Builder withArtifactStores(@Nullable IResolvable value) {
            this._artifactStores = value;
            return this;
        }

        public Builder withArtifactStores(@Nullable List<Object> value) {
            this._artifactStores = value;
            return this;
        }

        public Builder withDisableInboundStageTransitions(@Nullable IResolvable value) {
            this._disableInboundStageTransitions = value;
            return this;
        }

        public Builder withDisableInboundStageTransitions(@Nullable List<Object> value) {
            this._disableInboundStageTransitions = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withRestartExecutionOnUpdate(@Nullable Boolean value) {
            this._restartExecutionOnUpdate = value;
            return this;
        }

        public Builder withRestartExecutionOnUpdate(@Nullable IResolvable value) {
            this._restartExecutionOnUpdate = value;
            return this;
        }

        public CfnPipelineProps build() {
            return new CfnPipelineProps(){
                private final String $roleArn;
                private final Object $stages;
                @Nullable
                private final Object $artifactStore;
                @Nullable
                private final Object $artifactStores;
                @Nullable
                private final Object $disableInboundStageTransitions;
                @Nullable
                private final String $name;
                @Nullable
                private final Object $restartExecutionOnUpdate;
                {
                    this.$roleArn = Objects.requireNonNull(_roleArn, "roleArn is required");
                    this.$stages = Objects.requireNonNull(_stages, "stages is required");
                    this.$artifactStore = _artifactStore;
                    this.$artifactStores = _artifactStores;
                    this.$disableInboundStageTransitions = _disableInboundStageTransitions;
                    this.$name = _name;
                    this.$restartExecutionOnUpdate = _restartExecutionOnUpdate;
                }

                @Override
                public String getRoleArn() {
                    return this.$roleArn;
                }

                @Override
                public Object getStages() {
                    return this.$stages;
                }

                @Override
                public Object getArtifactStore() {
                    return this.$artifactStore;
                }

                @Override
                public Object getArtifactStores() {
                    return this.$artifactStores;
                }

                @Override
                public Object getDisableInboundStageTransitions() {
                    return this.$disableInboundStageTransitions;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getRestartExecutionOnUpdate() {
                    return this.$restartExecutionOnUpdate;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("roleArn", om.valueToTree((Object)this.getRoleArn()));
                    obj.set("stages", om.valueToTree(this.getStages()));
                    if (this.getArtifactStore() != null) {
                        obj.set("artifactStore", om.valueToTree(this.getArtifactStore()));
                    }
                    if (this.getArtifactStores() != null) {
                        obj.set("artifactStores", om.valueToTree(this.getArtifactStores()));
                    }
                    if (this.getDisableInboundStageTransitions() != null) {
                        obj.set("disableInboundStageTransitions", om.valueToTree(this.getDisableInboundStageTransitions()));
                    }
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getRestartExecutionOnUpdate() != null) {
                        obj.set("restartExecutionOnUpdate", om.valueToTree(this.getRestartExecutionOnUpdate()));
                    }
                    return obj;
                }
            };
        }
    }
}

