/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.codepipeline.CfnWebhook;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnWebhookProps
extends JsiiSerializable {
    public String getAuthentication();

    public Object getAuthenticationConfiguration();

    public Object getFilters();

    public String getTargetAction();

    public String getTargetPipeline();

    public Number getTargetPipelineVersion();

    public String getName();

    public Object getRegisterWithThirdParty();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _authentication;
        private Object _authenticationConfiguration;
        private Object _filters;
        private String _targetAction;
        private String _targetPipeline;
        private Number _targetPipelineVersion;
        @Nullable
        private String _name;
        @Nullable
        private Object _registerWithThirdParty;

        public Builder withAuthentication(String value) {
            this._authentication = Objects.requireNonNull(value, "authentication is required");
            return this;
        }

        public Builder withAuthenticationConfiguration(IResolvable value) {
            this._authenticationConfiguration = Objects.requireNonNull(value, "authenticationConfiguration is required");
            return this;
        }

        public Builder withAuthenticationConfiguration(CfnWebhook.WebhookAuthConfigurationProperty value) {
            this._authenticationConfiguration = Objects.requireNonNull(value, "authenticationConfiguration is required");
            return this;
        }

        public Builder withFilters(IResolvable value) {
            this._filters = Objects.requireNonNull(value, "filters is required");
            return this;
        }

        public Builder withFilters(List<Object> value) {
            this._filters = Objects.requireNonNull(value, "filters is required");
            return this;
        }

        public Builder withTargetAction(String value) {
            this._targetAction = Objects.requireNonNull(value, "targetAction is required");
            return this;
        }

        public Builder withTargetPipeline(String value) {
            this._targetPipeline = Objects.requireNonNull(value, "targetPipeline is required");
            return this;
        }

        public Builder withTargetPipelineVersion(Number value) {
            this._targetPipelineVersion = Objects.requireNonNull(value, "targetPipelineVersion is required");
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withRegisterWithThirdParty(@Nullable Boolean value) {
            this._registerWithThirdParty = value;
            return this;
        }

        public Builder withRegisterWithThirdParty(@Nullable IResolvable value) {
            this._registerWithThirdParty = value;
            return this;
        }

        public CfnWebhookProps build() {
            return new CfnWebhookProps(){
                private final String $authentication;
                private final Object $authenticationConfiguration;
                private final Object $filters;
                private final String $targetAction;
                private final String $targetPipeline;
                private final Number $targetPipelineVersion;
                @Nullable
                private final String $name;
                @Nullable
                private final Object $registerWithThirdParty;
                {
                    this.$authentication = Objects.requireNonNull(_authentication, "authentication is required");
                    this.$authenticationConfiguration = Objects.requireNonNull(_authenticationConfiguration, "authenticationConfiguration is required");
                    this.$filters = Objects.requireNonNull(_filters, "filters is required");
                    this.$targetAction = Objects.requireNonNull(_targetAction, "targetAction is required");
                    this.$targetPipeline = Objects.requireNonNull(_targetPipeline, "targetPipeline is required");
                    this.$targetPipelineVersion = Objects.requireNonNull(_targetPipelineVersion, "targetPipelineVersion is required");
                    this.$name = _name;
                    this.$registerWithThirdParty = _registerWithThirdParty;
                }

                @Override
                public String getAuthentication() {
                    return this.$authentication;
                }

                @Override
                public Object getAuthenticationConfiguration() {
                    return this.$authenticationConfiguration;
                }

                @Override
                public Object getFilters() {
                    return this.$filters;
                }

                @Override
                public String getTargetAction() {
                    return this.$targetAction;
                }

                @Override
                public String getTargetPipeline() {
                    return this.$targetPipeline;
                }

                @Override
                public Number getTargetPipelineVersion() {
                    return this.$targetPipelineVersion;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getRegisterWithThirdParty() {
                    return this.$registerWithThirdParty;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("authentication", om.valueToTree((Object)this.getAuthentication()));
                    obj.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                    obj.set("filters", om.valueToTree(this.getFilters()));
                    obj.set("targetAction", om.valueToTree((Object)this.getTargetAction()));
                    obj.set("targetPipeline", om.valueToTree((Object)this.getTargetPipeline()));
                    obj.set("targetPipelineVersion", om.valueToTree((Object)this.getTargetPipelineVersion()));
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getRegisterWithThirdParty() != null) {
                        obj.set("registerWithThirdParty", om.valueToTree(this.getRegisterWithThirdParty()));
                    }
                    return obj;
                }
            };
        }
    }
}

