/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import software.amazon.awscdk.core.Stack;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CrossRegionSupport
extends JsiiSerializable {
    public IBucket getReplicationBucket();

    public Stack getStack();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IBucket _replicationBucket;
        private Stack _stack;

        public Builder withReplicationBucket(IBucket value) {
            this._replicationBucket = Objects.requireNonNull(value, "replicationBucket is required");
            return this;
        }

        public Builder withStack(Stack value) {
            this._stack = Objects.requireNonNull(value, "stack is required");
            return this;
        }

        public CrossRegionSupport build() {
            return new CrossRegionSupport(){
                private final IBucket $replicationBucket;
                private final Stack $stack;
                {
                    this.$replicationBucket = Objects.requireNonNull(_replicationBucket, "replicationBucket is required");
                    this.$stack = Objects.requireNonNull(_stack, "stack is required");
                }

                @Override
                public IBucket getReplicationBucket() {
                    return this.$replicationBucket;
                }

                @Override
                public Stack getStack() {
                    return this.$stack;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("replicationBucket", om.valueToTree((Object)this.getReplicationBucket()));
                    obj.set("stack", om.valueToTree((Object)this.getStack()));
                    return obj;
                }
            };
        }
    }
}

