/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codepipeline.StageProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PipelineProps
extends JsiiSerializable {
    public IBucket getArtifactBucket();

    public Map<String, IBucket> getCrossRegionReplicationBuckets();

    public String getPipelineName();

    public Boolean getRestartExecutionOnUpdate();

    public IRole getRole();

    public List<StageProps> getStages();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private IBucket _artifactBucket;
        @Nullable
        private Map<String, IBucket> _crossRegionReplicationBuckets;
        @Nullable
        private String _pipelineName;
        @Nullable
        private Boolean _restartExecutionOnUpdate;
        @Nullable
        private IRole _role;
        @Nullable
        private List<StageProps> _stages;

        public Builder withArtifactBucket(@Nullable IBucket value) {
            this._artifactBucket = value;
            return this;
        }

        public Builder withCrossRegionReplicationBuckets(@Nullable Map<String, IBucket> value) {
            this._crossRegionReplicationBuckets = value;
            return this;
        }

        public Builder withPipelineName(@Nullable String value) {
            this._pipelineName = value;
            return this;
        }

        public Builder withRestartExecutionOnUpdate(@Nullable Boolean value) {
            this._restartExecutionOnUpdate = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withStages(@Nullable List<StageProps> value) {
            this._stages = value;
            return this;
        }

        public PipelineProps build() {
            return new PipelineProps(){
                @Nullable
                private final IBucket $artifactBucket;
                @Nullable
                private final Map<String, IBucket> $crossRegionReplicationBuckets;
                @Nullable
                private final String $pipelineName;
                @Nullable
                private final Boolean $restartExecutionOnUpdate;
                @Nullable
                private final IRole $role;
                @Nullable
                private final List<StageProps> $stages;
                {
                    this.$artifactBucket = _artifactBucket;
                    this.$crossRegionReplicationBuckets = _crossRegionReplicationBuckets;
                    this.$pipelineName = _pipelineName;
                    this.$restartExecutionOnUpdate = _restartExecutionOnUpdate;
                    this.$role = _role;
                    this.$stages = _stages;
                }

                @Override
                public IBucket getArtifactBucket() {
                    return this.$artifactBucket;
                }

                @Override
                public Map<String, IBucket> getCrossRegionReplicationBuckets() {
                    return this.$crossRegionReplicationBuckets;
                }

                @Override
                public String getPipelineName() {
                    return this.$pipelineName;
                }

                @Override
                public Boolean getRestartExecutionOnUpdate() {
                    return this.$restartExecutionOnUpdate;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public List<StageProps> getStages() {
                    return this.$stages;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getArtifactBucket() != null) {
                        obj.set("artifactBucket", om.valueToTree((Object)this.getArtifactBucket()));
                    }
                    if (this.getCrossRegionReplicationBuckets() != null) {
                        obj.set("crossRegionReplicationBuckets", om.valueToTree(this.getCrossRegionReplicationBuckets()));
                    }
                    if (this.getPipelineName() != null) {
                        obj.set("pipelineName", om.valueToTree((Object)this.getPipelineName()));
                    }
                    if (this.getRestartExecutionOnUpdate() != null) {
                        obj.set("restartExecutionOnUpdate", om.valueToTree((Object)this.getRestartExecutionOnUpdate()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    if (this.getStages() != null) {
                        obj.set("stages", om.valueToTree(this.getStages()));
                    }
                    return obj;
                }
            };
        }
    }
}

