/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.codepipeline.IAction;
import software.amazon.awscdk.services.codepipeline.StagePlacement;
import software.amazon.awscdk.services.codepipeline.StageProps;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface StageOptions
extends JsiiSerializable,
StageProps {
    public StagePlacement getPlacement();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private StagePlacement _placement;
        private String _stageName;
        @Nullable
        private List<IAction> _actions;

        public Builder withPlacement(@Nullable StagePlacement value) {
            this._placement = value;
            return this;
        }

        public Builder withStageName(String value) {
            this._stageName = Objects.requireNonNull(value, "stageName is required");
            return this;
        }

        public Builder withActions(@Nullable List<IAction> value) {
            this._actions = value;
            return this;
        }

        public StageOptions build() {
            return new StageOptions(){
                @Nullable
                private final StagePlacement $placement;
                private final String $stageName;
                @Nullable
                private final List<IAction> $actions;
                {
                    this.$placement = _placement;
                    this.$stageName = Objects.requireNonNull(_stageName, "stageName is required");
                    this.$actions = _actions;
                }

                @Override
                public StagePlacement getPlacement() {
                    return this.$placement;
                }

                @Override
                public String getStageName() {
                    return this.$stageName;
                }

                @Override
                public List<IAction> getActions() {
                    return this.$actions;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    if (this.getPlacement() != null) {
                        obj.set("placement", om.valueToTree((Object)this.getPlacement()));
                    }
                    obj.set("stageName", om.valueToTree((Object)this.getStageName()));
                    if (this.getActions() != null) {
                        obj.set("actions", om.valueToTree(this.getActions()));
                    }
                    return obj;
                }
            };
        }
    }
}

