package software.amazon.awscdk.services.codepipeline;

/**
 * The list of event types for AWS Codepipeline Pipeline.
 * <p>
 * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-07-12T14:11:15.721Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.PipelineNotificationEvents")
public enum PipelineNotificationEvents {
    /**
     * Trigger notification when pipeline execution failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIPELINE_EXECUTION_FAILED,
    /**
     * Trigger notification when pipeline execution canceled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIPELINE_EXECUTION_CANCELED,
    /**
     * Trigger notification when pipeline execution started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIPELINE_EXECUTION_STARTED,
    /**
     * Trigger notification when pipeline execution resumed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIPELINE_EXECUTION_RESUMED,
    /**
     * Trigger notification when pipeline execution succeeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIPELINE_EXECUTION_SUCCEEDED,
    /**
     * Trigger notification when pipeline execution superseded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PIPELINE_EXECUTION_SUPERSEDED,
    /**
     * Trigger notification when pipeline stage execution started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STAGE_EXECUTION_STARTED,
    /**
     * Trigger notification when pipeline stage execution succeeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STAGE_EXECUTION_SUCCEEDED,
    /**
     * Trigger notification when pipeline stage execution resumed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STAGE_EXECUTION_RESUMED,
    /**
     * Trigger notification when pipeline stage execution canceled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STAGE_EXECUTION_CANCELED,
    /**
     * Trigger notification when pipeline stage execution failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STAGE_EXECUTION_FAILED,
    /**
     * Trigger notification when pipeline action execution succeeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTION_EXECUTION_SUCCEEDED,
    /**
     * Trigger notification when pipeline action execution failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTION_EXECUTION_FAILED,
    /**
     * Trigger notification when pipeline action execution canceled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTION_EXECUTION_CANCELED,
    /**
     * Trigger notification when pipeline action execution started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTION_EXECUTION_STARTED,
    /**
     * Trigger notification when pipeline manual approval failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANUAL_APPROVAL_FAILED,
    /**
     * Trigger notification when pipeline manual approval needed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANUAL_APPROVAL_NEEDED,
    /**
     * Trigger notification when pipeline manual approval succeeded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MANUAL_APPROVAL_SUCCEEDED,
}
