package software.amazon.awscdk.services.codepipeline;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * PipelineProject project;
 * Repository repository = Repository.Builder.create(this, "MyRepository")
 *         .repositoryName("MyRepository")
 *         .build();
 * PipelineProject project = new PipelineProject(this, "MyProject");
 * Artifact sourceOutput = new Artifact();
 * CodeCommitSourceAction sourceAction = CodeCommitSourceAction.Builder.create()
 *         .actionName("CodeCommit")
 *         .repository(repository)
 *         .output(sourceOutput)
 *         .build();
 * CodeBuildAction buildAction = CodeBuildAction.Builder.create()
 *         .actionName("CodeBuild")
 *         .project(project)
 *         .input(sourceOutput)
 *         .outputs(List.of(new Artifact())) // optional
 *         .executeBatchBuild(true) // optional, defaults to false
 *         .combineBatchBuildArtifacts(true)
 *         .build();
 * Pipeline.Builder.create(this, "MyPipeline")
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-04T20:14:08.853Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.PipelineProps")
@software.amazon.jsii.Jsii.Proxy(PipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket used by this Pipeline to store artifacts.
     * <p>
     * Default: - A new S3 bucket will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
        return null;
    }

    /**
     * Create KMS keys for cross-account deployments.
     * <p>
     * This controls whether the pipeline is enabled for cross-account deployments.
     * <p>
     * By default cross-account deployments are enabled, but this feature requires
     * that KMS Customer Master Keys are created which have a cost of $1/month.
     * <p>
     * If you do not need cross-account deployments, you can set this to <code>false</code> to
     * not create those keys and save on that cost (the artifact bucket will be
     * encrypted with an AWS-managed key). However, cross-account deployments will
     * no longer be possible.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCrossAccountKeys() {
        return null;
    }

    /**
     * A map of region to S3 bucket name used for cross-region CodePipeline.
     * <p>
     * For every Action that you specify targeting a different region than the Pipeline itself,
     * if you don't provide an explicit Bucket for that region using this property,
     * the construct will automatically create a Stack containing an S3 Bucket in that region.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
        return null;
    }

    /**
     * Enable KMS key rotation for the generated KMS keys.
     * <p>
     * By default KMS key rotation is disabled, but will add an additional $1/month
     * for each year the key exists when enabled.
     * <p>
     * Default: - false (key rotation is disabled)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableKeyRotation() {
        return null;
    }

    /**
     * Name of the pipeline.
     * <p>
     * Default: - AWS CloudFormation generates an ID and uses that for the pipeline name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return null;
    }

    /**
     * Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRestartExecutionOnUpdate() {
        return null;
    }

    /**
     * Reuse the same cross region support stack for all pipelines in the App.
     * <p>
     * Default: - true (Use the same support stack for all pipelines in App)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReuseCrossRegionSupportStacks() {
        return null;
    }

    /**
     * The IAM role to be assumed by this Pipeline.
     * <p>
     * Default: a new IAM role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The list of Stages, in order, to create this Pipeline with.
     * <p>
     * You can always add more Stages later by calling {&#64;link Pipeline#addStage}.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> getStages() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineProps> {
        software.amazon.awscdk.services.s3.IBucket artifactBucket;
        java.lang.Boolean crossAccountKeys;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        java.lang.Boolean enableKeyRotation;
        java.lang.String pipelineName;
        java.lang.Boolean restartExecutionOnUpdate;
        java.lang.Boolean reuseCrossRegionSupportStacks;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages;

        /**
         * Sets the value of {@link PipelineProps#getArtifactBucket}
         * @param artifactBucket The S3 bucket used by this Pipeline to store artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.artifactBucket = artifactBucket;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getCrossAccountKeys}
         * @param crossAccountKeys Create KMS keys for cross-account deployments.
         *                         This controls whether the pipeline is enabled for cross-account deployments.
         *                         <p>
         *                         By default cross-account deployments are enabled, but this feature requires
         *                         that KMS Customer Master Keys are created which have a cost of $1/month.
         *                         <p>
         *                         If you do not need cross-account deployments, you can set this to <code>false</code> to
         *                         not create those keys and save on that cost (the artifact bucket will be
         *                         encrypted with an AWS-managed key). However, cross-account deployments will
         *                         no longer be possible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(java.lang.Boolean crossAccountKeys) {
            this.crossAccountKeys = crossAccountKeys;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getCrossRegionReplicationBuckets}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline.
         *                                      For every Action that you specify targeting a different region than the Pipeline itself,
         *                                      if you don't provide an explicit Bucket for that region using this property,
         *                                      the construct will automatically create a Stack containing an S3 Bucket in that region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder crossRegionReplicationBuckets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.crossRegionReplicationBuckets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket>)crossRegionReplicationBuckets;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getEnableKeyRotation}
         * @param enableKeyRotation Enable KMS key rotation for the generated KMS keys.
         *                          By default KMS key rotation is disabled, but will add an additional $1/month
         *                          for each year the key exists when enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableKeyRotation(java.lang.Boolean enableKeyRotation) {
            this.enableKeyRotation = enableKeyRotation;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getPipelineName}
         * @param pipelineName Name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(java.lang.Boolean restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getReuseCrossRegionSupportStacks}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.reuseCrossRegionSupportStacks = reuseCrossRegionSupportStacks;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getRole}
         * @param role The IAM role to be assumed by this Pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getStages}
         * @param stages The list of Stages, in order, to create this Pipeline with.
         *               You can always add more Stages later by calling {&#64;link Pipeline#addStage}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder stages(java.util.List<? extends software.amazon.awscdk.services.codepipeline.StageProps> stages) {
            this.stages = (java.util.List<software.amazon.awscdk.services.codepipeline.StageProps>)stages;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineProps {
        private final software.amazon.awscdk.services.s3.IBucket artifactBucket;
        private final java.lang.Boolean crossAccountKeys;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        private final java.lang.Boolean enableKeyRotation;
        private final java.lang.String pipelineName;
        private final java.lang.Boolean restartExecutionOnUpdate;
        private final java.lang.Boolean reuseCrossRegionSupportStacks;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactBucket = software.amazon.jsii.Kernel.get(this, "artifactBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.crossAccountKeys = software.amazon.jsii.Kernel.get(this, "crossAccountKeys", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.crossRegionReplicationBuckets = software.amazon.jsii.Kernel.get(this, "crossRegionReplicationBuckets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.enableKeyRotation = software.amazon.jsii.Kernel.get(this, "enableKeyRotation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restartExecutionOnUpdate = software.amazon.jsii.Kernel.get(this, "restartExecutionOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reuseCrossRegionSupportStacks = software.amazon.jsii.Kernel.get(this, "reuseCrossRegionSupportStacks", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.stages = software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.StageProps.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactBucket = builder.artifactBucket;
            this.crossAccountKeys = builder.crossAccountKeys;
            this.crossRegionReplicationBuckets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket>)builder.crossRegionReplicationBuckets;
            this.enableKeyRotation = builder.enableKeyRotation;
            this.pipelineName = builder.pipelineName;
            this.restartExecutionOnUpdate = builder.restartExecutionOnUpdate;
            this.reuseCrossRegionSupportStacks = builder.reuseCrossRegionSupportStacks;
            this.role = builder.role;
            this.stages = (java.util.List<software.amazon.awscdk.services.codepipeline.StageProps>)builder.stages;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
            return this.artifactBucket;
        }

        @Override
        public final java.lang.Boolean getCrossAccountKeys() {
            return this.crossAccountKeys;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
            return this.crossRegionReplicationBuckets;
        }

        @Override
        public final java.lang.Boolean getEnableKeyRotation() {
            return this.enableKeyRotation;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.lang.Boolean getRestartExecutionOnUpdate() {
            return this.restartExecutionOnUpdate;
        }

        @Override
        public final java.lang.Boolean getReuseCrossRegionSupportStacks() {
            return this.reuseCrossRegionSupportStacks;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> getStages() {
            return this.stages;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArtifactBucket() != null) {
                data.set("artifactBucket", om.valueToTree(this.getArtifactBucket()));
            }
            if (this.getCrossAccountKeys() != null) {
                data.set("crossAccountKeys", om.valueToTree(this.getCrossAccountKeys()));
            }
            if (this.getCrossRegionReplicationBuckets() != null) {
                data.set("crossRegionReplicationBuckets", om.valueToTree(this.getCrossRegionReplicationBuckets()));
            }
            if (this.getEnableKeyRotation() != null) {
                data.set("enableKeyRotation", om.valueToTree(this.getEnableKeyRotation()));
            }
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getRestartExecutionOnUpdate() != null) {
                data.set("restartExecutionOnUpdate", om.valueToTree(this.getRestartExecutionOnUpdate()));
            }
            if (this.getReuseCrossRegionSupportStacks() != null) {
                data.set("reuseCrossRegionSupportStacks", om.valueToTree(this.getReuseCrossRegionSupportStacks()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStages() != null) {
                data.set("stages", om.valueToTree(this.getStages()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.PipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineProps.Jsii$Proxy that = (PipelineProps.Jsii$Proxy) o;

            if (this.artifactBucket != null ? !this.artifactBucket.equals(that.artifactBucket) : that.artifactBucket != null) return false;
            if (this.crossAccountKeys != null ? !this.crossAccountKeys.equals(that.crossAccountKeys) : that.crossAccountKeys != null) return false;
            if (this.crossRegionReplicationBuckets != null ? !this.crossRegionReplicationBuckets.equals(that.crossRegionReplicationBuckets) : that.crossRegionReplicationBuckets != null) return false;
            if (this.enableKeyRotation != null ? !this.enableKeyRotation.equals(that.enableKeyRotation) : that.enableKeyRotation != null) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            if (this.restartExecutionOnUpdate != null ? !this.restartExecutionOnUpdate.equals(that.restartExecutionOnUpdate) : that.restartExecutionOnUpdate != null) return false;
            if (this.reuseCrossRegionSupportStacks != null ? !this.reuseCrossRegionSupportStacks.equals(that.reuseCrossRegionSupportStacks) : that.reuseCrossRegionSupportStacks != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.stages != null ? this.stages.equals(that.stages) : that.stages == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactBucket != null ? this.artifactBucket.hashCode() : 0;
            result = 31 * result + (this.crossAccountKeys != null ? this.crossAccountKeys.hashCode() : 0);
            result = 31 * result + (this.crossRegionReplicationBuckets != null ? this.crossRegionReplicationBuckets.hashCode() : 0);
            result = 31 * result + (this.enableKeyRotation != null ? this.enableKeyRotation.hashCode() : 0);
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.restartExecutionOnUpdate != null ? this.restartExecutionOnUpdate.hashCode() : 0);
            result = 31 * result + (this.reuseCrossRegionSupportStacks != null ? this.reuseCrossRegionSupportStacks.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stages != null ? this.stages.hashCode() : 0);
            return result;
        }
    }
}
