package software.amazon.awscdk.services.codepipeline;

/**
 * The abstract view of an AWS CodePipeline as required and used by Actions.
 * <p>
 * It extends {&#64;link events.IRuleTarget},
 * so this interface can be used as a Target for CloudWatch Events.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-13T18:53:59.453Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.IPipeline")
@software.amazon.jsii.Jsii.Proxy(IPipeline.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IPipeline extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.core.IResource {

    /**
     * The ARN of the Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPipelineArn();

    /**
     * The name of the Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPipelineName();

    /**
     * Define an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * Define an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options);

    /**
     * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.IPipeline {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the Pipeline.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getPipelineArn() {
            return this.jsiiGet("pipelineArn", java.lang.String.class);
        }

        /**
         * The name of the Pipeline.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull java.lang.String getPipelineName() {
            return this.jsiiGet("pipelineName", java.lang.String.class);
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Stack getStack() {
            return this.jsiiGet("stack", software.amazon.awscdk.core.Stack.class);
        }

        /**
         * The construct node in the tree.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
        }

        /**
         * Define an event rule triggered by this CodePipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         * @param options Additional options to pass to the event rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return this.jsiiCall("onEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Define an event rule triggered by this CodePipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return this.jsiiCall("onEvent", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }

        /**
         * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         * @param options Additional options to pass to the event rule.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
            return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
        }

        /**
         * Define an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
         * <p>
         * @param id Identifier for this event handler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
            return this.jsiiCall("onStateChange", software.amazon.awscdk.services.events.Rule.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
        }
    }
}
