package software.amazon.awscdk.services.codepipeline;

/**
 * Specifies the constraints on the number of input and output artifacts an action can have.
 * <p>
 * The constraints for each action type are documented on the
 * {&#64;link https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html Pipeline Structure Reference} page.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-30T10:27:06.563Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.ActionArtifactBounds")
@software.amazon.jsii.Jsii.Proxy(ActionArtifactBounds.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ActionArtifactBounds extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxInputs();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxOutputs();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinInputs();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinOutputs();

    /**
     * @return a {@link Builder} of {@link ActionArtifactBounds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionArtifactBounds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ActionArtifactBounds> {
        private java.lang.Number maxInputs;
        private java.lang.Number maxOutputs;
        private java.lang.Number minInputs;
        private java.lang.Number minOutputs;

        /**
         * Sets the value of {@link ActionArtifactBounds#getMaxInputs}
         * @param maxInputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInputs(java.lang.Number maxInputs) {
            this.maxInputs = maxInputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionArtifactBounds#getMaxOutputs}
         * @param maxOutputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxOutputs(java.lang.Number maxOutputs) {
            this.maxOutputs = maxOutputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionArtifactBounds#getMinInputs}
         * @param minInputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minInputs(java.lang.Number minInputs) {
            this.minInputs = minInputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionArtifactBounds#getMinOutputs}
         * @param minOutputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minOutputs(java.lang.Number minOutputs) {
            this.minOutputs = minOutputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionArtifactBounds}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ActionArtifactBounds build() {
            return new Jsii$Proxy(maxInputs, maxOutputs, minInputs, minOutputs);
        }
    }

    /**
     * An implementation for {@link ActionArtifactBounds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionArtifactBounds {
        private final java.lang.Number maxInputs;
        private final java.lang.Number maxOutputs;
        private final java.lang.Number minInputs;
        private final java.lang.Number minOutputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxInputs = this.jsiiGet("maxInputs", java.lang.Number.class);
            this.maxOutputs = this.jsiiGet("maxOutputs", java.lang.Number.class);
            this.minInputs = this.jsiiGet("minInputs", java.lang.Number.class);
            this.minOutputs = this.jsiiGet("minOutputs", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Number maxInputs, final java.lang.Number maxOutputs, final java.lang.Number minInputs, final java.lang.Number minOutputs) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxInputs = java.util.Objects.requireNonNull(maxInputs, "maxInputs is required");
            this.maxOutputs = java.util.Objects.requireNonNull(maxOutputs, "maxOutputs is required");
            this.minInputs = java.util.Objects.requireNonNull(minInputs, "minInputs is required");
            this.minOutputs = java.util.Objects.requireNonNull(minOutputs, "minOutputs is required");
        }

        @Override
        public java.lang.Number getMaxInputs() {
            return this.maxInputs;
        }

        @Override
        public java.lang.Number getMaxOutputs() {
            return this.maxOutputs;
        }

        @Override
        public java.lang.Number getMinInputs() {
            return this.minInputs;
        }

        @Override
        public java.lang.Number getMinOutputs() {
            return this.minOutputs;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxInputs", om.valueToTree(this.getMaxInputs()));
            data.set("maxOutputs", om.valueToTree(this.getMaxOutputs()));
            data.set("minInputs", om.valueToTree(this.getMinInputs()));
            data.set("minOutputs", om.valueToTree(this.getMinOutputs()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.ActionArtifactBounds"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionArtifactBounds.Jsii$Proxy that = (ActionArtifactBounds.Jsii$Proxy) o;

            if (!maxInputs.equals(that.maxInputs)) return false;
            if (!maxOutputs.equals(that.maxOutputs)) return false;
            if (!minInputs.equals(that.minInputs)) return false;
            return this.minOutputs.equals(that.minOutputs);
        }

        @Override
        public int hashCode() {
            int result = this.maxInputs.hashCode();
            result = 31 * result + (this.maxOutputs.hashCode());
            result = 31 * result + (this.minInputs.hashCode());
            result = 31 * result + (this.minOutputs.hashCode());
            return result;
        }
    }
}
