package software.amazon.awscdk.services.codepipeline;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.7.0 (build 179a3a5)", date = "2020-06-30T10:27:06.581Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.PipelineProps")
@software.amazon.jsii.Jsii.Proxy(PipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PipelineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The S3 bucket used by this Pipeline to store artifacts.
     * <p>
     * Default: - A new S3 bucket will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
        return null;
    }

    /**
     * A map of region to S3 bucket name used for cross-region CodePipeline.
     * <p>
     * For every Action that you specify targeting a different region than the Pipeline itself,
     * if you don't provide an explicit Bucket for that region using this property,
     * the construct will automatically create a Stack containing an S3 Bucket in that region.
     * <p>
     * Default: - None.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
        return null;
    }

    /**
     * Name of the pipeline.
     * <p>
     * Default: - AWS CloudFormation generates an ID and uses that for the pipeline name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPipelineName() {
        return null;
    }

    /**
     * Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRestartExecutionOnUpdate() {
        return null;
    }

    /**
     * The IAM role to be assumed by this Pipeline.
     * <p>
     * Default: a new IAM role will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The list of Stages, in order, to create this Pipeline with.
     * <p>
     * You can always add more Stages later by calling {&#64;link Pipeline#addStage}.
     * <p>
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> getStages() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PipelineProps> {
        private software.amazon.awscdk.services.s3.IBucket artifactBucket;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        private java.lang.String pipelineName;
        private java.lang.Boolean restartExecutionOnUpdate;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages;

        /**
         * Sets the value of {@link PipelineProps#getArtifactBucket}
         * @param artifactBucket The S3 bucket used by this Pipeline to store artifacts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.artifactBucket = artifactBucket;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getCrossRegionReplicationBuckets}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline.
         *                                      For every Action that you specify targeting a different region than the Pipeline itself,
         *                                      if you don't provide an explicit Bucket for that region using this property,
         *                                      the construct will automatically create a Stack containing an S3 Bucket in that region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder crossRegionReplicationBuckets(java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.crossRegionReplicationBuckets = crossRegionReplicationBuckets;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getPipelineName}
         * @param pipelineName Name of the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getRestartExecutionOnUpdate}
         * @param restartExecutionOnUpdate Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(java.lang.Boolean restartExecutionOnUpdate) {
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getRole}
         * @param role The IAM role to be assumed by this Pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link PipelineProps#getStages}
         * @param stages The list of Stages, in order, to create this Pipeline with.
         *               You can always add more Stages later by calling {&#64;link Pipeline#addStage}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages) {
            this.stages = stages;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PipelineProps build() {
            return new Jsii$Proxy(artifactBucket, crossRegionReplicationBuckets, pipelineName, restartExecutionOnUpdate, role, stages);
        }
    }

    /**
     * An implementation for {@link PipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineProps {
        private final software.amazon.awscdk.services.s3.IBucket artifactBucket;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets;
        private final java.lang.String pipelineName;
        private final java.lang.Boolean restartExecutionOnUpdate;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactBucket = this.jsiiGet("artifactBucket", software.amazon.awscdk.services.s3.IBucket.class);
            this.crossRegionReplicationBuckets = this.jsiiGet("crossRegionReplicationBuckets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class)));
            this.pipelineName = this.jsiiGet("pipelineName", java.lang.String.class);
            this.restartExecutionOnUpdate = this.jsiiGet("restartExecutionOnUpdate", java.lang.Boolean.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.stages = this.jsiiGet("stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.StageProps.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.s3.IBucket artifactBucket, final java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets, final java.lang.String pipelineName, final java.lang.Boolean restartExecutionOnUpdate, final software.amazon.awscdk.services.iam.IRole role, final java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> stages) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactBucket = artifactBucket;
            this.crossRegionReplicationBuckets = crossRegionReplicationBuckets;
            this.pipelineName = pipelineName;
            this.restartExecutionOnUpdate = restartExecutionOnUpdate;
            this.role = role;
            this.stages = stages;
        }

        @Override
        public software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
            return this.artifactBucket;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.s3.IBucket> getCrossRegionReplicationBuckets() {
            return this.crossRegionReplicationBuckets;
        }

        @Override
        public java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public java.lang.Boolean getRestartExecutionOnUpdate() {
            return this.restartExecutionOnUpdate;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.codepipeline.StageProps> getStages() {
            return this.stages;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArtifactBucket() != null) {
                data.set("artifactBucket", om.valueToTree(this.getArtifactBucket()));
            }
            if (this.getCrossRegionReplicationBuckets() != null) {
                data.set("crossRegionReplicationBuckets", om.valueToTree(this.getCrossRegionReplicationBuckets()));
            }
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getRestartExecutionOnUpdate() != null) {
                data.set("restartExecutionOnUpdate", om.valueToTree(this.getRestartExecutionOnUpdate()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getStages() != null) {
                data.set("stages", om.valueToTree(this.getStages()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.PipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PipelineProps.Jsii$Proxy that = (PipelineProps.Jsii$Proxy) o;

            if (this.artifactBucket != null ? !this.artifactBucket.equals(that.artifactBucket) : that.artifactBucket != null) return false;
            if (this.crossRegionReplicationBuckets != null ? !this.crossRegionReplicationBuckets.equals(that.crossRegionReplicationBuckets) : that.crossRegionReplicationBuckets != null) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            if (this.restartExecutionOnUpdate != null ? !this.restartExecutionOnUpdate.equals(that.restartExecutionOnUpdate) : that.restartExecutionOnUpdate != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            return this.stages != null ? this.stages.equals(that.stages) : that.stages == null;
        }

        @Override
        public int hashCode() {
            int result = this.artifactBucket != null ? this.artifactBucket.hashCode() : 0;
            result = 31 * result + (this.crossRegionReplicationBuckets != null ? this.crossRegionReplicationBuckets.hashCode() : 0);
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.restartExecutionOnUpdate != null ? this.restartExecutionOnUpdate.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.stages != null ? this.stages.hashCode() : 0);
            return result;
        }
    }
}
