package software.amazon.awscdk.services.codepipeline;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-03T17:04:18.783Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.ActionProperties")
@software.amazon.jsii.Jsii.Proxy(ActionProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ActionProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getActionName();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionArtifactBounds getArtifactBounds();

    /**
     * The category of the action.
     * <p>
     * The category defines which action type the owner
     * (the entity that performs the action) performs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionCategory getCategory();

    /**
     * The service provider that the action calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProvider();

    /**
     * The account the Action is supposed to live in.
     * <p>
     * For Actions backed by resources,
     * this is inferred from the Stack {&#64;link resource} is part of.
     * However, some Actions, like the CloudFormation ones,
     * are not backed by any resource, and they still might want to be cross-account.
     * In general, a concrete Action class should specify either {&#64;link resource},
     * or {&#64;link account} - but not both.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getInputs() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getOutputs() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOwner() {
        return null;
    }

    /**
     * The AWS region the given Action resides in.
     * <p>
     * Note that a cross-region Pipeline requires replication buckets to function correctly.
     * You can provide their names with the {&#64;link PipelineProps#crossRegionReplicationBuckets} property.
     * If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
     * that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
     * <p>
     * Default: the Action resides in the same region as the Pipeline
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * The optional resource that is backing this Action.
     * <p>
     * This is used for automatically handling Actions backed by
     * resources from a different account and/or region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResource getResource() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The order in which AWS CodePipeline runs this action. For more information, see the AWS CodePipeline User Guide.
     * <p>
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRunOrder() {
        return null;
    }

    /**
     * The name of the namespace to use for variables emitted by this action.
     * <p>
     * Default: - a name will be generated, based on the stage and action names
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVariablesNamespace() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ActionProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ActionProperties> {
        private java.lang.String actionName;
        private software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds;
        private software.amazon.awscdk.services.codepipeline.ActionCategory category;
        private java.lang.String provider;
        private java.lang.String account;
        private java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs;
        private java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs;
        private java.lang.String owner;
        private java.lang.String region;
        private software.amazon.awscdk.core.IResource resource;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.Number runOrder;
        private java.lang.String variablesNamespace;
        private java.lang.String version;

        /**
         * Sets the value of {@link ActionProperties#getActionName}
         * @param actionName the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getArtifactBounds}
         * @param artifactBounds the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBounds(software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds) {
            this.artifactBounds = artifactBounds;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getCategory}
         * @param category The category of the action. This parameter is required.
         *                 The category defines which action type the owner
         *                 (the entity that performs the action) performs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(software.amazon.awscdk.services.codepipeline.ActionCategory category) {
            this.category = category;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getProvider}
         * @param provider The service provider that the action calls. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getAccount}
         * @param account The account the Action is supposed to live in.
         *                For Actions backed by resources,
         *                this is inferred from the Stack {&#64;link resource} is part of.
         *                However, some Actions, like the CloudFormation ones,
         *                are not backed by any resource, and they still might want to be cross-account.
         *                In general, a concrete Action class should specify either {&#64;link resource},
         *                or {&#64;link account} - but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getInputs}
         * @param inputs the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputs(java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs) {
            this.inputs = inputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getOutputs}
         * @param outputs the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getOwner}
         * @param owner the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder owner(java.lang.String owner) {
            this.owner = owner;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getRegion}
         * @param region The AWS region the given Action resides in.
         *               Note that a cross-region Pipeline requires replication buckets to function correctly.
         *               You can provide their names with the {&#64;link PipelineProps#crossRegionReplicationBuckets} property.
         *               If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         *               that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getResource}
         * @param resource The optional resource that is backing this Action.
         *                 This is used for automatically handling Actions backed by
         *                 resources from a different account and/or region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(software.amazon.awscdk.core.IResource resource) {
            this.resource = resource;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getRole}
         * @param role the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getRunOrder}
         * @param runOrder The order in which AWS CodePipeline runs this action. For more information, see the AWS CodePipeline User Guide.
         *                 https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ActionProperties#getVersion}
         * @param version the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ActionProperties build() {
            return new Jsii$Proxy(actionName, artifactBounds, category, provider, account, inputs, outputs, owner, region, resource, role, runOrder, variablesNamespace, version);
        }
    }

    /**
     * An implementation for {@link ActionProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperties {
        private final java.lang.String actionName;
        private final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds;
        private final software.amazon.awscdk.services.codepipeline.ActionCategory category;
        private final java.lang.String provider;
        private final java.lang.String account;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs;
        private final java.lang.String owner;
        private final java.lang.String region;
        private final software.amazon.awscdk.core.IResource resource;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actionName = this.jsiiGet("actionName", java.lang.String.class);
            this.artifactBounds = this.jsiiGet("artifactBounds", software.amazon.awscdk.services.codepipeline.ActionArtifactBounds.class);
            this.category = this.jsiiGet("category", software.amazon.awscdk.services.codepipeline.ActionCategory.class);
            this.provider = this.jsiiGet("provider", java.lang.String.class);
            this.account = this.jsiiGet("account", java.lang.String.class);
            this.inputs = this.jsiiGet("inputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.outputs = this.jsiiGet("outputs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class)));
            this.owner = this.jsiiGet("owner", java.lang.String.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.resource = this.jsiiGet("resource", software.amazon.awscdk.core.IResource.class);
            this.role = this.jsiiGet("role", software.amazon.awscdk.services.iam.IRole.class);
            this.runOrder = this.jsiiGet("runOrder", java.lang.Number.class);
            this.variablesNamespace = this.jsiiGet("variablesNamespace", java.lang.String.class);
            this.version = this.jsiiGet("version", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String actionName, final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds, final software.amazon.awscdk.services.codepipeline.ActionCategory category, final java.lang.String provider, final java.lang.String account, final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> inputs, final java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> outputs, final java.lang.String owner, final java.lang.String region, final software.amazon.awscdk.core.IResource resource, final software.amazon.awscdk.services.iam.IRole role, final java.lang.Number runOrder, final java.lang.String variablesNamespace, final java.lang.String version) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actionName = java.util.Objects.requireNonNull(actionName, "actionName is required");
            this.artifactBounds = java.util.Objects.requireNonNull(artifactBounds, "artifactBounds is required");
            this.category = java.util.Objects.requireNonNull(category, "category is required");
            this.provider = java.util.Objects.requireNonNull(provider, "provider is required");
            this.account = account;
            this.inputs = inputs;
            this.outputs = outputs;
            this.owner = owner;
            this.region = region;
            this.resource = resource;
            this.role = role;
            this.runOrder = runOrder;
            this.variablesNamespace = variablesNamespace;
            this.version = version;
        }

        @Override
        public java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public software.amazon.awscdk.services.codepipeline.ActionArtifactBounds getArtifactBounds() {
            return this.artifactBounds;
        }

        @Override
        public software.amazon.awscdk.services.codepipeline.ActionCategory getCategory() {
            return this.category;
        }

        @Override
        public java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getInputs() {
            return this.inputs;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.codepipeline.Artifact> getOutputs() {
            return this.outputs;
        }

        @Override
        public java.lang.String getOwner() {
            return this.owner;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public software.amazon.awscdk.core.IResource getResource() {
            return this.resource;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        public java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actionName", om.valueToTree(this.getActionName()));
            data.set("artifactBounds", om.valueToTree(this.getArtifactBounds()));
            data.set("category", om.valueToTree(this.getCategory()));
            data.set("provider", om.valueToTree(this.getProvider()));
            if (this.getAccount() != null) {
                data.set("account", om.valueToTree(this.getAccount()));
            }
            if (this.getInputs() != null) {
                data.set("inputs", om.valueToTree(this.getInputs()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getOwner() != null) {
                data.set("owner", om.valueToTree(this.getOwner()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getResource() != null) {
                data.set("resource", om.valueToTree(this.getResource()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.ActionProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionProperties.Jsii$Proxy that = (ActionProperties.Jsii$Proxy) o;

            if (!actionName.equals(that.actionName)) return false;
            if (!artifactBounds.equals(that.artifactBounds)) return false;
            if (!category.equals(that.category)) return false;
            if (!provider.equals(that.provider)) return false;
            if (this.account != null ? !this.account.equals(that.account) : that.account != null) return false;
            if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            if (this.variablesNamespace != null ? !this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public int hashCode() {
            int result = this.actionName.hashCode();
            result = 31 * result + (this.artifactBounds.hashCode());
            result = 31 * result + (this.category.hashCode());
            result = 31 * result + (this.provider.hashCode());
            result = 31 * result + (this.account != null ? this.account.hashCode() : 0);
            result = 31 * result + (this.inputs != null ? this.inputs.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
