package software.amazon.awscdk.services.codepipeline;

/**
 * A CloudFormation `AWS::CodePipeline::CustomActionType`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.11.0 (build 1e9b8e1)", date = "2020-09-03T17:04:18.784Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.CfnCustomActionType")
public class CfnCustomActionType extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnCustomActionType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCustomActionType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codepipeline.CfnCustomActionType.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CodePipeline::CustomActionType`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCustomActionType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnCustomActionTypeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Category`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCategory() {
        return this.jsiiGet("category", java.lang.String.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Category`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCategory(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("category", java.util.Objects.requireNonNull(value, "category is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getInputArtifactDetails() {
        return this.jsiiGet("inputArtifactDetails", java.lang.Object.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty value) {
        this.jsiiSet("inputArtifactDetails", java.util.Objects.requireNonNull(value, "inputArtifactDetails is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("inputArtifactDetails", java.util.Objects.requireNonNull(value, "inputArtifactDetails is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getOutputArtifactDetails() {
        return this.jsiiGet("outputArtifactDetails", java.lang.Object.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty value) {
        this.jsiiSet("outputArtifactDetails", java.util.Objects.requireNonNull(value, "outputArtifactDetails is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutputArtifactDetails(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("outputArtifactDetails", java.util.Objects.requireNonNull(value, "outputArtifactDetails is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Provider`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProvider() {
        return this.jsiiGet("provider", java.lang.String.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Provider`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvider(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("provider", java.util.Objects.requireNonNull(value, "provider is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Version`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return this.jsiiGet("version", java.lang.String.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Version`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("version", java.util.Objects.requireNonNull(value, "version is required"));
    }

    /**
     * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationProperties() {
        return this.jsiiGet("configurationProperties", java.lang.Object.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("configurationProperties", value);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        this.jsiiSet("configurationProperties", value);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Settings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSettings() {
        return this.jsiiGet("settings", java.lang.Object.class);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Settings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("settings", value);
    }

    /**
     * `AWS::CodePipeline::CustomActionType.Settings`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.CfnCustomActionType.SettingsProperty value) {
        this.jsiiSet("settings", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.CfnCustomActionType.ArtifactDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCustomActionType.ArtifactDetailsProperty.MaximumCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-maximumcount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaximumCount();

        /**
         * `CfnCustomActionType.ArtifactDetailsProperty.MinimumCount`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-artifactdetails.html#cfn-codepipeline-customactiontype-artifactdetails-minimumcount
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinimumCount();

        /**
         * @return a {@link Builder} of {@link ArtifactDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactDetailsProperty> {
            private java.lang.Number maximumCount;
            private java.lang.Number minimumCount;

            /**
             * Sets the value of {@link ArtifactDetailsProperty#getMaximumCount}
             * @param maximumCount `CfnCustomActionType.ArtifactDetailsProperty.MaximumCount`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumCount(java.lang.Number maximumCount) {
                this.maximumCount = maximumCount;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactDetailsProperty#getMinimumCount}
             * @param minimumCount `CfnCustomActionType.ArtifactDetailsProperty.MinimumCount`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumCount(java.lang.Number minimumCount) {
                this.minimumCount = minimumCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactDetailsProperty build() {
                return new Jsii$Proxy(maximumCount, minimumCount);
            }
        }

        /**
         * An implementation for {@link ArtifactDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactDetailsProperty {
            private final java.lang.Number maximumCount;
            private final java.lang.Number minimumCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumCount = this.jsiiGet("maximumCount", java.lang.Number.class);
                this.minimumCount = this.jsiiGet("minimumCount", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number maximumCount, final java.lang.Number minimumCount) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumCount = java.util.Objects.requireNonNull(maximumCount, "maximumCount is required");
                this.minimumCount = java.util.Objects.requireNonNull(minimumCount, "minimumCount is required");
            }

            @Override
            public java.lang.Number getMaximumCount() {
                return this.maximumCount;
            }

            @Override
            public java.lang.Number getMinimumCount() {
                return this.minimumCount;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maximumCount", om.valueToTree(this.getMaximumCount()));
                data.set("minimumCount", om.valueToTree(this.getMinimumCount()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.CfnCustomActionType.ArtifactDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactDetailsProperty.Jsii$Proxy that = (ArtifactDetailsProperty.Jsii$Proxy) o;

                if (!maximumCount.equals(that.maximumCount)) return false;
                return this.minimumCount.equals(that.minimumCount);
            }

            @Override
            public int hashCode() {
                int result = this.maximumCount.hashCode();
                result = 31 * result + (this.minimumCount.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.CfnCustomActionType.ConfigurationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Key`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-key
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKey();

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Name`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-name
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Required`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-required
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRequired();

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Secret`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-secret
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSecret();

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Description`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-description
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Queryable`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-queryable
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryable() {
            return null;
        }

        /**
         * `CfnCustomActionType.ConfigurationPropertiesProperty.Type`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-configurationproperties.html#cfn-codepipeline-customactiontype-configurationproperties-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationPropertiesProperty> {
            private java.lang.Object key;
            private java.lang.String name;
            private java.lang.Object required;
            private java.lang.Object secret;
            private java.lang.String description;
            private java.lang.Object queryable;
            private java.lang.String type;

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getKey}
             * @param key `CfnCustomActionType.ConfigurationPropertiesProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.Boolean key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getKey}
             * @param key `CfnCustomActionType.ConfigurationPropertiesProperty.Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(software.amazon.awscdk.core.IResolvable key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getName}
             * @param name `CfnCustomActionType.ConfigurationPropertiesProperty.Name`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getRequired}
             * @param required `CfnCustomActionType.ConfigurationPropertiesProperty.Required`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(java.lang.Boolean required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getRequired}
             * @param required `CfnCustomActionType.ConfigurationPropertiesProperty.Required`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder required(software.amazon.awscdk.core.IResolvable required) {
                this.required = required;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getSecret}
             * @param secret `CfnCustomActionType.ConfigurationPropertiesProperty.Secret`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(java.lang.Boolean secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getSecret}
             * @param secret `CfnCustomActionType.ConfigurationPropertiesProperty.Secret`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secret(software.amazon.awscdk.core.IResolvable secret) {
                this.secret = secret;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getDescription}
             * @param description `CfnCustomActionType.ConfigurationPropertiesProperty.Description`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getQueryable}
             * @param queryable `CfnCustomActionType.ConfigurationPropertiesProperty.Queryable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryable(java.lang.Boolean queryable) {
                this.queryable = queryable;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getQueryable}
             * @param queryable `CfnCustomActionType.ConfigurationPropertiesProperty.Queryable`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryable(software.amazon.awscdk.core.IResolvable queryable) {
                this.queryable = queryable;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationPropertiesProperty#getType}
             * @param type `CfnCustomActionType.ConfigurationPropertiesProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationPropertiesProperty build() {
                return new Jsii$Proxy(key, name, required, secret, description, queryable, type);
            }
        }

        /**
         * An implementation for {@link ConfigurationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationPropertiesProperty {
            private final java.lang.Object key;
            private final java.lang.String name;
            private final java.lang.Object required;
            private final java.lang.Object secret;
            private final java.lang.String description;
            private final java.lang.Object queryable;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = this.jsiiGet("key", java.lang.Object.class);
                this.name = this.jsiiGet("name", java.lang.String.class);
                this.required = this.jsiiGet("required", java.lang.Object.class);
                this.secret = this.jsiiGet("secret", java.lang.Object.class);
                this.description = this.jsiiGet("description", java.lang.String.class);
                this.queryable = this.jsiiGet("queryable", java.lang.Object.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object key, final java.lang.String name, final java.lang.Object required, final java.lang.Object secret, final java.lang.String description, final java.lang.Object queryable, final java.lang.String type) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(key, "key is required");
                this.name = java.util.Objects.requireNonNull(name, "name is required");
                this.required = java.util.Objects.requireNonNull(required, "required is required");
                this.secret = java.util.Objects.requireNonNull(secret, "secret is required");
                this.description = description;
                this.queryable = queryable;
                this.type = type;
            }

            @Override
            public java.lang.Object getKey() {
                return this.key;
            }

            @Override
            public java.lang.String getName() {
                return this.name;
            }

            @Override
            public java.lang.Object getRequired() {
                return this.required;
            }

            @Override
            public java.lang.Object getSecret() {
                return this.secret;
            }

            @Override
            public java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public java.lang.Object getQueryable() {
                return this.queryable;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("required", om.valueToTree(this.getRequired()));
                data.set("secret", om.valueToTree(this.getSecret()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getQueryable() != null) {
                    data.set("queryable", om.valueToTree(this.getQueryable()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.CfnCustomActionType.ConfigurationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationPropertiesProperty.Jsii$Proxy that = (ConfigurationPropertiesProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!name.equals(that.name)) return false;
                if (!required.equals(that.required)) return false;
                if (!secret.equals(that.secret)) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.queryable != null ? !this.queryable.equals(that.queryable) : that.queryable != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.required.hashCode());
                result = 31 * result + (this.secret.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.queryable != null ? this.queryable.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codepipeline.$Module.class, fqn = "@aws-cdk/aws-codepipeline.CfnCustomActionType.SettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(SettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnCustomActionType.SettingsProperty.EntityUrlTemplate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-entityurltemplate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEntityUrlTemplate() {
            return null;
        }

        /**
         * `CfnCustomActionType.SettingsProperty.ExecutionUrlTemplate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-executionurltemplate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutionUrlTemplate() {
            return null;
        }

        /**
         * `CfnCustomActionType.SettingsProperty.RevisionUrlTemplate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-revisionurltemplate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRevisionUrlTemplate() {
            return null;
        }

        /**
         * `CfnCustomActionType.SettingsProperty.ThirdPartyConfigurationUrl`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-customactiontype-settings.html#cfn-codepipeline-customactiontype-settings-thirdpartyconfigurationurl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThirdPartyConfigurationUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SettingsProperty> {
            private java.lang.String entityUrlTemplate;
            private java.lang.String executionUrlTemplate;
            private java.lang.String revisionUrlTemplate;
            private java.lang.String thirdPartyConfigurationUrl;

            /**
             * Sets the value of {@link SettingsProperty#getEntityUrlTemplate}
             * @param entityUrlTemplate `CfnCustomActionType.SettingsProperty.EntityUrlTemplate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityUrlTemplate(java.lang.String entityUrlTemplate) {
                this.entityUrlTemplate = entityUrlTemplate;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getExecutionUrlTemplate}
             * @param executionUrlTemplate `CfnCustomActionType.SettingsProperty.ExecutionUrlTemplate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executionUrlTemplate(java.lang.String executionUrlTemplate) {
                this.executionUrlTemplate = executionUrlTemplate;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getRevisionUrlTemplate}
             * @param revisionUrlTemplate `CfnCustomActionType.SettingsProperty.RevisionUrlTemplate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revisionUrlTemplate(java.lang.String revisionUrlTemplate) {
                this.revisionUrlTemplate = revisionUrlTemplate;
                return this;
            }

            /**
             * Sets the value of {@link SettingsProperty#getThirdPartyConfigurationUrl}
             * @param thirdPartyConfigurationUrl `CfnCustomActionType.SettingsProperty.ThirdPartyConfigurationUrl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thirdPartyConfigurationUrl(java.lang.String thirdPartyConfigurationUrl) {
                this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SettingsProperty build() {
                return new Jsii$Proxy(entityUrlTemplate, executionUrlTemplate, revisionUrlTemplate, thirdPartyConfigurationUrl);
            }
        }

        /**
         * An implementation for {@link SettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SettingsProperty {
            private final java.lang.String entityUrlTemplate;
            private final java.lang.String executionUrlTemplate;
            private final java.lang.String revisionUrlTemplate;
            private final java.lang.String thirdPartyConfigurationUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityUrlTemplate = this.jsiiGet("entityUrlTemplate", java.lang.String.class);
                this.executionUrlTemplate = this.jsiiGet("executionUrlTemplate", java.lang.String.class);
                this.revisionUrlTemplate = this.jsiiGet("revisionUrlTemplate", java.lang.String.class);
                this.thirdPartyConfigurationUrl = this.jsiiGet("thirdPartyConfigurationUrl", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String entityUrlTemplate, final java.lang.String executionUrlTemplate, final java.lang.String revisionUrlTemplate, final java.lang.String thirdPartyConfigurationUrl) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityUrlTemplate = entityUrlTemplate;
                this.executionUrlTemplate = executionUrlTemplate;
                this.revisionUrlTemplate = revisionUrlTemplate;
                this.thirdPartyConfigurationUrl = thirdPartyConfigurationUrl;
            }

            @Override
            public java.lang.String getEntityUrlTemplate() {
                return this.entityUrlTemplate;
            }

            @Override
            public java.lang.String getExecutionUrlTemplate() {
                return this.executionUrlTemplate;
            }

            @Override
            public java.lang.String getRevisionUrlTemplate() {
                return this.revisionUrlTemplate;
            }

            @Override
            public java.lang.String getThirdPartyConfigurationUrl() {
                return this.thirdPartyConfigurationUrl;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEntityUrlTemplate() != null) {
                    data.set("entityUrlTemplate", om.valueToTree(this.getEntityUrlTemplate()));
                }
                if (this.getExecutionUrlTemplate() != null) {
                    data.set("executionUrlTemplate", om.valueToTree(this.getExecutionUrlTemplate()));
                }
                if (this.getRevisionUrlTemplate() != null) {
                    data.set("revisionUrlTemplate", om.valueToTree(this.getRevisionUrlTemplate()));
                }
                if (this.getThirdPartyConfigurationUrl() != null) {
                    data.set("thirdPartyConfigurationUrl", om.valueToTree(this.getThirdPartyConfigurationUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codepipeline.CfnCustomActionType.SettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SettingsProperty.Jsii$Proxy that = (SettingsProperty.Jsii$Proxy) o;

                if (this.entityUrlTemplate != null ? !this.entityUrlTemplate.equals(that.entityUrlTemplate) : that.entityUrlTemplate != null) return false;
                if (this.executionUrlTemplate != null ? !this.executionUrlTemplate.equals(that.executionUrlTemplate) : that.executionUrlTemplate != null) return false;
                if (this.revisionUrlTemplate != null ? !this.revisionUrlTemplate.equals(that.revisionUrlTemplate) : that.revisionUrlTemplate != null) return false;
                return this.thirdPartyConfigurationUrl != null ? this.thirdPartyConfigurationUrl.equals(that.thirdPartyConfigurationUrl) : that.thirdPartyConfigurationUrl == null;
            }

            @Override
            public int hashCode() {
                int result = this.entityUrlTemplate != null ? this.entityUrlTemplate.hashCode() : 0;
                result = 31 * result + (this.executionUrlTemplate != null ? this.executionUrlTemplate.hashCode() : 0);
                result = 31 * result + (this.revisionUrlTemplate != null ? this.revisionUrlTemplate.hashCode() : 0);
                result = 31 * result + (this.thirdPartyConfigurationUrl != null ? this.thirdPartyConfigurationUrl.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.CfnCustomActionType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.CfnCustomActionType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.CfnCustomActionTypeProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.CfnCustomActionTypeProps.Builder();
        }

        /**
         * `AWS::CodePipeline::CustomActionType.Category`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-category
         * @param category `AWS::CodePipeline::CustomActionType.Category`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(final java.lang.String category) {
            this.props.category(category);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
         * @param inputArtifactDetails `AWS::CodePipeline::CustomActionType.InputArtifactDetails`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifactDetails(final software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty inputArtifactDetails) {
            this.props.inputArtifactDetails(inputArtifactDetails);
            return this;
        }
        /**
         * `AWS::CodePipeline::CustomActionType.InputArtifactDetails`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-inputartifactdetails
         * @param inputArtifactDetails `AWS::CodePipeline::CustomActionType.InputArtifactDetails`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputArtifactDetails(final software.amazon.awscdk.core.IResolvable inputArtifactDetails) {
            this.props.inputArtifactDetails(inputArtifactDetails);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
         * @param outputArtifactDetails `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputArtifactDetails(final software.amazon.awscdk.services.codepipeline.CfnCustomActionType.ArtifactDetailsProperty outputArtifactDetails) {
            this.props.outputArtifactDetails(outputArtifactDetails);
            return this;
        }
        /**
         * `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-outputartifactdetails
         * @param outputArtifactDetails `AWS::CodePipeline::CustomActionType.OutputArtifactDetails`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputArtifactDetails(final software.amazon.awscdk.core.IResolvable outputArtifactDetails) {
            this.props.outputArtifactDetails(outputArtifactDetails);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.Provider`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-provider
         * @param provider `AWS::CodePipeline::CustomActionType.Provider`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(final java.lang.String provider) {
            this.props.provider(provider);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.Version`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-version
         * @param version `AWS::CodePipeline::CustomActionType.Version`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(final java.lang.String version) {
            this.props.version(version);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
         * @param configurationProperties `AWS::CodePipeline::CustomActionType.ConfigurationProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProperties(final software.amazon.awscdk.core.IResolvable configurationProperties) {
            this.props.configurationProperties(configurationProperties);
            return this;
        }
        /**
         * `AWS::CodePipeline::CustomActionType.ConfigurationProperties`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-configurationproperties
         * @param configurationProperties `AWS::CodePipeline::CustomActionType.ConfigurationProperties`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationProperties(final java.util.List<java.lang.Object> configurationProperties) {
            this.props.configurationProperties(configurationProperties);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.Settings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
         * @param settings `AWS::CodePipeline::CustomActionType.Settings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.core.IResolvable settings) {
            this.props.settings(settings);
            return this;
        }
        /**
         * `AWS::CodePipeline::CustomActionType.Settings`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-settings
         * @param settings `AWS::CodePipeline::CustomActionType.Settings`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder settings(final software.amazon.awscdk.services.codepipeline.CfnCustomActionType.SettingsProperty settings) {
            this.props.settings(settings);
            return this;
        }

        /**
         * `AWS::CodePipeline::CustomActionType.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-customactiontype.html#cfn-codepipeline-customactiontype-tags
         * @param tags `AWS::CodePipeline::CustomActionType.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.CfnCustomActionType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.CfnCustomActionType build() {
            return new software.amazon.awscdk.services.codepipeline.CfnCustomActionType(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
