/**
 * <h2>AWS CodePipeline Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * <h3>Pipeline</h3>
 * <p>
 * To construct an empty Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codepipeline.*;
 * 
 * Pipeline pipeline = new Pipeline(this, "MyFirstPipeline");
 * </pre></blockquote>
 * <p>
 * To give the Pipeline a nice, human-readable name:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var pipeline = Pipeline.Builder.create(this, "MyFirstPipeline")
 *         .pipelineName("MyPipeline")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Stages</h3>
 * <p>
 * You can provide Stages when creating the Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var pipeline = Pipeline.Builder.create(this, "MyFirstPipeline")
 *         .stages(asList(Map.of(
 *                 "stageName", "Source",
 *                 "actions", asList())))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Or append a Stage to an existing Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var sourceStage = pipeline.addStage(Map.of(
 *         "stageName", "Source",
 *         "actions", asList()));
 * </pre></blockquote>
 * <p>
 * You can insert the new Stage at an arbitrary point in the Pipeline:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var someStage = pipeline.addStage(Map.of(
 *         "stageName", "SomeStage",
 *         "placement", Map.of(
 *                 // note: you can only specify one of the below properties
 *                 "rightBefore", anotherStage,
 *                 "justAfter", anotherStage)));
 * </pre></blockquote>
 * <p>
 * <h3>Actions</h3>
 * <p>
 * Actions live in a separate package, <code>&#64;aws-cdk/aws-codepipeline-actions</code>.
 * <p>
 * To add an Action to a Stage, you can provide it when creating the Stage,
 * in the <code>actions</code> property,
 * or you can use the <code>IStage.addAction()</code> method to mutate an existing Stage:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * sourceStage.addAction(someAction);
 * </pre></blockquote>
 * <p>
 * <h3>Cross-region CodePipelines</h3>
 * <p>
 * You can also use the cross-region feature to deploy resources
 * into a different region than your Pipeline is in.
 * <p>
 * It works like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var pipeline = Pipeline.Builder.create(this, "MyFirstPipeline")
 *         // ...
 *         .crossRegionReplicationBuckets(Map.of(
 *                 // note that a physical name of the replication Bucket must be known at synthesis time
 *                 "us-west-1", s3.Bucket.fromBucketAttributes(this, "UsWest1ReplicationBucket", Map.of(
 *                         "bucketName", "my-us-west-1-replication-bucket",
 *                         // optional KMS key
 *                         "encryptionKey", kms.Key.fromKeyArn(this, "UsWest1ReplicationKey", "arn:aws:kms:us-west-1:123456789012:key/1234-5678-9012")))))
 *         .build();
 * 
 * // later in the code...
 * // later in the code...
 * CloudFormationCreateUpdateStackAction.Builder.create()
 *         .actionName("CFN_US_West_1")
 *         // ...
 *         .region("us-west-1")
 *         .build();
 * </pre></blockquote>
 * <p>
 * This way, the <code>CFN_US_West_1</code> Action will operate in the <code>us-west-1</code> region,
 * regardless of which region your Pipeline is in.
 * <p>
 * If you don't provide a bucket for a region (other than the Pipeline's region)
 * that you're using for an Action,
 * there will be a new Stack, called <code>&lt;nameOfYourPipelineStack&gt;-support-&lt;region&gt;</code>,
 * defined for you, containing a replication Bucket.
 * This new Stack will depend on your Pipeline Stack,
 * so deploying the Pipeline Stack will deploy the support Stack(s) first.
 * Example:
 * <p>
 * <blockquote><pre>
 * $ cdk ls
 * MyMainStack
 * MyMainStack-support-us-west-1
 * $ cdk deploy MyMainStack
 * # output of cdk deploy here...
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-cross-region.html">the AWS docs here</a>
 * for more information on cross-region CodePipelines.
 * <p>
 * <h4>Creating an encrypted replication bucket</h4>
 * <p>
 * If you're passing a replication bucket created in a different stack,
 * like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var replicationStack = Stack.Builder.create(app, "ReplicationStack")
 *         .env(Map.of(
 *                 "region", "us-west-1"))
 *         .build();
 * var key = new Key(replicationStack, "ReplicationKey");
 * var replicationBucket = Bucket.Builder.create(replicationStack, "ReplicationBucket")
 *         // like was said above - replication buckets need a set physical name
 *         .bucketName(PhysicalName.getGENERATE_IF_NEEDED())
 *         .encryptionKey(key)
 *         .build();
 * 
 * // later...
 * // later...
 * Pipeline.Builder.create(pipelineStack, "Pipeline")
 *         .crossRegionReplicationBuckets(Map.of(
 *                 "us-west-1", replicationBucket))
 *         .build();
 * </pre></blockquote>
 * <p>
 * When trying to encrypt it
 * (and note that if any of the cross-region actions happen to be cross-account as well,
 * the bucket <em>has to</em> be encrypted - otherwise the pipeline will fail at runtime),
 * you cannot use a key directly - KMS keys don't have physical names,
 * and so you can't reference them across environments.
 * <p>
 * In this case, you need to use an alias in place of the key when creating the bucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var key = new Key(replicationStack, "ReplicationKey");
 * var alias = Alias.Builder.create(replicationStack, "ReplicationAlias")
 *         // aliasName is required
 *         .aliasName(PhysicalName.getGENERATE_IF_NEEDED())
 *         .targetKey(key)
 *         .build();
 * var replicationBucket = Bucket.Builder.create(replicationStack, "ReplicationBucket")
 *         .bucketName(PhysicalName.getGENERATE_IF_NEEDED())
 *         .encryptionKey(alias)
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Variables</h3>
 * <p>
 * The library supports the CodePipeline Variables feature.
 * Each action class that emits variables has a separate variables interface,
 * accessed as a property of the action instance called <code>variables</code>.
 * You instantiate the action class and assign it to a local variable;
 * when you want to use a variable in the configuration of a different action,
 * you access the appropriate property of the interface returned from <code>variables</code>,
 * which represents a single variable.
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // MyAction is some action type that produces variables
 * var myAction = MyAction.Builder.create().build();
 * OtherAction.Builder.create()
 *         // ...
 *         .config(myAction.variables.getMyVariable())
 *         .build();
 * </pre></blockquote>
 * <p>
 * The namespace name that will be used will be automatically generated by the pipeline construct,
 * based on the stage and action name;
 * you can pass a custom name when creating the action instance:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myAction = MyAction.Builder.create()
 *         // ...
 *         .variablesNamespace("MyNamespace")
 *         .build();
 * </pre></blockquote>
 * <p>
 * There are also global variables available,
 * not tied to any action;
 * these are accessed through static properties of the <code>GlobalVariables</code> class:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * OtherAction.Builder.create()
 *         // ...
 *         .config(codepipeline.GlobalVariables.getExecutionId())
 *         .build();
 * </pre></blockquote>
 * <p>
 * Check the documentation of the <code>&#64;aws-cdk/aws-codepipeline-actions</code>
 * for details on how to use the variables for each action class.
 * <p>
 * See the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-variables.html">CodePipeline documentation</a>
 * for more details on how to use the variables feature.
 * <p>
 * <h3>Events</h3>
 * <p>
 * <h4>Using a pipeline as an event target</h4>
 * <p>
 * A pipeline can be used as a target for a CloudWatch event rule:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.events.targets.*;
 * import software.amazon.awscdk.services.events.*;
 * 
 * // kick off the pipeline every day
 * Rule rule = new Rule(this, "Daily", new RuleProps()
 *         .schedule(events.Schedule.rate(Duration.days(1))));
 * 
 * rule.addTarget(new CodePipeline(pipeline));
 * </pre></blockquote>
 * <p>
 * When a pipeline is used as an event target, the
 * "codepipeline:StartPipelineExecution" permission is granted to the AWS
 * CloudWatch Events service.
 * <p>
 * <h4>Event sources</h4>
 * <p>
 * Pipelines emit CloudWatch events. To define event rules for events emitted by
 * the pipeline, stages or action, use the <code>onXxx</code> methods on the respective
 * construct:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * myPipeline.onStateChange("MyPipelineStateChange", target);
 * myStage.onStateChange("MyStageStateChange", target);
 * myAction.onStateChange("MyActionStateChange", target);
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.codepipeline;
