/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.datapipeline;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnPipelineProps
extends JsiiSerializable {
    public String getName();

    public Object getParameterObjects();

    public Object getActivate();

    public String getDescription();

    public Object getParameterValues();

    public Object getPipelineObjects();

    public Object getPipelineTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _name;
        private Object _parameterObjects;
        @Nullable
        private Object _activate;
        @Nullable
        private String _description;
        @Nullable
        private Object _parameterValues;
        @Nullable
        private Object _pipelineObjects;
        @Nullable
        private Object _pipelineTags;

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withParameterObjects(Token value) {
            this._parameterObjects = Objects.requireNonNull(value, "parameterObjects is required");
            return this;
        }

        public Builder withParameterObjects(List<Object> value) {
            this._parameterObjects = Objects.requireNonNull(value, "parameterObjects is required");
            return this;
        }

        public Builder withActivate(@Nullable Boolean value) {
            this._activate = value;
            return this;
        }

        public Builder withActivate(@Nullable Token value) {
            this._activate = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withParameterValues(@Nullable Token value) {
            this._parameterValues = value;
            return this;
        }

        public Builder withParameterValues(@Nullable List<Object> value) {
            this._parameterValues = value;
            return this;
        }

        public Builder withPipelineObjects(@Nullable Token value) {
            this._pipelineObjects = value;
            return this;
        }

        public Builder withPipelineObjects(@Nullable List<Object> value) {
            this._pipelineObjects = value;
            return this;
        }

        public Builder withPipelineTags(@Nullable Token value) {
            this._pipelineTags = value;
            return this;
        }

        public Builder withPipelineTags(@Nullable List<Object> value) {
            this._pipelineTags = value;
            return this;
        }

        public CfnPipelineProps build() {
            return new CfnPipelineProps(){
                private final String $name;
                private final Object $parameterObjects;
                @Nullable
                private final Object $activate;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $parameterValues;
                @Nullable
                private final Object $pipelineObjects;
                @Nullable
                private final Object $pipelineTags;
                {
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$parameterObjects = Objects.requireNonNull(_parameterObjects, "parameterObjects is required");
                    this.$activate = _activate;
                    this.$description = _description;
                    this.$parameterValues = _parameterValues;
                    this.$pipelineObjects = _pipelineObjects;
                    this.$pipelineTags = _pipelineTags;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public Object getParameterObjects() {
                    return this.$parameterObjects;
                }

                @Override
                public Object getActivate() {
                    return this.$activate;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getParameterValues() {
                    return this.$parameterValues;
                }

                @Override
                public Object getPipelineObjects() {
                    return this.$pipelineObjects;
                }

                @Override
                public Object getPipelineTags() {
                    return this.$pipelineTags;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    obj.set("parameterObjects", om.valueToTree(this.getParameterObjects()));
                    obj.set("activate", om.valueToTree(this.getActivate()));
                    obj.set("description", om.valueToTree((Object)this.getDescription()));
                    obj.set("parameterValues", om.valueToTree(this.getParameterValues()));
                    obj.set("pipelineObjects", om.valueToTree(this.getPipelineObjects()));
                    obj.set("pipelineTags", om.valueToTree(this.getPipelineTags()));
                    return obj;
                }
            };
        }
    }
}

