package software.amazon.awscdk.services.ecs.patterns;

/**
 * Properties for a LoadBalancedEc2Service.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:22:48.114Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LoadBalancedEc2ServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.LoadBalancedServiceBaseProps {
    /**
     * The hard limit (in MiB) of memory to present to the container.
     * 
     * If your container attempts to exceed the allocated memory, the container
     * is terminated.
     * 
     * At least one of memoryLimitMiB and memoryReservationMiB is required.
     * 
     * Default: - No memory limit.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getMemoryLimitMiB();
    /**
     * The soft limit (in MiB) of memory to reserve for the container.
     * 
     * When system memory is under contention, Docker attempts to keep the
     * container memory within the limit. If the container requires more memory,
     * it can consume up to the value specified by the Memory property or all of
     * the available memory on the container instance—whichever comes first.
     * 
     * At least one of memoryLimitMiB and memoryReservationMiB is required.
     * 
     * Default: - No memory reserved.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getMemoryReservationMiB();

    /**
     * @return a {@link Builder} of {@link LoadBalancedEc2ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LoadBalancedEc2ServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _memoryLimitMiB;
        @javax.annotation.Nullable
        private java.lang.Number _memoryReservationMiB;
        private software.amazon.awscdk.services.ecs.ICluster _cluster;
        private software.amazon.awscdk.services.ecs.ContainerImage _image;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.certificatemanager.ICertificate _certificate;
        @javax.annotation.Nullable
        private java.lang.Number _containerPort;
        @javax.annotation.Nullable
        private java.lang.Number _desiredCount;
        @javax.annotation.Nullable
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.route53.IHostedZone _domainZone;
        @javax.annotation.Nullable
        private java.lang.Boolean _enableLogging;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _environment;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ecs.patterns.LoadBalancerType _loadBalancerType;
        @javax.annotation.Nullable
        private java.lang.Boolean _publicLoadBalancer;
        @javax.annotation.Nullable
        private java.lang.Boolean _publicTasks;

        /**
         * Sets the value of MemoryLimitMiB
         * @param value The hard limit (in MiB) of memory to present to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMemoryLimitMiB(@javax.annotation.Nullable final java.lang.Number value) {
            this._memoryLimitMiB = value;
            return this;
        }
        /**
         * Sets the value of MemoryReservationMiB
         * @param value The soft limit (in MiB) of memory to reserve for the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMemoryReservationMiB(@javax.annotation.Nullable final java.lang.Number value) {
            this._memoryReservationMiB = value;
            return this;
        }
        /**
         * Sets the value of Cluster
         * @param value The cluster where your service will be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCluster(final software.amazon.awscdk.services.ecs.ICluster value) {
            this._cluster = java.util.Objects.requireNonNull(value, "cluster is required");
            return this;
        }
        /**
         * Sets the value of Image
         * @param value The image to start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withImage(final software.amazon.awscdk.services.ecs.ContainerImage value) {
            this._image = java.util.Objects.requireNonNull(value, "image is required");
            return this;
        }
        /**
         * Sets the value of Certificate
         * @param value Certificate Manager certificate to associate with the load balancer. Setting this option will set the load balancer port to 443.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCertificate(@javax.annotation.Nullable final software.amazon.awscdk.services.certificatemanager.ICertificate value) {
            this._certificate = value;
            return this;
        }
        /**
         * Sets the value of ContainerPort
         * @param value The container port of the application load balancer attached to your Fargate service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withContainerPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._containerPort = value;
            return this;
        }
        /**
         * Sets the value of DesiredCount
         * @param value Number of desired copies of running tasks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDesiredCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._desiredCount = value;
            return this;
        }
        /**
         * Sets the value of DomainName
         * @param value Domain name for the service, e.g. api.example.com.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDomainName(@javax.annotation.Nullable final java.lang.String value) {
            this._domainName = value;
            return this;
        }
        /**
         * Sets the value of DomainZone
         * @param value Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDomainZone(@javax.annotation.Nullable final software.amazon.awscdk.services.route53.IHostedZone value) {
            this._domainZone = value;
            return this;
        }
        /**
         * Sets the value of EnableLogging
         * @param value Whether to create an AWS log driver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnableLogging(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enableLogging = value;
            return this;
        }
        /**
         * Sets the value of Environment
         * @param value Environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnvironment(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._environment = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerType
         * @param value Whether to create an application load balancer or a network load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withLoadBalancerType(@javax.annotation.Nullable final software.amazon.awscdk.services.ecs.patterns.LoadBalancerType value) {
            this._loadBalancerType = value;
            return this;
        }
        /**
         * Sets the value of PublicLoadBalancer
         * @param value Determines whether the Application Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPublicLoadBalancer(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._publicLoadBalancer = value;
            return this;
        }
        /**
         * Sets the value of PublicTasks
         * @param value Determines whether your Fargate Service will be assigned a public IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPublicTasks(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._publicTasks = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancedEc2ServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public LoadBalancedEc2ServiceProps build() {
            return new LoadBalancedEc2ServiceProps() {
                @javax.annotation.Nullable
                private final java.lang.Number $memoryLimitMiB = _memoryLimitMiB;
                @javax.annotation.Nullable
                private final java.lang.Number $memoryReservationMiB = _memoryReservationMiB;
                private final software.amazon.awscdk.services.ecs.ICluster $cluster = java.util.Objects.requireNonNull(_cluster, "cluster is required");
                private final software.amazon.awscdk.services.ecs.ContainerImage $image = java.util.Objects.requireNonNull(_image, "image is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.certificatemanager.ICertificate $certificate = _certificate;
                @javax.annotation.Nullable
                private final java.lang.Number $containerPort = _containerPort;
                @javax.annotation.Nullable
                private final java.lang.Number $desiredCount = _desiredCount;
                @javax.annotation.Nullable
                private final java.lang.String $domainName = _domainName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.route53.IHostedZone $domainZone = _domainZone;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enableLogging = _enableLogging;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $environment = _environment;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ecs.patterns.LoadBalancerType $loadBalancerType = _loadBalancerType;
                @javax.annotation.Nullable
                private final java.lang.Boolean $publicLoadBalancer = _publicLoadBalancer;
                @javax.annotation.Nullable
                private final java.lang.Boolean $publicTasks = _publicTasks;

                @Override
                public java.lang.Number getMemoryLimitMiB() {
                    return this.$memoryLimitMiB;
                }

                @Override
                public java.lang.Number getMemoryReservationMiB() {
                    return this.$memoryReservationMiB;
                }

                @Override
                public software.amazon.awscdk.services.ecs.ICluster getCluster() {
                    return this.$cluster;
                }

                @Override
                public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
                    return this.$image;
                }

                @Override
                public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
                    return this.$certificate;
                }

                @Override
                public java.lang.Number getContainerPort() {
                    return this.$containerPort;
                }

                @Override
                public java.lang.Number getDesiredCount() {
                    return this.$desiredCount;
                }

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
                    return this.$domainZone;
                }

                @Override
                public java.lang.Boolean getEnableLogging() {
                    return this.$enableLogging;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public software.amazon.awscdk.services.ecs.patterns.LoadBalancerType getLoadBalancerType() {
                    return this.$loadBalancerType;
                }

                @Override
                public java.lang.Boolean getPublicLoadBalancer() {
                    return this.$publicLoadBalancer;
                }

                @Override
                public java.lang.Boolean getPublicTasks() {
                    return this.$publicTasks;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getMemoryLimitMiB() != null) {
                        obj.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
                    }
                    if (this.getMemoryReservationMiB() != null) {
                        obj.set("memoryReservationMiB", om.valueToTree(this.getMemoryReservationMiB()));
                    }
                    obj.set("cluster", om.valueToTree(this.getCluster()));
                    obj.set("image", om.valueToTree(this.getImage()));
                    if (this.getCertificate() != null) {
                        obj.set("certificate", om.valueToTree(this.getCertificate()));
                    }
                    if (this.getContainerPort() != null) {
                        obj.set("containerPort", om.valueToTree(this.getContainerPort()));
                    }
                    if (this.getDesiredCount() != null) {
                        obj.set("desiredCount", om.valueToTree(this.getDesiredCount()));
                    }
                    if (this.getDomainName() != null) {
                        obj.set("domainName", om.valueToTree(this.getDomainName()));
                    }
                    if (this.getDomainZone() != null) {
                        obj.set("domainZone", om.valueToTree(this.getDomainZone()));
                    }
                    if (this.getEnableLogging() != null) {
                        obj.set("enableLogging", om.valueToTree(this.getEnableLogging()));
                    }
                    if (this.getEnvironment() != null) {
                        obj.set("environment", om.valueToTree(this.getEnvironment()));
                    }
                    if (this.getLoadBalancerType() != null) {
                        obj.set("loadBalancerType", om.valueToTree(this.getLoadBalancerType()));
                    }
                    if (this.getPublicLoadBalancer() != null) {
                        obj.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
                    }
                    if (this.getPublicTasks() != null) {
                        obj.set("publicTasks", om.valueToTree(this.getPublicTasks()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.patterns.LoadBalancedEc2ServiceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The hard limit (in MiB) of memory to present to the container.
         * 
         * If your container attempts to exceed the allocated memory, the container
         * is terminated.
         * 
         * At least one of memoryLimitMiB and memoryReservationMiB is required.
         * 
         * Default: - No memory limit.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getMemoryLimitMiB() {
            return this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
        }

        /**
         * The soft limit (in MiB) of memory to reserve for the container.
         * 
         * When system memory is under contention, Docker attempts to keep the
         * container memory within the limit. If the container requires more memory,
         * it can consume up to the value specified by the Memory property or all of
         * the available memory on the container instance—whichever comes first.
         * 
         * At least one of memoryLimitMiB and memoryReservationMiB is required.
         * 
         * Default: - No memory reserved.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getMemoryReservationMiB() {
            return this.jsiiGet("memoryReservationMiB", java.lang.Number.class);
        }

        /**
         * The cluster where your service will be deployed.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
        }

        /**
         * The image to start.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
        }

        /**
         * Certificate Manager certificate to associate with the load balancer. Setting this option will set the load balancer port to 443.
         * 
         * Default: - No certificate associated with the load balancer.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
        }

        /**
         * The container port of the application load balancer attached to your Fargate service.
         * 
         * Corresponds to container port mapping.
         * 
         * Default: 80
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getContainerPort() {
            return this.jsiiGet("containerPort", java.lang.Number.class);
        }

        /**
         * Number of desired copies of running tasks.
         * 
         * Default: 1
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getDesiredCount() {
            return this.jsiiGet("desiredCount", java.lang.Number.class);
        }

        /**
         * Domain name for the service, e.g. api.example.com.
         * 
         * Default: - No domain name.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Route53 hosted zone for the domain, e.g. "example.com.".
         * 
         * Default: - No Route53 hosted domain zone.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.jsiiGet("domainZone", software.amazon.awscdk.services.route53.IHostedZone.class);
        }

        /**
         * Whether to create an AWS log driver.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableLogging() {
            return this.jsiiGet("enableLogging", java.lang.Boolean.class);
        }

        /**
         * Environment variables to pass to the container.
         * 
         * Default: - No environment variables.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.jsiiGet("environment", java.util.Map.class);
        }

        /**
         * Whether to create an application load balancer or a network load balancer.
         * 
         * Default: application
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ecs.patterns.LoadBalancerType getLoadBalancerType() {
            return this.jsiiGet("loadBalancerType", software.amazon.awscdk.services.ecs.patterns.LoadBalancerType.class);
        }

        /**
         * Determines whether the Application Load Balancer will be internet-facing.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getPublicLoadBalancer() {
            return this.jsiiGet("publicLoadBalancer", java.lang.Boolean.class);
        }

        /**
         * Determines whether your Fargate Service will be assigned a public IP address.
         * 
         * Default: false
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getPublicTasks() {
            return this.jsiiGet("publicTasks", java.lang.Boolean.class);
        }
    }
}
