package software.amazon.awscdk.services.ecs.patterns;

/**
 * Properties to define a queue processing service.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:22:48.126Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface QueueProcessingServiceBaseProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Cluster where service will be deployed.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ecs.ICluster getCluster();
    /**
     * The image to start.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.ecs.ContainerImage getImage();
    /**
     * The CMD value to pass to the container.
     * 
     * A string with commands delimited by commas.
     * 
     * Default: none
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getCommand();
    /**
     * Number of desired copies of running tasks.
     * 
     * Default: 1
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getDesiredTaskCount();
    /**
     * Flag to indicate whether to enable logging.
     * 
     * Default: true
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getEnableLogging();
    /**
     * The environment variables to pass to the container.
     * 
     * Default: 'QUEUE_NAME: queue.queueName'
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.String> getEnvironment();
    /**
     * Maximum capacity to scale to.
     * 
     * Default: (desiredTaskCount * 2)
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getMaxScalingCapacity();
    /**
     * A queue for which to process items from.
     * 
     * If specified and this is a FIFO queue, the queue name must end in the string '.fifo'.
     * 
     * Default: 'SQSQueue with CloudFormation-generated name'
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.sqs.IQueue getQueue();
    /**
     * The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
     * 
     * Maps a range of metric values to a particular scaling behavior.
     * https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html
     * 
     * Default: [{ upper: 0, change: -1 },{ lower: 100, change: +1 },{ lower: 500, change: +5 }]
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps();

    /**
     * @return a {@link Builder} of {@link QueueProcessingServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link QueueProcessingServiceBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private software.amazon.awscdk.services.ecs.ICluster _cluster;
        private software.amazon.awscdk.services.ecs.ContainerImage _image;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _command;
        @javax.annotation.Nullable
        private java.lang.Number _desiredTaskCount;
        @javax.annotation.Nullable
        private java.lang.Boolean _enableLogging;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _environment;
        @javax.annotation.Nullable
        private java.lang.Number _maxScalingCapacity;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.sqs.IQueue _queue;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> _scalingSteps;

        /**
         * Sets the value of Cluster
         * @param value Cluster where service will be deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCluster(final software.amazon.awscdk.services.ecs.ICluster value) {
            this._cluster = java.util.Objects.requireNonNull(value, "cluster is required");
            return this;
        }
        /**
         * Sets the value of Image
         * @param value The image to start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withImage(final software.amazon.awscdk.services.ecs.ContainerImage value) {
            this._image = java.util.Objects.requireNonNull(value, "image is required");
            return this;
        }
        /**
         * Sets the value of Command
         * @param value The CMD value to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCommand(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._command = value;
            return this;
        }
        /**
         * Sets the value of DesiredTaskCount
         * @param value Number of desired copies of running tasks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDesiredTaskCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._desiredTaskCount = value;
            return this;
        }
        /**
         * Sets the value of EnableLogging
         * @param value Flag to indicate whether to enable logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnableLogging(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._enableLogging = value;
            return this;
        }
        /**
         * Sets the value of Environment
         * @param value The environment variables to pass to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEnvironment(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._environment = value;
            return this;
        }
        /**
         * Sets the value of MaxScalingCapacity
         * @param value Maximum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMaxScalingCapacity(@javax.annotation.Nullable final java.lang.Number value) {
            this._maxScalingCapacity = value;
            return this;
        }
        /**
         * Sets the value of Queue
         * @param value A queue for which to process items from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withQueue(@javax.annotation.Nullable final software.amazon.awscdk.services.sqs.IQueue value) {
            this._queue = value;
            return this;
        }
        /**
         * Sets the value of ScalingSteps
         * @param value The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withScalingSteps(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> value) {
            this._scalingSteps = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueProcessingServiceBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public QueueProcessingServiceBaseProps build() {
            return new QueueProcessingServiceBaseProps() {
                private final software.amazon.awscdk.services.ecs.ICluster $cluster = java.util.Objects.requireNonNull(_cluster, "cluster is required");
                private final software.amazon.awscdk.services.ecs.ContainerImage $image = java.util.Objects.requireNonNull(_image, "image is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $command = _command;
                @javax.annotation.Nullable
                private final java.lang.Number $desiredTaskCount = _desiredTaskCount;
                @javax.annotation.Nullable
                private final java.lang.Boolean $enableLogging = _enableLogging;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $environment = _environment;
                @javax.annotation.Nullable
                private final java.lang.Number $maxScalingCapacity = _maxScalingCapacity;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.sqs.IQueue $queue = _queue;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> $scalingSteps = _scalingSteps;

                @Override
                public software.amazon.awscdk.services.ecs.ICluster getCluster() {
                    return this.$cluster;
                }

                @Override
                public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
                    return this.$image;
                }

                @Override
                public java.util.List<java.lang.String> getCommand() {
                    return this.$command;
                }

                @Override
                public java.lang.Number getDesiredTaskCount() {
                    return this.$desiredTaskCount;
                }

                @Override
                public java.lang.Boolean getEnableLogging() {
                    return this.$enableLogging;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
                    return this.$environment;
                }

                @Override
                public java.lang.Number getMaxScalingCapacity() {
                    return this.$maxScalingCapacity;
                }

                @Override
                public software.amazon.awscdk.services.sqs.IQueue getQueue() {
                    return this.$queue;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
                    return this.$scalingSteps;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("cluster", om.valueToTree(this.getCluster()));
                    obj.set("image", om.valueToTree(this.getImage()));
                    if (this.getCommand() != null) {
                        obj.set("command", om.valueToTree(this.getCommand()));
                    }
                    if (this.getDesiredTaskCount() != null) {
                        obj.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
                    }
                    if (this.getEnableLogging() != null) {
                        obj.set("enableLogging", om.valueToTree(this.getEnableLogging()));
                    }
                    if (this.getEnvironment() != null) {
                        obj.set("environment", om.valueToTree(this.getEnvironment()));
                    }
                    if (this.getMaxScalingCapacity() != null) {
                        obj.set("maxScalingCapacity", om.valueToTree(this.getMaxScalingCapacity()));
                    }
                    if (this.getQueue() != null) {
                        obj.set("queue", om.valueToTree(this.getQueue()));
                    }
                    if (this.getScalingSteps() != null) {
                        obj.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Cluster where service will be deployed.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
        }

        /**
         * The image to start.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.jsiiGet("image", software.amazon.awscdk.services.ecs.ContainerImage.class);
        }

        /**
         * The CMD value to pass to the container.
         * 
         * A string with commands delimited by commas.
         * 
         * Default: none
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getCommand() {
            return this.jsiiGet("command", java.util.List.class);
        }

        /**
         * Number of desired copies of running tasks.
         * 
         * Default: 1
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getDesiredTaskCount() {
            return this.jsiiGet("desiredTaskCount", java.lang.Number.class);
        }

        /**
         * Flag to indicate whether to enable logging.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getEnableLogging() {
            return this.jsiiGet("enableLogging", java.lang.Boolean.class);
        }

        /**
         * The environment variables to pass to the container.
         * 
         * Default: 'QUEUE_NAME: queue.queueName'
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.jsiiGet("environment", java.util.Map.class);
        }

        /**
         * Maximum capacity to scale to.
         * 
         * Default: (desiredTaskCount * 2)
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getMaxScalingCapacity() {
            return this.jsiiGet("maxScalingCapacity", java.lang.Number.class);
        }

        /**
         * A queue for which to process items from.
         * 
         * If specified and this is a FIFO queue, the queue name must end in the string '.fifo'.
         * 
         * Default: 'SQSQueue with CloudFormation-generated name'
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.sqs.IQueue getQueue() {
            return this.jsiiGet("queue", software.amazon.awscdk.services.sqs.IQueue.class);
        }

        /**
         * The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         * 
         * Maps a range of metric values to a particular scaling behavior.
         * https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html
         * 
         * Default: [{ upper: 0, change: -1 },{ lower: 100, change: +1 },{ lower: 500, change: +5 }]
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
            return this.jsiiGet("scalingSteps", java.util.List.class);
        }
    }
}
