/**
 * <h1>CDK Construct library for higher-level ECS Constructs</h1>
 * <!-- raw HTML omitted -->
 * <hr />
 * <p><img src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge" alt="Stability: Experimental" /></p>
 * <blockquote>
 * <p><strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong></p>
 * <p>This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.</p>
 * </blockquote>
 * <hr />
 * <!-- raw HTML omitted -->
 * <p>This library provides higher-level ECS constructs which follow common architectural patterns. It contains:</p>
 * <ul>
 * <li>Load Balanced Services</li>
 * <li>Queue Processing Services</li>
 * <li>Scheduled Tasks (cron jobs)</li>
 * </ul>
 * <h2>Load Balanced Services</h2>
 * <p>To define a service that is behind a load balancer, instantiate one of the following:</p>
 * <ul>
 * <li><code>LoadBalancedEc2Service</code></li>
 * </ul>
 * <pre><code class="language-ts">const loadBalancedEcsService = new ecsPatterns.LoadBalancedEc2Service(stack, 'Service', {
 *   cluster,
 *   memoryLimitMiB: 1024,
 *   image: ecs.ContainerImage.fromRegistry('test'),
 *   desiredCount: 2,
 *   environment: {
 *     TEST_ENVIRONMENT_VARIABLE1: &quot;test environment variable 1 value&quot;,
 *     TEST_ENVIRONMENT_VARIABLE2: &quot;test environment variable 2 value&quot;
 *   }
 * });
 * </code></pre>
 * <ul>
 * <li><code>LoadBalancedFargateService</code></li>
 * </ul>
 * <pre><code class="language-ts">const loadBalancedFargateService = new ecsPatterns.LoadBalancedFargateService(stack, 'Service', {
 *   cluster,
 *   memoryLimitMiB: 1024,
 *   cpu: 512,
 *   image: ecs.ContainerImage.fromRegistry(&quot;amazon/amazon-ecs-sample&quot;),
 * });
 * </code></pre>
 * <h2>Queue Processing Services</h2>
 * <p>To define a service that creates a queue and reads from that queue, instantiate one of the following:</p>
 * <ul>
 * <li><code>QueueProcessingEc2Service</code></li>
 * </ul>
 * <pre><code class="language-ts">const queueProcessingEc2Service = new QueueProcessingEc2Service(stack, 'Service', {
 *   cluster,
 *   memoryLimitMiB: 1024,
 *   image: ecs.ContainerImage.fromRegistry('test'),
 *   command: [&quot;-c&quot;, &quot;4&quot;, &quot;amazon.com&quot;],
 *   enableLogging: false,
 *   desiredTaskCount: 2,
 *   environment: {
 *     TEST_ENVIRONMENT_VARIABLE1: &quot;test environment variable 1 value&quot;,
 *     TEST_ENVIRONMENT_VARIABLE2: &quot;test environment variable 2 value&quot;
 *   },
 *   queue,
 *   maxScalingCapacity: 5
 * });
 * </code></pre>
 * <ul>
 * <li><code>QueueProcessingFargateService</code></li>
 * </ul>
 * <pre><code class="language-ts">const queueProcessingFargateService = new QueueProcessingFargateService(stack, 'Service', {
 *   cluster,
 *   memoryLimitMiB: 512,
 *   image: ecs.ContainerImage.fromRegistry('test'),
 *   command: [&quot;-c&quot;, &quot;4&quot;, &quot;amazon.com&quot;],
 *   enableLogging: false,
 *   desiredTaskCount: 2,
 *   environment: {
 *     TEST_ENVIRONMENT_VARIABLE1: &quot;test environment variable 1 value&quot;,
 *     TEST_ENVIRONMENT_VARIABLE2: &quot;test environment variable 2 value&quot;
 *   },
 *   queue,
 *   maxScalingCapacity: 5
 * });
 * </code></pre>
 * <h2>Scheduled Tasks</h2>
 * <p>To define a task that runs periodically, instantiate an <code>ScheduledEc2Task</code>:</p>
 * <pre><code class="language-ts">// Instantiate an Amazon EC2 Task to run at a scheduled interval
 * const ecsScheduledTask = new ScheduledEc2Task(this, 'ScheduledTask', {
 *   cluster,
 *   image: ecs.ContainerImage.fromRegistry(&quot;amazon/amazon-ecs-sample&quot;),
 *   scheduleExpression: 'rate(1 minute)',
 *   environment: [{ name: 'TRIGGER', value: 'CloudWatch Events' }],
 *   memoryLimitMiB: 256
 * });
 * </code></pre>
 * 
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.ecs.patterns;
