/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.FargateTaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.$Module;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedFargateServiceProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs-patterns.ApplicationLoadBalancedFargateServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ApplicationLoadBalancedFargateServiceProps
extends JsiiSerializable,
ApplicationLoadBalancedServiceBaseProps {
    @Nullable
    default public Boolean getAssignPublicIp() {
        return null;
    }

    @Nullable
    default public Number getCpu() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimitMiB() {
        return null;
    }

    @Nullable
    default public FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public FargateTaskDefinition getTaskDefinition() {
        return null;
    }

    @Nullable
    default public SubnetSelection getTaskSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationLoadBalancedFargateServiceProps> {
        private Boolean assignPublicIp;
        private Number cpu;
        private Number memoryLimitMiB;
        private FargatePlatformVersion platformVersion;
        private List<ISecurityGroup> securityGroups;
        private FargateTaskDefinition taskDefinition;
        private SubnetSelection taskSubnets;
        private ICertificate certificate;
        private DeploymentCircuitBreaker circuitBreaker;
        private CloudMapOptions cloudMapOptions;
        private ICluster cluster;
        private DeploymentController deploymentController;
        private Number desiredCount;
        private String domainName;
        private IHostedZone domainZone;
        private Boolean enableEcsManagedTags;
        private Duration healthCheckGracePeriod;
        private Number listenerPort;
        private IApplicationLoadBalancer loadBalancer;
        private Number maxHealthyPercent;
        private Number minHealthyPercent;
        private Boolean openListener;
        private PropagatedTagSource propagateTags;
        private ApplicationProtocol protocol;
        private ApplicationProtocolVersion protocolVersion;
        private Boolean publicLoadBalancer;
        private ApplicationLoadBalancedServiceRecordType recordType;
        private Boolean redirectHttp;
        private String serviceName;
        private ApplicationProtocol targetProtocol;
        private ApplicationLoadBalancedTaskImageOptions taskImageOptions;
        private IVpc vpc;

        public Builder assignPublicIp(Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder platformVersion(FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder taskDefinition(FargateTaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder taskSubnets(SubnetSelection taskSubnets) {
            this.taskSubnets = taskSubnets;
            return this;
        }

        public Builder certificate(ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder domainZone(IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder listenerPort(Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public Builder loadBalancer(IApplicationLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        public Builder openListener(Boolean openListener) {
            this.openListener = openListener;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder protocolVersion(ApplicationProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder publicLoadBalancer(Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        public Builder recordType(ApplicationLoadBalancedServiceRecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder redirectHttp(Boolean redirectHttp) {
            this.redirectHttp = redirectHttp;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder targetProtocol(ApplicationProtocol targetProtocol) {
            this.targetProtocol = targetProtocol;
            return this;
        }

        public Builder taskImageOptions(ApplicationLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ApplicationLoadBalancedFargateServiceProps build() {
            return new Jsii.Proxy(this.assignPublicIp, this.cpu, this.memoryLimitMiB, this.platformVersion, this.securityGroups, this.taskDefinition, this.taskSubnets, this.certificate, this.circuitBreaker, this.cloudMapOptions, this.cluster, this.deploymentController, this.desiredCount, this.domainName, this.domainZone, this.enableEcsManagedTags, this.healthCheckGracePeriod, this.listenerPort, this.loadBalancer, this.maxHealthyPercent, this.minHealthyPercent, this.openListener, this.propagateTags, this.protocol, this.protocolVersion, this.publicLoadBalancer, this.recordType, this.redirectHttp, this.serviceName, this.targetProtocol, this.taskImageOptions, this.vpc);
        }
    }
}

