/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.services.applicationautoscaling.ScalingInterval;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.BaseService;
import software.amazon.awscdk.services.ecs.Cluster;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.Secret;
import software.amazon.awscdk.services.ecs.patterns.$Module;
import software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-ecs-patterns.QueueProcessingServiceBase")
public abstract class QueueProcessingServiceBase
extends Construct {
    protected QueueProcessingServiceBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingServiceBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected QueueProcessingServiceBase(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull QueueProcessingServiceBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    protected void configureAutoscalingForService(@NotNull BaseService service) {
        Kernel.call((Object)((Object)this), (String)"configureAutoscalingForService", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull software.constructs.Construct scope, @Nullable IVpc vpc) {
        return (Cluster)Kernel.call((Object)((Object)this), (String)"getDefaultCluster", (NativeType)NativeType.forClass(Cluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), vpc});
    }

    @NotNull
    protected Cluster getDefaultCluster(@NotNull software.constructs.Construct scope) {
        return (Cluster)Kernel.call((Object)((Object)this), (String)"getDefaultCluster", (NativeType)NativeType.forClass(Cluster.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required")});
    }

    protected void grantPermissionsToService(@NotNull BaseService service) {
        Kernel.call((Object)((Object)this), (String)"grantPermissionsToService", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    @NotNull
    public ICluster getCluster() {
        return (ICluster)Kernel.get((Object)((Object)this), (String)"cluster", (NativeType)NativeType.forClass(ICluster.class));
    }

    @Deprecated
    @NotNull
    public Number getDesiredCount() {
        return (Number)Kernel.get((Object)((Object)this), (String)"desiredCount", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"environment", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Number getMaxCapacity() {
        return (Number)Kernel.get((Object)((Object)this), (String)"maxCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public Number getMinCapacity() {
        return (Number)Kernel.get((Object)((Object)this), (String)"minCapacity", (NativeType)NativeType.forClass(Number.class));
    }

    @NotNull
    public List<ScalingInterval> getScalingSteps() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"scalingSteps", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ScalingInterval.class))));
    }

    @NotNull
    public IQueue getSqsQueue() {
        return (IQueue)Kernel.get((Object)((Object)this), (String)"sqsQueue", (NativeType)NativeType.forClass(IQueue.class));
    }

    @Nullable
    public IQueue getDeadLetterQueue() {
        return (IQueue)Kernel.get((Object)((Object)this), (String)"deadLetterQueue", (NativeType)NativeType.forClass(IQueue.class));
    }

    @Nullable
    public LogDriver getLogDriver() {
        return (LogDriver)Kernel.get((Object)((Object)this), (String)"logDriver", (NativeType)NativeType.forClass(LogDriver.class));
    }

    @Nullable
    public Map<String, Secret> getSecrets() {
        return Optional.ofNullable((Map)Kernel.get((Object)((Object)this), (String)"secrets", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Secret.class)))).map(Collections::unmodifiableMap).orElse(null);
    }
}

