package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the ScheduledFargateTask task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ScheduledFargateTask scheduledFargateTask = ScheduledFargateTask.Builder.create(this, "ScheduledFargateTask")
 *         .cluster(cluster)
 *         .scheduledFargateTaskImageOptions(ScheduledFargateTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .memoryLimitMiB(512)
 *                 .build())
 *         .schedule(Schedule.expression("rate(1 minute)"))
 *         .platformVersion(FargatePlatformVersion.LATEST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:50.050Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.ScheduledFargateTaskProps")
@software.amazon.jsii.Jsii.Proxy(ScheduledFargateTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledFargateTaskProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.ScheduledTaskBaseProps {

    /**
     * The platform version on which to run your service.
     * <p>
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
     * in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * Default: Latest
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    /**
     * The properties to define if using an existing TaskDefinition in this construct.
     * <p>
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions getScheduledFargateTaskDefinitionOptions() {
        return null;
    }

    /**
     * The properties to define if the construct is to create a TaskDefinition.
     * <p>
     * ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions getScheduledFargateTaskImageOptions() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduledFargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledFargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledFargateTaskProps> {
        software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions;
        software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions;
        software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        software.amazon.awscdk.services.ecs.ICluster cluster;
        java.lang.Number desiredTaskCount;
        java.lang.Boolean enabled;
        java.lang.String ruleName;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getPlatformVersion}
         * @param platformVersion The platform version on which to run your service.
         *                        If one is not specified, the LATEST platform version is used by default. For more information, see
         *                        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         *                        in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getScheduledFargateTaskDefinitionOptions}
         * @param scheduledFargateTaskDefinitionOptions The properties to define if using an existing TaskDefinition in this construct.
         *                                              ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskDefinitionOptions(software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions) {
            this.scheduledFargateTaskDefinitionOptions = scheduledFargateTaskDefinitionOptions;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getScheduledFargateTaskImageOptions}
         * @param scheduledFargateTaskImageOptions The properties to define if the construct is to create a TaskDefinition.
         *                                         ScheduledFargateTaskDefinitionOptions or ScheduledFargateTaskImageOptions must be defined, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledFargateTaskImageOptions(software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions) {
            this.scheduledFargateTaskImageOptions = scheduledFargateTaskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getSchedule}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         *                 For more information, see
         *                 <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         *                 in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getDesiredTaskCount}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(java.lang.Number desiredTaskCount) {
            this.desiredTaskCount = desiredTaskCount;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getEnabled}
         * @param enabled Indicates whether the rule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getRuleName}
         * @param ruleName A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getSecurityGroups}
         * @param securityGroups Existing security groups to use for your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getSubnetSelection}
         * @param subnetSelection In what subnets to place the task's ENIs.
         *                        (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledFargateTaskProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledFargateTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledFargateTaskProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduledFargateTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledFargateTaskProps {
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions;
        private final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions scheduledFargateTaskImageOptions;
        private final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredTaskCount;
        private final java.lang.Boolean enabled;
        private final java.lang.String ruleName;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.scheduledFargateTaskDefinitionOptions = software.amazon.jsii.Kernel.get(this, "scheduledFargateTaskDefinitionOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions.class));
            this.scheduledFargateTaskImageOptions = software.amazon.jsii.Kernel.get(this, "scheduledFargateTaskImageOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.desiredTaskCount = software.amazon.jsii.Kernel.get(this, "desiredTaskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.platformVersion = builder.platformVersion;
            this.scheduledFargateTaskDefinitionOptions = builder.scheduledFargateTaskDefinitionOptions;
            this.scheduledFargateTaskImageOptions = builder.scheduledFargateTaskImageOptions;
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.cluster = builder.cluster;
            this.desiredTaskCount = builder.desiredTaskCount;
            this.enabled = builder.enabled;
            this.ruleName = builder.ruleName;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.vpc = builder.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskDefinitionOptions getScheduledFargateTaskDefinitionOptions() {
            return this.scheduledFargateTaskDefinitionOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.patterns.ScheduledFargateTaskImageOptions getScheduledFargateTaskImageOptions() {
            return this.scheduledFargateTaskImageOptions;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.Number getDesiredTaskCount() {
            return this.desiredTaskCount;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            if (this.getScheduledFargateTaskDefinitionOptions() != null) {
                data.set("scheduledFargateTaskDefinitionOptions", om.valueToTree(this.getScheduledFargateTaskDefinitionOptions()));
            }
            if (this.getScheduledFargateTaskImageOptions() != null) {
                data.set("scheduledFargateTaskImageOptions", om.valueToTree(this.getScheduledFargateTaskImageOptions()));
            }
            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredTaskCount() != null) {
                data.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.ScheduledFargateTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledFargateTaskProps.Jsii$Proxy that = (ScheduledFargateTaskProps.Jsii$Proxy) o;

            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (this.scheduledFargateTaskDefinitionOptions != null ? !this.scheduledFargateTaskDefinitionOptions.equals(that.scheduledFargateTaskDefinitionOptions) : that.scheduledFargateTaskDefinitionOptions != null) return false;
            if (this.scheduledFargateTaskImageOptions != null ? !this.scheduledFargateTaskImageOptions.equals(that.scheduledFargateTaskImageOptions) : that.scheduledFargateTaskImageOptions != null) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredTaskCount != null ? !this.desiredTaskCount.equals(that.desiredTaskCount) : that.desiredTaskCount != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.platformVersion != null ? this.platformVersion.hashCode() : 0;
            result = 31 * result + (this.scheduledFargateTaskDefinitionOptions != null ? this.scheduledFargateTaskDefinitionOptions.hashCode() : 0);
            result = 31 * result + (this.scheduledFargateTaskImageOptions != null ? this.scheduledFargateTaskImageOptions.hashCode() : 0);
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredTaskCount != null ? this.desiredTaskCount.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
