package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the NetworkLoadBalancedFargateService service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.22.0 (build 14afdde)", date = "2020-02-26T08:39:03.196Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.ecs.patterns.$Module.class, fqn = "@aws-cdk/aws-ecs-patterns.NetworkLoadBalancedFargateServiceProps")
@software.amazon.jsii.Jsii.Proxy(NetworkLoadBalancedFargateServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NetworkLoadBalancedFargateServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedServiceBaseProps {

    /**
     * Determines whether the service will be assigned a public IP address.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getAssignPublicIp() {
        return null;
    }

    /**
     * The number of cpu units used by the task.
     * <p>
     * Valid values, which determines your range of valid values for the memory parameter:
     * <p>
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     * <p>
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     * <p>
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     * <p>
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     * <p>
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getCpu() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * This field is required and you must use one of the following values, which determines your range of valid values
     * for the cpu parameter:
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 512
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancedFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NetworkLoadBalancedFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean assignPublicIp;
        private java.lang.Number cpu;
        private java.lang.Number memoryLimitMiB;
        private software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;
        private software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.lang.Number desiredCount;
        private java.lang.String domainName;
        private software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private java.lang.Boolean enableEcsManagedTags;
        private software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private java.lang.Number listenerPort;
        private software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        private java.lang.Number maxHealthyPercent;
        private java.lang.Number minHealthyPercent;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private java.lang.Boolean publicLoadBalancer;
        private java.lang.String serviceName;
        private software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getAssignPublicIp}
         * @param assignPublicIp Determines whether the service will be assigned a public IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(java.lang.Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            Valid values, which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         *            <p>
         *            512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         *            <p>
         *            1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         *            <p>
         *            2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         *            <p>
         *            4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         *            <p>
         *            This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task.
         *                       This field is required and you must use one of the following values, which determines your range of valid values
         *                       for the cpu parameter:
         *                       <p>
         *                       512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         *                       <p>
         *                       1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         *                       <p>
         *                       2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         *                       <p>
         *                       Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         *                       <p>
         *                       Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         *                       <p>
         *                       This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getTaskDefinition}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getCloudMapOptions}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getDesiredCount}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service.
         *                     The minimum value is 1
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(java.lang.Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getDomainName}
         * @param domainName The domain name for the service, e.g. "api.example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getDomainZone}
         * @param domainZone The Route53 hosted zone for the domain, e.g. "example.com.".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainZone(software.amazon.awscdk.services.route53.IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(software.amazon.awscdk.core.Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getListenerPort}
         * @param listenerPort Listener port of the network load balancer that will serve traffic to the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerPort(java.lang.Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getLoadBalancer}
         * @param loadBalancer The network load balancer that will serve traffic to the service.
         *                     If the load balancer has been imported, the vpc attribute must be specified
         *                     in the call to fromNetworkLoadBalancerAttributes().
         *                     <p>
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getPublicLoadBalancer}
         * @param publicLoadBalancer Determines whether the Load Balancer will be internet-facing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicLoadBalancer(java.lang.Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getTaskImageOptions}
         * @param taskImageOptions The properties required to create a new task definition.
         *                         One of taskImageOptions or taskDefinition must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskImageOptions(software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        /**
         * Sets the value of {@link NetworkLoadBalancedFargateServiceProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancedFargateServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public NetworkLoadBalancedFargateServiceProps build() {
            return new Jsii$Proxy(assignPublicIp, cpu, memoryLimitMiB, taskDefinition, cloudMapOptions, cluster, desiredCount, domainName, domainZone, enableEcsManagedTags, healthCheckGracePeriod, listenerPort, loadBalancer, maxHealthyPercent, minHealthyPercent, propagateTags, publicLoadBalancer, serviceName, taskImageOptions, vpc);
        }
    }

    /**
     * An implementation for {@link NetworkLoadBalancedFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkLoadBalancedFargateServiceProps {
        private final java.lang.Boolean assignPublicIp;
        private final java.lang.Number cpu;
        private final java.lang.Number memoryLimitMiB;
        private final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;
        private final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredCount;
        private final java.lang.String domainName;
        private final software.amazon.awscdk.services.route53.IHostedZone domainZone;
        private final java.lang.Boolean enableEcsManagedTags;
        private final software.amazon.awscdk.core.Duration healthCheckGracePeriod;
        private final java.lang.Number listenerPort;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number minHealthyPercent;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final java.lang.Boolean publicLoadBalancer;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assignPublicIp = this.jsiiGet("assignPublicIp", java.lang.Boolean.class);
            this.cpu = this.jsiiGet("cpu", java.lang.Number.class);
            this.memoryLimitMiB = this.jsiiGet("memoryLimitMiB", java.lang.Number.class);
            this.taskDefinition = this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.FargateTaskDefinition.class);
            this.cloudMapOptions = this.jsiiGet("cloudMapOptions", software.amazon.awscdk.services.ecs.CloudMapOptions.class);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.desiredCount = this.jsiiGet("desiredCount", java.lang.Number.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.domainZone = this.jsiiGet("domainZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.enableEcsManagedTags = this.jsiiGet("enableECSManagedTags", java.lang.Boolean.class);
            this.healthCheckGracePeriod = this.jsiiGet("healthCheckGracePeriod", software.amazon.awscdk.core.Duration.class);
            this.listenerPort = this.jsiiGet("listenerPort", java.lang.Number.class);
            this.loadBalancer = this.jsiiGet("loadBalancer", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class);
            this.maxHealthyPercent = this.jsiiGet("maxHealthyPercent", java.lang.Number.class);
            this.minHealthyPercent = this.jsiiGet("minHealthyPercent", java.lang.Number.class);
            this.propagateTags = this.jsiiGet("propagateTags", software.amazon.awscdk.services.ecs.PropagatedTagSource.class);
            this.publicLoadBalancer = this.jsiiGet("publicLoadBalancer", java.lang.Boolean.class);
            this.serviceName = this.jsiiGet("serviceName", java.lang.String.class);
            this.taskImageOptions = this.jsiiGet("taskImageOptions", software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions.class);
            this.vpc = this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpc.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean assignPublicIp, final java.lang.Number cpu, final java.lang.Number memoryLimitMiB, final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition, final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.lang.Number desiredCount, final java.lang.String domainName, final software.amazon.awscdk.services.route53.IHostedZone domainZone, final java.lang.Boolean enableEcsManagedTags, final software.amazon.awscdk.core.Duration healthCheckGracePeriod, final java.lang.Number listenerPort, final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer loadBalancer, final java.lang.Number maxHealthyPercent, final java.lang.Number minHealthyPercent, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags, final java.lang.Boolean publicLoadBalancer, final java.lang.String serviceName, final software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions taskImageOptions, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assignPublicIp = assignPublicIp;
            this.cpu = cpu;
            this.memoryLimitMiB = memoryLimitMiB;
            this.taskDefinition = taskDefinition;
            this.cloudMapOptions = cloudMapOptions;
            this.cluster = cluster;
            this.desiredCount = desiredCount;
            this.domainName = domainName;
            this.domainZone = domainZone;
            this.enableEcsManagedTags = enableEcsManagedTags;
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            this.listenerPort = listenerPort;
            this.loadBalancer = loadBalancer;
            this.maxHealthyPercent = maxHealthyPercent;
            this.minHealthyPercent = minHealthyPercent;
            this.propagateTags = propagateTags;
            this.publicLoadBalancer = publicLoadBalancer;
            this.serviceName = serviceName;
            this.taskImageOptions = taskImageOptions;
            this.vpc = vpc;
        }

        @Override
        public java.lang.Boolean getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public software.amazon.awscdk.services.ecs.CloudMapOptions getCloudMapOptions() {
            return this.cloudMapOptions;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public java.lang.Number getDesiredCount() {
            return this.desiredCount;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getDomainZone() {
            return this.domainZone;
        }

        @Override
        public java.lang.Boolean getEnableEcsManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public software.amazon.awscdk.core.Duration getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public java.lang.Number getListenerPort() {
            return this.listenerPort;
        }

        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
            return this.loadBalancer;
        }

        @Override
        public java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public java.lang.Boolean getPublicLoadBalancer() {
            return this.publicLoadBalancer;
        }

        @Override
        public java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancedTaskImageOptions getTaskImageOptions() {
            return this.taskImageOptions;
        }

        @Override
        public software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssignPublicIp() != null) {
                data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getTaskDefinition() != null) {
                data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            }
            if (this.getCloudMapOptions() != null) {
                data.set("cloudMapOptions", om.valueToTree(this.getCloudMapOptions()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredCount() != null) {
                data.set("desiredCount", om.valueToTree(this.getDesiredCount()));
            }
            if (this.getDomainName() != null) {
                data.set("domainName", om.valueToTree(this.getDomainName()));
            }
            if (this.getDomainZone() != null) {
                data.set("domainZone", om.valueToTree(this.getDomainZone()));
            }
            if (this.getEnableEcsManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableEcsManagedTags()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getListenerPort() != null) {
                data.set("listenerPort", om.valueToTree(this.getListenerPort()));
            }
            if (this.getLoadBalancer() != null) {
                data.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getPublicLoadBalancer() != null) {
                data.set("publicLoadBalancer", om.valueToTree(this.getPublicLoadBalancer()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getTaskImageOptions() != null) {
                data.set("taskImageOptions", om.valueToTree(this.getTaskImageOptions()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-ecs-patterns.NetworkLoadBalancedFargateServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NetworkLoadBalancedFargateServiceProps.Jsii$Proxy that = (NetworkLoadBalancedFargateServiceProps.Jsii$Proxy) o;

            if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.taskDefinition != null ? !this.taskDefinition.equals(that.taskDefinition) : that.taskDefinition != null) return false;
            if (this.cloudMapOptions != null ? !this.cloudMapOptions.equals(that.cloudMapOptions) : that.cloudMapOptions != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredCount != null ? !this.desiredCount.equals(that.desiredCount) : that.desiredCount != null) return false;
            if (this.domainName != null ? !this.domainName.equals(that.domainName) : that.domainName != null) return false;
            if (this.domainZone != null ? !this.domainZone.equals(that.domainZone) : that.domainZone != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.listenerPort != null ? !this.listenerPort.equals(that.listenerPort) : that.listenerPort != null) return false;
            if (this.loadBalancer != null ? !this.loadBalancer.equals(that.loadBalancer) : that.loadBalancer != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.publicLoadBalancer != null ? !this.publicLoadBalancer.equals(that.publicLoadBalancer) : that.publicLoadBalancer != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.taskImageOptions != null ? !this.taskImageOptions.equals(that.taskImageOptions) : that.taskImageOptions != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public int hashCode() {
            int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.taskDefinition != null ? this.taskDefinition.hashCode() : 0);
            result = 31 * result + (this.cloudMapOptions != null ? this.cloudMapOptions.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredCount != null ? this.desiredCount.hashCode() : 0);
            result = 31 * result + (this.domainName != null ? this.domainName.hashCode() : 0);
            result = 31 * result + (this.domainZone != null ? this.domainZone.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.listenerPort != null ? this.listenerPort.hashCode() : 0);
            result = 31 * result + (this.loadBalancer != null ? this.loadBalancer.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.publicLoadBalancer != null ? this.publicLoadBalancer.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.taskImageOptions != null ? this.taskImageOptions.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
